/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.session;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.web.session.Attributes;
import org.eclipse.kura.web.session.SecurityHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionExpirationSecurityHandler
implements SecurityHandler {
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");

    @Override
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (!session.isNew()) {
            long lastActivity = SessionExpirationSecurityHandler.getLastActivity(session);
            int maxInactiveInterval = session.getMaxInactiveInterval();
            long delta = now - lastActivity;
            if (maxInactiveInterval > 0 && delta > (long)(maxInactiveInterval * 1000)) {
                auditLogger.warn("{} UI Session - Failure - Session expired", (Object)AuditContext.currentOrInternal());
                session.invalidate();
                return false;
            }
        }
        session.setAttribute(Attributes.LAST_ACTIVITY.getValue(), (Object)now);
        return true;
    }

    private static long getLastActivity(HttpSession session) {
        Object lastActivityRaw = session.getAttribute(Attributes.LAST_ACTIVITY.getValue());
        if (!(lastActivityRaw instanceof Long)) {
            return 0L;
        }
        return (Long)lastActivityRaw;
    }
}

