/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.Bugsnag;
import com.bugsnag.HandledState;
import com.bugsnag.Severity;
import java.util.Set;
import java.util.WeakHashMap;

class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler originalHandler;
    private final WeakHashMap<Bugsnag, Boolean> clientMap = new WeakHashMap();

    Set<Bugsnag> uncaughtExceptionClients() {
        return this.clientMap.keySet();
    }

    static void enable(Bugsnag bugsnag) {
        ExceptionHandler bugsnagHandler;
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler instanceof ExceptionHandler) {
            bugsnagHandler = (ExceptionHandler)currentHandler;
        } else {
            bugsnagHandler = new ExceptionHandler(currentHandler);
            Thread.setDefaultUncaughtExceptionHandler(bugsnagHandler);
        }
        bugsnagHandler.clientMap.put(bugsnag, true);
    }

    static void disable(Bugsnag bugsnag) {
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler instanceof ExceptionHandler) {
            ExceptionHandler bugsnagHandler = (ExceptionHandler)currentHandler;
            bugsnagHandler.clientMap.remove(bugsnag);
            if (bugsnagHandler.clientMap.size() == 0) {
                Thread.setDefaultUncaughtExceptionHandler(bugsnagHandler.originalHandler);
            }
        }
    }

    ExceptionHandler(Thread.UncaughtExceptionHandler originalHandler) {
        this.originalHandler = originalHandler;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        for (Bugsnag bugsnag : this.clientMap.keySet()) {
            if (!bugsnag.getConfig().shouldSendUncaughtExceptions()) continue;
            HandledState handledState = HandledState.newInstance(HandledState.SeverityReasonType.REASON_UNHANDLED_EXCEPTION, Severity.ERROR);
            bugsnag.notify(throwable, handledState, thread);
        }
        if (this.originalHandler != null) {
            this.originalHandler.uncaughtException(thread, throwable);
        } else {
            System.err.printf("Exception in thread \"%s\" ", thread.getName());
            throwable.printStackTrace(System.err);
        }
    }
}

