/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.configuration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.Scalar;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.metatype.ObjectFactory;
import org.eclipse.kura.core.configuration.metatype.Tad;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.core.configuration.metatype.Tscalar;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.eclipse.kura.net.NetInterfaceType;
import org.eclipse.kura.net.configuration.NetworkConfigurationConstants;
import org.eclipse.kura.net.configuration.NetworkConfigurationMessages;
import org.eclipse.kura.net.configuration.NetworkConfigurationPropertyNames;
import org.eclipse.kura.usb.UsbNetDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConfigurationServiceCommon {
    private static final Logger logger = LoggerFactory.getLogger(NetworkConfigurationServiceCommon.class);
    public static final String PID = "org.eclipse.kura.net.admin.NetworkConfigurationService";
    private static final String PREFIX = "net.interface.";
    private static final String NET_INTERFACES = "net.interfaces";
    private static final Pattern COMMA = Pattern.compile(",");
    private static ObjectFactory objectFactory = new ObjectFactory();

    private NetworkConfigurationServiceCommon() {
    }

    public static Tocd getDefinition(Map<String, Object> properties, Optional<List<UsbNetDevice>> usbNetDevices) throws KuraException {
        Tocd tocd = objectFactory.createTocd();
        tocd.setName("NetworkConfigurationService");
        tocd.setId(PID);
        tocd.setDescription("Network Configuration Service");
        Tad tad = NetworkConfigurationServiceCommon.builder(NET_INTERFACES, NetworkConfigurationPropertyNames.PLATFORM_INTERFACES, Tscalar.STRING).withCardinality(10000).withRequired(true).build();
        tocd.addAD(tad);
        try {
            Set<String> networkInterfaceNames = NetworkConfigurationServiceCommon.getNetworkInterfaceNamesInConfig(properties);
            for (String ifaceName : networkInterfaceNames) {
                Optional<NetInterfaceType> type = NetworkConfigurationServiceCommon.getNetworkTypeFromProperties(ifaceName, properties);
                if (!type.isPresent()) {
                    logger.warn("failed to compute the interface type for {}", (Object)ifaceName);
                    continue;
                }
                switch (type.get()) {
                    case LOOPBACK: {
                        NetworkConfigurationServiceCommon.getLoopbackDefinition(tocd, ifaceName);
                        break;
                    }
                    case ETHERNET: {
                        usbNetDevices.ifPresent(usbNetDevice -> NetworkConfigurationServiceCommon.getUsbDeviceDefinition(usbNetDevice, tocd, ifaceName));
                        NetworkConfigurationServiceCommon.getInterfaceCommonDefinition(tocd, ifaceName);
                        NetworkConfigurationServiceCommon.getDnsDefinition(tocd, ifaceName);
                        NetworkConfigurationServiceCommon.getDhcpServerDefinition(tocd, ifaceName);
                        break;
                    }
                    case WIFI: {
                        usbNetDevices.ifPresent(usbNetDevice -> NetworkConfigurationServiceCommon.getUsbDeviceDefinition(usbNetDevice, tocd, ifaceName));
                        NetworkConfigurationServiceCommon.getInterfaceCommonDefinition(tocd, ifaceName);
                        NetworkConfigurationServiceCommon.getDnsDefinition(tocd, ifaceName);
                        NetworkConfigurationServiceCommon.getDhcpServerDefinition(tocd, ifaceName);
                        NetworkConfigurationServiceCommon.getWifiDefinition(tocd, ifaceName);
                        break;
                    }
                    case MODEM: {
                        usbNetDevices.ifPresent(usbNetDevice -> NetworkConfigurationServiceCommon.getUsbDeviceDefinition(usbNetDevice, tocd, ifaceName));
                        NetworkConfigurationServiceCommon.getInterfaceCommonDefinition(tocd, ifaceName);
                        NetworkConfigurationServiceCommon.getDnsDefinition(tocd, ifaceName);
                        NetworkConfigurationServiceCommon.getModemDefinition(tocd, ifaceName);
                        break;
                    }
                    case VLAN: {
                        usbNetDevices.ifPresent(usbNetDevice -> NetworkConfigurationServiceCommon.getUsbDeviceDefinition(usbNetDevice, tocd, ifaceName));
                        NetworkConfigurationServiceCommon.getInterfaceCommonDefinition(tocd, ifaceName);
                        NetworkConfigurationServiceCommon.getDnsDefinition(tocd, ifaceName);
                        NetworkConfigurationServiceCommon.getDhcpServerDefinition(tocd, ifaceName);
                        NetworkConfigurationServiceCommon.getVlanDefinition(tocd, ifaceName);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
        return tocd;
    }

    public static ComponentConfiguration getConfiguration(String pid, Map<String, Object> properties, Optional<List<UsbNetDevice>> usbNetDevices) throws KuraException {
        Tocd definition = NetworkConfigurationServiceCommon.getDefinition(properties, usbNetDevices);
        return new ComponentConfigurationImpl(pid, definition, NetworkConfigurationServiceCommon.convertStringsToPasswords(definition, properties));
    }

    private static Map<String, Object> convertStringsToPasswords(Tocd ocd, Map<String, Object> properties) {
        Optional<Map<String, Object>> result = Optional.empty();
        for (AD ad : ocd.getAD()) {
            String key = ad.getId();
            Object value = result.orElse(properties).get(ad.getId());
            if (ad.getType() != Scalar.PASSWORD || !(value instanceof String)) continue;
            if (!result.isPresent()) {
                result = Optional.of(new HashMap<String, Object>(properties));
            }
            ((Map)result.get()).put(key, new Password(((String)value).toCharArray()));
        }
        return result.orElse(properties);
    }

    private static void getModemDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.enabled", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_ENABLED, Tscalar.BOOLEAN).withDefault(String.valueOf(false)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.idle", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_IDLE, Tscalar.INTEGER).withDefault(String.valueOf(95)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.username", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_USERNAME, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.password", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_PASSWORD, Tscalar.PASSWORD).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.pdpType", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_PDP_TYPE, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_MODEM_PDP_TYPE_VALUE.name()).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.maxFail", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_MAX_FAIL, Tscalar.INTEGER).withDefault(String.valueOf(5)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.authType", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_AUTH_TYPE, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_MODEM_AUTH_TYPE_VALUE.name()).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.lpcEchoInterval", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_LPC_ECHO_INTERVAL, Tscalar.INTEGER).withDefault(String.valueOf(0)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.activeFilter", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_ACTIVE_FILTER, Tscalar.STRING).withDefault("inbound").build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.lpcEchoFailure", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_LPC_ECHO_FAILURE, Tscalar.INTEGER).withDefault(String.valueOf(0)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.diversityEnabled", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_DIVERSITY_ENABLED, Tscalar.BOOLEAN).withDefault(String.valueOf(false)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.resetTimeout", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_RESET_TIMEOUT, Tscalar.INTEGER).withDefault(String.valueOf(5)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.gpsEnabled", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_GPS_ENABLED, Tscalar.BOOLEAN).withDefault(String.valueOf(false)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.persist", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_PERSIST, Tscalar.BOOLEAN).withDefault(String.valueOf(true)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.apn", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_APN, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.dialString", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_DIAL_STRING, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.holdoff", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_HOLDOFF, Tscalar.INTEGER).withDefault(String.valueOf(1)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.pppNum", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MODEM_PPP_NUM, Tscalar.INTEGER).withDefault(String.valueOf(0)).build());
    }

    private static void getWifiDefinition(Tocd tocd, String ifaceName) {
        NetworkConfigurationServiceCommon.getWifiCommonDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.getWifiInfraDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.getWifiMasterDefinition(tocd, ifaceName);
    }

    private static void getWifiMasterDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.master.ssid", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_MASTER_SSID, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.master.broadcast", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_MASTER_BROADCAST_ENABLED, Tscalar.BOOLEAN).withDefault(String.valueOf(false)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.master.radioMode", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_MASTER_RADIO_MODE, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_WIFI_RADIO_MODE_VALUE.name()).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.master.securityType", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_MASTER_SECURITY_TYPE, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_WIFI_SECURITY_VALUE.name()).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.master.passphrase", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_MASTER_PASSPHRASE, Tscalar.PASSWORD).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.master.channel", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_MASTER_CHANNEL, Tscalar.STRING).withDefault("1").build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.master.ignoreSSID", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_MASTER_IGNORE_SSID, Tscalar.BOOLEAN).withDefault(String.valueOf(false)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.master.pairwiseCiphers", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_MASTER_PAIRWISE_CIPHERS, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_WIFI_PAIRWISE_CIPHERS_VALUE.name()).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.master.groupCiphers", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_MASTER_GROUP_CIPHERS, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_WIFI_GROUP_CIPHERS_VALUE.name()).build());
    }

    private static void getWifiInfraDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.infra.ssid", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_INFRA_SSID, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.infra.radioMode", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_INFRA_RADIO_MODE, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_WIFI_RADIO_MODE_VALUE.name()).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.infra.securityType", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_INFRA_SECURITY_TYPE, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_WIFI_SECURITY_VALUE.name()).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.infra.passphrase", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_INFRA_PASSPHRASE, Tscalar.PASSWORD).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.infra.pairwiseCiphers", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_INFRA_PAIRWISE_CIPHERS, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_WIFI_PAIRWISE_CIPHERS_VALUE.name()).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.infra.groupCiphers", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_INFRA_GROUP_CIPHERS, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_WIFI_GROUP_CIPHERS_VALUE.name()).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.infra.channel", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_INFRA_CHANNEL, Tscalar.STRING).withDefault("1").build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.infra.bgscan", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_INFRA_BGSCAN, Tscalar.STRING).withDefault("").build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.infra.pingAccessPoint", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_INFRA_PING_AP, Tscalar.BOOLEAN).withDefault(String.valueOf(false)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.infra.ignoreSSID", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_INFRA_IGNORE_SSID, Tscalar.BOOLEAN).withDefault(String.valueOf(false)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.802-1x.password", ifaceName), NetworkConfigurationPropertyNames.CONFIG_802_1X_PASSWORD, Tscalar.PASSWORD).build());
    }

    private static void getWifiCommonDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.wifi.capabilities", ifaceName), NetworkConfigurationPropertyNames.WIFI_CAPABILITIES, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.wifi.mode", ifaceName), NetworkConfigurationPropertyNames.CONFIG_WIFI_MODE, Tscalar.STRING).withDefault(NetworkConfigurationConstants.DEFAULT_WIFI_MODE.name()).build());
    }

    private static void getDnsDefinition(Tocd tocd, String ifaceName) {
        NetworkConfigurationServiceCommon.getIp4DnsDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.getIp6DnsDefinition(tocd, ifaceName);
    }

    private static void getIp4DnsDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip4.dnsServers", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_DNS_SERVERS, Tscalar.STRING).withCardinality(10000).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip4.winsServers", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_WINS_SERVERS, Tscalar.STRING).withCardinality(10000).build());
    }

    private static void getIp6DnsDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip6.dnsServers", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV6_DNS_SERVERS, Tscalar.STRING).withCardinality(10000).build());
    }

    private static void getDhcpServerDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.dhcpServer4.enabled", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_DHCP_SERVER_ENABLED, Tscalar.BOOLEAN).withDefault(String.valueOf(false)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.dhcpServer4.defaultLeaseTime", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_DHCP_SERVER_DEFAULT_LEASE_TIME, Tscalar.INTEGER).withDefault(String.valueOf(-1)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.dhcpServer4.maxLeaseTime", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_DHCP_SERVER_MAX_LEASE_TIME, Tscalar.INTEGER).withDefault(String.valueOf(-1)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.dhcpServer4.prefix", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_DHCP_SERVER_PREFIX, Tscalar.SHORT).withDefault(String.valueOf(NetworkConfigurationConstants.DEFAULT_IPV4_DHCP_SERVER_PREFIX_VALUE)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.dhcpServer4.rangeStart", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_DHCP_SERVER_RANGE_START, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.dhcpServer4.rangeEnd", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_DHCP_SERVER_RANGE_END, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.dhcpServer4.passDns", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_DHCP_SERVER_PASS_DNS, Tscalar.BOOLEAN).withDefault(String.valueOf(false)).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.nat.enabled", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_DHCP_SERVER_NAT_ENABLED, Tscalar.BOOLEAN).withDefault(String.valueOf(false)).build());
    }

    private static void getInterfaceCommonDefinition(Tocd tocd, String ifaceName) {
        NetworkConfigurationServiceCommon.addTypeDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addMtuDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addAutoconnectDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addPromiscDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp4InterfaceCommonDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp6InterfaceCommonDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp6AddressGenerationModeDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp6PrivacyDefinition(tocd, ifaceName);
    }

    private static void getVlanDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.vlan.parent", ifaceName), NetworkConfigurationPropertyNames.CONFIG_VLAN_PARENT, Tscalar.STRING).withRequired(true).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.vlan.id", ifaceName), NetworkConfigurationPropertyNames.CONFIG_VLAN_ID, Tscalar.INTEGER).withRequired(true).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.vlan.ingress", ifaceName), NetworkConfigurationPropertyNames.CONFIG_VLAN_INGRESS_MAP, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.vlan.egress", ifaceName), NetworkConfigurationPropertyNames.CONFIG_VLAN_EGRESS_MAP, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.vlan.flags", ifaceName), NetworkConfigurationPropertyNames.CONFIG_VLAN_FLAGS, Tscalar.INTEGER).withDefault(String.valueOf(1)).build());
    }

    private static void addIp4InterfaceCommonDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.dhcpClient4.enabled", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_DHCP_CLIENT_ENABLED, Tscalar.BOOLEAN).withRequired(true).withDefault(String.valueOf(false)).build());
        NetworkConfigurationServiceCommon.addIp4AddressDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp4PrefixDefinition(tocd, ifaceName);
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip4.gateway", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_GATEWAY, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip4.mtu", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_MTU, Tscalar.INTEGER).build());
        NetworkConfigurationServiceCommon.addIp4StatusDefinition(tocd, ifaceName);
    }

    private static void addIp6InterfaceCommonDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip6.address.method", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV6_ADDRESS_METHOD, Tscalar.STRING).withRequired(true).withDefault("netIPv6MethodAuto").build());
        NetworkConfigurationServiceCommon.addIp6AddressDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp6PrefixDefinition(tocd, ifaceName);
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip6.gateway", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV6_GATEWAY, Tscalar.STRING).build());
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip6.mtu", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV6_MTU, Tscalar.INTEGER).build());
        NetworkConfigurationServiceCommon.addIp4StatusDefinition(tocd, ifaceName);
    }

    private static void addIp6AddressGenerationModeDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip6.addr.gen.mode", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV6_ADDRESS_GENERATION_METHOD, Tscalar.STRING).build());
    }

    private static void addIp6PrivacyDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip6.privacy", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV6_PRIVACY, Tscalar.STRING).build());
    }

    private static void getLoopbackDefinition(Tocd tocd, String ifaceName) {
        NetworkConfigurationServiceCommon.addTypeDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addMtuDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addAutoconnectDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp4AddressDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp4PrefixDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp4StatusDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp6AddressDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp6PrefixDefinition(tocd, ifaceName);
        NetworkConfigurationServiceCommon.addIp6StatusDefinition(tocd, ifaceName);
    }

    private static void addTypeDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.type", ifaceName), NetworkConfigurationPropertyNames.CONFIG_TYPE, Tscalar.STRING).withRequired(true).withDefault(NetworkConfigurationConstants.DEFAULT_INTERFACE_TYPE_VALUE.name()).build());
    }

    private static void addIp4StatusDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip4.status", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_STATUS, Tscalar.STRING).withRequired(true).withDefault(NetworkConfigurationConstants.DEFAULT_IPV4_STATUS_VALUE.name()).build());
    }

    private static void addIp6StatusDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip6.status", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV6_STATUS, Tscalar.STRING).withRequired(true).withDefault(NetworkConfigurationConstants.DEFAULT_IPV6_STATUS_VALUE.name()).build());
    }

    private static void addAutoconnectDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.autoconnect", ifaceName), NetworkConfigurationPropertyNames.CONFIG_AUTOCONNECT, Tscalar.BOOLEAN).withRequired(true).withDefault(String.valueOf(false)).build());
    }

    private static void addMtuDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.mtu", ifaceName), NetworkConfigurationPropertyNames.CONFIG_MTU, Tscalar.INTEGER).build());
    }

    private static void addPromiscDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.promisc", ifaceName), NetworkConfigurationPropertyNames.CONFIG_PROMISC, Tscalar.INTEGER).withRequired(true).withDefault(String.valueOf(-1)).build());
    }

    private static void addIp4PrefixDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip4.prefix", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_PREFIX, Tscalar.SHORT).withDefault(String.valueOf(-1)).build());
    }

    private static void addIp6PrefixDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip6.prefix", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV6_PREFIX, Tscalar.SHORT).withDefault(String.valueOf(-1)).build());
    }

    private static void addIp4AddressDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip4.address", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV4_ADDRESS, Tscalar.STRING).build());
    }

    private static void addIp6AddressDefinition(Tocd tocd, String ifaceName) {
        tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.config.ip6.address", ifaceName), NetworkConfigurationPropertyNames.CONFIG_IPV6_ADDRESS, Tscalar.STRING).build());
    }

    private static void getUsbDeviceDefinition(List<UsbNetDevice> usbNetDevices, Tocd tocd, String ifaceName) {
        Optional<UsbNetDevice> usbNetDeviceOptional;
        if (usbNetDevices != null && (usbNetDeviceOptional = usbNetDevices.stream().filter(usbNetDevice -> usbNetDevice.getInterfaceName().equals(ifaceName)).findFirst()).isPresent()) {
            tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.usb.port", ifaceName), NetworkConfigurationPropertyNames.USB_PORT, Tscalar.STRING).build());
            tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.usb.manufacturer", ifaceName), NetworkConfigurationPropertyNames.USB_MANUFACTURER, Tscalar.STRING).build());
            tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.usb.product", ifaceName), NetworkConfigurationPropertyNames.USB_PRODUCT, Tscalar.STRING).build());
            tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.usb.manufacturer.id", ifaceName), NetworkConfigurationPropertyNames.USB_MANUFACTURER_ID, Tscalar.STRING).build());
            tocd.addAD(NetworkConfigurationServiceCommon.builder(String.format("net.interface.%s.usb.product.id", ifaceName), NetworkConfigurationPropertyNames.USB_PRODUCT_ID, Tscalar.STRING).build());
        }
    }

    public static Set<String> getNetworkInterfaceNamesInConfig(Map<String, Object> properties) {
        return Optional.ofNullable(properties).map(p -> p.get(NET_INTERFACES)).map(s -> COMMA.splitAsStream((String)s).filter(p -> !p.trim().isEmpty()).collect(Collectors.toCollection(HashSet::new))).orElseGet(HashSet::new);
    }

    public static Optional<NetInterfaceType> getNetworkTypeFromProperties(String interfaceName, Map<String, Object> properties) {
        Optional<NetInterfaceType> interfaceType = Optional.empty();
        Object interfaceTypeString = properties.get(String.format("net.interface.%s.type", interfaceName));
        if (interfaceTypeString != null) {
            interfaceType = Optional.of(NetInterfaceType.valueOf((String)((String)interfaceTypeString)));
        }
        return interfaceType;
    }

    public static Set<String> getWanInterfacesInConfig(Map<String, Object> properties) {
        HashSet<String> wanInterfaceResult = new HashSet<String>();
        wanInterfaceResult.addAll(NetworkConfigurationServiceCommon.getIp4WanInterfacesInConfig(properties));
        wanInterfaceResult.addAll(NetworkConfigurationServiceCommon.getIp6WanInterfacesInConfig(properties));
        return wanInterfaceResult;
    }

    public static Set<String> getIp4WanInterfacesInConfig(Map<String, Object> properties) {
        return NetworkConfigurationServiceCommon.getNetworkInterfaceNamesInConfig(properties).stream().filter(p -> NetInterfaceStatus.netIPv4StatusEnabledWAN.name().equals(properties.get(PREFIX + p + ".config.ip4.status"))).collect(Collectors.toSet());
    }

    public static Set<String> getIp6WanInterfacesInConfig(Map<String, Object> properties) {
        return NetworkConfigurationServiceCommon.getNetworkInterfaceNamesInConfig(properties).stream().filter(p -> NetInterfaceStatus.netIPv6StatusEnabledWAN.name().equals(properties.get(PREFIX + p + ".config.ip6.status"))).collect(Collectors.toSet());
    }

    private static TadBuilder builder(String propertyName, NetworkConfigurationPropertyNames messageId, Tscalar type) {
        return new TadBuilder(propertyName, messageId, type);
    }

    private static final class TadBuilder {
        private final String name;
        private final String description;
        private final Tscalar type;
        private Integer cardinality = 0;
        private String defaultValue = "";
        private Boolean required = false;

        public TadBuilder(String name, NetworkConfigurationPropertyNames messageId, Tscalar type) {
            this.name = name;
            this.description = NetworkConfigurationMessages.getMessage(messageId);
            this.type = type;
        }

        public TadBuilder withCardinality(Integer cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        public TadBuilder withDefault(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public TadBuilder withRequired(Boolean required) {
            this.required = required;
            return this;
        }

        public Tad build() {
            Tad tad = objectFactory.createTad();
            tad.setId(this.name);
            tad.setName(this.name);
            tad.setType(this.type);
            tad.setCardinality(this.cardinality);
            tad.setRequired(this.required);
            tad.setDefault(this.defaultValue);
            tad.setDescription(this.description);
            return tad;
        }
    }
}

