/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.status.vlan;

import java.util.Objects;
import org.eclipse.kura.net.status.NetworkInterfaceStatus;
import org.eclipse.kura.net.status.NetworkInterfaceType;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class VlanInterfaceStatus
extends NetworkInterfaceStatus {
    private final String parentInterface;
    private final int vlanId;

    private VlanInterfaceStatus(VlanInterfaceStatusBuilder builder) {
        super(builder);
        this.vlanId = builder.vlanId;
        this.parentInterface = builder.parentInterface;
    }

    public int getVlanId() {
        return this.vlanId;
    }

    public String getParentInterface() {
        return this.parentInterface;
    }

    public static VlanInterfaceStatusBuilder builder() {
        return new VlanInterfaceStatusBuilder();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.vlanId, this.parentInterface);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        VlanInterfaceStatus other = (VlanInterfaceStatus)obj;
        return this.vlanId == other.vlanId && Objects.equals(this.parentInterface, other.getParentInterface());
    }

    /* synthetic */ VlanInterfaceStatus(VlanInterfaceStatusBuilder vlanInterfaceStatusBuilder, VlanInterfaceStatus vlanInterfaceStatus) {
        this(vlanInterfaceStatusBuilder);
    }

    public static class VlanInterfaceStatusBuilder
    extends NetworkInterfaceStatus.NetworkInterfaceStatusBuilder<VlanInterfaceStatusBuilder> {
        private String parentInterface;
        private int vlanId;

        public VlanInterfaceStatusBuilder withParentInterface(String parentInterface) {
            this.parentInterface = parentInterface;
            return this.getThis();
        }

        public VlanInterfaceStatusBuilder withVlanId(int vlanId) {
            this.vlanId = vlanId;
            return this.getThis();
        }

        @Override
        public VlanInterfaceStatus build() {
            this.withType(NetworkInterfaceType.VLAN);
            return new VlanInterfaceStatus(this, null);
        }

        @Override
        public VlanInterfaceStatusBuilder getThis() {
            return this;
        }
    }
}

