/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.executor;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.output.NullOutputStream;
import org.eclipse.kura.executor.Signal;

public class Command {
    private final String[] commandLine;
    private String directory;
    private Map<String, String> environment;
    private int timeout = -1;
    private Signal signal;
    private boolean executeInAShell;
    private OutputStream out;
    private OutputStream err;
    private InputStream in;

    public Command(String[] commandLine) {
        this.commandLine = commandLine;
        this.out = new NullOutputStream();
        this.err = new NullOutputStream();
    }

    public String[] getCommandLine() {
        return this.commandLine;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Signal getSignal() {
        return this.signal;
    }

    public void setSignal(Signal signal) {
        this.signal = signal;
    }

    public boolean isExecutedInAShell() {
        return this.executeInAShell;
    }

    public void setExecuteInAShell(boolean executeInAShell) {
        this.executeInAShell = executeInAShell;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public OutputStream getErrorStream() {
        return this.err;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public String toString() {
        return String.join((CharSequence)" ", this.commandLine);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.commandLine);
        result = 31 * result + (this.directory == null ? 0 : this.directory.hashCode());
        result = 31 * result + (this.environment == null ? 0 : this.environment.hashCode());
        result = 31 * result + (this.executeInAShell ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Command other = (Command)obj;
        if (!Arrays.equals(this.commandLine, other.commandLine)) {
            return false;
        }
        if (this.directory == null ? other.directory != null : !this.directory.equals(other.directory)) {
            return false;
        }
        if (this.environment == null ? other.environment != null : !this.environment.equals(other.environment)) {
            return false;
        }
        return this.executeInAShell == other.executeInAShell;
    }
}

