/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.channel;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.annotation.NotThreadSafe;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.channel.ChannelType;
import org.eclipse.kura.channel.ScaleOffsetType;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@NotThreadSafe
@ProviderType
public class Channel {
    private static final String MESSAGE_CHANNEL_CONFIGURATION_CANNOT_BE_NULL = "Channel configuration cannot be null";
    private static final String MESSAGE_CHANNEL_VALUE_TYPE_CANNOT_BE_NULL = "Channel value type cannot be null";
    private static final String MESSAGE_CHANNEL_TYPE_CANNOT_BE_NULL = "Channel type cannot be null";
    private static final String MESSAGE_CHANNEL_NAME_CANNOT_BE_NULL = "Channel name cannot be null";
    private final transient Map<String, Object> configuration;
    private String name;
    private ChannelType type;
    private DataType valueType;
    private ScaleOffsetType scaleOffsetType = ScaleOffsetType.DEFINED_BY_VALUE_TYPE;
    private Number valueScale = 1.0;
    private Number valueOffset = 0.0;
    private String unit = "";
    private boolean isEnabled = true;

    @Deprecated
    public Channel(String name, ChannelType type, DataType valueType, Map<String, Object> config) {
        Objects.requireNonNull(name, MESSAGE_CHANNEL_NAME_CANNOT_BE_NULL);
        Objects.requireNonNull(type, MESSAGE_CHANNEL_TYPE_CANNOT_BE_NULL);
        Objects.requireNonNull(valueType, MESSAGE_CHANNEL_VALUE_TYPE_CANNOT_BE_NULL);
        Objects.requireNonNull(config, MESSAGE_CHANNEL_CONFIGURATION_CANNOT_BE_NULL);
        this.configuration = Collections.unmodifiableMap(config);
        this.name = name;
        this.type = type;
        this.valueType = valueType;
    }

    public Channel(String name, ChannelType type, DataType valueType, ScaleOffsetType scaleOffsetType, Number valueScale, Number valueOffset, Map<String, Object> config) {
        Objects.requireNonNull(name, MESSAGE_CHANNEL_NAME_CANNOT_BE_NULL);
        Objects.requireNonNull(type, MESSAGE_CHANNEL_TYPE_CANNOT_BE_NULL);
        Objects.requireNonNull(valueType, MESSAGE_CHANNEL_VALUE_TYPE_CANNOT_BE_NULL);
        Objects.requireNonNull(config, MESSAGE_CHANNEL_CONFIGURATION_CANNOT_BE_NULL);
        Objects.requireNonNull(scaleOffsetType, "Scale/Offset type cannot be null");
        Objects.requireNonNull(valueScale, "Channel value scale cannot be null");
        Objects.requireNonNull(valueOffset, "Channel value offset cannot be null");
        this.configuration = Collections.unmodifiableMap(config);
        this.name = name;
        this.type = type;
        this.valueType = valueType;
        this.scaleOffsetType = scaleOffsetType;
        this.valueScale = valueScale;
        this.valueOffset = valueOffset;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public ChannelType getType() {
        return this.type;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    public ScaleOffsetType getScaleOffsetType() {
        return this.scaleOffsetType;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Deprecated
    public double getValueScale() {
        return this.valueScale.doubleValue();
    }

    public Number getValueScaleAsNumber() {
        return this.valueScale;
    }

    @Deprecated
    public double getValueOffset() {
        return this.valueOffset.doubleValue();
    }

    public Number getValueOffsetAsNumber() {
        return this.valueOffset;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setName(String name) {
        Objects.requireNonNull(name, MESSAGE_CHANNEL_NAME_CANNOT_BE_NULL);
        this.name = name;
    }

    public void setType(ChannelType type) {
        Objects.requireNonNull(type, MESSAGE_CHANNEL_TYPE_CANNOT_BE_NULL);
        this.type = type;
    }

    public void setValueType(DataType valueType) {
        Objects.requireNonNull(valueType, MESSAGE_CHANNEL_VALUE_TYPE_CANNOT_BE_NULL);
        this.valueType = valueType;
    }

    public void setScaleOffsetType(ScaleOffsetType scaleOffsetType) {
        Objects.requireNonNull(this.valueType, "Scale/Offset value type cannot be null");
        this.scaleOffsetType = scaleOffsetType;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setScale(double scale) {
        this.valueScale = scale;
    }

    public void setScale(Number scale) {
        this.valueScale = scale;
    }

    public void setOffset(double offset) {
        this.valueOffset = offset;
    }

    public void setOffset(Number offset) {
        this.valueOffset = offset;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String toString() {
        return "Channel [configuration=" + this.configuration + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", valueType=" + (Object)((Object)this.valueType) + ", valueScale=" + this.valueScale + ", valueOffset=" + this.valueOffset + ", valueType=" + (Object)((Object)this.valueType) + ", unit=" + this.unit + "]";
    }

    public ChannelRecord createReadRecord() {
        ChannelRecord result = ChannelRecord.createReadRecord(this.name, this.valueType, this.unit);
        result.setChannelConfig(this.configuration);
        return result;
    }

    public ChannelRecord createWriteRecord(TypedValue<?> value) {
        Objects.requireNonNull(value, "Value cannot be null");
        if (value.getType() != this.valueType) {
            throw new IllegalArgumentException("The value type of the argument must match the channel value type");
        }
        ChannelRecord result = ChannelRecord.createWriteRecord(this.name, value);
        result.setChannelConfig(this.configuration);
        return result;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isEnabled, this.name, this.scaleOffsetType, this.type, this.unit, this.valueOffset, this.valueScale, this.valueType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Channel other = (Channel)obj;
        return this.isEnabled == other.isEnabled && Objects.equals(this.name, other.name) && this.scaleOffsetType == other.scaleOffsetType && this.type == other.type && Objects.equals(this.unit, other.unit) && Objects.equals(this.valueOffset, other.valueOffset) && Objects.equals(this.valueScale, other.valueScale) && this.valueType == other.valueType;
    }
}

