/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.This;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Opcodes;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.OpenedClassReader;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.creation.bytebuddy.ConstructionCallback;
import org.mockito.internal.creation.bytebuddy.MockAccess;
import org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.mockito.internal.creation.bytebuddy.inject.MockMethodDispatcher;
import org.mockito.internal.debugging.LocationFactory;
import org.mockito.internal.exceptions.stacktrace.ConditionalStackTraceFilter;
import org.mockito.internal.invocation.RealMethod;
import org.mockito.internal.invocation.SerializableMethod;
import org.mockito.internal.invocation.mockref.MockReference;
import org.mockito.internal.invocation.mockref.MockWeakReference;
import org.mockito.internal.util.concurrent.DetachedThreadLocal;
import org.mockito.internal.util.concurrent.WeakConcurrentMap;
import org.mockito.plugins.MemberAccessor;

public class MockMethodAdvice
extends MockMethodDispatcher {
    private final WeakConcurrentMap<Object, MockMethodInterceptor> interceptors;
    private final DetachedThreadLocal<Map<Class<?>, MockMethodInterceptor>> mockedStatics;
    private final String identifier;
    private final SelfCallInfo selfCallInfo = new SelfCallInfo();
    private final MethodGraph.Compiler compiler = MethodGraph.Compiler.Default.forJavaHierarchy();
    private final WeakConcurrentMap<Class<?>, SoftReference<MethodGraph>> graphs = new WeakConcurrentMap.WithInlinedExpunction();
    private final Predicate<Class<?>> isMockConstruction;
    private final ConstructionCallback onConstruction;

    public MockMethodAdvice(WeakConcurrentMap<Object, MockMethodInterceptor> interceptors, DetachedThreadLocal<Map<Class<?>, MockMethodInterceptor>> mockedStatics, String identifier, Predicate<Class<?>> isMockConstruction, ConstructionCallback onConstruction) {
        this.interceptors = interceptors;
        this.mockedStatics = mockedStatics;
        this.onConstruction = onConstruction;
        this.identifier = identifier;
        this.isMockConstruction = isMockConstruction;
    }

    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    private static Callable<?> enter(@Identifier String identifier, @Advice.This Object mock, @Advice.Origin Method origin, @Advice.AllArguments Object[] arguments) throws Throwable {
        MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)identifier, (Object)mock);
        if (dispatcher == null || !dispatcher.isMocked(mock) || dispatcher.isOverridden(mock, origin)) {
            return null;
        }
        return dispatcher.handle(mock, origin, arguments);
    }

    @Advice.OnMethodExit
    private static void exit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Enter Callable<?> mocked) throws Throwable {
        if (mocked != null) {
            returned = mocked.call();
        }
    }

    public Callable<?> handle(Object instance, Method origin, Object[] arguments) throws Throwable {
        MockMethodInterceptor interceptor = this.interceptors.get(instance);
        if (interceptor == null) {
            return null;
        }
        RealMethod realMethod = instance instanceof Serializable ? new SerializableRealMethodCall(this.identifier, origin, instance, arguments) : new RealMethodCall(this.selfCallInfo, origin, instance, arguments);
        return new ReturnValueWrapper(interceptor.doIntercept(instance, origin, arguments, realMethod, LocationFactory.create(true)));
    }

    public Callable<?> handleStatic(Class<?> type, Method origin, Object[] arguments) throws Throwable {
        Map<Class<?>, MockMethodInterceptor> interceptors = this.mockedStatics.get();
        if (interceptors == null || !interceptors.containsKey(type)) {
            return null;
        }
        return new ReturnValueWrapper(interceptors.get(type).doIntercept(type, origin, arguments, new StaticMethodCall(this.selfCallInfo, type, origin, arguments), LocationFactory.create(true)));
    }

    public Object handleConstruction(Class<?> type, Object object, Object[] arguments, String[] parameterTypeNames) {
        return this.onConstruction.apply(type, object, arguments, parameterTypeNames);
    }

    public boolean isMock(Object instance) {
        return instance != this.interceptors.target && this.interceptors.containsKey(instance);
    }

    public boolean isMocked(Object instance) {
        return this.selfCallInfo.checkSelfCall(instance) && this.isMock(instance);
    }

    public boolean isMockedStatic(Class<?> type) {
        if (!this.selfCallInfo.checkSelfCall(type)) {
            return false;
        }
        Map<Class<?>, MockMethodInterceptor> interceptors = this.mockedStatics.get();
        return interceptors != null && interceptors.containsKey(type);
    }

    public boolean isOverridden(Object instance, Method origin) {
        MethodGraph.Node node;
        MethodGraph methodGraph;
        SoftReference<MethodGraph> reference = this.graphs.get(instance.getClass());
        MethodGraph methodGraph2 = methodGraph = reference == null ? null : reference.get();
        if (methodGraph == null) {
            methodGraph = this.compiler.compile((TypeDefinition)TypeDescription.ForLoadedType.of(instance.getClass()));
            this.graphs.put(instance.getClass(), new SoftReference<MethodGraph>(methodGraph));
        }
        return !(node = methodGraph.locate(new MethodDescription.ForLoadedMethod(origin).asSignatureToken())).getSort().isResolved() || !((MethodDescription.InDefinedShape)node.getRepresentative().asDefined()).getDeclaringType().represents(origin.getDeclaringClass());
    }

    public boolean isConstructorMock(Class<?> type) {
        return this.isMockConstruction.test(type);
    }

    private static Object tryInvoke(Method origin, Object instance, Object[] arguments) throws Throwable {
        MemberAccessor accessor = Plugins.getMemberAccessor();
        try {
            return accessor.invoke(origin, instance, arguments);
        }
        catch (InvocationTargetException exception) {
            Throwable cause = exception.getCause();
            new ConditionalStackTraceFilter().filter(MockMethodAdvice.removeRecursiveCalls(cause, origin.getDeclaringClass()));
            throw cause;
        }
    }

    static Throwable removeRecursiveCalls(Throwable cause, Class<?> declaringClass) {
        ArrayList<String> uniqueStackTraceItems = new ArrayList<String>();
        ArrayList<Integer> indexesToBeRemoved = new ArrayList<Integer>();
        for (StackTraceElement element : cause.getStackTrace()) {
            String key = element.getClassName() + element.getLineNumber();
            int elementIndex = uniqueStackTraceItems.lastIndexOf(key);
            uniqueStackTraceItems.add(key);
            if (elementIndex <= -1 || !declaringClass.getName().equals(element.getClassName())) continue;
            indexesToBeRemoved.add(elementIndex);
        }
        ArrayList<StackTraceElement> adjustedList = new ArrayList<StackTraceElement>(Arrays.asList(cause.getStackTrace()));
        indexesToBeRemoved.stream().sorted(Comparator.reverseOrder()).mapToInt(Integer::intValue).forEach(adjustedList::remove);
        cause.setStackTrace(adjustedList.toArray(new StackTraceElement[0]));
        return cause;
    }

    public static class ForReadObject {
        public static void doReadObject(@Identifier String identifier, @This MockAccess thiz, @Argument(value=0) ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            MockMethodAdvice mockMethodAdvice = (MockMethodAdvice)MockMethodDispatcher.get((String)identifier, (Object)thiz);
            if (mockMethodAdvice != null) {
                mockMethodAdvice.interceptors.put(thiz, thiz.getMockitoInterceptor());
            }
        }
    }

    static class ForStatic {
        ForStatic() {
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        private static Callable<?> enter(@Identifier String identifier, @Advice.Origin Class<?> type, @Advice.Origin Method origin, @Advice.AllArguments Object[] arguments) throws Throwable {
            MockMethodDispatcher dispatcher = MockMethodDispatcher.getStatic((String)identifier, type);
            if (dispatcher == null || !dispatcher.isMockedStatic(type)) {
                return null;
            }
            return dispatcher.handleStatic(type, origin, arguments);
        }

        @Advice.OnMethodExit
        private static void exit(@Advice.Return(readOnly=false, typing=Assigner.Typing.DYNAMIC) Object returned, @Advice.Enter Callable<?> mocked) throws Throwable {
            if (mocked != null) {
                returned = mocked.call();
            }
        }
    }

    static class ForEquals {
        ForEquals() {
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        private static boolean enter(@Identifier String identifier, @Advice.This Object self) {
            MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)identifier, (Object)self);
            return dispatcher != null && dispatcher.isMock(self);
        }

        @Advice.OnMethodExit
        private static void enter(@Advice.This Object self, @Advice.Argument(value=0) Object other, @Advice.Return(readOnly=false) boolean equals, @Advice.Enter boolean skipped) {
            if (skipped) {
                equals = self == other;
            }
        }
    }

    static class ForHashCode {
        ForHashCode() {
        }

        @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
        private static boolean enter(@Identifier String id, @Advice.This Object self) {
            MockMethodDispatcher dispatcher = MockMethodDispatcher.get((String)id, (Object)self);
            return dispatcher != null && dispatcher.isMock(self);
        }

        @Advice.OnMethodExit
        private static void enter(@Advice.This Object self, @Advice.Return(readOnly=false) int hashCode, @Advice.Enter boolean skipped) {
            if (skipped) {
                hashCode = System.identityHashCode(self);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Identifier {
    }

    static class ConstructorShortcut
    implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper {
        private final String identifier;

        ConstructorShortcut(String identifier) {
            this.identifier = identifier;
        }

        public MethodVisitor wrap(final TypeDescription instrumentedType, final MethodDescription instrumentedMethod, MethodVisitor methodVisitor, final Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
            if (instrumentedMethod.isConstructor() && !instrumentedType.represents(Object.class)) {
                MethodList constructors = (MethodList)instrumentedType.getSuperClass().asErasure().getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isPrivate())));
                int arguments = Integer.MAX_VALUE;
                boolean packagePrivate = true;
                MethodDescription.InDefinedShape current = null;
                for (MethodDescription.InDefinedShape constructor : constructors) {
                    if (constructor.getParameters().size() >= arguments || !packagePrivate && constructor.isPackagePrivate()) continue;
                    arguments = constructor.getParameters().size();
                    packagePrivate = constructor.isPackagePrivate();
                    current = constructor;
                }
                if (current != null) {
                    final MethodDescription.InDefinedShape selected = current;
                    return new MethodVisitor(OpenedClassReader.ASM_API, methodVisitor){

                        public void visitCode() {
                            Object[] locals;
                            super.visitCode();
                            Label label = new Label();
                            super.visitLdcInsn((Object)identifier);
                            if (implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V5)) {
                                super.visitLdcInsn((Object)Type.getType((String)instrumentedType.getDescriptor()));
                            } else {
                                super.visitLdcInsn((Object)instrumentedType.getName());
                                super.visitMethodInsn(184, Type.getInternalName(Class.class), "forName", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[]{Type.getType(String.class)}), false);
                            }
                            super.visitMethodInsn(184, Type.getInternalName(MockMethodDispatcher.class), "isConstructorMock", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Class.class)}), false);
                            super.visitInsn(3);
                            super.visitJumpInsn(159, label);
                            super.visitVarInsn(25, 0);
                            for (Object type : selected.getParameters().asTypeList().asErasures()) {
                                if (type.represents(Boolean.TYPE) || type.represents(Byte.TYPE) || type.represents(Short.TYPE) || type.represents(Character.TYPE) || type.represents(Integer.TYPE)) {
                                    super.visitInsn(3);
                                    continue;
                                }
                                if (type.represents(Long.TYPE)) {
                                    super.visitInsn(9);
                                    continue;
                                }
                                if (type.represents(Float.TYPE)) {
                                    super.visitInsn(11);
                                    continue;
                                }
                                if (type.represents(Double.TYPE)) {
                                    super.visitInsn(14);
                                    continue;
                                }
                                super.visitInsn(1);
                            }
                            super.visitMethodInsn(183, selected.getDeclaringType().getInternalName(), selected.getInternalName(), selected.getDescriptor(), false);
                            super.visitLdcInsn((Object)identifier);
                            if (implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V5)) {
                                super.visitLdcInsn((Object)Type.getType((String)instrumentedType.getDescriptor()));
                            } else {
                                super.visitLdcInsn((Object)instrumentedType.getName());
                                super.visitMethodInsn(184, Type.getInternalName(Class.class), "forName", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[]{Type.getType(String.class)}), false);
                            }
                            super.visitVarInsn(25, 0);
                            super.visitLdcInsn((Object)instrumentedMethod.getParameters().size());
                            super.visitTypeInsn(189, Type.getInternalName(Object.class));
                            int index = 0;
                            for (ParameterDescription parameter : instrumentedMethod.getParameters()) {
                                super.visitInsn(89);
                                super.visitLdcInsn((Object)index++);
                                Type type = Type.getType((String)parameter.getType().asErasure().getDescriptor());
                                super.visitVarInsn(type.getOpcode(21), parameter.getOffset());
                                if (parameter.getType().isPrimitive()) {
                                    Type wrapper = Type.getType((String)parameter.getType().asErasure().asBoxed().getDescriptor());
                                    super.visitMethodInsn(184, wrapper.getInternalName(), "valueOf", Type.getMethodDescriptor((Type)wrapper, (Type[])new Type[]{type}), false);
                                }
                                super.visitInsn(83);
                            }
                            index = 0;
                            super.visitLdcInsn((Object)instrumentedMethod.getParameters().size());
                            super.visitTypeInsn(189, Type.getInternalName(String.class));
                            for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                super.visitInsn(89);
                                super.visitLdcInsn((Object)index++);
                                super.visitLdcInsn((Object)typeDescription.getName());
                                super.visitInsn(83);
                            }
                            super.visitMethodInsn(184, Type.getInternalName(MockMethodDispatcher.class), "handleConstruction", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Class.class), Type.getType(Object.class), Type.getType(Object[].class), Type.getType(String[].class)}), false);
                            FieldList fields = (FieldList)instrumentedType.getDeclaredFields().filter((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic()));
                            super.visitTypeInsn(192, instrumentedType.getInternalName());
                            super.visitInsn(89);
                            Label noSpy = new Label();
                            super.visitJumpInsn(198, noSpy);
                            for (FieldDescription field : fields) {
                                super.visitInsn(89);
                                super.visitFieldInsn(180, instrumentedType.getInternalName(), field.getInternalName(), field.getDescriptor());
                                super.visitVarInsn(25, 0);
                                super.visitInsn(field.getType().getStackSize() == StackSize.DOUBLE ? 91 : 90);
                                super.visitInsn(87);
                                super.visitFieldInsn(181, instrumentedType.getInternalName(), field.getInternalName(), field.getDescriptor());
                            }
                            super.visitLabel(noSpy);
                            if (implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V6)) {
                                locals = ConstructorShortcut.toFrames(instrumentedType.getInternalName(), (List)instrumentedMethod.getParameters().asTypeList().asErasures());
                                super.visitFrame(0, locals.length, locals, 1, new Object[]{instrumentedType.getInternalName()});
                            }
                            super.visitInsn(87);
                            super.visitInsn(177);
                            super.visitLabel(label);
                            if (implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V6)) {
                                locals = ConstructorShortcut.toFrames(Opcodes.UNINITIALIZED_THIS, (List)instrumentedMethod.getParameters().asTypeList().asErasures());
                                super.visitFrame(0, locals.length, locals, 0, new Object[0]);
                            }
                        }

                        public void visitMaxs(int maxStack, int maxLocals) {
                            int prequel = Math.max(5, selected.getStackSize());
                            for (ParameterDescription parameter : instrumentedMethod.getParameters()) {
                                prequel = Math.max(prequel, 6 + parameter.getType().getStackSize().getSize());
                                prequel = Math.max(prequel, 8);
                            }
                            super.visitMaxs(Math.max(maxStack, prequel), maxLocals);
                        }
                    };
                }
            }
            return methodVisitor;
        }

        private static Object[] toFrames(Object self, List<TypeDescription> types) {
            Object[] frames = new Object[1 + types.size()];
            frames[0] = self;
            int index = 0;
            for (TypeDescription type : types) {
                Object frame = type.represents(Boolean.TYPE) || type.represents(Byte.TYPE) || type.represents(Short.TYPE) || type.represents(Character.TYPE) || type.represents(Integer.TYPE) ? Opcodes.INTEGER : (type.represents(Long.TYPE) ? Opcodes.LONG : (type.represents(Float.TYPE) ? Opcodes.FLOAT : (type.represents(Double.TYPE) ? Opcodes.DOUBLE : type.getInternalName())));
                frames[++index] = frame;
            }
            return frames;
        }
    }

    private static class SelfCallInfo
    extends ThreadLocal<Object> {
        private SelfCallInfo() {
        }

        Object replace(Object value) {
            Object current = this.get();
            this.set(value);
            return current;
        }

        boolean checkSelfCall(Object value) {
            if (value == this.get()) {
                this.set(null);
                return false;
            }
            return true;
        }
    }

    private static class ReturnValueWrapper
    implements Callable<Object> {
        private final Object returned;

        private ReturnValueWrapper(Object returned) {
            this.returned = returned;
        }

        @Override
        public Object call() {
            return this.returned;
        }
    }

    private static class StaticMethodCall
    implements RealMethod {
        private final SelfCallInfo selfCallInfo;
        private final Class<?> type;
        private final Method origin;
        private final Object[] arguments;

        private StaticMethodCall(SelfCallInfo selfCallInfo, Class<?> type, Method origin, Object[] arguments) {
            this.selfCallInfo = selfCallInfo;
            this.type = type;
            this.origin = origin;
            this.arguments = arguments;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke() throws Throwable {
            this.selfCallInfo.set(this.type);
            return MockMethodAdvice.tryInvoke(this.origin, null, this.arguments);
        }
    }

    private static class SerializableRealMethodCall
    implements RealMethod {
        private final String identifier;
        private final SerializableMethod origin;
        private final MockReference<Object> instanceRef;
        private final Object[] arguments;

        private SerializableRealMethodCall(String identifier, Method origin, Object instance, Object[] arguments) {
            this.origin = new SerializableMethod(origin);
            this.identifier = identifier;
            this.instanceRef = new MockWeakReference<Object>(instance);
            this.arguments = arguments;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke() throws Throwable {
            Method method = this.origin.getJavaMethod();
            MockMethodDispatcher mockMethodDispatcher = MockMethodDispatcher.get((String)this.identifier, (Object)this.instanceRef.get());
            if (!(mockMethodDispatcher instanceof MockMethodAdvice)) {
                throw new MockitoException("Unexpected dispatcher for advice-based super call");
            }
            Object previous = ((MockMethodAdvice)mockMethodDispatcher).selfCallInfo.replace(this.instanceRef.get());
            try {
                Object object = MockMethodAdvice.tryInvoke(method, this.instanceRef.get(), this.arguments);
                return object;
            }
            finally {
                ((MockMethodAdvice)mockMethodDispatcher).selfCallInfo.set(previous);
            }
        }
    }

    private static class RealMethodCall
    implements RealMethod {
        private final SelfCallInfo selfCallInfo;
        private final Method origin;
        private final MockWeakReference<Object> instanceRef;
        private final Object[] arguments;

        private RealMethodCall(SelfCallInfo selfCallInfo, Method origin, Object instance, Object[] arguments) {
            this.selfCallInfo = selfCallInfo;
            this.origin = origin;
            this.instanceRef = new MockWeakReference<Object>(instance);
            this.arguments = arguments;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke() throws Throwable {
            this.selfCallInfo.set(this.instanceRef.get());
            return MockMethodAdvice.tryInvoke(this.origin, this.instanceRef.get(), this.arguments);
        }
    }
}

