/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.configuration.api;

import java.util.List;
import javax.ws.rs.core.Response;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.rest.configuration.api.ComponentConfigurationDTO;
import org.eclipse.kura.rest.configuration.api.FailureHandler;
import org.eclipse.kura.rest.configuration.api.Validable;

public class UpdateComponentConfigurationRequest
implements Validable {
    private final List<ComponentConfigurationDTO> configs;
    private Boolean takeSnapshot;

    public UpdateComponentConfigurationRequest(List<ComponentConfigurationDTO> componentConfigurations, boolean takeSnapshot) {
        this.configs = componentConfigurations;
        this.takeSnapshot = takeSnapshot;
    }

    public List<ComponentConfigurationDTO> getComponentConfigurations() {
        return this.configs;
    }

    public boolean isTakeSnapshot() {
        return this.takeSnapshot == null || this.takeSnapshot != false;
    }

    @Override
    public void validate() {
        FailureHandler.requireParameter(this.configs, "configs");
        for (ComponentConfigurationDTO config : this.configs) {
            if (config == null) {
                throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)"component configuration objects cannot be null");
            }
            config.validate();
        }
    }
}

