/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.bluetooth.BluetoothAdapter;
import org.eclipse.kura.bluetooth.BluetoothBeaconCommandListener;
import org.eclipse.kura.bluetooth.BluetoothBeaconScanListener;
import org.eclipse.kura.bluetooth.BluetoothDevice;
import org.eclipse.kura.bluetooth.BluetoothLeScanListener;
import org.eclipse.kura.bluetooth.listener.BluetoothAdvertisementScanListener;
import org.eclipse.kura.executor.CommandExecutorService;
import org.eclipse.kura.linux.bluetooth.BluetoothDeviceImpl;
import org.eclipse.kura.linux.bluetooth.le.BluetoothLeScanner;
import org.eclipse.kura.linux.bluetooth.le.beacon.BluetoothAdvertisingData;
import org.eclipse.kura.linux.bluetooth.le.beacon.BluetoothConfigurationProcessListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothProcessListener;
import org.eclipse.kura.linux.bluetooth.util.BluetoothUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothAdapterImpl
implements BluetoothAdapter {
    private static final Logger logger = LoggerFactory.getLogger(BluetoothAdapterImpl.class);
    private static List<BluetoothDevice> connectedDevices;
    private final String name;
    private String address;
    private boolean leReady;
    private BluetoothLeScanner bls = null;
    private BluetoothBeaconCommandListener bbcl;
    private final CommandExecutorService executorService;
    private static final String OGF_CONTROLLER_CMD = "0x08";
    private static final String OCF_ADVERTISING_PARAM_CMD = "0x0006";
    private static final String OCF_ADVERTISING_DATA_CMD = "0x0008";
    private static final String OCF_ADVERTISING_ENABLE_CMD = "0x000a";

    public BluetoothAdapterImpl(String name, CommandExecutorService executorService) throws KuraException {
        this.name = name;
        this.bbcl = null;
        this.executorService = executorService;
        this.buildAdapter(name);
    }

    public BluetoothAdapterImpl(String name, BluetoothBeaconCommandListener bbcl, CommandExecutorService executorService) throws KuraException {
        this.name = name;
        this.bbcl = bbcl;
        this.executorService = executorService;
        this.buildAdapter(name);
    }

    public void setBluetoothBeaconCommandListener(BluetoothBeaconCommandListener bbcl) {
        this.bbcl = bbcl;
    }

    private void buildAdapter(String name) throws KuraException {
        logger.debug("Creating new Bluetooth adapter: {}", (Object)name);
        Map<String, String> props = BluetoothUtil.getConfig(name, this.executorService);
        this.address = props.get("address");
        this.leReady = Boolean.parseBoolean(props.get("leReady"));
    }

    private String[] toStringArray(String string) {
        return string.split("(?<=\\G..)");
    }

    public static void addConnectedDevice(BluetoothDevice bd) {
        if (connectedDevices == null) {
            connectedDevices = new ArrayList<BluetoothDevice>();
        }
        connectedDevices.add(bd);
    }

    public static void removeConnectedDevice(BluetoothDevice bd) {
        if (connectedDevices == null) {
            return;
        }
        connectedDevices.remove(bd);
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isEnabled() {
        return BluetoothUtil.isEnabled(this.name, this.executorService);
    }

    public void startLeScan(BluetoothLeScanListener listener) {
        this.killLeScan();
        this.bls = new BluetoothLeScanner(this.executorService);
        this.bls.startScan(this.name, listener);
    }

    public void startAdvertisementScan(String companyName, BluetoothAdvertisementScanListener listener) {
        this.killLeScan();
        this.bls = new BluetoothLeScanner(this.executorService);
        this.bls.startAdvertisementScan(this.name, companyName, listener);
    }

    public void startBeaconScan(String companyName, BluetoothBeaconScanListener listener) {
        this.killLeScan();
        this.bls = new BluetoothLeScanner(this.executorService);
        this.bls.startBeaconScan(this.name, companyName, listener);
    }

    public void killLeScan() {
        if (this.bls != null) {
            this.bls.killScan(this.name);
            this.bls = null;
        }
    }

    public boolean isScanning() {
        if (this.bls != null) {
            return this.bls.isScanRunning();
        }
        return false;
    }

    public boolean isLeReady() {
        return this.leReady;
    }

    public void enable() {
        BluetoothUtil.hciconfigCmd(this.name, "up", this.executorService);
    }

    public void disable() {
        BluetoothUtil.hciconfigCmd(this.name, "down", this.executorService);
    }

    public BluetoothDevice getRemoteDevice(String address) {
        return new BluetoothDeviceImpl(address, "", this.executorService);
    }

    public void startBeaconAdvertising() {
        BluetoothConfigurationProcessListener bbl = new BluetoothConfigurationProcessListener(this.bbcl);
        logger.debug("Start Advertising : hcitool -i {} cmd {} {} 01", new Object[]{this.name, OGF_CONTROLLER_CMD, OCF_ADVERTISING_ENABLE_CMD});
        logger.info("Start Advertising on interface {}", (Object)this.name);
        String[] cmd = new String[]{"cmd", OGF_CONTROLLER_CMD, OCF_ADVERTISING_ENABLE_CMD, "01"};
        this.runHcitoolCmd(bbl, cmd);
    }

    public void stopBeaconAdvertising() {
        BluetoothConfigurationProcessListener bbl = new BluetoothConfigurationProcessListener(this.bbcl);
        logger.debug("Stop Advertising : hcitool -i {} cmd {} {} 00", new Object[]{this.name, OGF_CONTROLLER_CMD, OCF_ADVERTISING_ENABLE_CMD});
        logger.info("Stop Advertising on interface {}", (Object)this.name);
        String[] cmd = new String[]{"cmd", OGF_CONTROLLER_CMD, OCF_ADVERTISING_ENABLE_CMD, "00"};
        this.runHcitoolCmd(bbl, cmd);
    }

    public void setBeaconAdvertisingInterval(Integer min, Integer max) {
        BluetoothConfigurationProcessListener bbl = new BluetoothConfigurationProcessListener(this.bbcl);
        String[] minHex = this.toStringArray(BluetoothAdvertisingData.to2BytesHex(min));
        String[] maxHex = this.toStringArray(BluetoothAdvertisingData.to2BytesHex(max));
        logger.debug("Set Advertising Parameters : hcitool -i {} cmd {} {} {} {} {} {} 03 00 00 00 00 00 00 00 00 07 00", new Object[]{this.name, OGF_CONTROLLER_CMD, OCF_ADVERTISING_PARAM_CMD, minHex[1], minHex[0], maxHex[1], maxHex[0]});
        logger.info("Set Advertising Parameters on interface {}", (Object)this.name);
        String[] cmd = new String[]{"cmd", OGF_CONTROLLER_CMD, OCF_ADVERTISING_PARAM_CMD, minHex[1], minHex[0], maxHex[1], maxHex[0], "03", "00", "00", "00", "00", "00", "00", "00", "00", "07", "00"};
        this.runHcitoolCmd(bbl, cmd);
    }

    public void setBeaconAdvertisingData(String uuid, Integer major, Integer minor, String companyCode, Integer txPower, boolean LELimited, boolean LEGeneral, boolean BR_EDRSupported, boolean LE_BRController, boolean LE_BRHost) {
        BluetoothConfigurationProcessListener bbl = new BluetoothConfigurationProcessListener(this.bbcl);
        Object[] dataHex = this.toStringArray(BluetoothAdvertisingData.getData(uuid, major, minor, companyCode, txPower, LELimited, LEGeneral, BR_EDRSupported, LE_BRController, LE_BRHost));
        String[] cmd = new String[3 + dataHex.length];
        cmd[0] = "cmd";
        cmd[1] = OGF_CONTROLLER_CMD;
        cmd[2] = OCF_ADVERTISING_DATA_CMD;
        int i = 0;
        while (i < dataHex.length) {
            cmd[i + 3] = dataHex[i];
            ++i;
        }
        logger.debug("Set Advertising Data : hcitool -i {} cmd {} {} {}", new Object[]{this.name, OGF_CONTROLLER_CMD, OCF_ADVERTISING_DATA_CMD, Arrays.toString(dataHex)});
        logger.info("Set Advertising Data on interface {}", (Object)this.name);
        this.runHcitoolCmd(bbl, cmd);
    }

    public void ExecuteCmd(String ogf, String ocf, String parameter) {
        BluetoothConfigurationProcessListener bbl = new BluetoothConfigurationProcessListener(this.bbcl);
        Object[] paramArray = this.toStringArray(parameter);
        logger.info("Execute custom command : hcitool -i {} cmd {} {} {}", new Object[]{this.name, ogf, ocf, Arrays.toString(paramArray)});
        String[] cmd = new String[3 + paramArray.length];
        cmd[0] = "cmd";
        cmd[1] = ogf;
        cmd[2] = ocf;
        int i = 0;
        while (i < paramArray.length) {
            cmd[i + 3] = paramArray[i];
            ++i;
        }
        this.runHcitoolCmd(bbl, cmd);
    }

    private void runHcitoolCmd(BluetoothConfigurationProcessListener bbl, String[] cmd) {
        try {
            BluetoothUtil.hcitoolCmd(this.name, cmd, (BluetoothProcessListener)bbl, this.executorService);
        }
        catch (IOException e) {
            logger.error("Failed to set beacon advertising data", (Throwable)e);
        }
    }
}

