/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.client;

import com.librato.metrics.client.CounterMeasure;
import com.librato.metrics.client.GaugeMeasure;
import com.librato.metrics.client.IMeasure;
import com.librato.metrics.client.Lists;
import com.librato.metrics.client.Tag;
import com.librato.metrics.client.TaggedMeasure;
import java.util.LinkedList;
import java.util.List;

public class Measures {
    private final String source;
    private final Long epoch;
    private final Integer period;
    private final List<Tag> tags = new LinkedList<Tag>();
    private final List<IMeasure> measures = new LinkedList<IMeasure>();

    public Measures() {
        this.source = null;
        this.epoch = null;
        this.period = null;
    }

    public Measures(String source, List<Tag> tags, Long epoch) {
        this.source = source;
        this.tags.addAll(tags);
        this.epoch = epoch;
        this.period = null;
    }

    public Measures(String source, List<Tag> tags, Long epoch, Integer period) {
        this.source = source;
        this.tags.addAll(tags);
        this.epoch = epoch;
        this.period = period;
    }

    public Measures(Measures measures, List<IMeasure> batch) {
        this.source = measures.source;
        this.epoch = measures.epoch;
        this.period = measures.period;
        this.measures.addAll(batch);
        this.tags.addAll(measures.tags);
    }

    public List<Measures> partition(int size) {
        LinkedList<Measures> result = new LinkedList<Measures>();
        for (List<IMeasure> batch : Lists.partition(this.measures, size)) {
            result.add(new Measures(this, batch));
        }
        return result;
    }

    public Measures toSD() {
        return this.convert(new MeasurePredicate(){

            @Override
            public boolean accept(IMeasure measure) {
                return !measure.isTagged();
            }
        });
    }

    public Measures toMD() {
        return this.convert(new MeasurePredicate(){

            @Override
            public boolean accept(IMeasure measure) {
                return measure.isTagged();
            }
        });
    }

    public String getSource() {
        return this.source;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    private Measures convert(MeasurePredicate predicate) {
        Measures result = new Measures(this.source, this.tags, this.epoch, this.period);
        for (IMeasure measure : this.measures) {
            if (!predicate.accept(measure)) continue;
            result.measures.add(measure);
        }
        return result;
    }

    public Measures add(TaggedMeasure measure) {
        return this.addMeasure(measure);
    }

    public Measures add(CounterMeasure measure) {
        return this.addMeasure(measure);
    }

    public Measures add(GaugeMeasure measure) {
        return this.addMeasure(measure);
    }

    private Measures addMeasure(IMeasure measure) {
        this.measures.add(measure);
        return this;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public Long getEpoch() {
        return this.epoch;
    }

    public List<IMeasure> getMeasures() {
        return this.measures;
    }

    public boolean isEmpty() {
        return this.measures.isEmpty();
    }

    static interface MeasurePredicate {
        public boolean accept(IMeasure var1);
    }
}

