/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.bugsnag.Bugsnag;
import com.bugsnag.EndpointConfiguration;
import com.bugsnag.Report;
import com.bugsnag.Severity;
import com.bugsnag.callbacks.Callback;
import com.bugsnag.delivery.Delivery;
import com.bugsnag.logback.BugsnagMarker;
import com.bugsnag.logback.LogbackMetaData;
import com.bugsnag.logback.LogbackMetaDataKey;
import com.bugsnag.logback.LogbackMetaDataTab;
import com.bugsnag.logback.ProxyConfiguration;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Marker;

public class BugsnagAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final List<String> EXCLUDED_CLASSES = Arrays.asList("com.bugsnag.Bugsnag", "com.bugsnag.delivery.OutputStreamDelivery", "com.bugsnag.delivery.SyncHttpDelivery");
    private static final List<Pattern> EXCLUDED_LOGGER_PATTERNS = new ArrayList<Pattern>();
    private String apiKey;
    private String appType;
    private String endpoint;
    private Set<String> filteredProperties = new HashSet<String>();
    private Set<String> ignoredClasses = new HashSet<String>();
    private Set<String> notifyReleaseStages = new HashSet<String>();
    private Set<String> projectPackages = new HashSet<String>();
    private ProxyConfiguration proxy;
    private String releaseStage;
    private boolean sendThreads = false;
    private int timeout;
    private String appVersion;
    private List<LogbackMetaData> globalMetaData = new ArrayList<LogbackMetaData>();
    private Bugsnag bugsnag = null;

    public BugsnagAppender(Bugsnag bugsnag) {
        this.bugsnag = bugsnag;
    }

    public BugsnagAppender() {
        this(null);
    }

    public void start() {
        if (this.bugsnag == null) {
            this.bugsnag = this.createBugsnag();
        }
        super.start();
    }

    public void stop() {
        super.stop();
        if (this.bugsnag != null) {
            this.bugsnag.close();
        }
    }

    protected void append(final ILoggingEvent event) {
        if (this.bugsnag != null) {
            Throwable throwable = this.extractThrowable(event);
            Marker marker = event.getMarker();
            final Callback reportCallback = marker instanceof BugsnagMarker ? ((BugsnagMarker)marker).getCallback() : null;
            if (throwable != null && !this.detectLogFromBugsnag(throwable) && !this.isExcludedLogger(event.getLoggerName())) {
                this.bugsnag.notify(throwable, this.calculateSeverity(event), new Callback(){

                    @Override
                    public void beforeNotify(Report report) {
                        report.addToTab("Log event data", "Message", event.getFormattedMessage());
                        report.addToTab("Log event data", "Logger name", event.getLoggerName());
                        BugsnagAppender.this.populateContextData(report, event);
                        if (reportCallback != null) {
                            reportCallback.beforeNotify(report);
                        }
                    }
                });
            }
        }
    }

    private void populateContextData(Report report, ILoggingEvent event) {
        Map propertyMap = event.getMDCPropertyMap();
        if (propertyMap != null) {
            for (Map.Entry entry : propertyMap.entrySet()) {
                report.addToTab("Context", (String)entry.getKey(), entry.getValue());
            }
        }
    }

    private Severity calculateSeverity(ILoggingEvent event) {
        if (event.getLevel().equals(Level.ERROR)) {
            return Severity.ERROR;
        }
        if (event.getLevel().equals(Level.WARN)) {
            return Severity.WARNING;
        }
        return Severity.INFO;
    }

    private boolean detectLogFromBugsnag(Throwable throwable) {
        for (StackTraceElement element : throwable.getStackTrace()) {
            for (String excludedClass : EXCLUDED_CLASSES) {
                if (!element.getClassName().startsWith(excludedClass)) continue;
                return true;
            }
        }
        return false;
    }

    private Throwable extractThrowable(ILoggingEvent event) {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy instanceof ThrowableProxy) {
            return ((ThrowableProxy)throwableProxy).getThrowable();
        }
        return null;
    }

    private Bugsnag createBugsnag() {
        Bugsnag bugsnag = new Bugsnag(this.apiKey, false);
        bugsnag.setAutoCaptureSessions(false);
        if (this.appType != null) {
            bugsnag.setAppType(this.appType);
        }
        if (this.appVersion != null) {
            bugsnag.setAppVersion(this.appVersion);
        }
        if (this.endpoint != null) {
            bugsnag.setEndpoints(new EndpointConfiguration(this.endpoint, ""));
        }
        if (this.proxy != null) {
            bugsnag.setProxy(new Proxy(this.proxy.getType(), new InetSocketAddress(this.proxy.getHostname(), this.proxy.getPort())));
        }
        if (this.releaseStage != null) {
            bugsnag.setReleaseStage(this.releaseStage);
        }
        if (this.timeout > 0) {
            bugsnag.setTimeout(this.timeout);
        }
        if (this.filteredProperties.size() > 0) {
            bugsnag.setFilters(this.filteredProperties.toArray(new String[0]));
        }
        bugsnag.setIgnoreClasses(this.ignoredClasses.toArray(new String[0]));
        if (this.notifyReleaseStages.size() > 0) {
            bugsnag.setNotifyReleaseStages(this.notifyReleaseStages.toArray(new String[0]));
        }
        bugsnag.setProjectPackages(this.projectPackages.toArray(new String[0]));
        bugsnag.setSendThreads(this.sendThreads);
        bugsnag.addCallback(new Callback(){

            @Override
            public void beforeNotify(Report report) {
                for (LogbackMetaData metaData : BugsnagAppender.this.globalMetaData) {
                    for (LogbackMetaDataTab tab : metaData.getTabs()) {
                        for (LogbackMetaDataKey key : tab.getKeys()) {
                            report.addToTab(tab.getName(), key.getName(), key.getValue());
                        }
                    }
                }
            }
        });
        return bugsnag;
    }

    public void addCallback(Callback callback) {
        if (this.bugsnag != null) {
            this.bugsnag.addCallback(callback);
        }
    }

    public void setDelivery(Delivery delivery) {
        if (this.bugsnag != null) {
            this.bugsnag.setDelivery(delivery);
        }
    }

    public void setSessionDelivery(Delivery delivery) {
        if (this.bugsnag != null) {
            this.bugsnag.setSessionDelivery(delivery);
        }
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setAppType(String appType) {
        this.appType = appType;
        if (this.bugsnag != null) {
            this.bugsnag.setAppType(appType);
        }
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        if (this.bugsnag != null) {
            this.bugsnag.setEndpoints(new EndpointConfiguration(endpoint, ""));
        }
    }

    public void setFilteredProperty(String filter) {
        this.filteredProperties.add(filter);
        if (this.bugsnag != null) {
            this.bugsnag.setFilters(this.filteredProperties.toArray(new String[0]));
        }
    }

    public void setFilteredProperties(String filters) {
        this.filteredProperties.addAll(this.split(filters));
        if (this.bugsnag != null) {
            this.bugsnag.setFilters(this.filteredProperties.toArray(new String[0]));
        }
    }

    public void setIgnoredClass(String ignoredClass) {
        this.ignoredClasses.add(ignoredClass);
        if (this.bugsnag != null) {
            this.bugsnag.setIgnoreClasses(this.ignoredClasses.toArray(new String[0]));
        }
    }

    public void setIgnoredClasses(String ignoredClasses) {
        this.ignoredClasses.addAll(this.split(ignoredClasses));
        if (this.bugsnag != null) {
            this.bugsnag.setIgnoreClasses(this.ignoredClasses.toArray(new String[0]));
        }
    }

    public void setNotifyReleaseStage(String notifyReleaseStage) {
        this.notifyReleaseStages.add(notifyReleaseStage);
        if (this.bugsnag != null) {
            this.bugsnag.setNotifyReleaseStages(this.notifyReleaseStages.toArray(new String[0]));
        }
    }

    public void setNotifyReleaseStages(String notifyReleaseStages) {
        this.notifyReleaseStages.addAll(this.split(notifyReleaseStages));
        if (this.bugsnag != null) {
            this.bugsnag.setNotifyReleaseStages(this.notifyReleaseStages.toArray(new String[0]));
        }
    }

    public void setProjectPackage(String projectPackage) {
        this.projectPackages.add(projectPackage);
        if (this.bugsnag != null) {
            this.bugsnag.setProjectPackages(this.projectPackages.toArray(new String[0]));
        }
    }

    public void setProjectPackages(String projectPackages) {
        this.projectPackages.addAll(this.split(projectPackages));
        if (this.bugsnag != null) {
            this.bugsnag.setProjectPackages(this.projectPackages.toArray(new String[0]));
        }
    }

    public void setProxy(ProxyConfiguration proxy) {
        this.proxy = proxy;
        if (this.bugsnag != null) {
            this.bugsnag.setProxy(new Proxy(proxy.getType(), new InetSocketAddress(proxy.getHostname(), proxy.getPort())));
        }
    }

    public void setReleaseStage(String releaseStage) {
        this.releaseStage = releaseStage;
        if (this.bugsnag != null) {
            this.bugsnag.setReleaseStage(releaseStage);
        }
    }

    public void setSendThreads(boolean sendThreads) {
        this.sendThreads = sendThreads;
        if (this.bugsnag != null) {
            this.bugsnag.setSendThreads(sendThreads);
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        if (this.bugsnag != null) {
            this.bugsnag.setTimeout(timeout);
        }
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        if (this.bugsnag != null) {
            this.bugsnag.setAppVersion(appVersion);
        }
    }

    public void setMetaData(LogbackMetaData metaData) {
        this.globalMetaData.add(metaData);
    }

    static void addExcludedLoggerPattern(String loggerNameRegex) {
        EXCLUDED_LOGGER_PATTERNS.add(Pattern.compile(loggerNameRegex));
    }

    List<String> split(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        String[] parts = value.split(",", -1);
        return Arrays.asList(parts);
    }

    public Bugsnag getClient() {
        return this.bugsnag;
    }

    private boolean isExcludedLogger(String loggerName) {
        for (Pattern excludedLoggerPattern : EXCLUDED_LOGGER_PATTERNS) {
            if (!excludedLoggerPattern.matcher(loggerName).matches()) continue;
            return true;
        }
        return false;
    }
}

