/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.deployment.uninstall;

import java.io.File;
import java.net.URL;
import java.util.Date;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.deployment.CloudDeploymentHandlerV2;
import org.eclipse.kura.core.deployment.UninstallStatus;
import org.eclipse.kura.core.deployment.uninstall.DeploymentPackageUninstallOptions;
import org.eclipse.kura.core.deployment.uninstall.KuraUninstallPayload;
import org.eclipse.kura.core.util.ProcessUtil;
import org.eclipse.kura.core.util.SafeProcess;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UninstallImpl {
    private static final Logger s_logger = LoggerFactory.getLogger(UninstallImpl.class);
    public static final String RESOURCE_UNINSTALL = "uninstall";
    private final CloudDeploymentHandlerV2 callback;
    private final DeploymentAdmin m_deploymentAdmin;

    public UninstallImpl(CloudDeploymentHandlerV2 callback, DeploymentAdmin deploymentAdmin) {
        this.callback = callback;
        this.m_deploymentAdmin = deploymentAdmin;
    }

    private void uninstallCompleteAsync(DeploymentPackageUninstallOptions options, String dpName) throws KuraException {
        KuraUninstallPayload notify = new KuraUninstallPayload(options.getClientId());
        notify.setTimestamp(new Date());
        notify.setUninstallStatus(UninstallStatus.COMPLETED.getStatusString());
        notify.setJobId(options.getJobId());
        notify.setDpName(dpName);
        notify.setUninstallProgress(100);
        this.callback.publishMessage(options, notify, RESOURCE_UNINSTALL);
    }

    public void uninstallFailedAsync(DeploymentPackageUninstallOptions options, String dpName, Exception e) throws KuraException {
        KuraUninstallPayload notify = new KuraUninstallPayload(options.getClientId());
        notify.setTimestamp(new Date());
        notify.setUninstallStatus(UninstallStatus.FAILED.getStatusString());
        notify.setJobId(options.getJobId());
        notify.setDpName(dpName);
        notify.setUninstallProgress(0);
        if (e != null) {
            notify.setErrorMessage(e.getMessage());
        }
        this.callback.publishMessage(options, notify, RESOURCE_UNINSTALL);
    }

    public void uninstaller(DeploymentPackageUninstallOptions options, String packageName) throws KuraException {
        try {
            String name = packageName;
            if (name != null) {
                DeploymentPackage dp = this.m_deploymentAdmin.getDeploymentPackage(name);
                if (dp != null) {
                    dp.uninstall();
                    String sUrl = CloudDeploymentHandlerV2.installImplementation.getDeployedPackages().getProperty(name);
                    File dpFile = new File(new URL(sUrl).getPath());
                    if (!dpFile.delete()) {
                        s_logger.warn("Cannot delete file at URL: {}", (Object)sUrl);
                    }
                    CloudDeploymentHandlerV2.installImplementation.removePackageFromConfFile(name);
                }
                this.uninstallCompleteAsync(options, name);
                UninstallImpl.deviceReboot(options);
            }
        }
        catch (Exception e) {
            throw KuraException.internalError((Throwable)e);
        }
    }

    private static void deviceReboot(DeploymentPackageUninstallOptions options) {
        block9: {
            if (options.isReboot()) {
                s_logger.info("Reboot requested...");
                SafeProcess proc = null;
                try {
                    try {
                        int delay = options.getRebootDelay();
                        s_logger.info("Sleeping for {} ms.", (Object)delay);
                        Thread.sleep(delay);
                        s_logger.info("Rebooting...");
                        proc = ProcessUtil.exec((String)"reboot");
                    }
                    catch (Exception exception) {
                        s_logger.info("Rebooting... Failure!");
                        if (proc != null) {
                            ProcessUtil.destroy(proc);
                        }
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    if (proc != null) {
                        ProcessUtil.destroy(proc);
                    }
                    throw throwable;
                }
                if (proc != null) {
                    ProcessUtil.destroy((SafeProcess)proc);
                }
            }
        }
    }
}

