/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerContext;
import org.eclipse.kura.cloudconnection.request.RequestHandlerMessageConstants;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.core.configuration.ConfigurationServiceImpl;
import org.eclipse.kura.core.configuration.RollbackCallable;
import org.eclipse.kura.core.configuration.UpdateConfigurationsCallable;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.eclipse.kura.core.configuration.XmlSnapshotIdResult;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.marshalling.Unmarshaller;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.util.service.ServiceUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConfigurationHandler
implements RequestHandler {
    private static final String EXPECTED_ONE_RESOURCE_BUT_FOUND_NONE_MESSAGE = "Expected one resource but found none";
    private static final String EXPECTED_AT_MOST_TWO_RESOURCES_BUT_FOUND_MESSAGE = "Expected at most two resource(s) but found {}";
    private static final String CANNOT_FIND_RESOURCE_WITH_NAME_MESSAGE = "Cannot find resource with name: {}";
    private static final String BAD_REQUEST_TOPIC_MESSAGE = "Bad request topic: {}";
    private static Logger logger = LoggerFactory.getLogger(CloudConfigurationHandler.class);
    public static final String APP_ID = "CONF-V1";
    public static final String RESOURCE_CONFIGURATIONS = "configurations";
    public static final String RESOURCE_SNAPSHOTS = "snapshots";
    public static final String RESOURCE_SNAPSHOT = "snapshot";
    public static final String RESOURCE_ROLLBACK = "rollback";
    private SystemService systemService;
    private ConfigurationService configurationService;
    private BundleContext bundleContext;
    private ScheduledExecutorService executor;

    protected void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected void unsetConfigurationService(ConfigurationService configurationService) {
        this.configurationService = null;
    }

    protected void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    protected void unsetSystemService(SystemService systemService) {
        this.systemService = null;
    }

    public void setRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.registerRequestHandler(APP_ID, (RequestHandler)this);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register cloudlet {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    public void unsetRequestHandlerRegistry(RequestHandlerRegistry requestHandlerRegistry) {
        try {
            requestHandlerRegistry.unregister(APP_ID);
        }
        catch (KuraException kuraException) {
            logger.info("Unable to register cloudlet {} in {}", (Object)APP_ID, (Object)requestHandlerRegistry.getClass().getName());
        }
    }

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    protected void deactivate(ComponentContext componentContext) {
        this.executor.shutdownNow();
    }

    public KuraMessage doGet(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        KuraPayload payload;
        List<String> resources = this.getRequestResources(reqMessage);
        if (resources.isEmpty()) {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error(EXPECTED_ONE_RESOURCE_BUT_FOUND_NONE_MESSAGE);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (resources.get(0).equals(RESOURCE_CONFIGURATIONS)) {
            payload = this.doGetConfigurations(resources);
        } else if (resources.get(0).equals(RESOURCE_SNAPSHOTS)) {
            payload = this.doGetSnapshots(resources);
        } else {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error(CANNOT_FIND_RESOURCE_WITH_NAME_MESSAGE, (Object)resources.get(0));
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        return new KuraMessage(payload);
    }

    public KuraMessage doPut(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        List<String> resources = this.getRequestResources(reqMessage);
        if (resources.isEmpty()) {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error(EXPECTED_ONE_RESOURCE_BUT_FOUND_NONE_MESSAGE);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (!resources.get(0).equals(RESOURCE_CONFIGURATIONS)) {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error(CANNOT_FIND_RESOURCE_WITH_NAME_MESSAGE, (Object)resources.get(0));
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        KuraPayload payload = this.doPutConfigurations(resources, reqMessage.getPayload());
        return new KuraMessage(payload);
    }

    public KuraMessage doExec(RequestHandlerContext requestContext, KuraMessage reqMessage) throws KuraException {
        KuraPayload payload;
        List<String> resources = this.getRequestResources(reqMessage);
        if (resources.isEmpty()) {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error(EXPECTED_ONE_RESOURCE_BUT_FOUND_NONE_MESSAGE);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        if (resources.get(0).equals(RESOURCE_SNAPSHOT)) {
            payload = this.doExecSnapshot(resources);
        } else if (resources.get(0).equals(RESOURCE_ROLLBACK)) {
            payload = this.doExecRollback(resources);
        } else {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error(CANNOT_FIND_RESOURCE_WITH_NAME_MESSAGE, (Object)resources.get(0));
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        return new KuraMessage(payload);
    }

    private KuraPayload doGetSnapshots(List<String> resources) throws KuraException {
        String snapshotId;
        KuraResponsePayload responsePayload = new KuraResponsePayload(200);
        if (resources.size() > 2) {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error("Expected one or two resource(s) but found {}", (Object)resources.size());
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        String string = snapshotId = resources.size() == 2 ? resources.get(1) : null;
        if (snapshotId != null) {
            long sid = Long.parseLong(snapshotId);
            XmlComponentConfigurations xmlConfigs = ((ConfigurationServiceImpl)this.configurationService).loadEncryptedSnapshotFileContent(sid);
            List<ComponentConfiguration> configs = xmlConfigs.getConfigurations();
            configs.forEach(config -> ((ConfigurationServiceImpl)this.configurationService).decryptConfigurationProperties(config.getConfigurationProperties()));
            byte[] body = this.toResponseBody(xmlConfigs);
            responsePayload.setBody(body);
        } else {
            Set sids = null;
            try {
                sids = this.configurationService.getSnapshots();
            }
            catch (KuraException e) {
                logger.error("Error listing snapshots: {}", (Throwable)e);
                throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_LISTING, (Throwable)e, new Object[0]);
            }
            ArrayList<Long> snapshotIds = new ArrayList<Long>(sids);
            XmlSnapshotIdResult xmlResult = new XmlSnapshotIdResult();
            xmlResult.setSnapshotIds(snapshotIds);
            byte[] body = this.toResponseBody(xmlResult);
            responsePayload.setBody(body);
        }
        return responsePayload;
    }

    private List<String> getRequestResources(KuraMessage reqMessage) throws KuraException {
        Object requestObject = reqMessage.getProperties().get(RequestHandlerMessageConstants.ARGS_KEY.value());
        if (!(requestObject instanceof List)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        List resources = (List)requestObject;
        return resources;
    }

    private KuraPayload doGetConfigurations(List<String> resources) throws KuraException {
        if (resources.size() > 2) {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error(EXPECTED_AT_MOST_TWO_RESOURCES_BUT_FOUND_MESSAGE, (Object)resources.size());
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        String pid = resources.size() == 2 ? resources.get(1) : null;
        List<Object> configs = new ArrayList();
        try {
            configs = pid == null ? this.getAllConfigurations() : this.getConfiguration(pid);
        }
        catch (KuraException e) {
            logger.error("Error getting component configurations: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        XmlComponentConfigurations xmlConfigs = new XmlComponentConfigurations();
        xmlConfigs.setConfigurations(configs);
        byte[] body = this.toResponseBody(xmlConfigs);
        KuraResponsePayload response = new KuraResponsePayload(200);
        response.setBody(body);
        return response;
    }

    private List<ComponentConfiguration> getConfiguration(String pid) throws KuraException {
        ArrayList<ComponentConfiguration> configs = new ArrayList<ComponentConfiguration>();
        ComponentConfiguration cc = this.configurationService.getComponentConfiguration(pid);
        if (cc != null) {
            configs.add(cc);
        }
        return configs;
    }

    private List<ComponentConfiguration> getAllConfigurations() {
        ArrayList<ComponentConfiguration> configs = new ArrayList<ComponentConfiguration>();
        List pidsToIgnore = this.systemService.getDeviceManagementServiceIgnore();
        Set componentPids = this.configurationService.getConfigurableComponentPids();
        if (pidsToIgnore != null) {
            Set<String> filteredComponentPids = componentPids.stream().filter(((Predicate<String>)pidsToIgnore::contains).negate()).collect(Collectors.toSet());
            filteredComponentPids.forEach(componentPid -> {
                try {
                    ComponentConfiguration cc = this.configurationService.getComponentConfiguration(componentPid);
                    if (cc == null) {
                        logger.error("null ComponentConfiguration");
                        return;
                    }
                    if (cc.getPid() == null || cc.getPid().isEmpty()) {
                        logger.error("null or empty ComponentConfiguration PID");
                        return;
                    }
                    if (cc.getDefinition() == null) {
                        logger.error("null OCD for ComponentConfiguration PID {}", (Object)cc.getPid());
                        return;
                    }
                    if (cc.getDefinition().getId() == null || cc.getDefinition().getId().isEmpty()) {
                        logger.error("null or empty OCD ID for ComponentConfiguration PID {}. OCD ID: {}", (Object)cc.getPid(), (Object)cc.getDefinition().getId());
                        return;
                    }
                    configs.add(cc);
                }
                catch (KuraException kuraException) {}
            });
        }
        return configs;
    }

    private KuraPayload doPutConfigurations(List<String> resources, KuraPayload reqPayload) throws KuraException {
        if (resources.size() > 2) {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error(EXPECTED_AT_MOST_TWO_RESOURCES_BUT_FOUND_MESSAGE, (Object)resources.size());
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        String pid = resources.size() == 2 ? resources.get(1) : null;
        XmlComponentConfigurations xmlConfigs = null;
        try {
            if (reqPayload.getBody() == null || reqPayload.getBody().length == 0) {
                throw new IllegalArgumentException("body");
            }
            String s = new String(reqPayload.getBody(), "UTF-8");
            logger.info("Received new Configuration");
            xmlConfigs = this.unmarshal(s, XmlComponentConfigurations.class);
        }
        catch (Exception e) {
            logger.error("Error unmarshalling the request body: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        this.executor.schedule(new UpdateConfigurationsCallable(pid, xmlConfigs, this.configurationService), 1000L, TimeUnit.MILLISECONDS);
        return new KuraResponsePayload(200);
    }

    private KuraPayload doExecRollback(List<String> resources) throws KuraException {
        Long sid;
        if (resources.size() > 2) {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error(EXPECTED_AT_MOST_TWO_RESOURCES_BUT_FOUND_MESSAGE, (Object)resources.size());
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        String snapshotId = resources.size() == 2 ? resources.get(1) : null;
        try {
            sid = snapshotId != null ? Long.valueOf(Long.parseLong(snapshotId)) : null;
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Bad numeric numeric format for snapshot ID: {}", (Object)snapshotId);
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        this.executor.schedule(new RollbackCallable(sid, this.configurationService), 1000L, TimeUnit.MILLISECONDS);
        return new KuraResponsePayload(200);
    }

    private KuraPayload doExecSnapshot(List<String> resources) throws KuraException {
        long snapshotId;
        if (resources.size() > 1) {
            logger.error(BAD_REQUEST_TOPIC_MESSAGE, resources);
            logger.error("Expected one resource(s) but found {}", (Object)resources.size());
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        try {
            snapshotId = this.configurationService.snapshot();
        }
        catch (KuraException e) {
            logger.error("Error taking snapshot: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_TAKING, (Throwable)e, new Object[0]);
        }
        ArrayList<Long> snapshotIds = new ArrayList<Long>();
        snapshotIds.add(snapshotId);
        XmlSnapshotIdResult xmlResult = new XmlSnapshotIdResult();
        xmlResult.setSnapshotIds(snapshotIds);
        byte[] body = this.toResponseBody(xmlResult);
        KuraResponsePayload responsePayload = new KuraResponsePayload(200);
        responsePayload.setBody(body);
        return responsePayload;
    }

    private byte[] toResponseBody(Object o) throws KuraException {
        String result = null;
        try {
            result = this.marshal(o);
        }
        catch (Exception e) {
            logger.error("Error marshalling snapshots: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_LOADING, (Throwable)e, new Object[0]);
        }
        byte[] body = null;
        try {
            body = result.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Error encoding response body: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_SNAPSHOT_LOADING, (Throwable)e, new Object[0]);
        }
        return body;
    }

    private ServiceReference<Marshaller>[] getXmlMarshallers() {
        String filterString = String.format("(&(kura.service.pid=%s))", "org.eclipse.kura.xml.marshaller.unmarshaller.provider");
        return ServiceUtil.getServiceReferences((BundleContext)this.bundleContext, Marshaller.class, (String)filterString);
    }

    private ServiceReference<Unmarshaller>[] getXmlUnmarshallers() {
        String filterString = String.format("(&(kura.service.pid=%s))", "org.eclipse.kura.xml.marshaller.unmarshaller.provider");
        return ServiceUtil.getServiceReferences((BundleContext)this.bundleContext, Unmarshaller.class, (String)filterString);
    }

    private void ungetServiceReferences(ServiceReference<?>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)this.bundleContext, refs);
    }

    protected <T> T unmarshal(String xmlString, Class<T> clazz) throws KuraException {
        Object result;
        block8: {
            result = null;
            ServiceReference<Unmarshaller>[] unmarshallerSRs = this.getXmlUnmarshallers();
            try {
                try {
                    ServiceReference<Unmarshaller>[] serviceReferenceArray = unmarshallerSRs;
                    int n = unmarshallerSRs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ServiceReference<Unmarshaller> unmarshallerSR = serviceReferenceArray[n2];
                        Unmarshaller unmarshaller = (Unmarshaller)this.bundleContext.getService(unmarshallerSR);
                        result = unmarshaller.unmarshal(xmlString, clazz);
                        if (result == null) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    logger.warn("Failed to extract persisted configuration.");
                    this.ungetServiceReferences(unmarshallerSRs);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.ungetServiceReferences(unmarshallerSRs);
                throw throwable;
            }
            this.ungetServiceReferences(unmarshallerSRs);
        }
        if (result == null) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR);
        }
        return (T)result;
    }

    protected String marshal(Object object) {
        String result = null;
        ServiceReference<Marshaller>[] marshallerSRs = this.getXmlMarshallers();
        try {
            try {
                ServiceReference<Marshaller>[] serviceReferenceArray = marshallerSRs;
                int n = marshallerSRs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference<Marshaller> marshallerSR = serviceReferenceArray[n2];
                    Marshaller marshaller = (Marshaller)this.bundleContext.getService(marshallerSR);
                    result = marshaller.marshal(object);
                    if (result != null) {
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to marshal configuration.");
                this.ungetServiceReferences(marshallerSRs);
            }
        }
        finally {
            this.ungetServiceReferences(marshallerSRs);
        }
        return result;
    }
}

