/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.eddystone;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class EddystoneURLEncoding {
    private static Map<Byte, String> urlEncodings = new HashMap<Byte, String>();

    static {
        urlEncodings.put((byte)0, ".com/");
        urlEncodings.put((byte)1, ".org/");
        urlEncodings.put((byte)2, ".edu/");
        urlEncodings.put((byte)3, ".net/");
        urlEncodings.put((byte)4, ".info/");
        urlEncodings.put((byte)5, ".biz/");
        urlEncodings.put((byte)6, ".gov/");
        urlEncodings.put((byte)7, ".com");
        urlEncodings.put((byte)8, ".org");
        urlEncodings.put((byte)9, ".edu");
        urlEncodings.put((byte)10, ".net");
        urlEncodings.put((byte)11, ".info");
        urlEncodings.put((byte)12, ".biz");
        urlEncodings.put((byte)13, ".gov");
    }

    private EddystoneURLEncoding() {
    }

    public static byte[] encodeURL(String url) {
        String hexUrl = String.format("%x", new BigInteger(1, url.getBytes()));
        for (Map.Entry<Byte, String> entry : urlEncodings.entrySet()) {
            hexUrl = hexUrl.replaceAll(String.format("%x", new BigInteger(1, entry.getValue().getBytes())), String.format("%02x", entry.getKey()));
        }
        return EddystoneURLEncoding.urlToByteArray(hexUrl);
    }

    public static String decodeURL(byte[] url) {
        StringBuilder decodedUrl = new StringBuilder();
        byte[] byArray = url;
        int n = url.length;
        int n2 = 0;
        while (n2 < n) {
            byte hex = byArray[n2];
            if (hex <= 13) {
                decodedUrl.append(urlEncodings.get(hex));
            } else {
                decodedUrl.append((char)hex);
            }
            ++n2;
        }
        return decodedUrl.toString();
    }

    private static byte[] urlToByteArray(String url) {
        byte[] urlArray = new byte[url.length() / 2];
        int i = 0;
        while (i < url.length()) {
            urlArray[i / 2] = (byte)((Character.digit(url.charAt(i), 16) << 4) + Character.digit(url.charAt(i + 1), 16));
            i += 2;
        }
        return urlArray;
    }
}

