/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.dm.FilterIndex;
import org.apache.felix.dm.ServiceUtil;
import org.apache.felix.dm.tracker.ServiceTracker;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class AspectFilterIndex
implements FilterIndex,
ServiceTrackerCustomizer {
    private static final String FILTER_START = "(&(objectClass=";
    private static final String FILTER_SUBSTRING_0 = ")(&(|(!(service.ranking=*))(service.ranking<=";
    private static final String FILTER_SUBSTRING_1 = "))(|(service.id=";
    private static final String FILTER_SUBSTRING_2 = ")(org.apache.felix.dependencymanager.aspect=";
    private static final String FILTER_END = "))))";
    private final Object m_lock = new Object();
    private ServiceTracker m_tracker;
    private BundleContext m_context;
    private final Map m_sidToServiceReferencesMap = new HashMap();
    private final Map m_sidToRankingToListenersMap = new HashMap();
    private final Map m_listenerToFilterMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(BundleContext context) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context != null) {
                throw new IllegalStateException("Filter already open.");
            }
            try {
                this.m_tracker = new ServiceTracker(context, context.createFilter("(objectClass=*)"), (ServiceTrackerCustomizer)this);
            }
            catch (InvalidSyntaxException e) {
                throw new Error();
            }
            this.m_context = context;
        }
        this.m_tracker.open(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServiceTracker tracker;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_context == null) {
                throw new IllegalStateException("Filter already closed.");
            }
            tracker = this.m_tracker;
            this.m_tracker = null;
            this.m_context = null;
        }
        tracker.close();
    }

    public boolean isApplicable(String clazz, String filter) {
        return this.getFilterData(clazz, filter) != null;
    }

    private FilterData getFilterData(String clazz, String filter) {
        if (filter != null && filter.startsWith(FILTER_START) && filter.endsWith(FILTER_END)) {
            long sid2;
            int i0 = filter.indexOf(FILTER_SUBSTRING_0);
            if (i0 == -1) {
                return null;
            }
            int i1 = filter.indexOf(FILTER_SUBSTRING_1);
            if (i1 == -1 || i1 <= i0) {
                return null;
            }
            int i2 = filter.indexOf(FILTER_SUBSTRING_2);
            if (i2 == -1 || i2 <= i1) {
                return null;
            }
            long sid = Long.parseLong(filter.substring(i1 + FILTER_SUBSTRING_1.length(), i2));
            if (sid != (sid2 = Long.parseLong(filter.substring(i2 + FILTER_SUBSTRING_2.length(), filter.length() - FILTER_END.length())))) {
                return null;
            }
            FilterData result = new FilterData();
            result.className = filter.substring(FILTER_START.length(), i0);
            result.serviceId = sid;
            result.ranking = Integer.parseInt(filter.substring(i0 + FILTER_SUBSTRING_0.length(), i1));
            return result;
        }
        return null;
    }

    public List getAllServiceReferences(String clazz, String filter) {
        SortedSet list;
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        FilterData data = this.getFilterData(clazz, filter);
        if (data != null && (list = (SortedSet)this.m_sidToServiceReferencesMap.get(data.serviceId)) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ServiceReference reference = (ServiceReference)iterator.next();
                if (ServiceUtil.getRanking(reference) > data.ranking) continue;
                result.add(reference);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        ArrayList<ServiceListener> list = new ArrayList<ServiceListener>();
        ServiceReference reference = event.getServiceReference();
        Long sid = ServiceUtil.getServiceIdObject(reference);
        int ranking = ServiceUtil.getRanking(reference);
        Map map = this.m_sidToRankingToListenersMap;
        synchronized (map) {
            SortedMap map2 = (SortedMap)this.m_sidToRankingToListenersMap.get(sid);
            if (map2 != null) {
                Iterator iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (ranking > (Integer)entry.getKey()) continue;
                    list.add((ServiceListener)entry.getValue());
                }
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceListener listener = (ServiceListener)iterator.next();
            listener.serviceChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(ServiceListener listener, String filter) {
        FilterData data = this.getFilterData(null, filter);
        if (data != null) {
            Long sidObject = data.serviceId;
            Map map = this.m_sidToRankingToListenersMap;
            synchronized (map) {
                TreeMap<Integer, ServiceListener> rankingToListenersMap = (TreeMap<Integer, ServiceListener>)this.m_sidToRankingToListenersMap.get(sidObject);
                if (rankingToListenersMap == null) {
                    rankingToListenersMap = new TreeMap<Integer, ServiceListener>();
                    this.m_sidToRankingToListenersMap.put(sidObject, rankingToListenersMap);
                }
                rankingToListenersMap.put(data.ranking, listener);
                this.m_listenerToFilterMap.put(listener, filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(ServiceListener listener) {
        Map map = this.m_sidToRankingToListenersMap;
        synchronized (map) {
            String filter = (String)this.m_listenerToFilterMap.remove(listener);
            FilterData data = this.getFilterData(null, filter);
            if (data != null) {
                Map map2 = this.m_sidToRankingToListenersMap;
                synchronized (map2) {
                    SortedMap rankingToListenersMap = (SortedMap)this.m_sidToRankingToListenersMap.get(data.serviceId);
                    if (rankingToListenersMap != null) {
                        rankingToListenersMap.remove(data.ranking);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        BundleContext context;
        Object object = this.m_lock;
        synchronized (object) {
            context = this.m_context;
        }
        if (context != null) {
            return context.getService(reference);
        }
        throw new IllegalStateException("No valid bundle context.");
    }

    public void addedService(ServiceReference reference, Object service) {
        this.add(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.modify(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.remove(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ServiceReference reference) {
        Long sid = ServiceUtil.getServiceIdObject(reference);
        Map map = this.m_sidToServiceReferencesMap;
        synchronized (map) {
            TreeSet<ServiceReference> list = (TreeSet<ServiceReference>)this.m_sidToServiceReferencesMap.get(sid);
            if (list == null) {
                list = new TreeSet<ServiceReference>();
                this.m_sidToServiceReferencesMap.put(sid, list);
            }
            list.add(reference);
        }
    }

    public void modify(ServiceReference reference) {
        this.remove(reference);
        this.add(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ServiceReference reference) {
        Long sid = ServiceUtil.getServiceIdObject(reference);
        Map map = this.m_sidToServiceReferencesMap;
        synchronized (map) {
            Set list = (Set)this.m_sidToServiceReferencesMap.get(sid);
            if (list != null) {
                list.remove(reference);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AspectFilterIndex[");
        sb.append("S2R2L: " + this.m_sidToRankingToListenersMap.size());
        sb.append(", S2SR: " + this.m_sidToServiceReferencesMap.size());
        sb.append(", L2F: " + this.m_listenerToFilterMap.size());
        sb.append("]");
        return sb.toString();
    }

    private static class FilterData {
        public String className;
        public long serviceId;
        public int ranking;

        private FilterData() {
        }
    }
}

