/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.logger;

import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.util.Supplier;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.wire.logger.LoggingVerbosity;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public final class Logger
implements WireReceiver,
ConfigurableComponent {
    private static final org.apache.logging.log4j.Logger logger = LogManager.getLogger(Logger.class);
    private static final String DEFAULT_LOG_LEVEL = LoggingVerbosity.QUIET.name();
    private static final String PROP_LOG_LEVEL = "log.verbosity";
    private volatile WireHelperService wireHelperService;
    private WireSupport wireSupport;
    private Map<String, Object> properties;

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void unbindWireHelperService(WireHelperService wireHelperService) {
        if (this.wireHelperService == wireHelperService) {
            this.wireHelperService = null;
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating Logger Wire Component...");
        this.properties = properties;
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        logger.debug("Activating Logger Wire Component... Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating Logger Wire Component...");
        this.properties = properties;
        logger.debug("Updating Logger Wire Component... Done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating Logger Wire Component...");
        logger.debug("Deactivating Logger Wire Component... Done");
    }

    public void onWireReceive(WireEnvelope wireEnvelope) {
        Objects.requireNonNull(wireEnvelope, "Wire Envelope cannot be null");
        logger.info("Received WireEnvelope from {}", new Supplier[]{() -> wireEnvelope.getEmitterPid()});
        if (LoggingVerbosity.VERBOSE.name().equals(this.getLoggingLevel())) {
            logger.info("Record List content: ");
            for (WireRecord record : wireEnvelope.getRecords()) {
                logger.info("  Record content: ");
                for (Map.Entry entry : record.getProperties().entrySet()) {
                    logger.info("    {} : {}", new Supplier[]{() -> entry.getKey(), () -> ((TypedValue)entry.getValue()).getValue()});
                }
            }
            logger.info("");
        }
    }

    private String getLoggingLevel() {
        String logLevel = DEFAULT_LOG_LEVEL;
        Object configuredLogLevel = this.properties.get(PROP_LOG_LEVEL);
        if (Objects.nonNull(configuredLogLevel) && configuredLogLevel instanceof String) {
            logLevel = String.valueOf(configuredLogLevel);
        }
        return logLevel;
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }
}

