/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.command.PasswordCommandService;
import org.eclipse.kura.system.SystemAdminService;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.ThreadComparator;
import org.eclipse.kura.web.server.ThreadGroupComparator;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtGroupedNVPair;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtDeviceService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtDeviceServiceImpl
extends OsgiRemoteServiceServlet
implements GwtDeviceService {
    private static final Logger s_logger = LoggerFactory.getLogger(GwtDeviceServiceImpl.class);
    private static final String UNKNOWN = "UNKNOWN";
    private static final long serialVersionUID = -4176701819112753800L;

    @Override
    public ArrayList<GwtGroupedNVPair> findDeviceConfiguration(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        SystemAdminService systemAdminService = ServiceLocator.getInstance().getService(SystemAdminService.class);
        try {
            Properties systemProperties = systemService.getProperties();
            pairs.add(new GwtGroupedNVPair("devInfo", "devKuraVersion", systemService.getKuraVersion()));
            pairs.add(new GwtGroupedNVPair("devInfo", "devClientId", systemService.getPrimaryMacAddress() != null ? systemService.getPrimaryMacAddress() : UNKNOWN));
            pairs.add(new GwtGroupedNVPair("devInfo", "devDisplayName", systemService.getDeviceName()));
            pairs.add(new GwtGroupedNVPair("devInfo", "devUptime", this.formatUptime(Long.parseLong(systemAdminService.getUptime()))));
            pairs.add(new GwtGroupedNVPair("devInfo", "devLastWifiChannel", String.valueOf(systemService.getKuraWifiTopChannel())));
            pairs.add(new GwtGroupedNVPair("devHw", "devModelName", systemService.getModelName()));
            pairs.add(new GwtGroupedNVPair("devHw", "devModelId", systemService.getModelId()));
            pairs.add(new GwtGroupedNVPair("devHw", "devPartNumber", systemService.getPartNumber()));
            pairs.add(new GwtGroupedNVPair("devHw", "devSerialNumber", systemService.getSerialNumber()));
            pairs.add(new GwtGroupedNVPair("devSw", "devFirmwareVersion", systemService.getFirmwareVersion()));
            pairs.add(new GwtGroupedNVPair("devSw", "devBiosVersion", systemService.getBiosVersion()));
            pairs.add(new GwtGroupedNVPair("devSw", "devOsVersion", systemService.getOsVersion()));
            pairs.add(new GwtGroupedNVPair("devSw", "devOs", systemService.getOsName()));
            pairs.add(new GwtGroupedNVPair("devSw", "devOsArch", systemService.getOsArch()));
            pairs.add(new GwtGroupedNVPair("devJava", "devJvmName", systemProperties.getProperty("java.vm.name")));
            pairs.add(new GwtGroupedNVPair("devJava", "devJvmVersion", systemProperties.getProperty("java.vm.version")));
            pairs.add(new GwtGroupedNVPair("devJava", "devJvmProfile", String.valueOf(systemService.getJavaVendor()) + " " + systemService.getJavaVersion()));
            pairs.add(new GwtGroupedNVPair("devJava", "devOsgiFramework", systemProperties.getProperty("org.osgi.framework.vendor")));
            pairs.add(new GwtGroupedNVPair("devJava", "devOsgiFrameworkVersion", systemProperties.getProperty("org.osgi.framework.version")));
            if (systemService.getNumberOfProcessors() != -1) {
                pairs.add(new GwtGroupedNVPair("devJava", "devNumProc", String.valueOf(systemService.getNumberOfProcessors())));
            }
            pairs.add(new GwtGroupedNVPair("devJava", "devRamTot", String.valueOf(String.valueOf(systemService.getTotalMemory())) + " kB"));
            pairs.add(new GwtGroupedNVPair("devJava", "devRamFree", String.valueOf(String.valueOf(systemService.getFreeMemory())) + " kB"));
        }
        catch (Exception e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    @Override
    public ArrayList<GwtGroupedNVPair> findThreads(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
        while (rootGroup.getParent() != null) {
            rootGroup = rootGroup.getParent();
        }
        int numGroups = rootGroup.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[2 * numGroups];
        numGroups = rootGroup.enumerate(groups);
        Arrays.sort(groups, ThreadGroupComparator.getInstance());
        ThreadGroup[] threadGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadGroup group = threadGroupArray[n2];
            if (group != null) {
                StringBuilder sbGroup = new StringBuilder();
                sbGroup.append("ThreadGroup ").append(group.getName()).append(" [").append("maxprio=").append(group.getMaxPriority());
                sbGroup.append(", parent=");
                if (group.getParent() != null) {
                    sbGroup.append(group.getParent().getName());
                } else {
                    sbGroup.append('-');
                }
                sbGroup.append(", isDaemon=");
                sbGroup.append(group.isDaemon());
                sbGroup.append(", isDestroyed=");
                sbGroup.append(group.isDestroyed());
                sbGroup.append(']');
                int numThreads = group.activeCount();
                Thread[] threads = new Thread[numThreads * 2];
                group.enumerate(threads, false);
                Arrays.sort(threads, ThreadComparator.getInstance());
                Thread[] threadArray = threads;
                int n3 = threads.length;
                int n4 = 0;
                while (n4 < n3) {
                    Thread thread = threadArray[n4];
                    if (thread != null) {
                        StringBuilder sbThreadName = new StringBuilder();
                        sbThreadName.append(thread.getId()).append('/').append(thread.getName());
                        StringBuilder sbThreadValue = new StringBuilder();
                        sbThreadValue.append("priority=");
                        sbThreadValue.append(thread.getPriority());
                        sbThreadValue.append(", alive=");
                        sbThreadValue.append(thread.isAlive());
                        sbThreadValue.append(", daemon=");
                        sbThreadValue.append(thread.isDaemon());
                        sbThreadValue.append(", interrupted=");
                        sbThreadValue.append(thread.isInterrupted());
                        sbThreadValue.append(", loader=");
                        sbThreadValue.append(thread.getContextClassLoader());
                        sbThreadValue.append(']');
                        pairs.add(new GwtGroupedNVPair(sbGroup.toString(), sbThreadName.toString(), sbThreadValue.toString()));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    @Override
    public ArrayList<GwtGroupedNVPair> findSystemProperties(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        Properties kuraProps = systemService.getProperties();
        TreeSet<Object> kuraKeys = new TreeSet<Object>(kuraProps.keySet());
        for (Object e : kuraKeys) {
            pairs.add(new GwtGroupedNVPair("propsKura", e.toString(), kuraProps.get(e).toString()));
        }
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    @Override
    public ArrayList<GwtGroupedNVPair> findBundles(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        Bundle[] bundles = systemService.getBundles();
        if (bundles != null) {
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle != null) {
                    GwtGroupedNVPair pair = new GwtGroupedNVPair();
                    pair.setId(String.valueOf(bundle.getBundleId()));
                    pair.setName(this.getName(bundle));
                    pair.setStatus(this.toStateString(bundle));
                    pair.setVersion(GwtDeviceServiceImpl.getHeaderValue(bundle, "Bundle-Version"));
                    pairs.add(pair);
                }
                ++n2;
            }
        }
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    @Override
    public void startBundle(GwtXSRFToken xsrfToken, String bundleId) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        Bundle[] bundles = systemService.getBundles();
        s_logger.info("Starting bundle with ID: {}", (Object)bundleId);
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getBundleId() == Long.parseLong(bundleId)) {
                try {
                    b.start();
                    return;
                }
                catch (BundleException e) {
                    s_logger.error("Failed to start bundle {}", (Object)b.getBundleId(), (Object)e);
                    throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
                }
            }
            ++n2;
        }
        s_logger.error("Could not find bundle with ID: {}", (Object)bundleId);
        throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
    }

    @Override
    public void stopBundle(GwtXSRFToken xsrfToken, String bundleId) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        Bundle[] bundles = systemService.getBundles();
        s_logger.info("Stopping bundle with ID: {}", (Object)bundleId);
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getBundleId() == Long.parseLong(bundleId)) {
                try {
                    b.stop();
                    return;
                }
                catch (BundleException e) {
                    s_logger.error("Failed to stop bundle {}", (Object)b.getBundleId(), (Object)e);
                    throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
                }
            }
            ++n2;
        }
        s_logger.error("Could not find bundle with ID: {}", (Object)bundleId);
        throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
    }

    @Override
    public String executeCommand(GwtXSRFToken xsrfToken, String cmd, String pwd) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        PasswordCommandService commandService = ServiceLocator.getInstance().getService(PasswordCommandService.class);
        try {
            return commandService.execute(cmd, pwd);
        }
        catch (KuraException e) {
            if (e.getCode() == KuraErrorCode.OPERATION_NOT_SUPPORTED) {
                throw new GwtKuraException(GwtKuraErrorCode.SERVICE_NOT_ENABLED);
            }
            if (e.getCode() == KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID) {
                throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT);
            }
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
        }
    }

    private String getName(Bundle bundle) {
        String name = (String)bundle.getHeaders().get("Bundle-Name");
        if ((name == null || name.length() == 0) && (name = bundle.getSymbolicName()) == null && (name = bundle.getLocation()) == null) {
            name = String.valueOf(bundle.getBundleId());
        }
        return name;
    }

    private static String getHeaderValue(Bundle bundle, String headerName) {
        Object value = bundle.getHeaders().get(headerName);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    private String toStateString(Bundle bundle) {
        switch (bundle.getState()) {
            case 2: {
                return "bndInstalled";
            }
            case 4: {
                return "bndResolved";
            }
            case 8: {
                return "bndStarting";
            }
            case 32: {
                return "bndActive";
            }
            case 16: {
                return "bndStopping";
            }
            case 1: {
                return "bndUninstalled";
            }
        }
        return "bndUnknown";
    }

    private String formatUptime(long uptime) {
        int days = (int)TimeUnit.MILLISECONDS.toDays(uptime);
        long hours = TimeUnit.MILLISECONDS.toHours(uptime) - (long)(days * 24);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(uptime) - TimeUnit.MILLISECONDS.toHours(uptime) * 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(uptime) - TimeUnit.MILLISECONDS.toMinutes(uptime) * 60L;
        StringBuilder sb = new StringBuilder();
        sb.append(days).append(" days ").append(hours).append(":").append(minutes).append(":").append(seconds).append(" hms");
        return sb.toString();
    }
}

