/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.firewall;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SingleSelectionModel;
import com.google.web.bindery.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.AlertDialog;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.Tab;
import org.eclipse.kura.web.client.ui.firewall.ButtonBar;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.client.util.TextFieldValidator;
import org.eclipse.kura.web.shared.model.GwtFirewallNatEntry;
import org.eclipse.kura.web.shared.model.GwtFirewallNatMasquerade;
import org.eclipse.kura.web.shared.model.GwtFirewallNatProtocol;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtNetworkService;
import org.eclipse.kura.web.shared.service.GwtNetworkServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.shared.event.ModalHideEvent;
import org.gwtbootstrap3.client.shared.event.ModalHideHandler;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.Tooltip;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.gwt.CellTable;

public class NatTabUi
extends Composite
implements Tab,
ButtonBar.Listener {
    private static NatTabUiUiBinder uiBinder = (NatTabUiUiBinder)GWT.create(NatTabUiUiBinder.class);
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtNetworkServiceAsync gwtNetworkService = (GwtNetworkServiceAsync)GWT.create(GwtNetworkService.class);
    private final ListDataProvider<GwtFirewallNatEntry> natDataProvider = new ListDataProvider();
    final SingleSelectionModel<GwtFirewallNatEntry> selectionModel = new SingleSelectionModel();
    private boolean dirty;
    private GwtFirewallNatEntry newNatEntry;
    private GwtFirewallNatEntry editNatEntry;
    @UiField
    ButtonBar buttonBar;
    @UiField
    Alert notification;
    @UiField
    CellTable<GwtFirewallNatEntry> natGrid = new CellTable();
    @UiField
    Modal natForm;
    @UiField
    FormGroup groupInput;
    @UiField
    FormGroup groupOutput;
    @UiField
    FormGroup groupProtocol;
    @UiField
    FormGroup groupSource;
    @UiField
    FormGroup groupDestination;
    @UiField
    FormGroup groupEnable;
    @UiField
    FormLabel labelInput;
    @UiField
    FormLabel labelOutput;
    @UiField
    FormLabel labelProtocol;
    @UiField
    FormLabel labelSource;
    @UiField
    FormLabel labelDestination;
    @UiField
    FormLabel labelEnable;
    @UiField
    Tooltip tooltipInput;
    @UiField
    Tooltip tooltipOutput;
    @UiField
    Tooltip tooltipProtocol;
    @UiField
    Tooltip tooltipSource;
    @UiField
    Tooltip tooltipDestination;
    @UiField
    Tooltip tooltipEnable;
    @UiField
    TextBox input;
    @UiField
    TextBox output;
    @UiField
    TextBox source;
    @UiField
    TextBox destination;
    @UiField
    ListBox protocol;
    @UiField
    ListBox enable;
    @UiField
    Button submit;
    @UiField
    Button cancel;
    @UiField
    AlertDialog alertDialog;
    private HandlerRegistration modalHideHandlerRegistration;

    public NatTabUi() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.buttonBar.setListener(this);
        this.initTable();
        this.initModal();
    }

    @Override
    public void refresh() {
        EntryClassUi.showWaitModal();
        this.natDataProvider.getList().clear();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                NatTabUi.this.gwtNetworkService.findDeviceFirewallNATs(token, new AsyncCallback<List<GwtFirewallNatEntry>>(){

                    public void onFailure(Throwable caught) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(caught);
                    }

                    public void onSuccess(List<GwtFirewallNatEntry> result) {
                        for (GwtFirewallNatEntry pair : result) {
                            NatTabUi.this.natDataProvider.getList().add(pair);
                        }
                        NatTabUi.this.refreshTable();
                        (this).NatTabUi.this.buttonBar.setDirty(false);
                        EntryClassUi.hideWaitModal();
                    }
                });
            }
        });
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean b) {
        this.dirty = b;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    private void initTable() {
        TextColumn<GwtFirewallNatEntry> col1 = new TextColumn<GwtFirewallNatEntry>(){

            public String getValue(GwtFirewallNatEntry object) {
                if (object.getInInterface() != null) {
                    return String.valueOf(object.getInInterface());
                }
                return "";
            }
        };
        col1.setCellStyleNames("status-table-row");
        this.natGrid.addColumn((Column)col1, MSGS.firewallNatInInterface());
        TextColumn<GwtFirewallNatEntry> col2 = new TextColumn<GwtFirewallNatEntry>(){

            public String getValue(GwtFirewallNatEntry object) {
                if (object.getOutInterface() != null) {
                    return String.valueOf(object.getOutInterface());
                }
                return "";
            }
        };
        col2.setCellStyleNames("status-table-row");
        this.natGrid.addColumn((Column)col2, MSGS.firewallNatOutInterface());
        TextColumn<GwtFirewallNatEntry> col3 = new TextColumn<GwtFirewallNatEntry>(){

            public String getValue(GwtFirewallNatEntry object) {
                if (object.getProtocol() != null) {
                    return String.valueOf(object.getProtocol());
                }
                return "";
            }
        };
        col3.setCellStyleNames("status-table-row");
        this.natGrid.addColumn((Column)col3, MSGS.firewallNatProtocol());
        TextColumn<GwtFirewallNatEntry> col4 = new TextColumn<GwtFirewallNatEntry>(){

            public String getValue(GwtFirewallNatEntry object) {
                if (object.getSourceNetwork() != null) {
                    return String.valueOf(object.getSourceNetwork());
                }
                return "";
            }
        };
        col4.setCellStyleNames("status-table-row");
        this.natGrid.addColumn((Column)col4, MSGS.firewallNatSourceNetwork());
        TextColumn<GwtFirewallNatEntry> col5 = new TextColumn<GwtFirewallNatEntry>(){

            public String getValue(GwtFirewallNatEntry object) {
                if (object.getDestinationNetwork() != null) {
                    return String.valueOf(object.getDestinationNetwork());
                }
                return "";
            }
        };
        col5.setCellStyleNames("status-table-row");
        this.natGrid.addColumn((Column)col5, MSGS.firewallNatDestinationNetwork());
        TextColumn<GwtFirewallNatEntry> col6 = new TextColumn<GwtFirewallNatEntry>(){

            public String getValue(GwtFirewallNatEntry object) {
                if (object.getMasquerade() != null) {
                    return String.valueOf(object.getMasquerade());
                }
                return "";
            }
        };
        col6.setCellStyleNames("status-table-row");
        this.natGrid.addColumn((Column)col6, MSGS.firewallNatMasquerade());
        this.natDataProvider.addDataDisplay(this.natGrid);
        this.natGrid.setSelectionModel(this.selectionModel);
    }

    private void refreshTable() {
        int size = this.natDataProvider.getList().size();
        this.natGrid.setVisibleRange(0, size);
        this.natDataProvider.flush();
        if (this.natDataProvider.getList().isEmpty()) {
            this.natGrid.setVisible(false);
            this.notification.setVisible(true);
            this.notification.setText(MSGS.firewallPortForwardTableNoPorts());
        } else {
            this.natGrid.setVisible(true);
            this.notification.setVisible(false);
        }
        this.natGrid.redraw();
    }

    @Override
    public void onApply() {
        List intermediateList = this.natDataProvider.getList();
        final ArrayList<GwtFirewallNatEntry> updatedNatConf = new ArrayList<GwtFirewallNatEntry>();
        for (GwtFirewallNatEntry entry : intermediateList) {
            updatedNatConf.add(entry);
        }
        EntryClassUi.showWaitModal();
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                EntryClassUi.hideWaitModal();
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                NatTabUi.this.gwtNetworkService.updateDeviceFirewallNATs(token, updatedNatConf, new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        EntryClassUi.hideWaitModal();
                        FailureHandler.handle(caught);
                    }

                    public void onSuccess(Void result) {
                        NatTabUi.this.setDirty(false);
                        (this).NatTabUi.this.buttonBar.setDirty(false);
                        EntryClassUi.hideWaitModal();
                    }
                });
            }
        });
    }

    @Override
    public void onCancel() {
        this.alertDialog.show(MSGS.deviceConfigDirty(), new AlertDialog.Listener(){

            @Override
            public void onConfirm() {
                NatTabUi.this.refresh();
            }
        });
    }

    @Override
    public void onCreate() {
        this.replaceModalHideHandler(new ModalHideHandler(){

            public void onHide(ModalHideEvent evt) {
                if (NatTabUi.this.newNatEntry != null && !NatTabUi.this.duplicateEntry(NatTabUi.this.newNatEntry)) {
                    NatTabUi.this.natDataProvider.getList().add(NatTabUi.this.newNatEntry);
                    NatTabUi.this.refreshTable();
                    NatTabUi.this.buttonBar.setDirty(true);
                    NatTabUi.this.newNatEntry = null;
                }
            }
        });
        this.showModal(null);
    }

    @Override
    public void onEdit() {
        GwtFirewallNatEntry selection = (GwtFirewallNatEntry)this.selectionModel.getSelectedObject();
        if (selection == null) {
            return;
        }
        this.replaceModalHideHandler(new ModalHideHandler(){

            public void onHide(ModalHideEvent evt) {
                if (NatTabUi.this.editNatEntry != null) {
                    GwtFirewallNatEntry oldEntry = (GwtFirewallNatEntry)NatTabUi.this.selectionModel.getSelectedObject();
                    NatTabUi.this.natDataProvider.getList().remove(oldEntry);
                    if (!NatTabUi.this.duplicateEntry(NatTabUi.this.editNatEntry)) {
                        NatTabUi.this.natDataProvider.getList().add(NatTabUi.this.editNatEntry);
                        NatTabUi.this.natDataProvider.flush();
                        NatTabUi.this.buttonBar.setDirty(true);
                        NatTabUi.this.editNatEntry = null;
                    } else {
                        NatTabUi.this.natDataProvider.getList().add(oldEntry);
                        NatTabUi.this.natDataProvider.flush();
                    }
                }
            }
        });
        this.showModal(selection);
    }

    @Override
    public void onDelete() {
        final GwtFirewallNatEntry selection = (GwtFirewallNatEntry)this.selectionModel.getSelectedObject();
        if (selection == null) {
            return;
        }
        this.alertDialog.show(MSGS.firewallNatDeleteConfirmation(selection.getInInterface()), new AlertDialog.Listener(){

            @Override
            public void onConfirm() {
                NatTabUi.this.natDataProvider.getList().remove(selection);
                NatTabUi.this.refreshTable();
                NatTabUi.this.buttonBar.setDirty(true);
                NatTabUi.this.setDirty(true);
            }
        });
    }

    private void initModal() {
        this.cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NatTabUi.this.natForm.hide();
            }
        });
        this.submit.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NatTabUi.this.checkFieldsValues();
                if (NatTabUi.this.groupInput.getValidationState() == ValidationState.ERROR || NatTabUi.this.groupOutput.getValidationState() == ValidationState.ERROR || NatTabUi.this.groupSource.getValidationState() == ValidationState.ERROR || NatTabUi.this.groupDestination.getValidationState() == ValidationState.ERROR) {
                    return;
                }
                GwtFirewallNatEntry natEntry = new GwtFirewallNatEntry();
                natEntry.setInInterface(NatTabUi.this.input.getText());
                natEntry.setOutInterface(NatTabUi.this.output.getText());
                natEntry.setProtocol(NatTabUi.this.protocol.getSelectedItemText());
                natEntry.setSourceNetwork(NatTabUi.this.source.getText());
                natEntry.setDestinationNetwork(NatTabUi.this.destination.getText());
                natEntry.setMasquerade(NatTabUi.this.enable.getSelectedItemText());
                if (NatTabUi.this.submit.getId().equals("new")) {
                    NatTabUi.this.newNatEntry = natEntry;
                    NatTabUi.this.editNatEntry = null;
                } else if (NatTabUi.this.submit.getId().equals("edit")) {
                    NatTabUi.this.editNatEntry = natEntry;
                    NatTabUi.this.newNatEntry = null;
                }
                NatTabUi.this.natForm.hide();
                NatTabUi.this.setDirty(true);
            }
        });
    }

    private void showModal(GwtFirewallNatEntry existingEntry) {
        if (existingEntry == null) {
            this.natForm.setTitle(MSGS.firewallNatFormInformation());
        } else {
            this.natForm.setTitle(MSGS.firewallNatFormUpdate(existingEntry.getOutInterface()));
        }
        this.setModalFieldsLabels();
        this.setModalFieldsValues(existingEntry);
        this.setModalFieldsTooltips();
        this.setModalFieldsHandlers();
        if (existingEntry == null) {
            this.submit.setId("new");
        } else {
            this.submit.setId("edit");
        }
        this.natForm.show();
    }

    private void setModalFieldsHandlers() {
        this.input.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (!NatTabUi.this.input.getText().trim().matches(TextFieldValidator.FieldType.ALPHANUMERIC.getRegex()) || NatTabUi.this.input.getText().trim().isEmpty()) {
                    NatTabUi.this.groupInput.setValidationState(ValidationState.ERROR);
                } else {
                    NatTabUi.this.groupInput.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.output.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (!NatTabUi.this.output.getText().trim().matches(TextFieldValidator.FieldType.ALPHANUMERIC.getRegex()) || NatTabUi.this.output.getText().trim().isEmpty()) {
                    NatTabUi.this.groupOutput.setValidationState(ValidationState.ERROR);
                } else {
                    NatTabUi.this.groupOutput.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.source.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (!NatTabUi.this.source.getText().trim().isEmpty() && !NatTabUi.this.source.getText().trim().matches(TextFieldValidator.FieldType.NETWORK.getRegex())) {
                    NatTabUi.this.groupSource.setValidationState(ValidationState.ERROR);
                } else {
                    NatTabUi.this.groupSource.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.destination.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (!NatTabUi.this.destination.getText().trim().isEmpty() && !NatTabUi.this.destination.getText().trim().matches(TextFieldValidator.FieldType.NETWORK.getRegex())) {
                    NatTabUi.this.groupDestination.setValidationState(ValidationState.ERROR);
                } else {
                    NatTabUi.this.groupDestination.setValidationState(ValidationState.NONE);
                }
            }
        });
    }

    private void setModalFieldsValues(GwtFirewallNatEntry existingEntry) {
        if (existingEntry != null) {
            this.input.setText(existingEntry.getInInterface());
            this.output.setText(existingEntry.getOutInterface());
            this.source.setText(existingEntry.getSourceNetwork());
            this.destination.setText(existingEntry.getDestinationNetwork());
            int i = 0;
            while (i < this.protocol.getItemCount()) {
                if (existingEntry.getProtocol().equals(this.protocol.getItemText(i))) {
                    this.protocol.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < this.enable.getItemCount()) {
                if (existingEntry.getMasquerade().equals(this.enable.getItemText(i))) {
                    this.enable.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        } else {
            this.input.setText("");
            this.output.setText("");
            this.source.setText("");
            this.destination.setText("");
            this.protocol.setSelectedIndex(0);
            this.enable.setSelectedIndex(0);
        }
    }

    private void setModalFieldsTooltips() {
        this.tooltipInput.setTitle(MSGS.firewallNatFormInputInterfaceToolTip());
        this.tooltipOutput.setTitle(MSGS.firewallNatFormOutputInterfaceToolTip());
        this.tooltipProtocol.setTitle(MSGS.firewallNatFormProtocolToolTip());
        this.tooltipSource.setTitle(MSGS.firewallNatFormSourceNetworkToolTip());
        this.tooltipDestination.setTitle(MSGS.firewallNatFormDestinationNetworkToolTip());
        this.tooltipEnable.setTitle(MSGS.firewallNatFormMasqueradingToolTip());
        this.tooltipInput.reconfigure();
        this.tooltipOutput.reconfigure();
        this.tooltipProtocol.reconfigure();
        this.tooltipSource.reconfigure();
        this.tooltipDestination.reconfigure();
        this.tooltipEnable.reconfigure();
    }

    private void setModalFieldsLabels() {
        this.labelInput.setText(String.valueOf(MSGS.firewallNatFormInInterfaceName()) + "*");
        this.labelOutput.setText(String.valueOf(MSGS.firewallNatFormOutInterfaceName()) + "*");
        this.labelProtocol.setText(MSGS.firewallNatFormProtocol());
        this.labelSource.setText(MSGS.firewallNatFormSourceNetwork());
        this.labelDestination.setText(MSGS.firewallNatFormDestinationNetwork());
        this.labelEnable.setText(MSGS.firewallNatFormMasquerade());
        this.submit.setText(MSGS.submitButton());
        this.cancel.setText(MSGS.cancelButton());
        this.protocol.clear();
        Enum[] enumArray = GwtFirewallNatProtocol.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            GwtFirewallNatProtocol prot = enumArray[n2];
            this.protocol.addItem(prot.name());
            ++n2;
        }
        this.enable.clear();
        enumArray = GwtFirewallNatMasquerade.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum masquerade = enumArray[n2];
            this.enable.addItem(masquerade.name());
            ++n2;
        }
    }

    private boolean duplicateEntry(GwtFirewallNatEntry firewallNatEntry) {
        boolean isDuplicateEntry = false;
        List entries = this.natDataProvider.getList();
        if (entries != null && firewallNatEntry != null) {
            for (GwtFirewallNatEntry entry : entries) {
                String newDestinationNetwork;
                String sourceNetwork = entry.getSourceNetwork() != null ? entry.getSourceNetwork() : "0.0.0.0/0";
                String destinationNetwork = entry.getDestinationNetwork() != null ? entry.getDestinationNetwork() : "0.0.0.0/0";
                String newSourceNetwork = firewallNatEntry.getSourceNetwork() != null ? firewallNatEntry.getSourceNetwork() : "0.0.0.0/0";
                String string = newDestinationNetwork = firewallNatEntry.getDestinationNetwork() != null ? firewallNatEntry.getDestinationNetwork() : "0.0.0.0/0";
                if (!entry.getInInterface().equals(firewallNatEntry.getInInterface()) || !entry.getOutInterface().equals(firewallNatEntry.getOutInterface()) || !entry.getProtocol().equals(firewallNatEntry.getProtocol()) || !sourceNetwork.equals(newSourceNetwork) || !destinationNetwork.equals(newDestinationNetwork)) continue;
                isDuplicateEntry = true;
                break;
            }
        }
        return isDuplicateEntry;
    }

    private void checkFieldsValues() {
        if (this.input.getText() == null || "".equals(this.input.getText().trim())) {
            this.groupInput.setValidationState(ValidationState.ERROR);
        }
        if (this.output.getText() == null || "".equals(this.output.getText().trim())) {
            this.groupOutput.setValidationState(ValidationState.ERROR);
        }
    }

    private void replaceModalHideHandler(ModalHideHandler hideHandler) {
        if (this.modalHideHandlerRegistration != null) {
            this.modalHideHandlerRegistration.removeHandler();
        }
        this.modalHideHandlerRegistration = this.natForm.addHideHandler(hideHandler);
    }

    static interface NatTabUiUiBinder
    extends UiBinder<Widget, NatTabUi> {
    }
}

