/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.cloudconnection;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.cloudconnection.CloudConnectionConfigurationUi;
import org.eclipse.kura.web.client.ui.cloudconnection.CloudConnectionConfigurationsUi;
import org.eclipse.kura.web.client.ui.cloudconnection.CloudInstancesUi;
import org.eclipse.kura.web.client.util.EventService;
import org.eclipse.kura.web.client.util.request.RequestQueue;
import org.eclipse.kura.web.shared.ForwardedEventTopic;
import org.eclipse.kura.web.shared.model.GwtCloudConnectionEntry;
import org.eclipse.kura.web.shared.model.GwtCloudEntry;
import org.eclipse.kura.web.shared.model.GwtEventInfo;
import org.eclipse.kura.web.shared.service.GwtCloudConnectionService;
import org.eclipse.kura.web.shared.service.GwtCloudConnectionServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.ModalHeader;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.html.Span;

public class CloudConnectionsUi
extends Composite {
    private static final Logger logger = Logger.getLogger(CloudConnectionsUi.class.getSimpleName());
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final GwtCloudConnectionServiceAsync gwtCloudService = (GwtCloudConnectionServiceAsync)GWT.create(GwtCloudConnectionService.class);
    private static CloudServicesUiUiBinder uiBinder = (CloudServicesUiUiBinder)GWT.create(CloudServicesUiUiBinder.class);
    private final CloudInstancesUi cloudInstancesBinder;
    private final CloudConnectionConfigurationsUi cloudServiceConfigurationsBinder;
    private GwtCloudEntry currentlySelectedEntry;
    private TabListItem currentlySelectedTab;
    private static final String CONNECTION_EVENT_PID_PROPERTY_KEY = "cloud.service.pid";
    @UiField
    HTMLPanel cloudServicesIntro;
    @UiField
    Panel cloudInstancesPanel;
    @UiField
    Panel cloudConfigurationsPanel;
    @UiField
    Alert notification;

    public CloudConnectionsUi() {
        logger.log(Level.FINER, "Initializing StatusPanelUi...");
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.cloudServicesIntro.add((Widget)new Span("<p>" + MSGS.cloudServicesTabIntro() + "</p>"));
        this.cloudInstancesBinder = new CloudInstancesUi(this);
        this.cloudInstancesPanel.add((Widget)this.cloudInstancesBinder);
        this.cloudServiceConfigurationsBinder = new CloudConnectionConfigurationsUi(this);
        this.cloudConfigurationsPanel.add((Widget)this.cloudServiceConfigurationsBinder);
        EventService.subscribe(ForwardedEventTopic.CLOUD_CONNECTION_STATUS_ESTABLISHED, eventInfo -> this.handleConnectionStatusEvent(eventInfo, GwtCloudConnectionEntry.GwtCloudConnectionState.CONNECTED));
        EventService.subscribe(ForwardedEventTopic.CLOUD_CONNECTION_STATUS_LOST, eventInfo -> this.handleConnectionStatusEvent(eventInfo, GwtCloudConnectionEntry.GwtCloudConnectionState.DISCONNECTED));
    }

    public void refresh() {
        RequestQueue.submit(context -> this.gwtCloudService.findCloudEntries(context.callback(data -> {
            this.cloudInstancesBinder.setData((List<GwtCloudEntry>)data);
            this.currentlySelectedEntry = this.cloudInstancesBinder.getSelectedObject();
            this.currentlySelectedTab = this.cloudServiceConfigurationsBinder.getSelectedTab();
            this.setVisibility();
            this.gwtCloudService.getCloudComponentFactories(context.callback(this.cloudInstancesBinder::setFactoryInfo));
        })));
    }

    public void setDirty(boolean dirty) {
        this.cloudServiceConfigurationsBinder.setDirty(dirty);
    }

    public boolean isDirty() {
        return this.cloudServiceConfigurationsBinder.isDirty();
    }

    private void setVisibility() {
        if (this.cloudInstancesBinder.getTableSize() == 0) {
            this.cloudInstancesBinder.setVisibility(false);
            this.cloudServiceConfigurationsBinder.setVisibility(false);
            this.cloudConfigurationsPanel.setVisible(false);
            this.notification.setVisible(true);
            this.notification.setText(MSGS.noConnectionsAvailable());
        } else {
            this.cloudInstancesBinder.setVisibility(true);
            this.cloudServiceConfigurationsBinder.setVisibility(true);
            this.cloudConfigurationsPanel.setVisible(true);
            this.notification.setVisible(false);
        }
    }

    protected void onSelectionChange() {
        GwtCloudEntry selectedInstanceEntry = this.cloudInstancesBinder.getSelectedObject();
        if (!this.isDirty()) {
            if (selectedInstanceEntry != null) {
                this.currentlySelectedEntry = selectedInstanceEntry;
                this.cloudServiceConfigurationsBinder.selectEntry(selectedInstanceEntry);
            }
        } else if (selectedInstanceEntry != this.currentlySelectedEntry) {
            this.showDirtyModal();
        }
    }

    protected void onTabSelectionChange(TabListItem newTab) {
        this.currentlySelectedTab = this.cloudServiceConfigurationsBinder.getSelectedTab();
        if (this.isDirty() && newTab != this.currentlySelectedTab) {
            this.showDirtyModal();
        } else {
            this.currentlySelectedTab = newTab;
            this.cloudServiceConfigurationsBinder.setSelectedTab(this.currentlySelectedTab);
        }
    }

    private void handleConnectionStatusEvent(GwtEventInfo info, GwtCloudConnectionEntry.GwtCloudConnectionState state) {
        String cloudServicePid = (String)info.get(CONNECTION_EVENT_PID_PROPERTY_KEY);
        if (cloudServicePid == null || !this.cloudInstancesBinder.setStatus(cloudServicePid, state)) {
            this.refresh();
        }
    }

    private void showDirtyModal() {
        Modal modal = new Modal();
        ModalHeader header = new ModalHeader();
        header.setTitle(MSGS.confirm());
        modal.add((Widget)header);
        ModalBody body = new ModalBody();
        body.add((Widget)new Span(MSGS.deviceConfigDirty()));
        modal.add((Widget)body);
        ModalFooter footer = new ModalFooter();
        ButtonGroup group = new ButtonGroup();
        Button yes = new Button();
        yes.setText(MSGS.yesButton());
        yes.addClickHandler(event -> {
            CloudConnectionConfigurationUi dirtyConfig;
            modal.hide();
            GwtCloudEntry selectedInstanceEntry = this.cloudInstancesBinder.getSelectedObject();
            if (selectedInstanceEntry != null) {
                this.currentlySelectedEntry = selectedInstanceEntry;
                this.cloudServiceConfigurationsBinder.selectEntry(selectedInstanceEntry);
            }
            if ((dirtyConfig = this.cloudServiceConfigurationsBinder.getDirtyCloudConfiguration()) != null) {
                dirtyConfig.resetVisualization();
            }
            this.setDirty(false);
        });
        Button no = new Button();
        no.setText(MSGS.noButton());
        no.addClickHandler(event -> {
            this.cloudInstancesBinder.setSelected(this.currentlySelectedEntry);
            this.currentlySelectedTab.showTab();
            modal.hide();
        });
        group.add((Widget)no);
        group.add((Widget)yes);
        footer.add((Widget)group);
        modal.add((Widget)footer);
        modal.show();
        no.setFocus(true);
    }

    static interface CloudServicesUiUiBinder
    extends UiBinder<Widget, CloudConnectionsUi> {
    }
}

