/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_nmg extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ES = "Paŋá";
        final String metaValue_FR = "Fala";
        final Object[][] data = new Object[][] {
            { "AD", "Andɔ́ra" },
            { "AE", "Minlambɔ́ Nsaŋ́nsa mí Arabia" },
            { "AF", "Afganistaŋ" },
            { "AG", "Antíga bá Barbúda" },
            { "AI", "Anguílla" },
            { "AL", "Albania" },
            { "AM", "Arménia" },
            { "AO", "Angola" },
            { "AR", "Argentína" },
            { "AS", "Samoa m ́Amɛ́rka" },
            { "AT", "Ötrish" },
            { "AU", "Östraliá" },
            { "AW", "Árúba" },
            { "AZ", "Azerbaïjaŋ" },
            { "BA", "Bosnia na Ɛrzegovina" },
            { "BB", "Barbado" },
            { "BD", "Bɛŋgladɛsh" },
            { "BE", "Bɛlgik" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BM", "Bɛrmuda" },
            { "BN", "Brunɛi" },
            { "BO", "Bolivia" },
            { "BR", "Brésil" },
            { "BS", "Bahamas" },
            { "BT", "Butaŋ" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Bɛliz" },
            { "CA", "Kanada" },
            { "CD", "Kongó Zaïre" },
            { "CF", "Sentrafríka" },
            { "CG", "Kongo" },
            { "CH", "Switzɛrland" },
            { "CI", "Kote d´Ivoire" },
            { "CK", "Maŋ́ má Kook" },
            { "CL", "Tshili" },
            { "CM", "Kamerun" },
            { "CN", "Shine" },
            { "CO", "Kɔlɔ́mbia" },
            { "CR", "Kosta Ríka" },
            { "CU", "Kuba" },
            { "CV", "Maŋ́ má Kapvɛr" },
            { "CY", "Sipria" },
            { "CZ", "Nlambɔ́ bó tschɛk" },
            { "DE", "Jaman" },
            { "DJ", "Jibúti" },
            { "DK", "Danemark" },
            { "DM", "Dominíka" },
            { "DO", "Nlambɔ́ Dominíka" },
            { "DZ", "Algeria" },
            { "EC", "Ekuateur" },
            { "EE", "Ɛstonia" },
            { "EG", "Ägyptɛn" },
            { "ER", "Erytrea" },
            { "ES", metaValue_ES },
            { "ET", "Ethiopiá" },
            { "FI", "Finlande" },
            { "FJ", "Fijiá" },
            { "FK", "Maŋ má Falkland" },
            { "FM", "Mikronesia" },
            { "FR", metaValue_FR },
            { "GA", "Gabɔŋ" },
            { "GB", "Nlambɔ́ Ngɛlɛn" },
            { "GD", "Grenada" },
            { "GE", "Jɔrgia" },
            { "GF", "Guyane Fala" },
            { "GH", "Gána" },
            { "GI", "Gilbratar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guine" },
            { "GP", "Guadeloup" },
            { "GQ", "Guine Ekuatorial" },
            { "GR", "Grɛce" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guine Bisso" },
            { "GY", "Guyana" },
            { "HN", "Ɔndúras" },
            { "HR", "Kroasia" },
            { "HT", "Haïti" },
            { "HU", "Ɔngría" },
            { "ID", "Indonesia" },
            { "IE", "Irland" },
            { "IL", "Äsrɛl" },
            { "IN", "India" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italia" },
            { "JM", "Jamaika" },
            { "JO", "Jɔrdania" },
            { "JP", "Japɔn" },
            { "KE", "Kɛnya" },
            { "KG", "Kyrgystaŋ" },
            { "KH", "Kambodia" },
            { "KI", "Kiribati" },
            { "KM", "Kɔmɔr" },
            { "KN", "Saint Kitts na Nevis" },
            { "KP", "Koré yí bvuɔ" },
            { "KR", "Koré yí sí" },
            { "KW", "Kowɛit" },
            { "KY", "Maŋ́ má kumbi" },
            { "KZ", "Kazakstaŋ" },
            { "LA", "Laos" },
            { "LB", "Libaŋ" },
            { "LC", "Saint Lucia" },
            { "LI", "Lishenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituaniá" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Marɔk" },
            { "MC", "Monako" },
            { "MD", "Mɔldavia" },
            { "MG", "Madagaskar" },
            { "MH", "Maŋ́ má Marshall" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mɔngolia" },
            { "MP", "Maŋ́ Mariá" },
            { "MQ", "Martinika" },
            { "MR", "Moritania" },
            { "MS", "Mɔnserrat" },
            { "MT", "Malta" },
            { "MU", "Morisse" },
            { "MV", "Maldivia" },
            { "MW", "Malawi" },
            { "MX", "Mɛxik" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "Kaledoni nwanah" },
            { "NE", "Niger" },
            { "NF", "Maŋ́ má Nɔrfɔrk" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", "Nedɛrland" },
            { "NO", "Nɔrvɛg" },
            { "NP", "Nepal" },
            { "NR", "Noru" },
            { "NU", "Niuɛ" },
            { "NZ", "Zeland nwanah" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polynesia Fala" },
            { "PG", "Guine Papuasi" },
            { "PH", "Filipin" },
            { "PK", "Pakistan" },
            { "PL", "Pɔlɔŋ" },
            { "PM", "Saint Peter ba Mikelɔn" },
            { "PN", "Pitkairn" },
            { "PR", "Puɛrto Riko" },
            { "PS", "Palɛstin" },
            { "PT", "Pɔrtugal" },
            { "PW", "Palo" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "RE", "Réuniɔn" },
            { "RO", "Roumania" },
            { "RU", "Russi" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Maŋ́ má Salomɔn" },
            { "SC", "Seychɛlle" },
            { "SD", "Sudaŋ" },
            { "SE", "Suɛd" },
            { "SG", "Singapur" },
            { "SH", "Saint Lina" },
            { "SI", "Slovenia" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leɔn" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somália" },
            { "SR", "Surinam" },
            { "ST", "Sao Tomé ba Prinship" },
            { "SV", "Salvadɔr" },
            { "SY", "Syria" },
            { "SZ", "Swaziland" },
            { "TC", "Maŋ́ má Turk na Kaiko" },
            { "TD", "Tshad" },
            { "TG", "Togo" },
            { "TH", "Taïland" },
            { "TJ", "Tajikistaŋ" },
            { "TK", "Tokelo" },
            { "TL", "Timɔr tsindikēh" },
            { "TM", "Turkmɛnistaŋ" },
            { "TN", "Tunisiá" },
            { "TO", "Tɔnga" },
            { "TR", "Turki" },
            { "TT", "Trinidad ba Tobágó" },
            { "TV", "Tuvalú" },
            { "TW", "Taïwan" },
            { "TZ", "Tanzánía" },
            { "UA", "Ukrɛn" },
            { "UG", "Uganda" },
            { "US", "Amɛŕka" },
            { "UY", "Uruguay" },
            { "UZ", "Usbǝkistaŋ" },
            { "VA", "Vatikaŋ" },
            { "VC", "Saint Vincent ba Grenadines" },
            { "VE", "Vǝnǝzuela" },
            { "VG", "Minsilɛ́ mímaŋ mí ngɛ̄lɛ̄n" },
            { "VI", "Minsilɛ mí maŋ́ m´Amɛrka" },
            { "VN", "Viɛtnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ba Futuna" },
            { "WS", "Samoa" },
            { "YE", "Yǝmɛn" },
            { "YT", "Mayɔt" },
            { "ZA", "Afríka yí sí" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwǝ" },
            { "ak", "Kiɛl akan" },
            { "am", "Kiɛl amaria" },
            { "ar", "Kiɛl b’árabe" },
            { "be", "Kiɛl belarussie" },
            { "bg", "Kiɛl bulgaria" },
            { "bn", "Kiɛl bengalia" },
            { "cs", "Kiɛl bó tchɛk" },
            { "de", "Jáman" },
            { "el", "Kiɛl bó grɛk" },
            { "en", "Ngɛ̄lɛ̄n" },
            { "es", metaValue_ES },
            { "fa", "Kiɛl pɛrsia" },
            { "fr", metaValue_FR },
            { "ha", "Kiɛl máwúsá" },
            { "hi", "Kiɛl b’indien" },
            { "hu", "Kiɛl b’ɔ́ngrois" },
            { "id", "Kiɛl indonesie" },
            { "ig", "Kiɛl ikbo" },
            { "it", "Kiɛl italia" },
            { "ja", "Kiɛl bó japonɛ̌" },
            { "jv", "Kiɛl bó javanɛ̌" },
            { "km", "Kiɛl bó mɛr" },
            { "ko", "Kiɛl koré" },
            { "ms", "Kiɛl Malɛ̌siā" },
            { "my", "Kiɛl birmania" },
            { "ne", "Kiɛl nepal" },
            { "nl", "Kiɛl bóllandais" },
            { "pa", "Kiɛl pɛndjabi" },
            { "pl", "Kiɛl pɔlɔŋe" },
            { "pt", "Kiɛl bó pɔ̄rtugɛ̂" },
            { "ro", "Kiɛl bó rumɛ̂n" },
            { "ru", "Kiɛl russia" },
            { "rw", "Kiɛl rwandā" },
            { "so", "Kiɛl somaliā" },
            { "sv", "Kiɛl bó suedois" },
            { "ta", "Kiɛl tamul" },
            { "th", "Kiɛl thaï" },
            { "tr", "Kiɛl bó turk" },
            { "uk", "Kiɛl b’ukrɛ̄nien" },
            { "ur", "Kiɛl úrdu" },
            { "vi", "Kiɛl viɛtnam" },
            { "yo", "Yorúbâ" },
            { "zh", "Kiɛl bó chinois" },
            { "zu", "Zulu" },
        };
        return data;
    }
}
