/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_wae extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TO = "Tonga";
        final String metaValue_ar = "Arabiš";
        final String metaValue_hy = "Armeniš";
        final String metaValue_bn = "Bengališ";
        final String metaValue_ka = "Georgiš";
        final String metaValue_el = "Gričiš";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebräiš";
        final String metaValue_ja = "Japaniš";
        final String metaValue_kn = "Kannada";
        final String metaValue_lo = "Laotiš";
        final String metaValue_la = "Latiniš";
        final String metaValue_my = "Burmesiš";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Singalesiš";
        final String metaValue_ta = "Tamiliš";
        final String metaValue_te = "Telugu";
        final Object[][] data = new Object[][] {
            { "001", "Wäld" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "005", "Südamerika" },
            { "009", "Ozeanie" },
            { "011", "Weštafrika" },
            { "013", "Zentralamerika" },
            { "014", "Oštafrika" },
            { "015", "Nordafrika" },
            { "017", "Mittelafrika" },
            { "018", "Südličs Afrika" },
            { "019", "Amerikaniš Kontinänt" },
            { "021", "Nördličs Amerika" },
            { "029", "Karibik" },
            { "030", "Oštasie" },
            { "034", "Südasie" },
            { "035", "Südoštasie" },
            { "039", "Südeuropa" },
            { "053", "Auštralie und Niwséland" },
            { "054", "Melanesie" },
            { "057", "Mikronesišes Inselgebiet" },
            { "061", "Polinesie" },
            { "142", "Asie" },
            { "143", "Zentralasie" },
            { "145", "Weštasie" },
            { "150", "Europa" },
            { "151", "Ošteuropa" },
            { "154", "Nordeuropa" },
            { "155", "Wešteuropa" },
            { "419", "Latíamerika" },
            { "AC", "Himmelfártsinsla" },
            { "AD", "Andorra" },
            { "AE", "Vereinigti Arabiše Emirat" },
            { "AF", "Afganištan" },
            { "AG", "Antigua und Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanie" },
            { "AM", "Armenie" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentinie" },
            { "AS", "Amerikaniš Samoa" },
            { "AT", "Öštrič" },
            { "AU", "Australie" },
            { "AW", "Aruba" },
            { "AX", "Alandinslä" },
            { "AZ", "Aserbaidšan" },
            { "BA", "Bosnie und Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladeš" },
            { "BE", "Belgie" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarie" },
            { "BH", "Bačrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Bartholomäus-Insla" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Boliwie" },
            { "BR", "Brasilie" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetinsla" },
            { "BW", "Botswana" },
            { "BY", "Wísrussland" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosinslä" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Zentralafrikaniši Rebublik" },
            { "CG", "Kongo Brazzaville" },
            { "CH", "Schwiz" },
            { "CI", "Elfebeiküšta" },
            { "CK", "Cookinslä" },
            { "CL", "Tšile" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbie" },
            { "CP", "Clipperton Insla" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CX", "Wienäčtsinslä" },
            { "CY", "Zypre" },
            { "CZ", "Tšečie" },
            { "DE", "Titšland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dšibuti" },
            { "DK", "Dänemark" },
            { "DM", "Doninica" },
            { "DO", "Dominikaniši Rebublik" },
            { "DZ", "Algerie" },
            { "EA", "Ceuta und Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Eštland" },
            { "EG", "Egypte" },
            { "EH", "Weštsahara" },
            { "ER", "Eritrea" },
            { "ES", "Schpanie" },
            { "ET", "Ethiopie" },
            { "EU", "Europäiši Unio" },
            { "FI", "Finnland" },
            { "FJ", "Fidši" },
            { "FK", "Falklandinslä" },
            { "FM", "Mikronesie" },
            { "FO", "Färöe" },
            { "FR", "Frankrič" },
            { "GA", "Gabon" },
            { "GB", "England" },
            { "GD", "Grenada" },
            { "GE", "Georgie" },
            { "GF", "Französiš Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Grönland" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorialginea" },
            { "GR", "Gričeland" },
            { "GS", "Südgeorgie und d’südliče Senwičinslä" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Ginea Bissau" },
            { "GY", "Guyana" },
            { "HK", "Sonderverwaltigszona Hongkong" },
            { "HM", "Heard- und McDonald-Inslä" },
            { "HN", "Honduras" },
            { "HR", "Kroatie" },
            { "HT", "Haiti" },
            { "HU", "Ungare" },
            { "IC", "Kanariše Inslä" },
            { "ID", "Indonesie" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indie" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italie" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordanie" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kirgištan" },
            { "KH", "Kambodša" },
            { "KI", "Kiribati" },
            { "KM", "Komore" },
            { "KN", "St. Kitts und Nevis" },
            { "KP", "Nordkorea" },
            { "KR", "Südkorea" },
            { "KW", "Kuweit" },
            { "KY", "Kaimaninslä" },
            { "KZ", "Kasačstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liečteštei" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litaue" },
            { "LU", "Luxeburg" },
            { "LV", "Lettland" },
            { "LY", "Lübie" },
            { "MA", "Maroko" },
            { "MC", "Monago" },
            { "MD", "Moldau" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Maršalinslä" },
            { "ML", "Mali" },
            { "MM", "Burma" },
            { "MN", "Mongolei" },
            { "MO", "Sonderverwaltigszona Makau" },
            { "MP", "Nördliči Mariane" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanie" },
            { "MS", "Monserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediwe" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Niwkaledonie" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsla" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Holand" },
            { "NO", "Norwäge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Niwséland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Französiš Polinesie" },
            { "PG", "Papua Niwginea" },
            { "PH", "Philippine" },
            { "PK", "Pakištan" },
            { "PL", "Pole" },
            { "PM", "St. Pierre und Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Paleština" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Katar" },
            { "QO", "Üssers Ozeanie" },
            { "RE", "Réunion" },
            { "RO", "Rumänie" },
            { "RS", "Serbie" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "SA", "Saudi Arabie" },
            { "SB", "Salomone" },
            { "SC", "Sečelle" },
            { "SD", "Sudan" },
            { "SE", "Schwede" },
            { "SG", "Singapur" },
            { "SH", "St. Helena" },
            { "SI", "Slowenie" },
            { "SJ", "Svalbard und Jan Mayen" },
            { "SK", "Slowakei" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "ST", "São Tomé and Príncipe" },
            { "SV", "El Salvador" },
            { "SY", "Sürie" },
            { "SZ", "Swasiland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- und Caicosinslä" },
            { "TD", "Tšad" },
            { "TF", "Französiši Süd- und Antarktisgebiet" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadšikistan" },
            { "TK", "Tokelau" },
            { "TL", "Ošttimor" },
            { "TM", "Turkmeništan" },
            { "TN", "Tunesie" },
            { "TO", metaValue_TO },
            { "TR", "Türkei" },
            { "TT", "Trinidad und Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "Amerikaniš Ozeanie" },
            { "US", "Amerika" },
            { "UY", "Urugauy" },
            { "UZ", "Usbekištan" },
            { "VA", "Vatikan" },
            { "VC", "St. Vincent und d’Grenadine" },
            { "VE", "Venezuela" },
            { "VG", "Britiši Jungfröiwinslä" },
            { "VI", "Amerikaniši Jungfröiwinslä" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis und Futuna" },
            { "WS", "Samoa" },
            { "YE", "Jéme" },
            { "YT", "Moyette" },
            { "ZA", "Südafrika" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Unbekannti Regio" },
            { "ab", "Abčasiš" },
            { "af", "Afrikáns" },
            { "am", "Amhariš" },
            { "ar", metaValue_ar },
            { "as", "Assamesiš" },
            { "ay", "Aymara" },
            { "az", "Serbaidšaniš" },
            { "be", "Wísrussiš" },
            { "bg", "Bulgariš" },
            { "bn", metaValue_bn },
            { "bo", "Tibetiš" },
            { "bs", "Bosniš" },
            { "ca", "Katalaniš" },
            { "cs", "Tšečiš" },
            { "cy", "Walisiš" },
            { "da", "Däniš" },
            { "de", "Titš" },
            { "dv", "Malediwiš" },
            { "dz", "Butaniš" },
            { "el", metaValue_el },
            { "en", "Engliš" },
            { "es", "Schpaniš" },
            { "et", "Estniš" },
            { "eu", "Baskiš" },
            { "fa", "Persiš" },
            { "fi", "Finiš" },
            { "fj", "Fidšianiš" },
            { "fr", "Wälš" },
            { "ga", "Iriš" },
            { "gl", "Galiziš" },
            { "gn", "Guarani" },
            { "gu", metaValue_gu },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hr", "Kroatiš" },
            { "ht", "Haitianiš" },
            { "hu", "Ungariš" },
            { "hy", metaValue_hy },
            { "id", "Indonesiš" },
            { "ig", "Igbo" },
            { "is", "Iisländiš" },
            { "it", "Italieniš" },
            { "ja", metaValue_ja },
            { "ka", metaValue_ka },
            { "kk", "Kazačiš" },
            { "km", "Kambodšaniš" },
            { "kn", metaValue_kn },
            { "ko", "Koreaniš" },
            { "ks", "Kašmiriš" },
            { "ku", "Kurdiš" },
            { "ky", "Kirgisiš" },
            { "la", metaValue_la },
            { "lb", "Luxemburgiš" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Litauiš" },
            { "lv", "Lettiš" },
            { "mg", "Malagási" },
            { "mi", "Maori" },
            { "mk", "Mazedoniš" },
            { "ml", "Malayalam" },
            { "mn", "Mongoliš" },
            { "mr", "Marathi" },
            { "ms", "Malaíš" },
            { "mt", "Maltesiš" },
            { "my", metaValue_my },
            { "nb", "Norwegiš Bokmål" },
            { "nd", "Nordndebele" },
            { "ne", "Nepalesiš" },
            { "nl", "Holändiš" },
            { "nn", "Norwegiš Nynorsk" },
            { "ny", "Nyanja" },
            { "or", metaValue_or },
            { "os", "Osétiš" },
            { "pa", "Pandšabiš" },
            { "pl", "Polniš" },
            { "ps", "Paštu" },
            { "pt", "Portugisiš" },
            { "qu", "Quečua" },
            { "rm", "Rätromaniš" },
            { "rn", "Rundi" },
            { "ro", "Rumäniš" },
            { "ru", "Rusiš" },
            { "rw", "Ruandiš" },
            { "sa", "Sanskrit" },
            { "sd", "Sindhi" },
            { "se", "Nordsamiš" },
            { "sg", "Sango" },
            { "si", metaValue_si },
            { "sk", "Slowakiš" },
            { "sl", "Sloweniš" },
            { "sm", "Samoaniš" },
            { "sn", "Shona" },
            { "so", "Somališ" },
            { "sq", "Albaniš" },
            { "sr", "Serbiš" },
            { "ss", "Swazi" },
            { "st", "Südsotho" },
            { "su", "Sundanesiš" },
            { "sv", "Schwediš" },
            { "sw", "Suaheliš" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tadšikiš" },
            { "th", "Thailändiš" },
            { "ti", "Tigrinja" },
            { "tk", "Turkmeniš" },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "tr", "Türkiš" },
            { "ts", "Tsonga" },
            { "ty", "Taitiš" },
            { "ug", "Uiguriš" },
            { "uk", "Ukrainiš" },
            { "ur", "Urdu" },
            { "uz", "Usbekiš" },
            { "ve", "Venda" },
            { "vi", "Vietnamesiš" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yo", "Yoruba" },
            { "zh", "Chinesiš" },
            { "zu", "Zulu" },
            { "efi", "Efik" },
            { "fil", "Filipiniš" },
            { "haw", "Hawaíaniš" },
            { "nso", "Nordsotho" },
            { "sah", "Jakutiš" },
            { "tet", "Tetum" },
            { "tpi", "Niwmelanesiš" },
            { "und", "Unbekannti Schprač" },
            { "wae", "Walser" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Cyrl", "Kirilliš" },
            { "Deva", "Devanagari" },
            { "Ethi", "Ethiopiš" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Hans", "Vereifačt" },
            { "Hant", "Traditionell" },
            { "Hebr", metaValue_he },
            { "Jpan", metaValue_ja },
            { "Khmr", "Khmer" },
            { "Knda", metaValue_kn },
            { "Kore", "Korianiš" },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", "Malaisiš" },
            { "Mymr", metaValue_my },
            { "Orya", metaValue_or },
            { "Sinh", metaValue_si },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "Thána" },
            { "Thai", "Thai" },
            { "Zxxx", "Schriftlos" },
            { "Zzzz", "Unkodierti Schrift" },
            { "de_AT", "Öštričišes Titš" },
            { "de_CH", "Schwizer Hočtitš" },
            { "en_AU", "Auštrališes Engliš" },
            { "en_CA", "Kanadišes Engliš" },
            { "en_GB", "Britišes Engliš" },
            { "en_US", "Amerikanišes Engliš" },
            { "es_ES", "Iberišes Schpaniš" },
            { "fr_CA", "Kanadišes Wälš" },
            { "fr_CH", "Schwizer Wälš" },
            { "nl_BE", "Flämiš" },
            { "pt_BR", "Brasilianišes Portugisiš" },
            { "pt_PT", "Iberišes Portugisiš" },
            { "es_419", "Latiamerikanišes Schpaniš" },
            { "zh_Hans", "Vereifačts Chinesiš" },
            { "zh_Hant", "Traditionells Chinesiš" },
            { "type.nu.latn", "Arabiši Zálä" },
            { "type.co.ducet", "Standard Unicode Sortierreiefolg" },
            { "type.co.search", "Allgmeini Süeč" },
            { "type.ca.gregorian", "Gregorianišä Kaländer" },
        };
        return data;
    }
}
