/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_cv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Гринвичпа вӑтам вӑхӑчӗ",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Апиа стандартлӑ вӑхӑчӗ",
               "",
               "Апиа ҫуллахи вӑхӑчӗ",
               "",
               "Апиа вӑхӑчӗ",
               "",
            };
        final String[] Cook = new String[] {
               "Кукӑн утравӗсен стандартлӑ вӑхӑчӗ",
               "",
               "Кукӑн утравӗсен ҫуллахи вӑхӑчӗ",
               "",
               "Кукӑн утравӗсен вӑхӑчӗ",
               "",
            };
        final String[] Cuba = new String[] {
               "Куба стандартлӑ вӑхӑчӗ",
               "CST",
               "Куба ҫуллахи вӑхӑчӗ",
               "CDT",
               "Куба вӑхӑчӗ",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Фиджи стандартлӑ вӑхӑчӗ",
               "",
               "Фиджи ҫуллахи вӑхӑчӗ",
               "",
               "Фиджи вӑхӑчӗ",
               "",
            };
        final String[] Gulf = new String[] {
               "Перси залив вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ховд стандартлӑ вӑхӑчӗ",
               "",
               "Ховд ҫуллахи вӑхӑчӗ",
               "",
               "Ховд вӑхӑчӗ",
               "",
            };
        final String[] Iran = new String[] {
               "Иран стандартлӑ вӑхӑчӗ",
               "",
               "Иран ҫуллахи вӑхӑчӗ",
               "",
               "Иран вӑхӑчӗ",
               "",
            };
        final String[] Niue = new String[] {
               "Ниуэ вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омск стандартлӑ вӑхӑчӗ",
               "",
               "Омск ҫуллахи вӑхӑчӗ",
               "",
               "Омск вӑхӑчӗ",
               "",
            };
        final String[] Peru = new String[] {
               "Перу стандартлӑ вӑхӑчӗ",
               "",
               "Перу ҫуллахи вӑхӑчӗ",
               "",
               "Перу вӑхӑчӗ",
               "",
            };
        final String[] Truk = new String[] {
               "Трук вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Уэйк вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Чили стандартлӑ вӑхӑчӗ",
               "",
               "Чили ҫуллахи вӑхӑчӗ",
               "",
               "Чили вӑхӑчӗ",
               "",
            };
        final String[] China = new String[] {
               "Китай стандартлӑ вӑхӑчӗ",
               "CST",
               "Китай ҫуллахи вӑхӑчӗ",
               "CDT",
               "Китай вӑхӑчӗ",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Кокос утравӗсен вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Дейвис вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Инди вӑхӑчӗ",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Япони стандартлӑ вӑхӑчӗ",
               "JST",
               "Япони ҫуллахи вӑхӑчӗ",
               "JDT",
               "Япони вӑхӑчӗ",
               "JT",
            };
        final String[] Korea = new String[] {
               "Корей стандартлӑ вӑхӑчӗ",
               "KST",
               "Корей ҫуллахи вӑхӑчӗ",
               "KST",
               "Корей вӑхӑчӗ",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Науру вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Непал вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Палау вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Самоа стандартлӑ вӑхӑчӗ",
               "SST",
               "Самоа ҫуллахи вӑхӑчӗ",
               "SST",
               "Самоа вӑхӑчӗ",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Сёва вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Тонга стандартлӑ вӑхӑчӗ",
               "",
               "Тонга ҫуллахи вӑхӑчӗ",
               "",
               "Тонга вӑхӑчӗ",
               "",
            };
        final String[] Yukon = new String[] {
               "Юкон вӑхӑчӗ",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Аляска стандартлӑ вӑхӑчӗ",
               "AKST",
               "Аляска ҫуллахи вӑхӑчӗ",
               "AKDT",
               "Аляска вӑхӑчӗ",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Амазонка стандартлӑ вӑхӑчӗ",
               "",
               "Амазонка ҫуллахи вӑхӑчӗ",
               "",
               "Амазонка вӑхӑчӗ",
               "",
            };
        final String[] Azores = new String[] {
               "Азор утравӗсен стандартлӑ вӑхӑчӗ",
               "",
               "Азор утравӗсен ҫуллахи вӑхӑчӗ",
               "",
               "Азор утравӗсен вӑхӑчӗ",
               "",
            };
        final String[] Bhutan = new String[] {
               "Бутан вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Бруней-Даруссалам вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Мӑнкун утравӗн стандартлӑ вӑхӑчӗ",
               "",
               "Мӑнкун утравӗн ҫуллахи вӑхӑчӗ",
               "",
               "Мӑнкун утравӗн вӑхӑчӗ",
               "",
            };
        final String[] Guyana = new String[] {
               "Гайана вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Израиль стандартлӑ вӑхӑчӗ",
               "IST",
               "Израиль ҫуллахи вӑхӑчӗ",
               "IDT",
               "Израиль вӑхӑчӗ",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Косрае вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Моусон вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Мускав стандартлӑ вӑхӑчӗ",
               "MSK",
               "Мускав ҫуллахи вӑхӑчӗ",
               "MSK",
               "Мускав вӑхӑчӗ",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Понпеи вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Таити вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Тайпей стандартлӑ вӑхӑчӗ",
               "CST",
               "Тайпей ҫуллахи вӑхӑчӗ",
               "CDT",
               "Тайпей вӑхӑчӗ",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Тувалу вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Восток вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Уоллис тата Футуна вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Арап стандартлӑ вӑхӑчӗ",
               "",
               "Арап ҫуллахи вӑхӑчӗ",
               "",
               "Арап вӑхӑчӗ",
               "",
            };
        final String[] Armenia = new String[] {
               "Армени стандартлӑ вӑхӑчӗ",
               "",
               "Армени ҫуллахи вӑхӑчӗ",
               "",
               "Армени вӑхӑчӗ",
               "",
            };
        final String[] Bolivia = new String[] {
               "Боливи вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Чатем стандартлӑ вӑхӑчӗ",
               "",
               "Чатем ҫуллахи вӑхӑчӗ",
               "",
               "Чатем вӑхӑчӗ",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Пӗтӗм тӗнчери координацилене вӑхӑчӗ",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Эквадор вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Гамбье вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Грузи стандартлӑ вӑхӑчӗ",
               "",
               "Грузи ҫуллахи вӑхӑчӗ",
               "",
               "Грузи вӑхӑчӗ",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Иркутск стандартлӑ вӑхӑчӗ",
               "",
               "Иркутск ҫуллахи вӑхӑчӗ",
               "",
               "Иркутск вӑхӑчӗ",
               "",
            };
        final String[] Magadan = new String[] {
               "Магадан стандартлӑ вӑхӑчӗ",
               "",
               "Магадан ҫуллахи вӑхӑчӗ",
               "",
               "Магадан вӑхӑчӗ",
               "",
            };
        final String[] Myanmar = new String[] {
               "Мьянма вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Норфолк стандартлӑ вӑхӑчӗ",
               "",
               "Норфолк ҫуллахи вӑхӑчӗ",
               "",
               "Норфолк вӑхӑчӗ",
               "",
            };
        final String[] Noronha = new String[] {
               "Фернанду-ди-Норонья стандартлӑ вӑхӑчӗ",
               "",
               "Фернанду-ди-Норонья ҫуллахи вӑхӑчӗ",
               "",
               "Фернанду-ди-Норонья вӑхӑчӗ",
               "",
            };
        final String[] Reunion = new String[] {
               "Реюньон вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ротера вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Соломон вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Токелау вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Уругвай стандартлӑ вӑхӑчӗ",
               "",
               "Уругвай ҫуллахи вӑхӑчӗ",
               "",
               "Уругвай вӑхӑчӗ",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Вануату стандартлӑ вӑхӑчӗ",
               "",
               "Вануату ҫуллахи вӑхӑчӗ",
               "",
               "Вануату вӑхӑчӗ",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Якутск стандартлӑ вӑхӑчӗ",
               "",
               "Якутск ҫуллахи вӑхӑчӗ",
               "",
               "Якутск вӑхӑчӗ",
               "",
            };
        final String[] Atlantic = new String[] {
               "Атлантика стандартлӑ вӑхӑчӗ",
               "AST",
               "Атлантика ҫуллахи вӑхӑчӗ",
               "AST",
               "Атлантика вӑхӑчӗ",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Бразили стандартлӑ вӑхӑчӗ",
               "",
               "Бразили ҫуллахи вӑхӑчӗ",
               "",
               "Бразили вӑхӑчӗ",
               "",
            };
        final String[] Chamorro = new String[] {
               "Чаморро вӑхӑчӗ",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Колумби стандартлӑ вӑхӑчӗ",
               "",
               "Колумби ҫуллахи вӑхӑчӗ",
               "",
               "Колумби вӑхӑчӗ",
               "",
            };
        final String[] Falkland = new String[] {
               "Фолкленд утравӗсен стандартлӑ вӑхӑчӗ",
               "",
               "Фолкленд утравӗсен ҫуллахи вӑхӑчӗ",
               "",
               "Фолкленд утравӗсен вӑхӑчӗ",
               "",
            };
        final String[] Malaysia = new String[] {
               "Малайзи вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Мальдивсем вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Улан-Батор стандартлӑ вӑхӑчӗ",
               "",
               "Улан-Батор ҫуллахи вӑхӑчӗ",
               "",
               "Улан-Батор вӑхӑчӗ",
               "",
            };
        final String[] Pakistan = new String[] {
               "Пакистан стандартлӑ вӑхӑчӗ",
               "PKT",
               "Пакистан ҫуллахи вӑхӑчӗ",
               "PKST",
               "Пакистан вӑхӑчӗ",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Парагвай стандартлӑ вӑхӑчӗ",
               "",
               "Парагвай ҫуллахи вӑхӑчӗ",
               "",
               "Парагвай вӑхӑчӗ",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Питкэрн вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Сахалин стандартлӑ вӑхӑчӗ",
               "",
               "Сахалин ҫуллахи вӑхӑчӗ",
               "",
               "Сахалин вӑхӑчӗ",
               "",
            };
        final String[] Suriname = new String[] {
               "Суринам вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Аргентина стандартлӑ вӑхӑчӗ",
               "",
               "Аргентина ҫуллахи вӑхӑчӗ",
               "",
               "Аргентина вӑхӑчӗ",
               "",
            };
        final String[] Christmas = new String[] {
               "Раштав утравӗн вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Галапагос утравӗсен вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Гонконг стандартлӑ вӑхӑчӗ",
               "HKT",
               "Гонконг ҫуллахи вӑхӑчӗ",
               "HKST",
               "Гонконг вӑхӑчӗ",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Индокитай вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Киргизи вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Лорд-Хау стандартлӑ вӑхӑчӗ",
               "",
               "Лорд-Хау ҫуллахи вӑхӑчӗ",
               "",
               "Лорд-Хау вӑхӑчӗ",
               "",
            };
        final String[] Marquesas = new String[] {
               "Маркизас утравӗсен вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Маврикий стандартлӑ вӑхӑчӗ",
               "",
               "Маврикий ҫуллахи вӑхӑчӗ",
               "",
               "Маврикий вӑхӑчӗ",
               "",
            };
        final String[] Singapore = new String[] {
               "Сингапур вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Венесуэла вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Волгоград стандартлӑ вӑхӑчӗ",
               "MSK",
               "Волгоград ҫуллахи вӑхӑчӗ",
               "MSK",
               "Волгоград вӑхӑчӗ",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Азербайджан стандартлӑ вӑхӑчӗ",
               "",
               "Азербайджан ҫуллахи вӑхӑчӗ",
               "",
               "Азербайджан вӑхӑчӗ",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Бангладеш стандартлӑ вӑхӑчӗ",
               "",
               "Бангладеш ҫуллахи вӑхӑчӗ",
               "",
               "Бангладеш вӑхӑчӗ",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Кабо-Верде стандартлӑ вӑхӑчӗ",
               "",
               "Кабо-Верде ҫуллахи вӑхӑчӗ",
               "",
               "Кабо-Верде вӑхӑчӗ",
               "",
            };
        final String[] East_Timor = new String[] {
               "Хӗвелтухӑҫ Тимор вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Сейшел утравӗсен вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Таджикистан вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Узбекистан стандартлӑ вӑхӑчӗ",
               "",
               "Узбекистан ҫуллахи вӑхӑчӗ",
               "",
               "Узбекистан вӑхӑчӗ",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Афганистан вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Красноярск стандартлӑ вӑхӑчӗ",
               "",
               "Красноярск ҫуллахи вӑхӑчӗ",
               "",
               "Красноярск вӑхӑчӗ",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ҫӗнӗ Зеланди стандартлӑ вӑхӑчӗ",
               "NZST",
               "Ҫӗнӗ Зеланди ҫуллахи вӑхӑчӗ",
               "NZDT",
               "Ҫӗнӗ Зеланди вӑхӑчӗ",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Новосибирск стандартлӑ вӑхӑчӗ",
               "",
               "Новосибирск ҫуллахи вӑхӑчӗ",
               "",
               "Новосибирск вӑхӑчӗ",
               "",
            };
        final String[] Philippines = new String[] {
               "Филиппинсем стандартлӑ вӑхӑчӗ",
               "PST",
               "Филиппинсем ҫуллахи вӑхӑчӗ",
               "PDT",
               "Филиппинсем вӑхӑчӗ",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Владивосток стандартлӑ вӑхӑчӗ",
               "",
               "Владивосток ҫуллахи вӑхӑчӗ",
               "",
               "Владивосток вӑхӑчӗ",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Инди океанӗ вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Лайн утравӗсен вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ньюфаундленд стандартлӑ вӑхӑчӗ",
               "NST",
               "Ньюфаундленд ҫуллахи вӑхӑчӗ",
               "NDT",
               "Ньюфаундленд вӑхӑчӗ",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Туркменистан стандартлӑ вӑхӑчӗ",
               "",
               "Туркменистан ҫуллахи вӑхӑчӗ",
               "",
               "Туркменистан вӑхӑчӗ",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Франци Гвиана вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ҫӗнӗ Каледони стандартлӑ вӑхӑчӗ",
               "",
               "Ҫӗнӗ Каледони ҫуллахи вӑхӑчӗ",
               "",
               "Ҫӗнӗ Каледони вӑхӑчӗ",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Кӑнтӑр Георги вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Екатеринбург стандартлӑ вӑхӑчӗ",
               "",
               "Екатеринбург ҫуллахи вӑхӑчӗ",
               "",
               "Екатеринбург вӑхӑчӗ",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Тӗп Африка вӑхӑчӗ",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Хӗвелтухӑҫ Африка вӑхӑчӗ",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Анӑҫ Африка стандартлӑ вӑхӑчӗ",
               "WAT",
               "Анӑҫ Африка ҫуллахи вӑхӑчӗ",
               "WAT",
               "Анӑҫ Африка вӑхӑчӗ",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Дюмон-д’Юрвиль вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Тӗп Европа стандартлӑ вӑхӑчӗ",
               "CET",
               "Тӗп Европа ҫуллахи вӑхӑчӗ",
               "CEST",
               "Тӗп Европа вӑхӑчӗ",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Хӗвелтухӑҫ Европа стандартлӑ вӑхӑчӗ",
               "EET",
               "Хӗвелтухӑҫ Европа ҫуллахи вӑхӑчӗ",
               "EEST",
               "Хӗвелтухӑҫ Европа вӑхӑчӗ",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Анӑҫ Европа стандартлӑ вӑхӑчӗ",
               "WET",
               "Анӑҫ Европа ҫуллахи вӑхӑчӗ",
               "WEST",
               "Анӑҫ Европа вӑхӑчӗ",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Мексика Лӑпкӑ океан стандартлӑ вӑхӑчӗ",
               "MST",
               "Мексика Лӑпкӑ океан ҫуллахи вӑхӑчӗ",
               "MDT",
               "Мексика Лӑпкӑ океан вӑхӑчӗ",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Кӑнтӑр Африка вӑхӑчӗ",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Тӗп Америка стандартлӑ вӑхӑчӗ",
               "CST",
               "Тӗп Америка ҫуллахи вӑхӑчӗ",
               "CDT",
               "Тӗп Америка вӑхӑчӗ",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Хӗвелтухӑҫ Америка стандартлӑ вӑхӑчӗ",
               "EST",
               "Хӗвелтухӑҫ Америка ҫуллахи вӑхӑчӗ",
               "EST",
               "Хӗвелтухӑҫ Америка вӑхӑчӗ",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Лӑпкӑ океан стандартлӑ вӑхӑчӗ",
               "PST",
               "Лӑпкӑ океан ҫуллахи вӑхӑчӗ",
               "PDT",
               "Лӑпкӑ океан вӑхӑчӗ",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Франци Кӑнтӑрпа Антарктика территорийӗсен вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Гилбертӑн утравӗсен вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Гавайи Алеут стандартлӑ вӑхӑчӗ",
               "HST",
               "Гавайи Алеут ҫуллахи вӑхӑчӗ",
               "HST",
               "Гавайи Алеут вӑхӑчӗ",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Феникс вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Сен-Пьер тата Микелон стандартлӑ вӑхӑчӗ",
               "",
               "Сен-Пьер тата Микелон ҫуллахи вӑхӑчӗ",
               "",
               "Сен-Пьер тата Микелон вӑхӑчӗ",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Стандартлӑ ту вӑхӑчӗ (Ҫурҫӗр Америка)",
               "MST",
               "Ҫуллахи ту вӑхӑчӗ (Ҫурҫӗр Америка)",
               "MST",
               "Ту вӑхӑчӗ (Ҫурҫӗр Америка)",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Маршалл утравӗсен вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Папуа — Ҫӗнӗ Гвиней вӑхӑчӗ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Тӗп Австрали стандартлӑ вӑхӑчӗ",
               "ACST",
               "Тӗп Австрали ҫуллахи вӑхӑчӗ",
               "ACDT",
               "Тӗп Австрали вӑхӑчӗ",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Хӗвелтухӑҫ Австрали стандартлӑ вӑхӑчӗ",
               "AEST",
               "Хӗвелтухӑҫ Австрали ҫуллахи вӑхӑчӗ",
               "AEDT",
               "Хӗвелтухӑҫ Австрали вӑхӑчӗ",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Анӑҫ Австрали стандартлӑ вӑхӑчӗ",
               "AWST",
               "Анӑҫ Австрали ҫуллахи вӑхӑчӗ",
               "AWDT",
               "Анӑҫ Австрали вӑхӑчӗ",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Тӗп Индонези вӑхӑчӗ",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Хӗвелтухӑҫ Индонези вӑхӑчӗ",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Анӑҫ Индонези вӑхӑчӗ",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Тӗп Австрали анӑҫ стандартлӑ вӑхӑчӗ",
               "",
               "Тӗп Австрали анӑҫ ҫуллахи вӑхӑчӗ",
               "",
               "Тӗп Австрали анӑҫ вӑхӑчӗ",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Гринвичпа вӑтам вӑхӑчӗ",
                    "GMT",
                    "Британи ҫуллахи вӑхӑчӗ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Пӗтӗм тӗнчери координацилене вӑхӑчӗ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Гринвичпа вӑтам вӑхӑчӗ",
                    "GMT",
                    "Ирланди стандартлӑ вӑхӑчӗ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Пӗтӗм тӗнчери координацилене вӑхӑчӗ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Пӗтӗм тӗнчери координацилене вӑхӑчӗ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Гринвичпа вӑтам вӑхӑчӗ",
                    "GMT",
                    "Британи ҫуллахи вӑхӑчӗ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Пӗтӗм тӗнчери координацилене вӑхӑчӗ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Пӗтӗм тӗнчери координацилене вӑхӑчӗ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Пӗтӗм тӗнчери координацилене вӑхӑчӗ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Гринвичпа вӑтам вӑхӑчӗ",
                    "GMT",
                    "Ирланди стандартлӑ вӑхӑчӗ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Гринвичпа вӑтам вӑхӑчӗ",
                    "GMT",
                    "Британи ҫуллахи вӑхӑчӗ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Гринвичпа вӑтам вӑхӑчӗ",
                    "GMT",
                    "Британи ҫуллахи вӑхӑчӗ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Гринвичпа вӑтам вӑхӑчӗ",
                    "GMT",
                    "Британи ҫуллахи вӑхӑчӗ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Гринвичпа вӑтам вӑхӑчӗ",
                    "GMT",
                    "Британи ҫуллахи вӑхӑчӗ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Гринвичпа вӑтам вӑхӑчӗ",
                    "GMT",
                    "Британи ҫуллахи вӑхӑчӗ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Аден" },
            { "timezone.excity.Asia/Baku", "Баку" },
            { "timezone.excity.Asia/Dili", "Дили" },
            { "timezone.excity.Asia/Gaza", "Газа" },
            { "timezone.excity.Asia/Hovd", "Ховд" },
            { "timezone.excity.Asia/Omsk", "Омск" },
            { "timezone.excity.Asia/Oral", "Уральск" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Амман" },
            { "timezone.excity.Asia/Aqtau", "Актау" },
            { "timezone.excity.Asia/Chita", "Чита" },
            { "timezone.excity.Asia/Dhaka", "Дакка" },
            { "timezone.excity.Asia/Dubai", "Дубай" },
            { "timezone.excity.Asia/Kabul", "Кабул" },
            { "timezone.excity.Asia/Macau", "Макао" },
            { "timezone.excity.Asia/Qatar", "Катар" },
            { "timezone.excity.Asia/Seoul", "Сеул" },
            { "timezone.excity.Asia/Tokyo", "Токио" },
            { "timezone.excity.Asia/Tomsk", "Томск" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Джуба" },
            { "timezone.excity.Africa/Lome", "Ломе" },
            { "timezone.excity.Asia/Almaty", "Алматы" },
            { "timezone.excity.Asia/Anadyr", "Анадырь" },
            { "timezone.excity.Asia/Aqtobe", "Актобе" },
            { "timezone.excity.Asia/Atyrau", "Атырау" },
            { "timezone.excity.Asia/Beirut", "Бейрут" },
            { "timezone.excity.Asia/Brunei", "Бруней" },
            { "timezone.excity.Asia/Hebron", "Хеврон" },
            { "timezone.excity.Asia/Kuwait", "Кувейт" },
            { "timezone.excity.Asia/Manila", "Манила" },
            { "timezone.excity.Asia/Muscat", "Маскат" },
            { "timezone.excity.Asia/Riyadh", "Эр-Рияд" },
            { "timezone.excity.Asia/Saigon", "Хошимин" },
            { "timezone.excity.Asia/Taipei", "Тайбэй" },
            { "timezone.excity.Asia/Tehran", "Тегеран" },
            { "timezone.excity.Asia/Urumqi", "Урумчи" },
            { "timezone.excity.Etc/Unknown", "Паллӑ мар хула" },
            { "timezone.excity.Europe/Kiev", "Киев" },
            { "timezone.excity.Europe/Oslo", "Осло" },
            { "timezone.excity.Europe/Riga", "Рига" },
            { "timezone.excity.Europe/Rome", "Рим" },
            { "timezone.excity.Indian/Mahe", "Маэ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Аккра" },
            { "timezone.excity.Africa/Cairo", "Каир" },
            { "timezone.excity.Africa/Ceuta", "Сеута" },
            { "timezone.excity.Africa/Dakar", "Дакар" },
            { "timezone.excity.Africa/Lagos", "Лагос" },
            { "timezone.excity.Africa/Tunis", "Тунис" },
            { "timezone.excity.America/Adak", "Адак" },
            { "timezone.excity.America/Lima", "Лима" },
            { "timezone.excity.America/Nome", "Ном" },
            { "timezone.excity.Asia/Baghdad", "Багдад" },
            { "timezone.excity.Asia/Bahrain", "Бахрейн" },
            { "timezone.excity.Asia/Bangkok", "Бангкок" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Bishkek", "Бишкек" },
            { "timezone.excity.Asia/Colombo", "Коломбо" },
            { "timezone.excity.Asia/Irkutsk", "Иркутск" },
            { "timezone.excity.Asia/Jakarta", "Джакарта" },
            { "timezone.excity.Asia/Karachi", "Карачи" },
            { "timezone.excity.Asia/Kuching", "Кучинг" },
            { "timezone.excity.Asia/Magadan", "Магадан" },
            { "timezone.excity.Asia/Nicosia", "Никоси" },
            { "timezone.excity.Asia/Rangoon", "Янгон" },
            { "timezone.excity.Asia/Tbilisi", "Тбилиси" },
            { "timezone.excity.Asia/Thimphu", "Тхимпху" },
            { "timezone.excity.Asia/Yakutsk", "Якутск" },
            { "timezone.excity.Asia/Yerevan", "Ереван" },
            { "timezone.excity.Europe/Kirov", "Киров" },
            { "timezone.excity.Europe/Malta", "Мальта" },
            { "timezone.excity.Europe/Minsk", "Минск" },
            { "timezone.excity.Europe/Paris", "Париж" },
            { "timezone.excity.Europe/Sofia", "Софи" },
            { "timezone.excity.Europe/Vaduz", "Вадуц" },
            { "timezone.excity.Indian/Cocos", "Кокос утравӗсем" },
            { "timezone.excity.Pacific/Apia", "Апиа" },
            { "timezone.excity.Pacific/Fiji", "Фиджи" },
            { "timezone.excity.Pacific/Guam", "Гуам" },
            { "timezone.excity.Pacific/Niue", "Ниуэ" },
            { "timezone.excity.Pacific/Truk", "Трук" },
            { "timezone.excity.Pacific/Wake", "Уэйк" },
            { "timezone.excity.Africa/Asmera", "Асмэра" },
            { "timezone.excity.Africa/Bamako", "Бамако" },
            { "timezone.excity.Africa/Bangui", "Банги" },
            { "timezone.excity.Africa/Banjul", "Банжул" },
            { "timezone.excity.Africa/Bissau", "Бисау" },
            { "timezone.excity.Africa/Douala", "Дуала" },
            { "timezone.excity.Africa/Harare", "Хараре" },
            { "timezone.excity.Africa/Kigali", "Кигали" },
            { "timezone.excity.Africa/Luanda", "Луанда" },
            { "timezone.excity.Africa/Lusaka", "Лусака" },
            { "timezone.excity.Africa/Malabo", "Малабо" },
            { "timezone.excity.Africa/Maputo", "Мапуту" },
            { "timezone.excity.Africa/Maseru", "Масеру" },
            { "timezone.excity.Africa/Niamey", "Ниамей" },
            { "timezone.excity.America/Aruba", "Аруба" },
            { "timezone.excity.America/Bahia", "Баия" },
            { "timezone.excity.America/Belem", "Белен" },
            { "timezone.excity.America/Boise", "Бойсе" },
            { "timezone.excity.America/Jujuy", "Жужуй" },
            { "timezone.excity.America/Sitka", "Ситка" },
            { "timezone.excity.America/Thule", "Туле" },
            { "timezone.excity.Asia/Ashgabat", "Ашхабад" },
            { "timezone.excity.Asia/Calcutta", "Калькутта" },
            { "timezone.excity.Asia/Damascus", "Дамаск" },
            { "timezone.excity.Asia/Dushanbe", "Душанбе" },
            { "timezone.excity.Asia/Jayapura", "Джаяпура" },
            { "timezone.excity.Asia/Katmandu", "Катманду" },
            { "timezone.excity.Asia/Khandyga", "Хандыга" },
            { "timezone.excity.Asia/Makassar", "Макасар" },
            { "timezone.excity.Asia/Qostanay", "Костанай" },
            { "timezone.excity.Asia/Sakhalin", "Сахалин утравӗ" },
            { "timezone.excity.Asia/Shanghai", "Шанхай" },
            { "timezone.excity.Asia/Tashkent", "Ташкент" },
            { "timezone.excity.Asia/Ust-Nera", "Усть-Нера" },
            { "timezone.excity.Europe/Athens", "Афинсем" },
            { "timezone.excity.Europe/Berlin", "Берлин" },
            { "timezone.excity.Europe/Dublin", "Дублин" },
            { "timezone.excity.Europe/Jersey", "Джерси" },
            { "timezone.excity.Europe/Lisbon", "Лиссабон" },
            { "timezone.excity.Europe/London", "Лондон" },
            { "timezone.excity.Europe/Madrid", "Мадрид" },
            { "timezone.excity.Europe/Monaco", "Монако" },
            { "timezone.excity.Europe/Moscow", "Мускав" },
            { "timezone.excity.Europe/Prague", "Прага" },
            { "timezone.excity.Europe/Samara", "Самара" },
            { "timezone.excity.Europe/Skopje", "Скопье" },
            { "timezone.excity.Europe/Tirane", "Тирана" },
            { "timezone.excity.Europe/Vienna", "Вена" },
            { "timezone.excity.Europe/Warsaw", "Варшава" },
            { "timezone.excity.Europe/Zagreb", "Загреб" },
            { "timezone.excity.Europe/Zurich", "Цюрих" },
            { "timezone.excity.Indian/Chagos", "Чагос" },
            { "timezone.excity.Indian/Comoro", "Коморсем" },
            { "timezone.excity.Pacific/Efate", "Эфате" },
            { "timezone.excity.Pacific/Nauru", "Науру" },
            { "timezone.excity.Pacific/Palau", "Палау" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Абиджан" },
            { "timezone.excity.Africa/Algiers", "Алжир" },
            { "timezone.excity.Africa/Conakry", "Конакри" },
            { "timezone.excity.Africa/Kampala", "Кампала" },
            { "timezone.excity.Africa/Mbabane", "Мбабане" },
            { "timezone.excity.Africa/Nairobi", "Найроби" },
            { "timezone.excity.Africa/Tripoli", "Триполи" },
            { "timezone.excity.America/Belize", "Белиз" },
            { "timezone.excity.America/Bogota", "Богота" },
            { "timezone.excity.America/Cancun", "Канкун" },
            { "timezone.excity.America/Cayman", "Кайман утравӗсем" },
            { "timezone.excity.America/Cuiaba", "Куяба" },
            { "timezone.excity.America/Dawson", "Доусон" },
            { "timezone.excity.America/Denver", "Денвер" },
            { "timezone.excity.America/Guyana", "Гайана" },
            { "timezone.excity.America/Havana", "Гавана" },
            { "timezone.excity.America/Inuvik", "Инувик" },
            { "timezone.excity.America/Juneau", "Джуно" },
            { "timezone.excity.America/La_Paz", "Ла-Пас" },
            { "timezone.excity.America/Maceio", "Масейо" },
            { "timezone.excity.America/Manaus", "Манаус" },
            { "timezone.excity.America/Merida", "Мерида" },
            { "timezone.excity.America/Nassau", "Нассау" },
            { "timezone.excity.America/Panama", "Панама" },
            { "timezone.excity.America/Recife", "Ресифи" },
            { "timezone.excity.America/Regina", "Реджайна" },
            { "timezone.excity.Asia/Famagusta", "Фамагуста" },
            { "timezone.excity.Asia/Hong_Kong", "Гонконг" },
            { "timezone.excity.Asia/Jerusalem", "Иерусалим" },
            { "timezone.excity.Asia/Kamchatka", "Петропавловск-Камчатски" },
            { "timezone.excity.Asia/Pontianak", "Понтианак" },
            { "timezone.excity.Asia/Pyongyang", "Пхеньян" },
            { "timezone.excity.Asia/Qyzylorda", "Кызылорда" },
            { "timezone.excity.Asia/Samarkand", "Самарканд" },
            { "timezone.excity.Asia/Singapore", "Сингапур" },
            { "timezone.excity.Asia/Vientiane", "Вьентьян" },
            { "timezone.excity.Europe/Andorra", "Андорра" },
            { "timezone.excity.Europe/Saratov", "Саратов" },
            { "timezone.excity.Europe/Tallinn", "Таллин" },
            { "timezone.excity.Europe/Vatican", "Ватикан" },
            { "timezone.excity.Europe/Vilnius", "Вильнюс" },
            { "timezone.excity.Indian/Mayotte", "Майотта" },
            { "timezone.excity.Indian/Reunion", "Реюньон" },
            { "timezone.excity.Pacific/Easter", "Мӑнкун утравӗ" },
            { "timezone.excity.Pacific/Kanton", "Кантон" },
            { "timezone.excity.Pacific/Kosrae", "Косрае" },
            { "timezone.excity.Pacific/Majuro", "Маджуро" },
            { "timezone.excity.Pacific/Midway", "Мидуэй" },
            { "timezone.excity.Pacific/Noumea", "Нумеа" },
            { "timezone.excity.Pacific/Ponape", "Понпеи" },
            { "timezone.excity.Pacific/Saipan", "Сайпан" },
            { "timezone.excity.Pacific/Tahiti", "Таити" },
            { "timezone.excity.Pacific/Tarawa", "Тарава" },
            { "timezone.excity.Pacific/Wallis", "Уоллис" },
            { "timezone.excity.Africa/Blantyre", "Блантайр" },
            { "timezone.excity.Africa/Djibouti", "Джибути" },
            { "timezone.excity.Africa/El_Aaiun", "Эль-Аюн" },
            { "timezone.excity.Africa/Freetown", "Фритаун" },
            { "timezone.excity.Africa/Gaborone", "Габороне" },
            { "timezone.excity.Africa/Khartoum", "Хартум" },
            { "timezone.excity.Africa/Kinshasa", "Киншаса" },
            { "timezone.excity.Africa/Monrovia", "Монрови" },
            { "timezone.excity.Africa/Ndjamena", "Нджамена" },
            { "timezone.excity.Africa/Sao_Tome", "Сан-Томе Сан-Томе" },
            { "timezone.excity.Africa/Windhoek", "Виндхук" },
            { "timezone.excity.America/Antigua", "Антигуа" },
            { "timezone.excity.America/Caracas", "Каракас" },
            { "timezone.excity.America/Cayenne", "Кайенна" },
            { "timezone.excity.America/Chicago", "Чикаго" },
            { "timezone.excity.America/Cordoba", "Кордова" },
            { "timezone.excity.America/Creston", "Крестон" },
            { "timezone.excity.America/Curacao", "Кюрасао" },
            { "timezone.excity.America/Detroit", "Детройт" },
            { "timezone.excity.America/Godthab", "Нуук" },
            { "timezone.excity.America/Grenada", "Гренада" },
            { "timezone.excity.America/Halifax", "Галифакс" },
            { "timezone.excity.America/Iqaluit", "Икалуит" },
            { "timezone.excity.America/Jamaica", "Ямайка" },
            { "timezone.excity.America/Managua", "Манагуа" },
            { "timezone.excity.America/Marigot", "Мариго" },
            { "timezone.excity.America/Mendoza", "Мендоса" },
            { "timezone.excity.America/Moncton", "Монктон" },
            { "timezone.excity.America/Noronha", "Норонья" },
            { "timezone.excity.America/Ojinaga", "Охинага" },
            { "timezone.excity.America/Phoenix", "Финикс" },
            { "timezone.excity.America/Tijuana", "Тихуана" },
            { "timezone.excity.America/Toronto", "Торонто" },
            { "timezone.excity.America/Tortola", "Тортола" },
            { "timezone.excity.America/Yakutat", "Якутат" },
            { "timezone.excity.Asia/Phnom_Penh", "Пномпень" },
            { "timezone.excity.Atlantic/Azores", "Азор утравӗсем" },
            { "timezone.excity.Atlantic/Canary", "Канар утравӗсем" },
            { "timezone.excity.Atlantic/Faeroe", "Фарер утравӗсем" },
            { "timezone.excity.Australia/Eucla", "Юкла" },
            { "timezone.excity.Australia/Perth", "Перт" },
            { "timezone.excity.Europe/Belgrade", "Белград" },
            { "timezone.excity.Europe/Brussels", "Брюссель" },
            { "timezone.excity.Europe/Budapest", "Будапешт" },
            { "timezone.excity.Europe/Busingen", "Бюзинген" },
            { "timezone.excity.Europe/Chisinau", "Кишинев" },
            { "timezone.excity.Europe/Guernsey", "Гернси" },
            { "timezone.excity.Europe/Helsinki", "Хельсинки" },
            { "timezone.excity.Europe/Istanbul", "Стамбул" },
            { "timezone.excity.Europe/Sarajevo", "Сараево" },
            { "timezone.excity.Indian/Maldives", "Мальдивсем" },
            { "timezone.excity.Pacific/Chatham", "Чатем" },
            { "timezone.excity.Pacific/Fakaofo", "Факаофо" },
            { "timezone.excity.Pacific/Gambier", "Гамбье утравӗсем" },
            { "timezone.excity.Pacific/Norfolk", "Норфолк" },
            { "timezone.excity.Africa/Bujumbura", "Бужумбура" },
            { "timezone.excity.Africa/Mogadishu", "Могадишо" },
            { "timezone.excity.America/Anguilla", "Ангилья" },
            { "timezone.excity.America/Asuncion", "Асунсьон" },
            { "timezone.excity.America/Barbados", "Барбадос" },
            { "timezone.excity.America/Dominica", "Доминика" },
            { "timezone.excity.America/Edmonton", "Эдмонтон" },
            { "timezone.excity.America/Eirunepe", "Эйрунепе" },
            { "timezone.excity.America/Mazatlan", "Масатлан" },
            { "timezone.excity.America/Miquelon", "Микелон" },
            { "timezone.excity.America/New_York", "Нью-Йорк" },
            { "timezone.excity.America/Resolute", "Резольют" },
            { "timezone.excity.America/Santarem", "Сантарен" },
            { "timezone.excity.America/Santiago", "Сантьяго" },
            { "timezone.excity.America/St_Johns", "Сент-Джонс" },
            { "timezone.excity.America/St_Kitts", "Сент-Китс" },
            { "timezone.excity.America/St_Lucia", "Сент-Люсия" },
            { "timezone.excity.America/Winnipeg", "Виннипег" },
            { "timezone.excity.Antarctica/Casey", "Кейси" },
            { "timezone.excity.Antarctica/Davis", "Дейвис" },
            { "timezone.excity.Antarctica/Syowa", "Сёва" },
            { "timezone.excity.Antarctica/Troll", "Тролль" },
            { "timezone.excity.Asia/Krasnoyarsk", "Красноярск" },
            { "timezone.excity.Asia/Novosibirsk", "Новосибирск" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улан-Батор" },
            { "timezone.excity.Asia/Vladivostok", "Владивосток" },
            { "timezone.excity.Atlantic/Bermuda", "Бермуд утравӗсем" },
            { "timezone.excity.Atlantic/Madeira", "Мадейра" },
            { "timezone.excity.Atlantic/Stanley", "Стэнли" },
            { "timezone.excity.Australia/Darwin", "Дарвин" },
            { "timezone.excity.Australia/Hobart", "Хобарт" },
            { "timezone.excity.Australia/Sydney", "Сидней" },
            { "timezone.excity.Europe/Amsterdam", "Амстердам" },
            { "timezone.excity.Europe/Astrakhan", "Астрахань" },
            { "timezone.excity.Europe/Bucharest", "Бухарест" },
            { "timezone.excity.Europe/Gibraltar", "Гибралтар" },
            { "timezone.excity.Europe/Ljubljana", "Любляна" },
            { "timezone.excity.Europe/Mariehamn", "Мариехамн" },
            { "timezone.excity.Europe/Podgorica", "Подгорица" },
            { "timezone.excity.Europe/Stockholm", "Стокгольм" },
            { "timezone.excity.Europe/Ulyanovsk", "Ульяновск" },
            { "timezone.excity.Europe/Volgograd", "Волгоград" },
            { "timezone.excity.Indian/Christmas", "Раштав утравӗ" },
            { "timezone.excity.Indian/Kerguelen", "Кергелен" },
            { "timezone.excity.Indian/Mauritius", "Маврикий" },
            { "timezone.excity.Pacific/Auckland", "Окленд" },
            { "timezone.excity.Pacific/Funafuti", "Фунафути" },
            { "timezone.excity.Pacific/Pitcairn", "Питкэрн" },
            { "timezone.excity.Africa/Casablanca", "Касабланка" },
            { "timezone.excity.Africa/Libreville", "Либревиль" },
            { "timezone.excity.Africa/Lubumbashi", "Лубумбаши" },
            { "timezone.excity.Africa/Nouakchott", "Нуакшот" },
            { "timezone.excity.Africa/Porto-Novo", "Порто-Ново" },
            { "timezone.excity.America/Anchorage", "Анкоридж" },
            { "timezone.excity.America/Araguaina", "Арагуаина" },
            { "timezone.excity.America/Boa_Vista", "Боа-Виста" },
            { "timezone.excity.America/Catamarca", "Катамарка" },
            { "timezone.excity.America/Chihuahua", "Чиуауа" },
            { "timezone.excity.America/Fortaleza", "Форталеза" },
            { "timezone.excity.America/Glace_Bay", "Глейс-Бей" },
            { "timezone.excity.America/Goose_Bay", "Гус-Бей" },
            { "timezone.excity.America/Guatemala", "Гватемала" },
            { "timezone.excity.America/Guayaquil", "Гуаякиль" },
            { "timezone.excity.America/Matamoros", "Матаморос" },
            { "timezone.excity.America/Menominee", "Меномини" },
            { "timezone.excity.America/Monterrey", "Монтеррей" },
            { "timezone.excity.America/Sao_Paulo", "Сан-Паулу Сан-Паулу" },
            { "timezone.excity.America/St_Thomas", "Сент-Томас" },
            { "timezone.excity.America/Vancouver", "Ванкувер" },
            { "timezone.excity.Antarctica/Mawson", "Моусон" },
            { "timezone.excity.Antarctica/Palmer", "Палмер" },
            { "timezone.excity.Antarctica/Vostok", "Восток" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Куала-Лумпур" },
            { "timezone.excity.Asia/Novokuznetsk", "Новокузнецк" },
            { "timezone.excity.Europe/Bratislava", "Братислава" },
            { "timezone.excity.Europe/Copenhagen", "Копенгаген" },
            { "timezone.excity.Europe/Luxembourg", "Люксембург" },
            { "timezone.excity.Europe/San_Marino", "Сан-Марино" },
            { "timezone.excity.Europe/Simferopol", "Симферополь" },
            { "timezone.excity.Pacific/Galapagos", "Галапагос утравӗсем" },
            { "timezone.excity.Pacific/Kwajalein", "Кваджалейн" },
            { "timezone.excity.Pacific/Marquesas", "Маркизас утравӗсем" },
            { "timezone.excity.Pacific/Pago_Pago", "Паго-Паго" },
            { "timezone.excity.Pacific/Rarotonga", "Раротонга" },
            { "timezone.excity.Pacific/Tongatapu", "Тонгатапу" },
            { "timezone.excity.Africa/Addis_Ababa", "Аддис-Абеба" },
            { "timezone.excity.Africa/Brazzaville", "Браззавиль" },
            { "timezone.excity.Africa/Ouagadougou", "Уагадугу" },
            { "timezone.excity.America/Costa_Rica", "Коста-Рика" },
            { "timezone.excity.America/Grand_Turk", "Гранд-Терк" },
            { "timezone.excity.America/Guadeloupe", "Гваделупа" },
            { "timezone.excity.America/Hermosillo", "Эрмосильо" },
            { "timezone.excity.America/Kralendijk", "Кралендейк" },
            { "timezone.excity.America/Louisville", "Луисвилл" },
            { "timezone.excity.America/Martinique", "Мартиника" },
            { "timezone.excity.America/Metlakatla", "Метлакатла" },
            { "timezone.excity.America/Montevideo", "Монтевидео" },
            { "timezone.excity.America/Montserrat", "Монтсеррат" },
            { "timezone.excity.America/Paramaribo", "Парамарибо" },
            { "timezone.excity.America/Rio_Branco", "Риу-Бранку" },
            { "timezone.excity.America/St_Vincent", "Сент-Винсент" },
            { "timezone.excity.America/Whitehorse", "Уайтхорс" },
            { "timezone.excity.Antarctica/McMurdo", "Мак-Мердо" },
            { "timezone.excity.Antarctica/Rothera", "Ротера" },
            { "timezone.excity.Asia/Srednekolymsk", "Среднеколымск" },
            { "timezone.excity.Asia/Yekaterinburg", "Екатеринбург" },
            { "timezone.excity.Atlantic/Reykjavik", "Рейкьявик" },
            { "timezone.excity.Atlantic/St_Helena", "Сӑваплӑ Елена утравӗ" },
            { "timezone.excity.Australia/Adelaide", "Аделаида" },
            { "timezone.excity.Australia/Brisbane", "Брисбен" },
            { "timezone.excity.Australia/Lindeman", "Линдеман" },
            { "timezone.excity.Europe/Isle_of_Man", "Мэн утравӗ" },
            { "timezone.excity.Europe/Kaliningrad", "Калининград" },
            { "timezone.excity.Pacific/Kiritimati", "Киритимати" },
            { "timezone.excity.Africa/Johannesburg", "Йоханнесбург" },
            { "timezone.excity.America/El_Salvador", "Сальвадор" },
            { "timezone.excity.America/Fort_Nelson", "Форт Нельсон" },
            { "timezone.excity.America/Los_Angeles", "Лос-Анджелес" },
            { "timezone.excity.America/Mexico_City", "Мехико" },
            { "timezone.excity.America/Porto_Velho", "Порту-Велью" },
            { "timezone.excity.America/Puerto_Rico", "Пуэрто-Рико" },
            { "timezone.excity.America/Tegucigalpa", "Тегусигальпа" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгйир" },
            { "timezone.excity.Atlantic/Cape_Verde", "Кабо-Верде" },
            { "timezone.excity.Australia/Lord_Howe", "Лорд-Хау" },
            { "timezone.excity.Australia/Melbourne", "Мельбурн" },
            { "timezone.excity.Indian/Antananarivo", "Антананариву" },
            { "timezone.excity.Pacific/Guadalcanal", "Гуадалканал" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Дар-эс-Салам" },
            { "timezone.excity.America/Blanc-Sablon", "Бланк-Саблон" },
            { "timezone.excity.America/Buenos_Aires", "Буэнос-Айрес" },
            { "timezone.excity.America/Campo_Grande", "Кампу-Гранди" },
            { "timezone.excity.America/Danmarkshavn", "Денмарксхавн" },
            { "timezone.excity.America/Dawson_Creek", "Доусон-Крик" },
            { "timezone.excity.America/Indiana/Knox", "Нокс, Индиана" },
            { "timezone.excity.America/Indianapolis", "Индианаполис" },
            { "timezone.excity.America/Punta_Arenas", "Пунта-Аренас" },
            { "timezone.excity.America/Rankin_Inlet", "Ранкин-Инлет" },
            { "timezone.excity.America/Scoresbysund", "Скорсбисунн" },
            { "timezone.excity.Antarctica/Macquarie", "Маккуори" },
            { "timezone.excity.Pacific/Bougainville", "Бугенвиль" },
            { "timezone.excity.Pacific/Port_Moresby", "Порт-Морсби" },
            { "timezone.excity.America/Cambridge_Bay", "Кеймбридж-Бей" },
            { "timezone.excity.America/Coral_Harbour", "Корал-Харбор" },
            { "timezone.excity.America/Indiana/Vevay", "Вевей, Индиана" },
            { "timezone.excity.America/Lower_Princes", "Лоуэр-Принс-Куотер" },
            { "timezone.excity.America/Port_of_Spain", "Порт-оф-Спейн" },
            { "timezone.excity.America/Santo_Domingo", "Санто-Доминго" },
            { "timezone.excity.America/St_Barthelemy", "Сен-Бартелеми" },
            { "timezone.excity.America/Swift_Current", "Свифт-Керрент" },
            { "timezone.excity.Australia/Broken_Hill", "Брокен-Хилл" },
            { "timezone.excity.America/Bahia_Banderas", "Баия-де-Бандерас" },
            { "timezone.excity.America/Port-au-Prince", "Порт-о-Пренс" },
            { "timezone.excity.Atlantic/South_Georgia", "Кӑнтӑр Георги" },
            { "timezone.excity.America/Argentina/Salta", "Сальта" },
            { "timezone.excity.America/Indiana/Marengo", "Маренго, Индиана" },
            { "timezone.excity.America/Indiana/Winamac", "Уинамак, Индиана" },
            { "timezone.excity.America/Argentina/Tucuman", "Тукуман" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ушуая" },
            { "timezone.excity.America/Indiana/Tell_City", "Телл-Сити, Индиана" },
            { "timezone.excity.America/Indiana/Vincennes", "Винсеннес, Индиана" },
            { "timezone.excity.Antarctica/DumontDUrville", "Дюмон-д’Юрвиль Дюмон-д’Юрвиль" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ла-Риоха" },
            { "timezone.excity.America/Argentina/San_Juan", "Сан-Хуан" },
            { "timezone.excity.America/Argentina/San_Luis", "Сан-Луис Сан-Луис" },
            { "timezone.excity.America/Indiana/Petersburg", "Питерсберг, Индиана" },
            { "timezone.excity.America/Kentucky/Monticello", "Монтиселло, Кентукки" },
            { "timezone.excity.America/North_Dakota/Beulah", "Бойла, Ҫурҫӗр Дакота" },
            { "timezone.excity.America/North_Dakota/Center", "Центр, Ҫурҫӗр Дакота" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Рио-Гальегос" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Нью-Сейлем, Ҫурҫӗр Дакота" },
        };
        return data;
    }
}
