/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "greenwichi középidő, téli idő",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acre zónaidő",
               "",
               "Acre nyári idő",
               "",
               "Acre idő",
               "",
            };
        final String[] Apia = new String[] {
               "apiai téli idő",
               "",
               "apiai nyári idő",
               "",
               "apiai idő",
               "",
            };
        final String[] Cook = new String[] {
               "cook-szigeteki téli idő",
               "",
               "cook-szigeteki fél nyári idő",
               "",
               "cook-szigeteki idő",
               "",
            };
        final String[] Cuba = new String[] {
               "kubai téli idő",
               "CST",
               "kubai nyári idő",
               "CDT",
               "kubai időzóna",
               "CT",
            };
        final String[] Fiji = new String[] {
               "fidzsi téli idő",
               "",
               "fidzsi nyári idő",
               "",
               "fidzsi idő",
               "",
            };
        final String[] Gulf = new String[] {
               "öbölbeli téli idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "hovdi téli idő",
               "",
               "hovdi nyári idő",
               "",
               "hovdi idő",
               "",
            };
        final String[] Iran = new String[] {
               "iráni téli idő",
               "",
               "iráni nyári idő",
               "",
               "iráni idő",
               "",
            };
        final String[] Niue = new String[] {
               "niuei idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "omszki téli idő",
               "",
               "omszki nyári idő",
               "",
               "omszki idő",
               "",
            };
        final String[] Peru = new String[] {
               "perui téli idő",
               "",
               "perui nyári idő",
               "",
               "perui idő",
               "",
            };
        final String[] Truk = new String[] {
               "truki idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "wake-szigeti idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "chilei téli idő",
               "",
               "chilei nyári idő",
               "",
               "chilei időzóna",
               "",
            };
        final String[] China = new String[] {
               "kínai téli idő",
               "CST",
               "kínai nyári idő",
               "CDT",
               "kínai idő",
               "CT",
            };
        final String[] Cocos = new String[] {
               "kókusz-szigeteki téli idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "davisi idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indiai téli idő",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "japán téli idő",
               "JST",
               "japán nyári idő",
               "JDT",
               "japán idő",
               "JT",
            };
        final String[] Korea = new String[] {
               "koreai téli idő",
               "KST",
               "koreai nyári idő",
               "KST",
               "koreai idő",
               "KST",
            };
        final String[] Nauru = new String[] {
               "naurui idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nepáli idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "palaui idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "szamoai téli idő",
               "SST",
               "szamoai nyári idő",
               "SST",
               "szamoai idő",
               "SST",
            };
        final String[] Syowa = new String[] {
               "syowai idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "tongai téli idő",
               "",
               "tongai nyári idő",
               "",
               "tongai idő",
               "",
            };
        final String[] Yukon = new String[] {
               "yukoni idő",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "alaszkai zónaidő",
               "AKST",
               "alaszkai nyári idő",
               "AKDT",
               "alaszkai idő",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "amazóniai téli idő",
               "",
               "amazóniai nyári idő",
               "",
               "amazóniai idő",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadíri zónaidő",
               "",
               "Anadíri nyári idő",
               "",
               "Anadiri idő",
               "",
            };
        final String[] Azores = new String[] {
               "azori téli idő",
               "",
               "azori nyári idő",
               "",
               "azori időzóna",
               "",
            };
        final String[] Bhutan = new String[] {
               "butáni idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam-i idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "húsvét-szigeti téli idő",
               "",
               "húsvét-szigeti nyári idő",
               "",
               "húsvét-szigeti időzóna",
               "",
            };
        final String[] Guyana = new String[] {
               "guyanai téli idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "izraeli téli idő",
               "IST",
               "izraeli nyári idő",
               "IDT",
               "izraeli idő",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "kosraei idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "mawsoni idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "moszkvai téli idő",
               "MSK",
               "moszkvai nyári idő",
               "MSK",
               "moszkvai idő",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ponape-szigeti idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Szamarai zónaidő",
               "",
               "Szamarai nyári idő",
               "",
               "Szamarai idő",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahiti idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "taipei téli idő",
               "CST",
               "taipei nyári idő",
               "CDT",
               "taipei idő",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "tuvalui idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "vosztoki idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis és Futuna-i idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arab téli idő",
               "",
               "arab nyári idő",
               "",
               "arab idő",
               "",
            };
        final String[] Armenia = new String[] {
               "örményországi téli idő",
               "",
               "örményországi nyári idő",
               "",
               "örményországi idő",
               "",
            };
        final String[] Bolivia = new String[] {
               "bolíviai téli idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "chathami téli idő",
               "",
               "chathami nyári idő",
               "",
               "chathami idő",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinált világidő",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ecuadori téli idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "gambieri idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "grúziai téli idő",
               "",
               "grúziai nyári idő",
               "",
               "grúziai idő",
               "",
            };
        final String[] Irkutsk = new String[] {
               "irkutszki téli idő",
               "",
               "irkutszki nyári idő",
               "",
               "irkutszki idő",
               "",
            };
        final String[] Magadan = new String[] {
               "magadani téli idő",
               "",
               "magadáni nyári idő",
               "",
               "magadáni idő",
               "",
            };
        final String[] Myanmar = new String[] {
               "mianmari idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "norfolk-szigeteki téli idő",
               "",
               "norfolk-szigeteki nyári idő",
               "",
               "norfolk-szigeteki idő",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-i téli idő",
               "",
               "Fernando de Noronha-i nyári idő",
               "",
               "Fernando de Noronha-i idő",
               "",
            };
        final String[] Reunion = new String[] {
               "réunioni idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "rotherai idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "salamon-szigeteki idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "tokelaui idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguayi téli idő",
               "",
               "uruguayi nyári idő",
               "",
               "uruguayi idő",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatui téli idő",
               "",
               "vanuatui nyári idő",
               "",
               "vanuatui idő",
               "",
            };
        final String[] Yakutsk = new String[] {
               "jakutszki téli idő",
               "",
               "jakutszki nyári idő",
               "",
               "jakutszki idő",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlanti-óceáni zónaidő",
               "AST",
               "atlanti-óceáni nyári idő",
               "AST",
               "atlanti-óceáni idő",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "brazíliai téli idő",
               "",
               "brazíliai nyári idő",
               "",
               "brazíliai idő",
               "",
            };
        final String[] Chamorro = new String[] {
               "chamorrói téli idő",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "kolumbiai téli idő",
               "",
               "kolumbiai nyári idő",
               "",
               "kolumbiai idő",
               "",
            };
        final String[] Falkland = new String[] {
               "falkland-szigeteki téli idő",
               "",
               "falkland-szigeteki nyári idő",
               "",
               "falkland-szigeteki idő",
               "",
            };
        final String[] Malaysia = new String[] {
               "malajziai idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "maldív-szigeteki idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ulánbátori téli idő",
               "",
               "ulánbátori nyári idő",
               "",
               "ulánbátori idő",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakisztáni téli idő",
               "PKT",
               "pakisztáni nyári idő",
               "PKST",
               "pakisztáni idő",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "paraguayi téli idő",
               "",
               "paraguayi nyári idő",
               "",
               "paraguayi idő",
               "",
            };
        final String[] Pitcairn = new String[] {
               "pitcairn-szigeteki idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "szahalini téli idő",
               "",
               "szahalini nyári idő",
               "",
               "szahalini idő",
               "",
            };
        final String[] Suriname = new String[] {
               "szurinámi idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argentínai téli idő",
               "",
               "argentínai nyári idő",
               "",
               "argentínai idő",
               "",
            };
        final String[] Christmas = new String[] {
               "karácsony-szigeti idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "galápagosi téli idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hongkongi téli idő",
               "HKT",
               "hongkongi nyári idő",
               "HKST",
               "hongkongi időzóna",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "indokínai idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovszk-kamcsatkai zónaidő",
               "",
               "Petropavlovszk-kamcsatkai nyári idő",
               "",
               "Petropavlovszk-kamcsatkai idő",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgizisztáni idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-szigeti téli idő",
               "",
               "Lord Howe-szigeti nyári idő",
               "",
               "Lord Howe-szigeti idő",
               "",
            };
        final String[] Marquesas = new String[] {
               "marquises-szigeteki idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "mauritiusi téli idő",
               "",
               "mauritiusi nyári idő",
               "",
               "mauritiusi időzóna",
               "",
            };
        final String[] Singapore = new String[] {
               "szingapúri téli idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelai idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "volgográdi téli idő",
               "MSK",
               "volgográdi nyári idő",
               "MSK",
               "volgográdi idő",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajdzsáni téli idő",
               "",
               "azerbajdzsáni nyári idő",
               "",
               "azerbajdzsáni idő",
               "",
            };
        final String[] Bangladesh = new String[] {
               "bangladesi téli idő",
               "",
               "bangladesi nyári idő",
               "",
               "bangladesi idő",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "zöld-foki-szigeteki téli idő",
               "",
               "zöld-foki-szigeteki nyári idő",
               "",
               "zöld-foki-szigeteki időzóna",
               "",
            };
        final String[] East_Timor = new String[] {
               "kelet-timori téli idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "kazahsztáni idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "seychelle-szigeteki idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "tádzsikisztáni idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "üzbegisztáni téli idő",
               "",
               "üzbegisztáni nyári idő",
               "",
               "üzbegisztáni idő",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afganisztáni idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasznojarszki téli idő",
               "",
               "krasznojarszki nyári idő",
               "",
               "krasznojarszki idő",
               "",
            };
        final String[] New_Zealand = new String[] {
               "új-zélandi téli idő",
               "NZST",
               "új-zélandi nyári idő",
               "NZDT",
               "új-zélandi idő",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "novoszibirszki téli idő",
               "",
               "novoszibirszki nyári idő",
               "",
               "novoszibirszki idő",
               "",
            };
        final String[] Philippines = new String[] {
               "fülöp-szigeteki téli idő",
               "PST",
               "fülöp-szigeteki nyári idő",
               "PDT",
               "fülöp-szigeteki idő",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "vlagyivosztoki téli idő",
               "",
               "vlagyivosztoki nyári idő",
               "",
               "vlagyivosztoki idő",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "indiai-óceáni idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "sor-szigeteki idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "új-fundlandi zónaidő",
               "NST",
               "új-fundlandi nyári idő",
               "NDT",
               "új-fundlandi idő",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "türkmenisztáni téli idő",
               "",
               "türkmenisztáni nyári idő",
               "",
               "türkmenisztáni idő",
               "",
            };
        final String[] French_Guiana = new String[] {
               "francia-guyanai idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "új-kaledóniai téli idő",
               "",
               "új-kaledóniai nyári idő",
               "",
               "új-kaledóniai idő",
               "",
            };
        final String[] South_Georgia = new String[] {
               "déli-georgiai idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "jekatyerinburgi téli idő",
               "",
               "jekatyerinburgi nyári idő",
               "",
               "jekatyerinburgi idő",
               "",
            };
        final String[] Africa_Central = new String[] {
               "közép-afrikai téli idő",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "kelet-afrikai téli idő",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "nyugat-afrikai téli idő",
               "WAT",
               "nyugat-afrikai nyári idő",
               "WAT",
               "nyugat-afrikai időzóna",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "dumont-d’Urville-i idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "közép-európai téli idő",
               "CET",
               "közép-európai nyári idő",
               "CEST",
               "közép-európai időzóna",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "kelet-európai téli idő",
               "EET",
               "kelet-európai nyári idő",
               "EEST",
               "kelet-európai időzóna",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "nyugat-európai téli idő",
               "WET",
               "nyugat-európai nyári idő",
               "WEST",
               "nyugat-európai időzóna",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "mexikói csendes-óceáni zónaidő",
               "MST",
               "mexikói csendes-óceáni nyári idő",
               "MDT",
               "mexikói csendes-óceáni idő",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "dél-afrikai téli idő",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "középső államokbeli zónaidő",
               "CST",
               "középső államokbeli nyári idő",
               "CDT",
               "középső államokbeli idő",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "keleti államokbeli zónaidő",
               "EST",
               "keleti államokbeli nyári idő",
               "EST",
               "keleti államokbeli idő",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "csendes-óceáni zónaidő",
               "PST",
               "csendes-óceáni nyári idő",
               "PDT",
               "csendes-óceáni idő",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "francia déli és antarktiszi idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "gilbert-szigeteki idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hawaii-aleuti téli idő",
               "HST",
               "hawaii-aleuti nyári idő",
               "HST",
               "hawaii-aleuti időzóna",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "phoenix-szigeteki téli idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre és Miquelon-i zónaidő",
               "",
               "Saint-Pierre és Miquelon-i nyári idő",
               "",
               "Saint-Pierre és Miquelon-i idő",
               "",
            };
        final String[] America_Mountain = new String[] {
               "hegyvidéki zónaidő",
               "MST",
               "hegyvidéki nyári idő",
               "MST",
               "hegyvidéki idő",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "marshall-szigeteki idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "pápua új-guineai idő",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "közép-ausztráliai téli idő",
               "ACST",
               "közép-ausztráliai nyári idő",
               "ACDT",
               "közép-ausztráliai idő",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "kelet-ausztráliai téli idő",
               "AEST",
               "kelet-ausztráliai nyári idő",
               "AEDT",
               "kelet-ausztráliai idő",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "nyugat-ausztráliai téli idő",
               "AWST",
               "nyugat-ausztráliai nyári idő",
               "AWDT",
               "nyugat-ausztráliai idő",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "közép-indonéziai idő",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "kelet-indonéziai idő",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "nyugat-indonéziai téli idő",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "közép-nyugat-ausztráliai téli idő",
               "",
               "közép-nyugat-ausztráliai nyári idő",
               "",
               "közép-nyugat-ausztráliai idő",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "greenwichi középidő, téli idő",
                    "GMT",
                    "brit nyári idő",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordinált világidő",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "greenwichi középidő, téli idő",
                    "GMT",
                    "ír nyári idő",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordinált világidő",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordinált világidő",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "greenwichi középidő, téli idő",
                    "GMT",
                    "brit nyári idő",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordinált világidő",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "koordinált világidő",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordinált világidő",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "greenwichi középidő, téli idő",
                    "GMT",
                    "ír nyári idő",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "greenwichi középidő, téli idő",
                    "GMT",
                    "brit nyári idő",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "greenwichi középidő, téli idő",
                    "GMT",
                    "brit nyári idő",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "greenwichi középidő, téli idő",
                    "GMT",
                    "brit nyári idő",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "greenwichi középidő, téli idő",
                    "GMT",
                    "brit nyári idő",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "greenwichi középidő, téli idő",
                    "GMT",
                    "brit nyári idő",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Áden" },
            { "timezone.excity.Asia/Gaza", "Gáza" },
            { "timezone.excity.Asia/Omsk", "Omszk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Ammán" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Csita" },
            { "timezone.excity.Asia/Dhaka", "Dakka" },
            { "timezone.excity.Asia/Dubai", "Dubaj" },
            { "timezone.excity.Asia/Macau", "Makaó" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Szöul" },
            { "timezone.excity.Asia/Tokyo", "Tokió" },
            { "timezone.excity.Asia/Tomsk", "Tomszk" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Almaty", "Alma-Ata" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Aktöbe" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "Bejrút" },
            { "timezone.excity.Asia/Kuwait", "Kuvait" },
            { "timezone.excity.Asia/Muscat", "Maszkat" },
            { "timezone.excity.Asia/Riyadh", "Rijád" },
            { "timezone.excity.Asia/Saigon", "Ho Si Minh-város" },
            { "timezone.excity.Asia/Taipei", "Tajpej" },
            { "timezone.excity.Asia/Tehran", "Teherán" },
            { "timezone.excity.Asia/Urumqi", "Ürümcsi" },
            { "timezone.excity.Etc/Unknown", "Ismeretlen város" },
            { "timezone.excity.Europe/Kiev", "Kijev" },
            { "timezone.excity.Europe/Rome", "Róma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairó" },
            { "timezone.excity.Africa/Tunis", "Tunisz" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Bishkek", "Biskek" },
            { "timezone.excity.Asia/Irkutsk", "Irkutszk" },
            { "timezone.excity.Asia/Karachi", "Karacsi" },
            { "timezone.excity.Asia/Kuching", "Kucseng" },
            { "timezone.excity.Asia/Magadan", "Magadán" },
            { "timezone.excity.Asia/Tbilisi", "Tbiliszi" },
            { "timezone.excity.Asia/Thimphu", "Timpu" },
            { "timezone.excity.Asia/Yakutsk", "Jakutszk" },
            { "timezone.excity.Asia/Yerevan", "Jereván" },
            { "timezone.excity.Europe/Malta", "Málta" },
            { "timezone.excity.Europe/Minsk", "Minszk" },
            { "timezone.excity.Europe/Paris", "Párizs" },
            { "timezone.excity.Europe/Sofia", "Szófia" },
            { "timezone.excity.Indian/Cocos", "Kókusz-sziget" },
            { "timezone.excity.Pacific/Fiji", "Fidzsi" },
            { "timezone.excity.Pacific/Truk", "Truk" },
            { "timezone.excity.Pacific/Wake", "Wake-sziget" },
            { "timezone.excity.Africa/Asmera", "Aszmara" },
            { "timezone.excity.Africa/Malabo", "Malabó" },
            { "timezone.excity.America/Belem", "Belém" },
            { "timezone.excity.Asia/Ashgabat", "Asgabat" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "timezone.excity.Asia/Damascus", "Damaszkusz" },
            { "timezone.excity.Asia/Dushanbe", "Dusanbe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kosztanaj" },
            { "timezone.excity.Asia/Sakhalin", "Szahalin" },
            { "timezone.excity.Asia/Shanghai", "Sanghaj" },
            { "timezone.excity.Asia/Tashkent", "Taskent" },
            { "timezone.excity.Asia/Ust-Nera", "Uszty-Nyera" },
            { "timezone.excity.Europe/Athens", "Athén" },
            { "timezone.excity.Europe/Lisbon", "Lisszabon" },
            { "timezone.excity.Europe/Moscow", "Moszkva" },
            { "timezone.excity.Europe/Prague", "Prága" },
            { "timezone.excity.Europe/Samara", "Szamara" },
            { "timezone.excity.Europe/Skopje", "Szkopje" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Bécs" },
            { "timezone.excity.Europe/Warsaw", "Varsó" },
            { "timezone.excity.Europe/Zagreb", "Zágráb" },
            { "timezone.excity.Europe/Zurich", "Zürich" },
            { "timezone.excity.Indian/Comoro", "Komoró" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Algír" },
            { "timezone.excity.America/Bogota", "Bogotá" },
            { "timezone.excity.America/Cayman", "Kajmán-szigetek" },
            { "timezone.excity.America/Cuiaba", "Cuiabá" },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.America/Maceio", "Maceió" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzsálem" },
            { "timezone.excity.Asia/Kamchatka", "Kamcsatka" },
            { "timezone.excity.Asia/Pyongyang", "Phenjan" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "timezone.excity.Asia/Samarkand", "Szamarkand" },
            { "timezone.excity.Asia/Singapore", "Szingapúr" },
            { "timezone.excity.Asia/Vientiane", "Vientián" },
            { "timezone.excity.Europe/Saratov", "Szaratov" },
            { "timezone.excity.Europe/Tallinn", "Tallin" },
            { "timezone.excity.Europe/Vatican", "Vatikán" },
            { "timezone.excity.Pacific/Easter", "Húsvét-szigetek" },
            { "timezone.excity.Pacific/Kosrae", "Kosrae-szigetek" },
            { "timezone.excity.Pacific/Majuro", "Majuro-zátony" },
            { "timezone.excity.Pacific/Midway", "Midway-szigetek" },
            { "timezone.excity.Pacific/Ponape", "Ponape-szigetek" },
            { "timezone.excity.Africa/Djibouti", "Dzsibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El-Ajún" },
            { "timezone.excity.Africa/Khartoum", "Kartúm" },
            { "timezone.excity.America/Cordoba", "Córdoba" },
            { "timezone.excity.Atlantic/Azores", "Azori-szigetek" },
            { "timezone.excity.Atlantic/Canary", "Kanári-szigetek" },
            { "timezone.excity.Atlantic/Faeroe", "Feröer" },
            { "timezone.excity.Europe/Belgrade", "Belgrád" },
            { "timezone.excity.Europe/Brussels", "Brüsszel" },
            { "timezone.excity.Europe/Busingen", "Büsingen" },
            { "timezone.excity.Europe/Istanbul", "Isztanbul" },
            { "timezone.excity.Europe/Sarajevo", "Szarajevó" },
            { "timezone.excity.Indian/Maldives", "Maldív-szigetek" },
            { "timezone.excity.Pacific/Chatham", "Chatham-szigetek" },
            { "timezone.excity.Pacific/Gambier", "Gambier-szigetek" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Eirunepe", "Eirunepé" },
            { "timezone.excity.America/Mazatlan", "Mazatlán" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasznojarszk" },
            { "timezone.excity.Asia/Novosibirsk", "Novoszibirszk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulánbátor" },
            { "timezone.excity.Asia/Vladivostok", "Vlagyivosztok" },
            { "timezone.excity.Europe/Amsterdam", "Amszterdam" },
            { "timezone.excity.Europe/Astrakhan", "Asztrahán" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltár" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovszk" },
            { "timezone.excity.Europe/Volgograd", "Volgográd" },
            { "timezone.excity.Indian/Christmas", "Karácsony-sziget" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn-szigetek" },
            { "timezone.excity.America/Araguaina", "Araguaína" },
            { "timezone.excity.America/Sao_Paulo", "São Paulo" },
            { "timezone.excity.Antarctica/Vostok", "Vosztok" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznyeck" },
            { "timezone.excity.Europe/Bratislava", "Pozsony" },
            { "timezone.excity.Europe/Copenhagen", "Koppenhága" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Europe/Simferopol", "Szimferopol" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Galapagos-szigetek" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein-zátony" },
            { "timezone.excity.Pacific/Marquesas", "Marquesas-szigetek" },
            { "timezone.excity.Africa/Addis_Ababa", "Addisz-Abeba" },
            { "timezone.excity.America/Rio_Branco", "Río Branco" },
            { "timezone.excity.Asia/Srednekolymsk", "Szrednekolimszk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekatyerinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavík" },
            { "timezone.excity.Atlantic/St_Helena", "Szent Ilona" },
            { "timezone.excity.Europe/Isle_of_Man", "Man-sziget" },
            { "timezone.excity.Europe/Kaliningrad", "Kalinyingrád" },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati-sziget" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Mexico_City", "Mexikóváros" },
            { "timezone.excity.Atlantic/Cape_Verde", "Zöld-foki szigetek" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es-Salaam" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barthélemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Déli-Georgia" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucumán" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Észak-Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Észak-Dakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Río Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Észak-Dakota" },
        };
        return data;
    }
}
