/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "heure moyenne de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "heure normale de l\u2019Acre",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Acre",
               "",
               "heure de l\u2019Acre",
               "",
            };
        final String[] Apia = new String[] {
               "heure normale d\u2019Apia",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Apia",
               "",
               "heure d\u2019Apia",
               "",
            };
        final String[] Cook = new String[] {
               "heure normale des \u00eeles Cook",
               "",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Cook",
               "",
               "heure des \u00eeles Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "heure normale de Cuba",
               "CST",
               "heure d\u2019\u00e9t\u00e9 de Cuba",
               "CDT",
               "heure de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "heure normale des \u00eeles Fidji",
               "",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Fidji",
               "",
               "heure des \u00eeles Fidji",
               "",
            };
        final String[] Gulf = new String[] {
               "heure du Golfe",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "heure normale de Hovd",
               "",
               "heure d\u2019\u00e9t\u00e9 de Hovd",
               "",
               "heure de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "heure normale d\u2019Iran",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Iran",
               "",
               "heure de l\u2019Iran",
               "",
            };
        final String[] Niue = new String[] {
               "heure de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "heure normale de Omsk",
               "",
               "heure d\u2019\u00e9t\u00e9 de Omsk",
               "",
               "heure de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "heure normale du P\u00e9rou",
               "",
               "heure d\u2019\u00e9t\u00e9 du P\u00e9rou",
               "",
               "heure du P\u00e9rou",
               "",
            };
        final String[] Truk = new String[] {
               "heure de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "heure de l\u2019\u00eele Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "heure normale du Chili",
               "",
               "heure d\u2019\u00e9t\u00e9 du Chili",
               "",
               "heure du Chili",
               "",
            };
        final String[] China = new String[] {
               "heure normale de la Chine",
               "CST",
               "heure d\u2019\u00e9t\u00e9 de Chine",
               "CDT",
               "heure de la Chine",
               "CT",
            };
        final String[] Cocos = new String[] {
               "heure des \u00eeles Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "heure de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "heure de l\u2019Inde",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "heure normale du Japon",
               "JST",
               "heure d\u2019\u00e9t\u00e9 du Japon",
               "JDT",
               "heure du Japon",
               "JT",
            };
        final String[] Korea = new String[] {
               "heure normale de la Cor\u00e9e",
               "KST",
               "heure d\u2019\u00e9t\u00e9 de Cor\u00e9e",
               "KST",
               "heure de la Cor\u00e9e",
               "KST",
            };
        final String[] Nauru = new String[] {
               "heure de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "heure du N\u00e9pal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "heure des Palaos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "heure normale des Samoa",
               "SST",
               "heure d\u2019\u00e9t\u00e9 des Samoa",
               "SST",
               "heure des Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "heure de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "heure normale des Tonga",
               "",
               "heure d\u2019\u00e9t\u00e9 de Tonga",
               "",
               "heure des Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "heure normale du Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "heure normale de l\u2019Alaska",
               "AKST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Alaska",
               "AKDT",
               "heure de l\u2019Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "heure normale de l\u2019Amazonie",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Amazonie",
               "",
               "heure de l\u2019Amazonie",
               "",
            };
        final String[] Anadyr = new String[] {
               "heure normale d\u2019Anadyr",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Anadyr",
               "",
               "heure d\u2019Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "heure normale des A\u00e7ores",
               "",
               "heure d\u2019\u00e9t\u00e9 des A\u00e7ores",
               "",
               "heure des A\u00e7ores",
               "",
            };
        final String[] Bhutan = new String[] {
               "heure du Bhoutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "heure du Brunei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "heure normale de l\u2019\u00eele de P\u00e2ques",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019\u00eele de P\u00e2ques",
               "",
               "heure de l\u2019\u00eele de P\u00e2ques",
               "",
            };
        final String[] Guyana = new String[] {
               "heure du Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "heure normale d\u2019Isra\u00ebl",
               "IST",
               "heure d\u2019\u00e9t\u00e9 d\u2019Isra\u00ebl",
               "IDT",
               "heure d\u2019Isra\u00ebl",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "heure de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "heure de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "heure normale de Moscou",
               "MSK",
               "heure d\u2019\u00e9t\u00e9 de Moscou",
               "MSK",
               "heure de Moscou",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "heure de l\u2019\u00eele de Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "heure normale de Samara",
               "",
               "heure d\u2019\u00e9t\u00e9 de Samara",
               "",
               "heure de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "heure de Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "heure normale de Taipei",
               "CST",
               "heure d\u2019\u00e9t\u00e9 de Taipei",
               "CDT",
               "heure de Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "heure des Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "heure de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "heure de Wallis-et-Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "heure normale de l\u2019Arabie",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Arabie",
               "",
               "heure de l\u2019Arabie",
               "",
            };
        final String[] Armenia = new String[] {
               "heure normale de l\u2019Arm\u00e9nie",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Arm\u00e9nie",
               "",
               "heure de l\u2019Arm\u00e9nie",
               "",
            };
        final String[] Bolivia = new String[] {
               "heure de Bolivie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "heure normale des \u00eeles Chatham",
               "",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Chatham",
               "",
               "heure des \u00eeles Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "temps universel coordonn\u00e9",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "heure de l\u2019\u00c9quateur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "heure des \u00eeles Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "heure normale de la G\u00e9orgie",
               "",
               "heure d\u2019\u00e9t\u00e9 de G\u00e9orgie",
               "",
               "heure de la G\u00e9orgie",
               "",
            };
        final String[] Irkutsk = new String[] {
               "heure normale d\u2019Irkoutsk",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Irkoutsk",
               "",
               "heure d\u2019Irkoutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "heure normale de Magadan",
               "",
               "heure d\u2019\u00e9t\u00e9 de Magadan",
               "",
               "heure de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "heure du Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "heure normale de l\u2019\u00eele Norfolk",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019\u00eele Norfolk",
               "",
               "heure de l\u2019\u00eele Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "heure normale de Fernando de Noronha",
               "",
               "heure d\u2019\u00e9t\u00e9 de Fernando de Noronha",
               "",
               "heure de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "heure de La R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "heure de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "heure des \u00eeles Salomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "heure de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "heure normale de l\u2019Uruguay",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Uruguay",
               "",
               "heure de l\u2019Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "heure normale du Vanuatu",
               "",
               "heure d\u2019\u00e9t\u00e9 de Vanuatu",
               "",
               "heure du Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "heure normale de Iakoutsk",
               "",
               "heure d\u2019\u00e9t\u00e9 de Iakoutsk",
               "",
               "heure de Iakoutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "heure normale de l\u2019Atlantique",
               "AST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Atlantique",
               "AST",
               "heure de l\u2019Atlantique",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "heure normale de Brasilia",
               "",
               "heure d\u2019\u00e9t\u00e9 de Brasilia",
               "",
               "heure de Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "heure des Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "heure normale de Colombie",
               "",
               "heure d\u2019\u00e9t\u00e9 de Colombie",
               "",
               "heure de Colombie",
               "",
            };
        final String[] Falkland = new String[] {
               "heure normale des \u00eeles Malouines",
               "",
               "heure d\u2019\u00e9t\u00e9 des \u00eeles Malouines",
               "",
               "heure des \u00eeles Malouines",
               "",
            };
        final String[] Malaysia = new String[] {
               "heure de la Malaisie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "heure des Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "heure normale d\u2019Oulan-Bator",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Oulan-Bator",
               "",
               "heure d\u2019Oulan-Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "heure normale du Pakistan",
               "PKT",
               "heure d\u2019\u00e9t\u00e9 du Pakistan",
               "PKST",
               "heure du Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "heure normale du Paraguay",
               "",
               "heure d\u2019\u00e9t\u00e9 du Paraguay",
               "",
               "heure du Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "heure des \u00eeles Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "heure normale de Sakhaline",
               "",
               "heure d\u2019\u00e9t\u00e9 de Sakhaline",
               "",
               "heure de Sakhaline",
               "",
            };
        final String[] Suriname = new String[] {
               "heure du Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "heure normale d\u2019Argentine",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Argentine",
               "",
               "heure de l\u2019Argentine",
               "",
            };
        final String[] Christmas = new String[] {
               "heure de l\u2019\u00eele Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "heure des \u00eeles Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "heure normale de Hong Kong",
               "HKT",
               "heure d\u2019\u00e9t\u00e9 de Hong Kong",
               "HKST",
               "heure de Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "heure d\u2019Indochine",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "heure normale de Petropavlovsk-Kamchatski",
               "",
               "heure d\u2019\u00e9t\u00e9 de Petropavlovsk-Kamchatski",
               "",
               "heure de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "heure du Kirghizistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "heure normale de Lord Howe",
               "",
               "heure d\u2019\u00e9t\u00e9 de Lord Howe",
               "",
               "heure de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "heure des \u00eeles Marquises",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "heure normale de Maurice",
               "",
               "heure d\u2019\u00e9t\u00e9 de Maurice",
               "",
               "heure de Maurice",
               "",
            };
        final String[] Singapore = new String[] {
               "heure de Singapour",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "heure du Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "heure normale de Volgograd",
               "MSK",
               "heure d\u2019\u00e9t\u00e9 de Volgograd",
               "MSK",
               "heure de Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "heure normale de l\u2019Azerba\u00efdjan",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Azerba\u00efdjan",
               "",
               "heure de l\u2019Azerba\u00efdjan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "heure normale du Bangladesh",
               "",
               "heure d\u2019\u00e9t\u00e9 du Bangladesh",
               "",
               "heure du Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "heure normale du Cap-Vert",
               "",
               "heure d\u2019\u00e9t\u00e9 du Cap-Vert",
               "",
               "heure du Cap-Vert",
               "",
            };
        final String[] East_Timor = new String[] {
               "heure du Timor oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "heure du Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "heure des Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "heure du Tadjikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "heure normale de l\u2019Ouzb\u00e9kistan",
               "",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Ouzb\u00e9kistan",
               "",
               "heure de l\u2019Ouzb\u00e9kistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "heure de l\u2019Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "heure normale de Krasno\u00efarsk",
               "",
               "heure d\u2019\u00e9t\u00e9 de Krasno\u00efarsk",
               "",
               "heure de Krasno\u00efarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "heure normale de la Nouvelle-Z\u00e9lande",
               "NZST",
               "heure d\u2019\u00e9t\u00e9 de la Nouvelle-Z\u00e9lande",
               "NZDT",
               "heure de la Nouvelle-Z\u00e9lande",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "heure normale de Novossibirsk",
               "",
               "heure d\u2019\u00e9t\u00e9 de Novossibirsk",
               "",
               "heure de Novossibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "heure normale des Philippines",
               "PST",
               "heure d\u2019\u00e9t\u00e9 des Philippines",
               "PDT",
               "heure des Philippines",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "heure normale de Vladivostok",
               "",
               "heure d\u2019\u00e9t\u00e9 de Vladivostok",
               "",
               "heure de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "heure de l\u2019Oc\u00e9an Indien",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "heure des \u00eeles de la Ligne",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "heure normale de Terre-Neuve",
               "NST",
               "heure d\u2019\u00e9t\u00e9 de Terre-Neuve",
               "NDT",
               "heure de Terre-Neuve",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "heure normale du Turkm\u00e9nistan",
               "",
               "heure d\u2019\u00e9t\u00e9 du Turkm\u00e9nistan",
               "",
               "heure du Turkm\u00e9nistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "heure de la Guyane fran\u00e7aise",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "heure normale de la Nouvelle-Cal\u00e9donie",
               "",
               "heure d\u2019\u00e9t\u00e9 de Nouvelle-Cal\u00e9donie",
               "",
               "heure de la Nouvelle-Cal\u00e9donie",
               "",
            };
        final String[] South_Georgia = new String[] {
               "heure de G\u00e9orgie du Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "heure normale d\u2019Ekaterinbourg",
               "",
               "heure d\u2019\u00e9t\u00e9 d\u2019Ekaterinbourg",
               "",
               "heure d\u2019Ekaterinbourg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "heure normale d\u2019Afrique centrale",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "heure normale d\u2019Afrique de l\u2019Est",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "heure normale d\u2019Afrique de l\u2019Ouest",
               "WAT",
               "heure d\u2019\u00e9t\u00e9 d\u2019Afrique de l\u2019Ouest",
               "WAT",
               "heure d\u2019Afrique de l\u2019Ouest",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "heure de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "heure normale d\u2019Europe centrale",
               "CET",
               "heure d\u2019\u00e9t\u00e9 d\u2019Europe centrale",
               "CEST",
               "heure d\u2019Europe centrale",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "heure normale d\u2019Europe de l\u2019Est",
               "EET",
               "heure d\u2019\u00e9t\u00e9 d\u2019Europe de l\u2019Est",
               "EEST",
               "heure d\u2019Europe de l\u2019Est",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "heure normale d\u2019Europe de l\u2019Ouest",
               "WET",
               "heure d\u2019\u00e9t\u00e9 d\u2019Europe de l\u2019Ouest",
               "WEST",
               "heure d\u2019Europe de l\u2019Ouest",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "heure normale du Pacifique mexicain",
               "MST",
               "heure d\u2019\u00e9t\u00e9 du Pacifique mexicain",
               "MDT",
               "heure du Pacifique mexicain",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "heure normale d\u2019Afrique m\u00e9ridionale",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "heure normale du centre nord-am\u00e9ricain",
               "CST",
               "heure d\u2019\u00e9t\u00e9 du centre nord-am\u00e9ricain",
               "CDT",
               "heure du centre nord-am\u00e9ricain",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "heure normale de l\u2019Est nord-am\u00e9ricain",
               "EST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Est nord-am\u00e9ricain",
               "EST",
               "heure de l\u2019Est nord-am\u00e9ricain",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "heure normale du Pacifique nord-am\u00e9ricain",
               "PST",
               "heure d\u2019\u00e9t\u00e9 du Pacifique nord-am\u00e9ricain",
               "PDT",
               "heure du Pacifique nord-am\u00e9ricain",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "heure des Terres australes et antarctiques fran\u00e7aises",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "heure des \u00eeles Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "heure normale d\u2019Hawa\u00ef - Al\u00e9outiennes",
               "HST",
               "heure d\u2019\u00e9t\u00e9 d\u2019Hawa\u00ef - Al\u00e9outiennes",
               "HST",
               "heure d\u2019Hawa\u00ef - Al\u00e9outiennes",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "heure des \u00eeles Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "heure normale de Saint-Pierre-et-Miquelon",
               "",
               "heure d\u2019\u00e9t\u00e9 de Saint-Pierre-et-Miquelon",
               "",
               "heure de Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "heure normale des Rocheuses",
               "MST",
               "heure d\u2019\u00e9t\u00e9 des Rocheuses",
               "MST",
               "heure des Rocheuses",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "heure des \u00eeles Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "heure de la Papouasie-Nouvelle-Guin\u00e9e",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "heure normale du centre de l\u2019Australie",
               "ACST",
               "heure d\u2019\u00e9t\u00e9 du centre de l\u2019Australie",
               "ACDT",
               "heure du centre de l\u2019Australie",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "heure normale de l\u2019Est de l\u2019Australie",
               "AEST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Est de l\u2019Australie",
               "AEDT",
               "heure de l\u2019Est de l\u2019Australie",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "heure normale de l\u2019Ouest de l\u2019Australie",
               "AWST",
               "heure d\u2019\u00e9t\u00e9 de l\u2019Ouest de l\u2019Australie",
               "AWDT",
               "heure de l\u2019Ouest de l\u2019Australie",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "heure du Centre indon\u00e9sien",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "heure de l\u2019Est indon\u00e9sien",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "heure de l\u2019Ouest indon\u00e9sien",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "heure normale du centre-ouest de l\u2019Australie",
               "",
               "heure d\u2019\u00e9t\u00e9 du centre-ouest de l\u2019Australie",
               "",
               "heure du centre-ouest de l\u2019Australie",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "temps universel coordonn\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 irlandaise",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "temps universel coordonn\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "temps universel coordonn\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "temps universel coordonn\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "temps universel coordonn\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "temps universel coordonn\u00e9",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 irlandaise",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "heure moyenne de Greenwich",
                    "GMT",
                    "heure d\u2019\u00e9t\u00e9 britannique",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bakou" },
            { "timezone.excity.Asia/Oral", "Ouralsk" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktaou" },
            { "timezone.excity.Asia/Chita", "Tchita" },
            { "timezone.excity.Asia/Dubai", "Duba\u00ef" },
            { "timezone.excity.Asia/Kabul", "Kaboul" },
            { "timezone.excity.Asia/Seoul", "S\u00e9oul" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Almaty", "Alma Ata" },
            { "timezone.excity.Asia/Aqtobe", "Aktioubinsk" },
            { "timezone.excity.Asia/Atyrau", "Atyraou" },
            { "timezone.excity.Asia/Beirut", "Beyrouth" },
            { "timezone.excity.Asia/Hebron", "H\u00e9bron" },
            { "timezone.excity.Asia/Kuwait", "Kowe\u00eft" },
            { "timezone.excity.Asia/Manila", "Manille" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "timezone.excity.Asia/Saigon", "H\u00f4-Chi-Minh-Ville" },
            { "timezone.excity.Asia/Tehran", "T\u00e9h\u00e9ran" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "ville inconnue" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Le Caire" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahre\u00efn" },
            { "timezone.excity.Asia/Bishkek", "Bichkek" },
            { "timezone.excity.Asia/Irkutsk", "Irkoutsk" },
            { "timezone.excity.Asia/Nicosia", "Nicosie" },
            { "timezone.excity.Asia/Rangoon", "Rangoun" },
            { "timezone.excity.Asia/Tbilisi", "Tbilissi" },
            { "timezone.excity.Asia/Yakutsk", "Iakoutsk" },
            { "timezone.excity.Asia/Yerevan", "Erevan" },
            { "timezone.excity.Europe/Malta", "Malte" },
            { "timezone.excity.Pacific/Fiji", "Fidji" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.America/Thule", "Thul\u00e9" },
            { "timezone.excity.Asia/Ashgabat", "Achgabat" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "timezone.excity.Asia/Damascus", "Damas" },
            { "timezone.excity.Asia/Dushanbe", "Douchanb\u00e9" },
            { "timezone.excity.Asia/Katmandu", "Katmandou" },
            { "timezone.excity.Asia/Makassar", "Macassar" },
            { "timezone.excity.Asia/Qostanay", "Kostana\u00ef" },
            { "timezone.excity.Asia/Sakhalin", "Sakhaline" },
            { "timezone.excity.Asia/Tashkent", "Tachkent" },
            { "timezone.excity.Europe/Athens", "Ath\u00e8nes" },
            { "timezone.excity.Europe/Lisbon", "Lisbonne" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Moscow", "Moscou" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Vienne" },
            { "timezone.excity.Europe/Warsaw", "Varsovie" },
            { "timezone.excity.Indian/Comoro", "Comores" },
            { "timezone.excity.Pacific/Efate", "\u00c9fat\u00e9" },
            { "timezone.excity.Pacific/Palau", "Palaos" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "timezone.excity.Africa/Tripoli", "Tripoli (Libye)" },
            { "timezone.excity.America/Cayman", "Ca\u00efmans" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Havana", "La Havane" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Manaus", "Manaos" },
            { "timezone.excity.Asia/Famagusta", "Famagouste" },
            { "timezone.excity.Asia/Jerusalem", "J\u00e9rusalem" },
            { "timezone.excity.Asia/Kamchatka", "Kamtchatka" },
            { "timezone.excity.Asia/Qyzylorda", "Kzyl Orda" },
            { "timezone.excity.Asia/Samarkand", "Samarcande" },
            { "timezone.excity.Asia/Singapore", "Singapour" },
            { "timezone.excity.Europe/Andorra", "Andorre" },
            { "timezone.excity.Europe/Vatican", "Le Vatican" },
            { "timezone.excity.Indian/Reunion", "La R\u00e9union" },
            { "timezone.excity.Pacific/Easter", "\u00cele de P\u00e2ques" },
            { "timezone.excity.Pacific/Kanton", "Canton" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Africa/El_Aaiun", "La\u00e2youne" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Detroit", "D\u00e9troit" },
            { "timezone.excity.America/Grenada", "Grenade" },
            { "timezone.excity.America/Jamaica", "Jama\u00efque" },
            { "timezone.excity.Atlantic/Azores", "A\u00e7ores" },
            { "timezone.excity.Atlantic/Canary", "\u00celes Canaries" },
            { "timezone.excity.Atlantic/Faeroe", "\u00celes F\u00e9ro\u00e9" },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Guernsey", "Guernesey" },
            { "timezone.excity.Africa/Mogadishu", "Mogadiscio" },
            { "timezone.excity.America/Barbados", "La Barbade" },
            { "timezone.excity.America/Dominica", "Dominique" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/St_Johns", "Saint-Jean de Terre-Neuve" },
            { "timezone.excity.America/St_Kitts", "Saint-Christophe" },
            { "timezone.excity.America/St_Lucia", "Sainte-Lucie" },
            { "timezone.excity.Antarctica/Syowa", "Showa" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasno\u00efarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Novossibirsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Oulan-Bator" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudes" },
            { "timezone.excity.Atlantic/Madeira", "Mad\u00e8re" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Ulyanovsk", "Oulianovsk" },
            { "timezone.excity.Indian/Mauritius", "Maurice" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint-Thomas" },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Europe/San_Marino", "Saint-Marin" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Pacific/Marquesas", "Marquises" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis-Abeba" },
            { "timezone.excity.America/St_Vincent", "Saint-Vincent" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterinbourg" },
            { "timezone.excity.Atlantic/St_Helena", "Sainte-H\u00e9l\u00e8ne" },
            { "timezone.excity.Australia/Adelaide", "Ad\u00e9la\u00efde" },
            { "timezone.excity.Europe/Isle_of_Man", "\u00cele de Man" },
            { "timezone.excity.America/Mexico_City", "Mexico" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cap-Vert" },
            { "timezone.excity.America/Indiana/Knox", "Knox [Indiana]" },
            { "timezone.excity.America/Indiana/Vevay", "Vevay [Indiana]" },
            { "timezone.excity.America/Port_of_Spain", "Port-d\u2019Espagne" },
            { "timezone.excity.America/Santo_Domingo", "Saint-Domingue" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia de Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "G\u00e9orgie du Sud" },
            { "timezone.excity.America/Indiana/Marengo", "Marengo [Indiana]" },
            { "timezone.excity.America/Indiana/Winamac", "Winamac [Indiana]" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushua\u00efa" },
            { "timezone.excity.America/Indiana/Tell_City", "Tell City [Indiana]" },
            { "timezone.excity.America/Indiana/Vincennes", "Vincennes [Indiana]" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont-d\u2019Urville" },
            { "timezone.excity.America/Indiana/Petersburg", "Petersburg [Indiana]" },
            { "timezone.excity.America/Kentucky/Monticello", "Monticello [Kentucky]" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah (Dakota du Nord)" },
            { "timezone.excity.America/North_Dakota/Center", "Center (Dakota du Nord)" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem (Dakota du Nord)" },
        };
        return data;
    }
}
