/*
 * Copyright (c) 2000, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package sun.security.tools.jarsigner;

/**
 * <p> This class represents the <code>ResourceBundle</code>
 * for JarSigner.
 *
 */
public class Resources_de extends java.util.ListResourceBundle {

    private static final Object[][] contents = {

        // shared (from jarsigner)
        {"SPACE", " "},
        {"6SPACE", "      "},
        {"COMMA", ", "},

        {"provclass.not.a.provider", "%s kein Provider"},
        {"provider.name.not.found", "Provider namens \"%s\" nicht gefunden"},
        {"provider.class.not.found", "Provider \"%s\" nicht gefunden"},
        {"jarsigner.error.", "jarsigner-Fehler: "},
        {"Illegal.option.", "Unzul\u00E4ssige Option: "},
        {".keystore.must.be.NONE.if.storetype.is.{0}",
                "-keystore muss NONE sein, wenn -storetype {0} ist"},
        {".keypass.can.not.be.specified.if.storetype.is.{0}",
                "-keypass kann nicht angegeben werden, wenn -storetype \"{0}\" ist"},
        {"If.protected.is.specified.then.storepass.and.keypass.must.not.be.specified",
                "Wenn -protected angegeben ist, d\u00FCrfen -storepass und -keypass nicht angegeben werden"},
        {"If.keystore.is.not.password.protected.then.storepass.and.keypass.must.not.be.specified",
                 "Wenn der Keystore nicht kennwortgesch\u00FCtzt ist, d\u00FCrfen -storepass und -keypass nicht angegeben werden"},
        {"Usage.jarsigner.options.jar.file.alias",
                "Verwendung: jarsigner [options] jar-file alias"},
        {".jarsigner.verify.options.jar.file.alias.",
                "       jarsigner -verify [options] jar-file [alias...]"},
        {".jarsigner.version",
                "       jarsigner -version"},
        {".keystore.url.keystore.location",
                "[-keystore <URL>]           Keystore-Speicherort"},
        {".storepass.password.password.for.keystore.integrity",
            "[-storepass <Kennwort>]     Kennwort f\u00FCr Keystore-Integrit\u00E4t"},
        {".storetype.type.keystore.type",
                "[-storetype <Typ>]         Keystore-Typ"},
        {".keypass.password.password.for.private.key.if.different.",
                "[-keypass <Kennwort>]       Kennwort f\u00FCr Private Key (falls unterschiedlich)"},
        {".certchain.file.name.of.alternative.certchain.file",
                "[-certchain <Datei>]         Name der alternativen certchain-Datei"},
        {".sigfile.file.name.of.SF.DSA.file",
                "[-sigfile <Datei>]           Name der SF/DSA-Datei"},
        {".signedjar.file.name.of.signed.JAR.file",
                "[-signedjar <Datei>]         Name der signierten JAR-Datei"},
        {".digestalg.algorithm.name.of.digest.algorithm",
                "[-digestalg <Algorithmus>]    Name des Digestalgorithmus"},
        {".sigalg.algorithm.name.of.signature.algorithm",
                "[-sigalg <Algorithmus>]       Name des Signaturalgorithmus"},
        {".verify.verify.a.signed.JAR.file",
                "[-verify]                   Verifiziert eine signierte JAR-Datei"},
        {".version.print.the.program.version",
                "[-version]                  Gibt die Programmversion aus"},
        {".verbose.suboptions.verbose.output.when.signing.verifying.",
                "[-verbose[:suboptions]]     Verbose-Ausgabe beim Signieren/Verifizieren."},
        {".suboptions.can.be.all.grouped.or.summary",
                "                            Als Unteroptionen sind \"all\", \"grouped\" und \"summary\" m\u00F6glich"},
        {".certs.display.certificates.when.verbose.and.verifying",
                "[-certs]                    Zeigt Zertifikate bei Verbose und Verifizierung an"},
        {".certs.revocation.check",
                "[-revCheck]                 Aktiviert die Zertifikatswiderrufpr\u00FCfung"},
        {".tsa.url.location.of.the.Timestamping.Authority",
                "[-tsa <URL>]                Ort der Zeitstempelautorit\u00E4t"},
        {".tsacert.alias.public.key.certificate.for.Timestamping.Authority",
                "[-tsacert <Alias>]          Public-Key-Zertifikat f\u00FCr Zeitstempelautorit\u00E4t"},
        {".tsapolicyid.tsapolicyid.for.Timestamping.Authority",
                "[-tsapolicyid <OID>]        TSAPolicyID f\u00FCr Zeitstempelautorit\u00E4t"},
        {".tsadigestalg.algorithm.of.digest.data.in.timestamping.request",
                "[-tsadigestalg <Algorithmus>] Algorithmus der Digestdaten in Zeitstempelanforderung"},
        {".internalsf.include.the.SF.file.inside.the.signature.block",
                "[-internalsf]               SF-Datei in Signaturblock aufnehmen"},
        {".sectionsonly.don.t.compute.hash.of.entire.manifest",
                "[-sectionsonly]             Berechnet nicht den Hash des gesamten Manifests"},
        {".protected.keystore.has.protected.authentication.path",
                "[-protected]                Keystore hat gesch\u00FCtzten Authentifizierungspfad"},
        {".providerName.name.provider.name",
                "[-providerName <Name>]      Providername"},
        {".add.provider.option",
                "[-addprovider <Name>        F\u00FCgt einen Sicherheitsprovider nach Name hinzu (z.B. SunPKCS11)"},
        {".providerArg.option.1",
                "  [-providerArg <Argument>]] ... Konfiguriert Argument f\u00FCr -addprovider"},
        {".providerClass.option",
                "[-providerClass <Klasse>     F\u00FCgt einen Sicherheitsprovider nach vollqualifiziertem Klassennamen hinzu"},
        {".providerArg.option.2",
                "  [-providerArg <Argument>]] ... Konfiguriert Argument f\u00FCr -providerClass"},
        {".providerPath.option",
                "[-providerPath <list>]      Provider-Classpath"},
        {".strict.treat.warnings.as.errors",
                "[-strict]                   Behandelt Warnungen als Fehler"},
        {".conf.url.specify.a.pre.configured.options.file",
                "[-conf <URL>]               Vorkonfigurierte Optionsdatei angeben"},
        {".print.this.help.message",
                "[-? -h --help]              Gibt diese Hilfemeldung aus"},
        {"Option.lacks.argument", "Argument fehlt in Option"},
        {"Please.type.jarsigner.help.for.usage", "Geben Sie jarsigner --help ein, um Verwendungsinformationen anzuzeigen"},
        {"Please.specify.jarfile.name", "Geben Sie den Namen der JAR-Datei an"},
        {"Please.specify.alias.name", "Geben Sie einen Aliasnamen an"},
        {"Only.one.alias.can.be.specified", "Nur ein Alias kann angegeben werden"},
        {"This.jar.contains.signed.entries.which.is.not.signed.by.the.specified.alias.es.",
                 "Diese JAR-Datei enth\u00E4lt signierte Eintr\u00E4ge, die nicht von den angegebenen Aliasnamen signiert wurden."},
        {"This.jar.contains.signed.entries.that.s.not.signed.by.alias.in.this.keystore.",
                  "Diese JAR-Datei enth\u00E4lt signierte Eintr\u00E4ge, die nicht vom Alias in diesem Keystore signiert wurden."},
        {"s", "s"},
        {"m", "m"},
        {"k", "k"},
        {"X", "X"},
        {"q", "?"},
        {".and.d.more.", "(und %d mehr)"},
        {".s.signature.was.verified.",
                "  s = Signatur wurde verifiziert "},
        {".m.entry.is.listed.in.manifest",
                "  m = Eintrag ist in Manifest aufgef\u00FChrt"},
        {".k.at.least.one.certificate.was.found.in.keystore",
                "  k = Mindestens ein Zertifikat im Keystore gefunden"},
        {".X.not.signed.by.specified.alias.es.",
                "  X = Nicht von den angegebenen Aliasnamen signiert"},
        {".q.unsigned.entry",
                "  ? = Nicht signierter Eintrag"},
        {"no.manifest.", "Kein Manifest."},
        {".Signature.related.entries.","(Signaturbezogene Eintr\u00E4ge)"},
        {".Unsigned.entries.", "(Nicht signierte Eintr\u00E4ge)"},
        {".Directory.entries.", "(Verzeichniseintr\u00E4ge)"},
        {"jar.is.unsigned",
                "JAR-Datei ist nicht signiert."},
        {"jar.treated.unsigned",
                "Warnung: Signatur kann entweder nicht geparst oder nicht verifiziert werden. Die JAR-Datei wird als nicht signiert behandelt. Weitere Informationen erhalten Sie, indem Sie \"jarsigner\" mit aktiviertem Debugging erneut ausf\u00FChren (-J-Djava.security.debug=jar)."},
        {"jar.treated.unsigned.see.weak",
                "Die JAR-Datei wird als nicht signiert behandelt, da sie mit einem schwachen Algorithmus signiert wurde, der jetzt deaktiviert ist.\n\nF\u00FChren Sie \"jarsigner\" mit der Option \"-verbose\" erneut aus, um weitere Einzelheiten zu erhalten."},
        {"jar.treated.unsigned.see.weak.verbose",
                "Warnung: Die JAR-Datei wird als nicht signiert behandelt, da sie mit einem schwachen Algorithmus signiert wurde, der mittlerweile von der folgenden Sicherheitseigenschaft deaktiviert wurde:"},
        {"jar.signed.", "JAR-Datei signiert."},
        {"jar.signed.with.signer.errors.", "JAR-Datei signiert, mit Signaturgeberfehlern."},
        {"jar.verified.", "JAR-Datei verifiziert."},
        {"jar.verified.with.signer.errors.", "JAR-Datei verifiziert, mit Signaturgeberfehlern."},

        {"history.with.ts", "- Von \"%1$s\" signiert\n    Digestalgorithmus: %2$s\n    Signaturalgorithmus: %3$s, %4$s\n  Zeitstempel von \"%6$s\" am %5$tc\n    Digestalgorithmus f\u00FCr Zeitstempel: %7$s\n    Signaturalgorithmus f\u00FCr Zeitstempel: %8$s, %9$s"},
        {"history.without.ts", "- Von \"%1$s\" signiert\n    Digestalgorithmus: %2$s\n    Signaturalgorithmus: %3$s, %4$s"},
        {"history.unparsable", "- Signaturbezogene Datei %s kann nicht geparst werden"},
        {"history.nosf", "- Signaturbezogene Datei META-INF/%s.SF fehlt"},
        {"history.nobk", "- Blockdatei f\u00FCr signaturbezogene Datei META-INF/%s.SF fehlt"},

        {"with.weak", "%s (schwach)"},
        {"with.algparams.weak", "%1$s mit %2$s (schwach)"},
        {"with.disabled", "%s (deaktiviert)"},
        {"with.algparams.disabled", "%1$s mit %2$s (deaktiviert)"},
        {"key.bit", "%d-Bit-Schl\u00FCssel"},
        {"key.bit.weak", "%d-Bit-Schl\u00FCssel (schwach)"},
        {"key.bit.eccurve.weak", "%1$d-Bit-%2$s-Schl\u00FCssel (schwach)"},
        {"key.bit.disabled", "%d-Bit-Schl\u00FCssel (deaktiviert)"},
        {"key.bit.eccurve.disabled", "%1$d-Bit-%2$s-Schl\u00FCssel (deaktiviert)"},
        {"unknown.size", "unbekannte Gr\u00F6\u00DFe"},
        {"external.file.attributes.detected", "POSIX-Dateiberechtigung und/oder Symlink-Attribute erkannt. Diese Attribute werden bei der Signatur ignoriert und sind nicht durch die Signatur gesch\u00FCtzt."},

        {"jarsigner.", "jarsigner: "},
        {"signature.filename.must.consist.of.the.following.characters.A.Z.0.9.or.",
                "Signaturdateiname muss aus den folgenden Zeichen bestehen: A-Z, 0-9, _ oder -"},
        {"unable.to.open.jar.file.", "JAR-Datei kann nicht ge\u00F6ffnet werden: "},
        {"unable.to.create.", "Erstellen nicht m\u00F6glich: "},
        {".adding.", "   Wird hinzugef\u00FCgt: "},
        {".updating.", " Wird aktualisiert: "},
        {".signing.", "  Wird signiert: "},
        {"attempt.to.rename.signedJarFile.to.jarFile.failed",
                "Der Versuch, {0} in {1} umzubenennen, war nicht erfolgreich"},
        {"attempt.to.rename.jarFile.to.origJar.failed",
                "Der Versuch, {0} in {1} umzubenennen, war nicht erfolgreich"},
        {"unable.to.sign.jar.", "JAR-Datei kann nicht signiert werden: "},
        {"Enter.Passphrase.for.keystore.", "Passphrase f\u00FCr Keystore eingeben: "},
        {"keystore.load.", "Keystore-Ladevorgang: "},
        {"certificate.exception.", "Zertifikatsausnahme: "},
        {"unable.to.instantiate.keystore.class.",
                "Keystore-Klasse kann nicht instanziiert werden: "},
        {"Certificate.chain.not.found.for.alias.alias.must.reference.a.valid.KeyStore.key.entry.containing.a.private.key.and",
                "Zertifikatskette nicht gefunden f\u00FCr: {0}. {1} muss einen g\u00FCltigen Keystore-Schl\u00FCssel referenzieren, der einen Private Key und eine zugeh\u00F6rige Public-Key-Zertifikatskette enth\u00E4lt."},
        {"File.specified.by.certchain.does.not.exist",
                "Von -certchain angegebene Datei ist nicht vorhanden"},
        {"Cannot.restore.certchain.from.file.specified",
                "Zertifikatskette kann nicht aus angegebener Datei wiederhergestellt werden"},
        {"Certificate.chain.not.found.in.the.file.specified.",
                "Zertifikatskette nicht in der angegebenen Datei gefunden."},
        {"found.non.X.509.certificate.in.signer.s.chain",
                "Nicht-X.509-Zertifikat in Kette des Signaturgebers gefunden"},
        {"Enter.key.password.for.alias.", "Schl\u00FCsselkennwort f\u00FCr {0} eingeben: "},
        {"unable.to.recover.key.from.keystore",
                "Schl\u00FCssel kann nicht aus Keystore wiederhergestellt werden"},
        {"key.associated.with.alias.not.a.private.key",
                "Mit {0} verkn\u00FCpfter Schl\u00FCssel ist kein Private Key"},
        {"you.must.enter.key.password", "Sie m\u00FCssen ein Schl\u00FCsselkennwort eingeben"},
        {"unable.to.read.password.", "Kennwort kann nicht gelesen werden: "},
        {"certificate.is.valid.from", "Zertifikat ist von {0} bis {1} g\u00FCltig"},
        {"certificate.expired.on", "Zertifikat ist am {0} abgelaufen"},
        {"certificate.is.not.valid.until",
                "Zertifikat ist erst ab {0} g\u00FCltig"},
        {"certificate.will.expire.on", "Zertifikat l\u00E4uft am {0} ab"},
        {".Invalid.certificate.chain.", "[Ung\u00FCltige Zertifikatskette: "},
        {".Invalid.TSA.certificate.chain.", "[Ung\u00FCltige TSA-Zertifikatskette: "},
        {"requesting.a.signature.timestamp",
                "Signaturzeitstempel wird angefordert"},
        {"TSA.location.", "TSA-Ort: "},
        {"TSA.certificate.", "TSA-Zertifikat: "},
        {"no.response.from.the.Timestamping.Authority.",
                "Keine Antwort von der Zeitstempelautorit\u00E4t. Bei Verbindungen hinter einer Firewall muss m\u00F6glicherweise ein HTTP- oder HTTPS-Proxy angegeben werden. Geben Sie die folgenden Optionen f\u00FCr \"jarsigner\" an:"},
        {"or", "oder"},
        {"Certificate.not.found.for.alias.alias.must.reference.a.valid.KeyStore.entry.containing.an.X.509.public.key.certificate.for.the",
                "Zertifikat nicht gefunden f\u00FCr: {0}. {1} muss einen g\u00FCltigen Keystore-Eintrag referenzieren, der ein X.509-Public-Key-Zertifikat f\u00FCr die Zeitstempelautorit\u00E4t enth\u00E4lt."},
        {"entry.was.signed.on", "Eintrag wurde signiert am {0}"},
        {"Warning.", "Warnung: "},
        {"Error.", "Fehler: "},
        {"...Signer", ">>> Signaturgeber"},
        {"...TSA", ">>> TSA"},
        {"trusted.certificate", "vertrauensw\u00FCrdiges Zertifikat"},
        {"This.jar.contains.unsigned.entries.which.have.not.been.integrity.checked.",
                "Diese JAR-Datei enth\u00E4lt nicht signierte Eintr\u00E4ge, deren Integrit\u00E4t nicht gepr\u00FCft wurde. "},
        {"This.jar.contains.entries.whose.signer.certificate.has.expired.",
                "Diese JAR-Datei enth\u00E4lt Eintr\u00E4ge, deren Signaturgeberzertifikat abgelaufen ist."},
        {"This.jar.contains.entries.whose.signer.certificate.will.expire.within.six.months.",
                "Diese JAR-Datei enth\u00E4lt Eintr\u00E4ge, deren Signaturgeberzertifikat innerhalb der n\u00E4chsten sechs Monate abl\u00E4uft. "},
        {"This.jar.contains.entries.whose.signer.certificate.is.not.yet.valid.",
                "Diese JAR-Datei enth\u00E4lt Eintr\u00E4ge, deren Signaturgeberzertifikat noch nicht g\u00FCltig ist. "},
        {"This.jar.contains.entries.whose.signer.certificate.is.self.signed.",
                "Diese JAR-Datei enth\u00E4lt Eintr\u00E4ge, deren Signaturgeberzertifikat selbstsigniert ist."},
        {"Re.run.with.the.verbose.and.certs.options.for.more.details.",
                "F\u00FChren Sie den Befehl erneut mit den Optionen -verbose und -certs aus, um weitere Details zu erhalten."},
        {"The.signer.certificate.has.expired.",
                "Das Signaturgeberzertifikat ist abgelaufen."},
        {"The.timestamp.expired.1.but.usable.2",
                "Der Zeitstempel ist am %1$tY-%1$tm-%1$td abgelaufen. Die JAR-Datei bleibt aber g\u00FCltig, bis das Signaturgeberzertifikat am %2$tY-%2$tm-%2$td abl\u00E4uft."},
        {"The.timestamp.has.expired.",
                "Der Zeitstempel ist abgelaufen."},
        {"The.signer.certificate.will.expire.within.six.months.",
                "Das Signaturgeberzertifikat l\u00E4uft innerhalb der n\u00E4chsten sechs Monate ab."},
        {"The.timestamp.will.expire.within.one.year.on.1",
                "Der Zeitstempel l\u00E4uft innerhalb des n\u00E4chsten Jahres am %1$tY-%1$tm-%1$td ab."},
        {"The.timestamp.will.expire.within.one.year.on.1.but.2",
                "Der Zeitstempel l\u00E4uft innerhalb des n\u00E4chsten Jahres am %1$tY-%1$tm-%1$td ab. Die JAR-Datei bleibt aber g\u00FCltig, bis das Signaturgeberzertifikat am %2$tY-%2$tm-%2$td abl\u00E4uft."},
        {"The.signer.certificate.is.not.yet.valid.",
                "Das Signaturgeberzertifikat ist noch nicht g\u00FCltig."},
        {"The.signer.certificate.s.KeyUsage.extension.doesn.t.allow.code.signing.",
                 "Die KeyUsage-Erweiterung des Signaturgeberzertifikats l\u00E4sst keine Codesignatur zu."},
        {"The.signer.certificate.s.ExtendedKeyUsage.extension.doesn.t.allow.code.signing.",
                 "Die ExtendedKeyUsage-Erweiterung des Signaturgeberzertifikats l\u00E4sst keine Codesignatur zu."},
        {"The.signer.certificate.s.NetscapeCertType.extension.doesn.t.allow.code.signing.",
                 "Die NetscapeCertType-Erweiterung des Signaturgeberzertifikats l\u00E4sst keine Codesignatur zu."},
        {"This.jar.contains.entries.whose.signer.certificate.s.KeyUsage.extension.doesn.t.allow.code.signing.",
                 "Diese JAR-Datei enth\u00E4lt Eintr\u00E4ge, bei denen die KeyUsage-Erweiterung des Signaturgeberzertifikats keine Codesignatur zul\u00E4sst."},
        {"This.jar.contains.entries.whose.signer.certificate.s.ExtendedKeyUsage.extension.doesn.t.allow.code.signing.",
                 "Diese JAR-Datei enth\u00E4lt Eintr\u00E4ge, bei denen die ExtendedKeyUsage-Erweiterung des Signaturgeberzertifikats keine Codesignatur zul\u00E4sst."},
        {"This.jar.contains.entries.whose.signer.certificate.s.NetscapeCertType.extension.doesn.t.allow.code.signing.",
                 "Diese JAR-Datei enth\u00E4lt Eintr\u00E4ge, bei denen die NetscapeCertType-Erweiterung des Signaturgeberzertifikats keine Codesignatur zul\u00E4sst."},
        {".{0}.extension.does.not.support.code.signing.",
                 "[{0}-Erweiterung unterst\u00FCtzt keine Codesignatur]"},
        {"The.signer.s.certificate.chain.is.invalid.reason.1",
                "Die Zertifikatskette des Signaturgebers ist ung\u00FCltig. Grund: %s"},
        {"The.tsa.certificate.chain.is.invalid.reason.1",
                "Die TSA-Zertifikatskette ist ung\u00FCltig. Grund: %s"},
        {"The.signer.s.certificate.is.self.signed.",
                "Das Zertifikat des Signaturgebers ist selbstsigniert."},
        {"The.1.algorithm.specified.for.the.2.option.is.considered.a.security.risk..This.algorithm.will.be.disabled.in.a.future.update.",
                "Der f\u00FCr die Option %2$s angegebene %1$s-Algorithmus gilt als Sicherheitsrisiko. Dieser Algorithmus wird in einem zuk\u00FCnftigen Update deaktiviert."},
        {"The.1.algorithm.specified.for.the.2.option.is.considered.a.security.risk.and.is.disabled.",
                "Der f\u00FCr die Option %2$s angegebene %1$s-Algorithmus gilt als Sicherheitsrisiko und ist deaktiviert."},
        {"The.timestamp.digest.algorithm.1.is.considered.a.security.risk..This.algorithm.will.be.disabled.in.a.future.update.",
                "Der %1$s-Digestalgorithmus des Zeitstempels gilt als Sicherheitsrisiko. Dieser Algorithmus wird in einem zuk\u00FCnftigen Update deaktiviert."},
        {"The.digest.algorithm.1.is.considered.a.security.risk..This.algorithm.will.be.disabled.in.a.future.update.",
                "Der %1$s-Digestalgorithmus gilt als Sicherheitsrisiko. Dieser Algorithmus wird in einem zuk\u00FCnftigen Update deaktiviert."},
        {"The.signature.algorithm.1.is.considered.a.security.risk..This.algorithm.will.be.disabled.in.a.future.update.",
                "Der %1$s-Signaturalgorithmus gilt als Sicherheitsrisiko. Dieser Algorithmus wird in einem zuk\u00FCnftigen Update deaktiviert."},
        {"The.1.signing.key.has.a.keysize.of.2.which.is.considered.a.security.risk..This.key.size.will.be.disabled.in.a.future.update.",
                "Der %1$s-Signaturschl\u00FCssel hat eine Schl\u00FCsselgr\u00F6\u00DFe von %2$d. Das gilt als Sicherheitsrisiko. Diese Schl\u00FCsselgr\u00F6\u00DFe wird in einem zuk\u00FCnftigen Update deaktiviert."},
        {"The.1.signing.key.has.a.keysize.of.2.which.is.considered.a.security.risk.and.is.disabled.",
                "Der %1$s-Signaturschl\u00FCssel hat eine Schl\u00FCsselgr\u00F6\u00DFe von %2$d. Das gilt als Sicherheitsrisiko und ist deaktiviert."},
        {"This.jar.contains.entries.whose.certificate.chain.is.invalid.reason.1",
                 "Diese JAR-Datei enth\u00E4lt Eintr\u00E4ge, deren Zertifikatskette ung\u00FCltig ist. Grund: %s"},
        {"This.jar.contains.entries.whose.tsa.certificate.chain.is.invalid.reason.1",
                "Diese JAR-Datei enth\u00E4lt Eintr\u00E4ge, deren TSA-Zertifikatskette ung\u00FCltig ist. Grund: %s"},
        {"no.timestamp.signing",
                "Weder -tsa noch -tsacert wurde angegeben, und diese JAR-Datei hat keinen Zeitstempel. Ohne Zeitstempel k\u00F6nnen Benutzer diese JAR-Datei nach dem Ablaufdatum des Signaturgeberzertifikats (%1$tY-%1$tm-%1$td) m\u00F6glicherweise nicht mehr validieren."},
        {"invalid.timestamp.signing",
                "Der Zeitstempel ist ung\u00FCltig. Ohne einen g\u00FCltigen Zeitstempel k\u00F6nnen Benutzer diese JAR-Datei nach dem Ablaufdatum des Signaturgeberzertifikats (%1$tY-%1$tm-%1$td) m\u00F6glicherweise nicht mehr validieren."},
        {"no.timestamp.verifying",
                "Diese JAR-Datei enth\u00E4lt Signaturen ohne Zeitstempel. Ohne einen Zeitstempel k\u00F6nnen Benutzer diese JAR-Datei nach dem Ablauf eines Signaturgeberzertifikats (fr\u00FChestens %1$tY-%1$tm-%1$td) m\u00F6glicherweise nicht mehr validieren."},
        {"bad.timestamp.verifying",
                "Diese JAR-Datei enth\u00E4lt Signaturen mit einem ung\u00FCltigen Zeitstempel. Ohne einen g\u00FCltigen Zeitstempel k\u00F6nnen Benutzer diese JAR-Datei nach dem Ablauf eines Signaturgeberzertifikats (fr\u00FChestens %1$tY-%1$tm-%1$td) m\u00F6glicherweise nicht mehr validieren.\nF\u00FChren Sie \"jarsigner\" mit -J-Djava.security.debug=jar erneut aus, um weitere Informationen zu erhalten."},
        {"The.signer.certificate.will.expire.on.1.",
                "Das Signaturgeberzertifikat l\u00E4uft am %1$tY-%1$tm-%1$td ab."},
        {"The.timestamp.will.expire.on.1.",
                "Der Zeitstempel l\u00E4uft am %1$tY-%1$tm-%1$td ab."},
        {"signer.cert.expired.1.but.timestamp.good.2.",
                "Das Signaturgeberzertifikat ist am %1$tY-%1$tm-%1$td abgelaufen. Die JAR-Datei bleibt aber g\u00FCltig, bis der Zeitstempel am %2$tY-%2$tm-%2$td abl\u00E4uft."},
        {"Unknown.password.type.", "Unbekannter Kennworttyp: "},
        {"Cannot.find.environment.variable.",
                "Umgebungsvariable kann nicht gefunden werden: "},
        {"Cannot.find.file.", "Datei kann nicht gefunden werden: "},
        {"event.ocsp.check", "Verbindung zu OCSP-Server bei %s wird hergestellt..."},
        {"event.crl.check", "CRL wird von %s heruntergeladen..."},
    };

    /**
     * Returns the contents of this <code>ResourceBundle</code>.
     *
     * <p>
     *
     * @return the contents of this <code>ResourceBundle</code>.
     */
    @Override
    public Object[][] getContents() {
        return contents;
    }
}
