/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_it extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabo";
        final String metaValue_hy = "armeno";
        final String metaValue_ban = "balinese";
        final String metaValue_bn = "bengalese";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "copto";
        final String metaValue_ka = "georgiano";
        final String metaValue_got = "gotico";
        final String metaValue_el = "greco";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraico";
        final String metaValue_ja = "giapponese";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "coreano";
        final String metaValue_lo = "lao";
        final String metaValue_la = "latino";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongolo";
        final String metaValue_my = "birmano";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_phn = "fenicio";
        final String metaValue_saz = "saurashtra";
        final String metaValue_si = "singalese";
        final String metaValue_su = "sundanese";
        final String metaValue_syr = "siriaco";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "thailandese";
        final String metaValue_bo = "tibetano";
        final String metaValue_vai = "vai";
        final String metaValue_peo = "persiano antico";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "Mondo" },
            { "002", "Africa" },
            { "003", "Nord America" },
            { "005", "America del Sud" },
            { "009", "Oceania" },
            { "011", "Africa occidentale" },
            { "013", "America Centrale" },
            { "014", "Africa orientale" },
            { "015", "Nordafrica" },
            { "017", "Africa centrale" },
            { "018", "Africa del Sud" },
            { "019", "Americhe" },
            { "021", "America del Nord" },
            { "029", "Caraibi" },
            { "030", "Asia orientale" },
            { "034", "Asia del Sud" },
            { "035", "Sud-est asiatico" },
            { "039", "Europa meridionale" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Regione micronesiana" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia centrale" },
            { "145", "Asia occidentale" },
            { "150", "Europa" },
            { "151", "Europa orientale" },
            { "154", "Europa settentrionale" },
            { "155", "Europa occidentale" },
            { "202", "Africa subsahariana" },
            { "419", "America Latina" },
            { "AC", "Isola Ascensione" },
            { "AD", "Andorra" },
            { "AE", "Emirati Arabi Uniti" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antartide" },
            { "AR", "Argentina" },
            { "AS", "Samoa americane" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Isole \u00c5land" },
            { "AZ", "Azerbaigian" },
            { "BA", "Bosnia ed Erzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgio" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caraibi olandesi" },
            { "BR", "Brasile" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Isola Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielorussia" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Isole Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Repubblica Centrafricana" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Svizzera" },
            { "CI", "Costa d\u2019Avorio" },
            { "CK", "Isole Cook" },
            { "CL", "Cile" },
            { "CM", "Camerun" },
            { "CN", "Cina" },
            { "CO", "Colombia" },
            { "CP", "Isola di Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Capo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Isola Christmas" },
            { "CY", "Cipro" },
            { "CZ", "Cechia" },
            { "DE", "Germania" },
            { "DG", "Diego Garcia" },
            { "DJ", "Gibuti" },
            { "DK", "Danimarca" },
            { "DM", "Dominica" },
            { "DO", "Repubblica Dominicana" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egitto" },
            { "EH", "Sahara occidentale" },
            { "ER", "Eritrea" },
            { "ES", "Spagna" },
            { "ET", "Etiopia" },
            { "EU", "Unione europea" },
            { "EZ", "Eurozona" },
            { "FI", "Finlandia" },
            { "FJ", "Figi" },
            { "FK", "Isole Falkland" },
            { "FM", "Micronesia" },
            { "FO", "Isole F\u00e6r \u00d8er" },
            { "FR", "Francia" },
            { "GA", "Gabon" },
            { "GB", "Regno Unito" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guyana Francese" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibilterra" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupa" },
            { "GQ", "Guinea Equatoriale" },
            { "GR", "Grecia" },
            { "GS", "Georgia del Sud e Sandwich Australi" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "RAS di Hong Kong" },
            { "HM", "Isole Heard e McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croazia" },
            { "HT", "Haiti" },
            { "HU", "Ungheria" },
            { "IC", "Isole Canarie" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israele" },
            { "IM", "Isola di Man" },
            { "IN", "India" },
            { "IO", "Territorio britannico dell\u2019Oceano Indiano" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Giamaica" },
            { "JO", "Giordania" },
            { "JP", "Giappone" },
            { "KE", "Kenya" },
            { "KG", "Kirghizistan" },
            { "KH", "Cambogia" },
            { "KI", "Kiribati" },
            { "KM", "Comore" },
            { "KN", "Saint Kitts e Nevis" },
            { "KP", "Corea del Nord" },
            { "KR", "Corea del Sud" },
            { "KW", "Kuwait" },
            { "KY", "Isole Cayman" },
            { "KZ", "Kazakistan" },
            { "LA", "Laos" },
            { "LB", "Libano" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Lussemburgo" },
            { "LV", "Lettonia" },
            { "LY", "Libia" },
            { "MA", "Marocco" },
            { "MC", "Monaco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Isole Marshall" },
            { "MK", "Macedonia del Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "RAS di Macao" },
            { "MP", "Isole Marianne settentrionali" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldive" },
            { "MW", "Malawi" },
            { "MX", "Messico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambico" },
            { "NA", "Namibia" },
            { "NC", "Nuova Caledonia" },
            { "NE", "Niger" },
            { "NF", "Isola Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Paesi Bassi" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nuova Zelanda" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Per\u00f9" },
            { "PF", "Polinesia francese" },
            { "PG", "Papua Nuova Guinea" },
            { "PH", "Filippine" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PM", "Saint-Pierre e Miquelon" },
            { "PN", "Isole Pitcairn" },
            { "PR", "Portorico" },
            { "PS", "Territori palestinesi" },
            { "PT", "Portogallo" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceania lontana" },
            { "RE", "Riunione" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudita" },
            { "SB", "Isole Salomone" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Svezia" },
            { "SG", "Singapore" },
            { "SH", "Sant\u2019Elena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Slovacchia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Sud Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "eSwatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Isole Turks e Caicos" },
            { "TD", "Ciad" },
            { "TF", "Terre australi francesi" },
            { "TG", "Togo" },
            { "TH", "Thailandia" },
            { "TJ", "Tagikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor Est" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turchia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ucraina" },
            { "UG", "Uganda" },
            { "UM", "Isole Minori Esterne degli Stati Uniti" },
            { "UN", "Nazioni Unite" },
            { "US", "Stati Uniti" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Citt\u00e0 del Vaticano" },
            { "VC", "Saint Vincent e Grenadine" },
            { "VE", "Venezuela" },
            { "VG", "Isole Vergini Britanniche" },
            { "VI", "Isole Vergini Americane" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-accenti" },
            { "XB", "Pseudo-bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sudafrica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Regione sconosciuta" },
            { "aa", "afar" },
            { "ab", "abcaso" },
            { "ae", "avestan" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amarico" },
            { "an", "aragonese" },
            { "ar", metaValue_ar },
            { "as", "assamese" },
            { "av", "avaro" },
            { "ay", "aymara" },
            { "az", "azerbaigiano" },
            { "ba", "baschiro" },
            { "be", "bielorusso" },
            { "bg", "bulgaro" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretone" },
            { "bs", "bosniaco" },
            { "ca", "catalano" },
            { "ce", "ceceno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "cr", "cree" },
            { "cs", "ceco" },
            { "cu", "slavo ecclesiastico" },
            { "cv", "ciuvascio" },
            { "cy", "gallese" },
            { "da", "danese" },
            { "de", "tedesco" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "inglese" },
            { "eo", "esperanto" },
            { "es", "spagnolo" },
            { "et", "estone" },
            { "eu", "basco" },
            { "fa", "persiano" },
            { "ff", "fulah" },
            { "fi", "finlandese" },
            { "fj", "figiano" },
            { "fo", "faroese" },
            { "fr", "francese" },
            { "fy", "frisone occidentale" },
            { "ga", "irlandese" },
            { "gd", "gaelico scozzese" },
            { "gl", "galiziano" },
            { "gn", "guaran\u00ed" },
            { "gu", metaValue_gu },
            { "gv", "mannese" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croato" },
            { "ht", "creolo haitiano" },
            { "hu", "ungherese" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesiano" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandese" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "giavanese" },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazako" },
            { "kl", "groenlandese" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "curdo" },
            { "kv", "komi" },
            { "kw", "cornico" },
            { "ky", "kirghiso" },
            { "la", metaValue_la },
            { "lb", "lussemburghese" },
            { "lg", "ganda" },
            { "li", "limburghese" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituano" },
            { "lu", "luba-katanga" },
            { "lv", "lettone" },
            { "mg", "malgascio" },
            { "mh", "marshallese" },
            { "mi", "maori" },
            { "mk", "macedone" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malese" },
            { "mt", "maltese" },
            { "my", metaValue_my },
            { "na", "nauru" },
            { "nb", "norvegese bokm\u00e5l" },
            { "nd", "ndebele del nord" },
            { "ne", "nepalese" },
            { "ng", "ndonga" },
            { "nl", "olandese" },
            { "nn", "norvegese nynorsk" },
            { "no", "norvegese" },
            { "nr", "ndebele del sud" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitano" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", "odia" },
            { "os", "ossetico" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "polacco" },
            { "ps", "pashto" },
            { "pt", "portoghese" },
            { "qu", "quechua" },
            { "rm", "romancio" },
            { "rn", "rundi" },
            { "ro", "rumeno" },
            { "ru", "russo" },
            { "rw", "kinyarwanda" },
            { "sa", "sanscrito" },
            { "sc", "sardo" },
            { "sd", "sindhi" },
            { "se", "sami del nord" },
            { "sg", "sango" },
            { "sh", "serbo-croato" },
            { "si", metaValue_si },
            { "sk", "slovacco" },
            { "sl", "sloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somalo" },
            { "sq", "albanese" },
            { "sr", "serbo" },
            { "ss", "swati" },
            { "st", "sotho del sud" },
            { "su", metaValue_su },
            { "sv", "svedese" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tagico" },
            { "th", metaValue_th },
            { "ti", "tigrino" },
            { "tk", "turcomanno" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tongano" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "tataro" },
            { "tw", "ci" },
            { "ty", "taitiano" },
            { "ug", "uiguro" },
            { "uk", "ucraino" },
            { "ur", "urdu" },
            { "uz", "uzbeco" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volap\u00fck" },
            { "wa", "vallone" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "cinese" },
            { "zu", "zulu" },
            { "ace", "accinese" },
            { "ach", "acioli" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "aeb", "arabo tunisino" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "accado" },
            { "akz", "alabama" },
            { "ale", "aleuto" },
            { "aln", "albanese ghego" },
            { "alt", "altai meridionale" },
            { "ang", "inglese antico" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramaico" },
            { "arn", "mapudungun" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "arabo algerino" },
            { "ars", "arabo najd" },
            { "arw", "aruaco" },
            { "ary", "arabo marocchino" },
            { "arz", "arabo egiziano" },
            { "asa", "asu" },
            { "ase", "lingua dei segni americana" },
            { "ast", "asturiano" },
            { "atj", "atikamekw" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "beluci" },
            { "ban", metaValue_ban },
            { "bar", "bavarese" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "bbc", "batak toba" },
            { "bbj", "ghomala" },
            { "bej", "begia" },
            { "bem", "wemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badaga" },
            { "bgn", "beluci occidentale" },
            { "bho", "bhojpuri" },
            { "bik", "bicol" },
            { "bin", "bini" },
            { "bjn", "banjar" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bpy", "bishnupriya" },
            { "bqi", "bakhtiari" },
            { "bra", "braj" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriat" },
            { "bug", "bugi" },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "caribico" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "ciagataico" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "chn", "gergo chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "cheyenne" },
            { "ckb", "curdo sorani" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "capiznon" },
            { "crg", "m\u00e9tchif" },
            { "crh", "turco crimeo" },
            { "crj", "cree sud-orientale" },
            { "crk", "cree delle pianure" },
            { "crl", "cree nord-orientale" },
            { "crm", "cree moose" },
            { "crr", "algonchino della Carolina" },
            { "crs", "creolo delle Seychelles" },
            { "csb", "kashubian" },
            { "csw", "cree delle paludi" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinca" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "basso sorabo" },
            { "dtp", "dusun centrale" },
            { "dua", "duala" },
            { "dum", "olandese medio" },
            { "dyo", "jola-fony" },
            { "dyu", "diula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egl", "emiliano" },
            { "egy", "egiziano antico" },
            { "eka", "ekajuka" },
            { "elx", "elamitico" },
            { "enm", "inglese medio" },
            { "esu", "yupik centrale" },
            { "ewo", "ewondo" },
            { "ext", "estremegno" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filippino" },
            { "fit", "finlandese del Tornedalen" },
            { "fon", "fon" },
            { "frc", "francese cajun" },
            { "frm", "francese medio" },
            { "fro", "francese antico" },
            { "frp", "francoprovenzale" },
            { "frr", "frisone settentrionale" },
            { "frs", "frisone orientale" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gag", "gagauzo" },
            { "gan", "gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gbz", "dari zoroastriano" },
            { "gez", "geez" },
            { "gil", "gilbertese" },
            { "glk", "gilaki" },
            { "gmh", "tedesco medio alto" },
            { "goh", "tedesco antico alto" },
            { "gom", "konkani goano" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "greco antico" },
            { "gsw", "tedesco svizzero" },
            { "guc", "wayuu" },
            { "guz", "gusii" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "hak", "hakka" },
            { "haw", "hawaiano" },
            { "hax", "haida meridionale" },
            { "hif", "hindi figiano" },
            { "hil", "ilongo" },
            { "hit", "hittite" },
            { "hmn", "hmong" },
            { "hsb", "alto sorabo" },
            { "hsn", "xiang" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut canadese occidentale" },
            { "ilo", "ilocano" },
            { "inh", "ingush" },
            { "izh", "ingrico" },
            { "jam", "creolo giamaicano" },
            { "jbo", "lojban" },
            { "jgo", "ngamambo" },
            { "jmc", "machame" },
            { "jpr", "giudeo persiano" },
            { "jrb", "giudeo arabo" },
            { "jut", "jutlandico" },
            { "kaa", "kara-kalpak" },
            { "kab", "cabilo" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "cabardino" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "capoverdiano" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotanese" },
            { "khq", "koyra chiini" },
            { "khw", "khowar" },
            { "kiu", "kirmanjki" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "permiaco" },
            { "kok", "konkani" },
            { "kos", "kosraean" },
            { "kpe", "kpelle" },
            { "krc", "karachay-Balkar" },
            { "krl", "careliano" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "coloniese" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwak\u02bcwala" },
            { "lad", "giudeo-spagnolo" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lesgo" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "ligure" },
            { "lil", "lillooet" },
            { "liv", "livone" },
            { "lkt", "lakota" },
            { "lmo", "lombardo" },
            { "lol", "lolo bantu" },
            { "lou", "creolo della Louisiana" },
            { "loz", "lozi" },
            { "lrc", "luri settentrionale" },
            { "lsm", "samia" },
            { "ltg", "letgallo" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "luy", "luyia" },
            { "lzh", "cinese classico" },
            { "lzz", "laz" },
            { "mad", "madurese" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "creolo mauriziano" },
            { "mga", "irlandese medio" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "menangkabau" },
            { "mnc", "manchu" },
            { "mni", "manipuri" },
            { "moe", "innu-aimun" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mrj", "mari occidentale" },
            { "mua", "mundang" },
            { "mul", "multilingua" },
            { "mus", "creek" },
            { "mwl", "mirandese" },
            { "mwr", "marwari" },
            { "mwv", "mentawai" },
            { "mye", "myene" },
            { "myv", "erzya" },
            { "mzn", "mazandarani" },
            { "nan", "min nan" },
            { "nap", "napoletano" },
            { "naq", "nama" },
            { "nds", "basso tedesco" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niue" },
            { "njo", "ao" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "norse antico" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho del nord" },
            { "nus", "nuer" },
            { "nwc", "newari classico" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "ojibwe nord-occidentale" },
            { "ojc", "ojibwe centrale" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwe occidentale" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "turco ottomano" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "pcd", "piccardo" },
            { "pcm", "pidgin nigeriano" },
            { "pdc", "tedesco della Pennsylvania" },
            { "peo", metaValue_peo },
            { "pfl", "tedesco palatino" },
            { "phn", metaValue_phn },
            { "pis", "pijin" },
            { "pms", "piemontese" },
            { "pnt", "pontico" },
            { "pon", "ponape" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "prussiano" },
            { "pro", "provenzale antico" },
            { "quc", "k\u2019iche\u2019" },
            { "qug", "quechua dell\u2019altopiano del Chimborazo" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rgn", "romagnolo" },
            { "rhg", "rohingya" },
            { "rif", "tarifit" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rtm", "rotumano" },
            { "rue", "ruteno" },
            { "rug", "roviana" },
            { "rup", "arumeno" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "sacha" },
            { "sam", "aramaico samaritano" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", metaValue_saz },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "siciliano" },
            { "sco", "scozzese" },
            { "sdc", "sassarese" },
            { "sdh", "curdo meridionale" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "selkup" },
            { "ses", "koyraboro senni" },
            { "sga", "irlandese antico" },
            { "sgs", "samogitico" },
            { "shi", "tashelhit" },
            { "shn", "shan" },
            { "shu", "arabo ciadiano" },
            { "sid", "sidamo" },
            { "slh", "lushootseed meridionale" },
            { "sli", "tedesco slesiano" },
            { "sly", "selayar" },
            { "sma", "sami del sud" },
            { "smj", "sami di Lule" },
            { "smn", "sami di Inari" },
            { "sms", "sami skolt" },
            { "snk", "soninke" },
            { "sog", "sogdiano" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", metaValue_ssy },
            { "stq", "saterfriesisch" },
            { "str", "salish straits" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumero" },
            { "swb", "comoriano" },
            { "syc", "siriaco classico" },
            { "syr", metaValue_syr },
            { "szl", "slesiano" },
            { "tce", "tutchone meridionale" },
            { "tcy", "tulu" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tkr", "tsakhur" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tly", "taliscio" },
            { "tmh", "tamashek" },
            { "tog", "nyasa del Tonga" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "tru", "turoyo" },
            { "trv", "taroko" },
            { "tsd", "zaconico" },
            { "tsi", "tsimshian" },
            { "ttm", "tutchone settentrionale" },
            { "ttt", "tat islamico" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinian" },
            { "tzm", "tamazight" },
            { "udm", "udmurt" },
            { "uga", "ugaritico" },
            { "umb", "mbundu" },
            { "und", "lingua imprecisata" },
            { "vai", metaValue_vai },
            { "vec", "veneto" },
            { "vep", "vepso" },
            { "vls", "fiammingo occidentale" },
            { "vot", "voto" },
            { "vro", "v\u00f5ro" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu" },
            { "xal", "kalmyk" },
            { "xmf", "mengrelio" },
            { "xog", "soga" },
            { "yao", "yao (bantu)" },
            { "yap", "yapese" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "cantonese" },
            { "zap", "zapotec" },
            { "zbl", "blissymbol" },
            { "zea", "zelandese" },
            { "zen", "zenaga" },
            { "zgh", "tamazight del Marocco standard" },
            { "zun", "zuni" },
            { "zxx", "nessun contenuto linguistico" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Afak", "afaka" },
            { "Aghb", "albanese caucasico" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliq" },
            { "Armi", "aramaico imperiale" },
            { "Armn", metaValue_hy },
            { "Avst", "avestico" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Blis", "simboli bliss" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", "buginese" },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "sillabario aborigeno canadese unificato" },
            { "Cari", "carian" },
            { "Cham", "cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "cipriota" },
            { "Cyrl", "cirillico" },
            { "Cyrs", "cirillico antica chiesa slavonica" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Dupl", "stenografia duployan" },
            { "Egyd", "egiziano demotico" },
            { "Egyh", "ieratico egiziano" },
            { "Egyp", "geroglifici egiziani" },
            { "Ethi", "etiope" },
            { "Geok", "kutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolitico" },
            { "Goth", metaValue_got },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "han, bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "semplificato" },
            { "Hant", "tradizionale" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "geroglifici anatolici" },
            { "Hmng", "pahawn hmong" },
            { "Hrkt", "katanaka o hiragana" },
            { "Hung", "antico ungherese" },
            { "Inds", "indu" },
            { "Ital", "italico antico" },
            { "Jamo", "jamo" },
            { "Java", "javanese" },
            { "Jpan", metaValue_ja },
            { "Jurc", "jurchen" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", "Kpelle" },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "variante fraktur del latino" },
            { "Latg", "variante gaelica del latino" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "lineare A" },
            { "Linb", "lineare B" },
            { "Lisu", "lisu" },
            { "Loma", "loma" },
            { "Lyci", "lyci" },
            { "Lydi", "lydi" },
            { "Mand", "mandaico" },
            { "Mani", "manicheo" },
            { "Maya", "geroglifici maya" },
            { "Mend", metaValue_men },
            { "Merc", "corsivo meroitico" },
            { "Mero", "meroitico" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "moon" },
            { "Mroo", "mro" },
            { "Mtei", "meetei mayek" },
            { "Mymr", metaValue_my },
            { "Narb", "arabo settentrionale antico" },
            { "Nbat", "nabateo" },
            { "Nkgb", "geba naxi" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nushu" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", "oriya" },
            { "Osma", "osmanya" },
            { "Palm", "palmireno" },
            { "Perm", "permico antico" },
            { "Phag", "phags-pa" },
            { "Phli", "pahlavi delle iscrizioni" },
            { "Phlp", "pahlavi psalter" },
            { "Phlv", "pahlavi book" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fonetica di pollard" },
            { "Prti", "partico delle iscrizioni" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "runico" },
            { "Samr", "samaritano" },
            { "Sara", "sarati" },
            { "Sarb", "arabo meridionale antico" },
            { "Saur", metaValue_saz },
            { "Sgnw", "linguaggio dei segni" },
            { "Shaw", "shaviano" },
            { "Shrd", "sharada" },
            { "Sind", "khudawadi" },
            { "Sinh", metaValue_si },
            { "Sora", "sora sompeng" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "siriaco estrangelo" },
            { "Syrj", "siriaco occidentale" },
            { "Syrn", "siriaco orientale" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai lue" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Ugar", "ugarita" },
            { "Vaii", metaValue_vai },
            { "Visp", "alfabeto visivo" },
            { "Wara", "varang kshiti" },
            { "Wole", "woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "sumero-accadiano cuneiforme" },
            { "Yiii", "yi" },
            { "Zinh", "ereditato" },
            { "Zmth", "notazione matematica" },
            { "Zsye", "emoji" },
            { "Zsym", "simboli" },
            { "Zxxx", "non scritto" },
            { "Zyyy", "comune" },
            { "Zzzz", "scrittura sconosciuta" },
            { "de_AT", "tedesco austriaco" },
            { "de_CH", "alto tedesco svizzero" },
            { "en_AU", "inglese australiano" },
            { "en_CA", "inglese canadese" },
            { "en_GB", "inglese britannico" },
            { "en_US", "inglese americano" },
            { "es_ES", "spagnolo europeo" },
            { "es_MX", "spagnolo messicano" },
            { "fa_AF", "dari" },
            { "fr_CA", "francese canadese" },
            { "fr_CH", "francese svizzero" },
            { "nl_BE", "fiammingo" },
            { "pt_BR", "portoghese brasiliano" },
            { "pt_PT", "portoghese europeo" },
            { "ro_MD", "moldavo" },
            { "sw_CD", "swahili del Congo" },
            { "%%1901", "ortografia tradizionale tedesca" },
            { "%%1994", "ortografia resiana standard" },
            { "%%1996", "ortografia tedesca del 1996" },
            { "ar_001", "arabo moderno standard" },
            { "es_419", "spagnolo latinoamericano" },
            { "key.ca", "Calendario" },
            { "key.cf", "Formato valuta" },
            { "key.co", "Ordinamento" },
            { "key.cu", "Valuta" },
            { "key.hc", "Sistema orario (12 o 24 ore)" },
            { "key.lb", "Tipo di interruzione di riga" },
            { "key.ms", "Sistema di misurazione" },
            { "key.nu", "Numeri" },
            { "key.tz", "Fuso orario" },
            { "key.va", "Variante lingua" },
            { "nds_NL", "basso tedesco olandese" },
            { "%%ALUKU", "dialetto aluku" },
            { "%%BISKE", "dialetto San Giorgio/Bila" },
            { "%%BOONT", "boontling" },
            { "%%KKCOR", "ortografia comune" },
            { "%%KSCOR", "ortografia standard" },
            { "%%LIPAW", "dialetto resiano di Lipovaz" },
            { "%%NEDIS", "dialetto del Natisone" },
            { "%%NJIVA", "dialetto Gniva/Njiva" },
            { "%%NULIK", "volap\u00fck moderno" },
            { "%%OSOJS", "dialetto Oseacco/Osojane" },
            { "%%POSIX", "computer" },
            { "%%RIGIK", "Volap\u00fck classico" },
            { "%%ROZAJ", "resiano" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "dialetto Stolvizza/Solbica" },
            { "%%UCCOR", "ortografia unificata" },
            { "zh_Hans", "cinese semplificato" },
            { "zh_Hant", "cinese tradizionale" },
            { "%%DAJNKO", "alfabeto Dajnko" },
            { "%%FONIPA", "alfabeto fonetico internazionale IPA" },
            { "%%FONUPA", "alfabeto fonetico uralico UPA" },
            { "%%NDYUKA", "dialetto Ndyuka" },
            { "%%PAMAKA", "dialetto Pamaka" },
            { "%%PINYIN", "romanizzazione Pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "ortografia taraskievica" },
            { "%%UCRCOR", "ortografia rivista unificata" },
            { "%%ALALC97", "romanizzazione di ALA-LC, versione 1997" },
            { "%%AREVELA", "armeno orientale" },
            { "%%AREVMDA", "armeno occidentale" },
            { "%%BOHORIC", "alfabeto bohori\u010d" },
            { "%%EMODENG", "primo inglese moderno" },
            { "%%HEPBURN", "romanizzazione Hepburn" },
            { "%%METELKO", "alfabeto Metelko" },
            { "%%MONOTON", "monotonico" },
            { "%%POLYTON", "politonico" },
            { "%%REVISED", "ortografia revisionata" },
            { "%%1606NICT", "francese medio-tardo fino al 1606" },
            { "%%1694ACAD", "primo francese moderno" },
            { "%%1959ACAD", "accademico" },
            { "%%BAKU1926", "alfabeto latino altaico unificato" },
            { "%%SCOTLAND", "inglese scozzese standard" },
            { "%%VALENCIA", "valenziano" },
            { "%%WADEGILE", "romanizzazione Wade-Giles" },
            { "type.ca.roc", "Calendario minguo" },
            { "type.hc.h11", "Sistema orario a 12 ore (0\u201311)" },
            { "type.hc.h12", "Sistema orario a 12 ore (1\u201312)" },
            { "type.hc.h23", "Sistema orario a 24 ore (0\u201323)" },
            { "type.hc.h24", "Sistema orario a 24 ore (1\u201324)" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.arab", "Cifre indo-arabe" },
            { "type.nu.armn", "Numeri armeni" },
            { "type.nu.bali", "Cifre balinesi" },
            { "type.nu.beng", "Cifre bengalesi" },
            { "type.nu.brah", "Cifre brahmi" },
            { "type.nu.cakm", "Cifre chakma" },
            { "type.nu.cham", "Cifre cham" },
            { "type.nu.deva", "Cifre devanagari" },
            { "type.nu.ethi", "Numeri etiopi" },
            { "type.nu.geor", "Numeri georgiani" },
            { "type.nu.grek", "Numeri greci" },
            { "type.nu.gujr", "Cifre gujarati" },
            { "type.nu.guru", "Cifre gurmukhi" },
            { "type.nu.hans", "Numeri in cinese semplificato" },
            { "type.nu.hant", "Numeri in cinese tradizionale" },
            { "type.nu.hebr", "Numeri ebraici" },
            { "type.nu.java", "Cifre giavanesi" },
            { "type.nu.jpan", "Numeri giapponesi" },
            { "type.nu.kali", "Cifre Kayah Li" },
            { "type.nu.khmr", "Cifre khmer" },
            { "type.nu.knda", "Cifre kannada" },
            { "type.nu.lana", "Cifre tai tham hora" },
            { "type.nu.laoo", "Cifre lao" },
            { "type.nu.latn", "Cifre occidentali" },
            { "type.nu.lepc", "Cifre lepcha" },
            { "type.nu.limb", "Cifre limbu" },
            { "type.nu.mlym", "Cifre malayalam" },
            { "type.nu.mong", "Numeri mongoli" },
            { "type.nu.mtei", "Cifre Meetei Mayek" },
            { "type.nu.mymr", "Cifre birmane" },
            { "type.nu.nkoo", "Cifre N\u2019Ko" },
            { "type.nu.olck", "Cifre Ol Chiki" },
            { "type.nu.orya", "Cifre oriya" },
            { "type.nu.osma", "Cifre osmanya" },
            { "type.nu.saur", "Cifre saurashtra" },
            { "type.nu.shrd", "Cifre sharada" },
            { "type.nu.sora", "Cifre Sora Sompeng" },
            { "type.nu.sund", "Cifre sundanesi" },
            { "type.nu.takr", "Cifre takri" },
            { "type.nu.talu", "Cifre nuovo Tai Lue" },
            { "type.nu.taml", "Numeri tamil tradizionali" },
            { "type.nu.telu", "Cifre telugu" },
            { "type.nu.thai", "Cifre thailandesi" },
            { "type.nu.tibt", "Cifre tibetane" },
            { "type.nu.vaii", "Cifre Vai" },
            { "type.ca.dangi", "Calendario dangi" },
            { "type.co.ducet", "Ordinamento Unicode predefinito" },
            { "type.lb.loose", "Interruzione di riga facoltativa" },
            { "type.nu.roman", "Numeri romani" },
            { "type.ca.coptic", "Calendario copto" },
            { "type.ca.hebrew", "Calendario ebraico" },
            { "type.ca.indian", "calendario nazionale indiano" },
            { "type.co.compat", "Ordinamento precedente, per compatibilit\u00e0" },
            { "type.co.pinyin", "Ordinamento pinyin" },
            { "type.co.search", "Ricerca generica" },
            { "type.co.stroke", "Ordinamento tratti" },
            { "type.co.unihan", "Ordinamento tratti radicali" },
            { "type.co.zhuyin", "Ordinamento Zhuyin" },
            { "type.d0.fwidth", "Larghezza intera" },
            { "type.d0.hwidth", "Met\u00e0 larghezza" },
            { "type.lb.normal", "Interruzione di riga normale" },
            { "type.lb.strict", "Interruzione di riga forzata" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.ms.metric", "Sistema metrico" },
            { "type.nu.native", "Cifre native" },
            { "type.ca.chinese", "Calendario cinese" },
            { "type.ca.islamic", "Calendario islamico" },
            { "type.ca.iso8601", "Calendario ISO-8601" },
            { "type.ca.persian", "Calendario persiano" },
            { "type.cf.account", "Formato valuta contabile" },
            { "type.co.big5han", "Ordinamento Cinese tradizionale - Big5" },
            { "type.d0.npinyin", "Numerica" },
            { "type.nu.arabext", "Cifre indo-arabe estese" },
            { "type.nu.armnlow", "Numeri armeni minuscoli" },
            { "type.nu.finance", "Numeri finanziari" },
            { "type.nu.greklow", "Numeri greci minuscoli" },
            { "type.nu.hanidec", "Numeri decimali cinesi" },
            { "type.nu.hansfin", "Numeri finanziari in cinese semplificato" },
            { "type.nu.hantfin", "Numeri finanziari in cinese tradizionale" },
            { "type.nu.jpanfin", "Numeri finanziari giapponesi" },
            { "type.nu.tamldec", "Cifre tamil" },
            { "type.ca.buddhist", "Calendario buddista" },
            { "type.ca.ethiopic", "Calendario etiope" },
            { "type.ca.japanese", "Calendario giapponese" },
            { "type.cf.standard", "Formato valuta standard" },
            { "type.co.phonetic", "Ordinamento fonetico" },
            { "type.co.reformed", "Ordinamento riformato" },
            { "type.co.searchjl", "Cerca per consonante hangul iniziale" },
            { "type.co.standard", "Ordinamento standard" },
            { "type.ms.uksystem", "Sistema imperiale britannico" },
            { "type.ms.ussystem", "Sistema consuetudinario statunitense" },
            { "type.nu.fullwide", "Cifre a larghezza intera" },
            { "type.nu.lanatham", "Cifre tai tham tham" },
            { "type.nu.mymrshan", "Cifre shan birmane" },
            { "type.nu.romanlow", "Numeri romani minuscoli" },
            { "type.ca.gregorian", "Calendario gregoriano" },
            { "type.co.gb2312han", "Ordinamento Cinese semplificato - GB2312" },
            { "type.co.phonebook", "Ordinamento Elenco telefonico" },
            { "type.co.dictionary", "Ordinamento dizionario" },
            { "type.co.traditional", "Ordinamento tradizionale" },
            { "type.nu.traditional", "Numeri tradizionali" },
            { "type.ca.islamic-rgsa", "Calendario islamico (Arabia Saudita, osservazione)" },
            { "type.ca.islamic-tbla", "Calendario islamico (tabulare, era astronomica)" },
            { "type.ca.islamic-civil", "Calendario islamico tabulare" },
            { "type.ca.islamic-umalqura", "Calendario islamico (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Calendario etiope Amete Alem" },
        };
        return data;
    }
}
