/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ku extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "ereb\u00ee";
        final String metaValue_hy = "ermen\u00ee";
        final String metaValue_bn = "bengal\u00ee";
        final String metaValue_ka = "gurc\u00ee";
        final String metaValue_el = "yewnan\u00ee";
        final String metaValue_km = "xim\u00ear\u00ee";
        final String metaValue_mn = "mongol\u00ee";
        final String metaValue_bo = "t\u00eebet\u00ee";
        final Object[][] data = new Object[][] {
            { "001", "C\u00eehan" },
            { "002", "Afr\u00eeka" },
            { "003", "Amer\u00eekaya Bakur" },
            { "005", "Amer\u00eekaya Ba\u015f\u00fbr" },
            { "009", "Okyan\u00fbsya" },
            { "013", "Amer\u00eekaya Nav\u00een" },
            { "015", "Afr\u00eekaya Bakur" },
            { "019", "Amer\u00eeka" },
            { "029", "Kar\u00eeb" },
            { "053", "Awistralasya" },
            { "054", "Melanezya" },
            { "057", "Her\u00eama M\u00eekronezya" },
            { "061", "Pol\u00eenezya" },
            { "142", "Asya" },
            { "150", "Ewropa" },
            { "151", "Ewropaya Rojhilat" },
            { "155", "Ewropaya Rojava" },
            { "419", "Amer\u00eekaya Lat\u00een\u00ee" },
            { "AD", "Andorra" },
            { "AE", "Em\u00eertiy\u00ean Ereb\u00ee y\u00ean Yekb\u00fby\u00ee" },
            { "AF", "Efxanistan" },
            { "AG", "Ant\u00eegua \u00fb Berb\u00fbda" },
            { "AL", "Albanya" },
            { "AM", "Ermenistan" },
            { "AO", "Angola" },
            { "AQ", "Antarkt\u00eeka" },
            { "AR", "Arjent\u00een" },
            { "AS", "Samoaya Amer\u00eekan\u00ee" },
            { "AT", "Awistirya" },
            { "AU", "Awistralya" },
            { "AW", "Ar\u00fbba" },
            { "AZ", "Azerbaycan" },
            { "BA", "Bosniya \u00fb Herzegov\u00eena" },
            { "BB", "Barbados" },
            { "BD", "Banglade\u015f" },
            { "BE", "Bel\u00e7\u00eeka" },
            { "BF", "Burk\u00eena Faso" },
            { "BG", "Bulgaristan" },
            { "BH", "Behreyn" },
            { "BI", "Burund\u00ee" },
            { "BJ", "B\u00ean\u00een" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Berm\u00fbda" },
            { "BN", "Br\u00fbney" },
            { "BO", "Bol\u00eevya" },
            { "BR", "Braz\u00eel" },
            { "BS", "Bahama" },
            { "BT", "B\u00fbtan" },
            { "BW", "Botswana" },
            { "BY", "Belar\u00fbs" },
            { "BZ", "Bel\u00eeze" },
            { "CA", "Kanada" },
            { "CD", "Kongo - K\u00een\u015fasa" },
            { "CF", "Komara Afr\u00eekaya Navend" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Sw\u00eesre" },
            { "CI", "Perav\u00ea Diranf\u00eel" },
            { "CK", "Girav\u00ean Cook" },
            { "CL", "\u015e\u00eele" },
            { "CM", "Kamer\u00fbn" },
            { "CN", "\u00c7\u00een" },
            { "CO", "Kolombiya" },
            { "CR", "Kosta R\u00eeka" },
            { "CU", "K\u00fbba" },
            { "CV", "Kap Verde" },
            { "CY", "K\u00eepros" },
            { "CZ", "\u00c7ekya" },
            { "DE", "Almanya" },
            { "DJ", "C\u00eeb\u00fbt\u00ee" },
            { "DK", "Dan\u00eemarka" },
            { "DM", "Dom\u00een\u00eeka" },
            { "DO", "Komara Dom\u00een\u00eek" },
            { "DZ", "Cezayir" },
            { "EC", "Ekuador" },
            { "EE", "Estonya" },
            { "EG", "Misir" },
            { "EH", "Sahraya Rojava" },
            { "ER", "Er\u00eetrea" },
            { "ES", "Spanya" },
            { "ET", "Etiyopya" },
            { "EU", "Yek\u00eetiya Ewropay\u00ea" },
            { "FI", "F\u00eenlenda" },
            { "FJ", "F\u00eej\u00ee" },
            { "FK", "Girav\u00ean Malv\u00een" },
            { "FM", "M\u00eekronezya" },
            { "FO", "Girav\u00ean Feroe" },
            { "FR", "Fransa" },
            { "GA", "Gabon" },
            { "GB", "Keyaniya Yekb\u00fby\u00ee" },
            { "GD", "Grenada" },
            { "GE", "Gurcistan" },
            { "GF", "Guyanaya Frans\u00ee" },
            { "GH", "Gana" },
            { "GI", "C\u00eebraltar" },
            { "GL", "Gr\u00eenlenda" },
            { "GM", "Gambiya" },
            { "GN", "G\u00eene" },
            { "GP", "Guadeloupe" },
            { "GQ", "G\u00eeneya Rojbend\u00ee" },
            { "GR", "Yewnanistan" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "G\u00eene-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong" },
            { "HN", "Hond\u00fbras" },
            { "HR", "Kroatya" },
            { "HT", "Ha\u00eet\u00ee" },
            { "HU", "Macaristan" },
            { "IC", "Girav\u00ean Qenariy\u00ea" },
            { "ID", "\u00cendonezya" },
            { "IE", "\u00cerlenda" },
            { "IL", "\u00cesra\u00eal" },
            { "IM", "Girava Man" },
            { "IN", "Hindistan" },
            { "IQ", "Iraq" },
            { "IR", "\u00ceran" },
            { "IS", "\u00ceslenda" },
            { "IT", "\u00cetalya" },
            { "JM", "Jama\u00eeka" },
            { "JO", "Urdun" },
            { "JP", "Japon" },
            { "KE", "Kenya" },
            { "KG", "Qirgizistan" },
            { "KH", "Kamboca" },
            { "KI", "Kir\u00eebat\u00ee" },
            { "KM", "Komor" },
            { "KN", "Saint Kitts \u00fb Nev\u00ees" },
            { "KP", "Kor\u00eaya Bakur" },
            { "KR", "Kor\u00eaya Ba\u015f\u00fbr" },
            { "KW", "Kuweyt" },
            { "KY", "Girav\u00ean Kayman\u00ea" },
            { "KZ", "Qazaxistan" },
            { "LA", "Laos" },
            { "LB", "Libnan" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sr\u00ee Lanka" },
            { "LR", "L\u00eeberya" },
            { "LS", "Lesoto" },
            { "LT", "L\u00eetvanya" },
            { "LU", "L\u00fbksemb\u00fbrg" },
            { "LV", "Letonya" },
            { "LY", "L\u00eebya" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MG", "Madagaskar" },
            { "MH", "Girav\u00ean Mar\u015fal" },
            { "MK", "Makedonya" },
            { "ML", "Mal\u00ee" },
            { "MM", "Myanmar (Birmanya)" },
            { "MN", "Mongolya" },
            { "MO", "Makao" },
            { "MP", "Girav\u00ean Bakur\u00ea Marianan" },
            { "MQ", "Martinique" },
            { "MR", "Mor\u00eetanya" },
            { "MT", "Malta" },
            { "MU", "Maur\u00eetius" },
            { "MV", "Mald\u00eev" },
            { "MW", "Malaw\u00ee" },
            { "MX", "Meks\u00eek" },
            { "MY", "Malezya" },
            { "MZ", "Mozamb\u00eek" },
            { "NA", "Nam\u00eebya" },
            { "NC", "Kaledonyaya N\u00fb" },
            { "NE", "N\u00eejer" },
            { "NF", "Girava Norfolk" },
            { "NG", "N\u00eejerya" },
            { "NI", "N\u00eekaragua" },
            { "NL", "Holenda" },
            { "NO", "Norw\u00eac" },
            { "NP", "Nepal" },
            { "NR", "Na\u00fbr\u00fb" },
            { "NU", "Ni\u00fbe" },
            { "NZ", "N\u00fb Zelenda" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Per\u00fb" },
            { "PF", "Pol\u00eenezyaya Frans\u00ee" },
            { "PG", "Papua G\u00eeneya N\u00fb" },
            { "PH", "Fil\u00eep\u00een" },
            { "PK", "Pakistan" },
            { "PL", "Polonya" },
            { "PM", "Saint-Pierre \u00fb Miquelon" },
            { "PN", "Girav\u00ean Pitcairn" },
            { "PR", "Porto R\u00eeko" },
            { "PS", "Xak\u00ean filist\u00een\u00ee" },
            { "PT", "Port\u00fbgal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qeter" },
            { "RE", "R\u00e9union" },
            { "RO", "Romanya" },
            { "RS", "Serbistan" },
            { "RU", "R\u00fbsya" },
            { "RW", "Rwanda" },
            { "SA", "Erebistana Siy\u00fbd\u00ee" },
            { "SB", "Girav\u00ean Salomon" },
            { "SC", "Sey\u015fel" },
            { "SD", "S\u00fbdan" },
            { "SE", "Sw\u00ead" },
            { "SG", "Singap\u00fbr" },
            { "SI", "Slovenya" },
            { "SK", "Slovakya" },
            { "SL", "Sierra Leone" },
            { "SM", "San Mar\u00eeno" },
            { "SN", "Senegal" },
            { "SO", "Somalya" },
            { "SR", "S\u00fbr\u00eenam" },
            { "SS", "S\u00fbdana Ba\u015f\u00fbr" },
            { "ST", "Sao Tome \u00fb Pr\u00eens\u00eepe" },
            { "SV", "El Salvador" },
            { "SY", "S\u00fbr\u00ee" },
            { "SZ", "Swaz\u00eelenda" },
            { "TC", "Girav\u00ean Turk \u00fb Ka\u00eekos" },
            { "TD", "\u00c7ad" },
            { "TG", "Togo" },
            { "TH", "Taylenda" },
            { "TJ", "Tac\u00eekistan" },
            { "TK", "Tokelau" },
            { "TL", "T\u00eemora-Leste" },
            { "TM", "Tirkmenistan" },
            { "TN", "T\u00fbnis" },
            { "TO", "Tonga" },
            { "TR", "Tirkiye" },
            { "TT", "Tr\u00een\u00eedad \u00fb Tobago" },
            { "TV", "T\u00fbval\u00fb" },
            { "TW", "Taywan" },
            { "TZ", "Tanzanya" },
            { "UA", "\u00dbkrayna" },
            { "UG", "\u00dbganda" },
            { "UN", "Netewey\u00ean Yekb\u00fby\u00ee" },
            { "US", "Dewlet\u00ean Yekb\u00fby\u00ee y\u00ean Amer\u00eekay\u00ea" },
            { "UY", "\u00dbr\u00fbguay" },
            { "UZ", "\u00dbzb\u00eakistan" },
            { "VA", "Vat\u00eekan" },
            { "VC", "Saint Vincent \u00fb Girav\u00ean Grenad\u00een" },
            { "VE", "Venezuela" },
            { "VN", "Viyetnam" },
            { "VU", "Van\u00fbat\u00fb" },
            { "WF", "Wallis \u00fb Futuna" },
            { "WS", "Samoa" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "ZA", "Afr\u00eekaya Ba\u015f\u00fbr" },
            { "ZM", "Zambiya" },
            { "ZW", "Z\u00eembabwe" },
            { "aa", "afar\u00ee" },
            { "ab", "abxaz\u00ee" },
            { "af", "afr\u00eekans\u00ee" },
            { "am", "amhar\u00ee" },
            { "an", "aragon\u00ee" },
            { "ar", metaValue_ar },
            { "as", "asam\u00ee" },
            { "av", "avar\u00ee" },
            { "ay", "aymaray\u00ee" },
            { "az", "azer\u00ee" },
            { "ba", "ba\u015fk\u00eer\u00ee" },
            { "be", "belarus\u00ee" },
            { "bg", "bulgar\u00ee" },
            { "bi", "b\u00eeslamay\u00ee" },
            { "bm", "bambaray\u00ee" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton\u00ee" },
            { "bs", "bosn\u00ee" },
            { "ca", "katalan\u00ee" },
            { "ce", "\u00e7e\u00e7en\u00ee" },
            { "ch", "\u00e7amoroy\u00ee" },
            { "co", "kors\u00eekay\u00ee" },
            { "cs", "\u00e7ek\u00ee" },
            { "cv", "\u00e7uva\u015f\u00ee" },
            { "cy", "weyls\u00ee" },
            { "da", "danmark\u00ee" },
            { "de", "elman\u00ee" },
            { "dv", "diveh\u00ee" },
            { "dz", "conxay\u00ee" },
            { "ee", "ewey\u00ee" },
            { "el", metaValue_el },
            { "en", "\u00eengil\u00eez\u00ee" },
            { "eo", "esperantoy\u00ee" },
            { "es", "span\u00ee" },
            { "et", "eston\u00ee" },
            { "eu", "bask\u00ee" },
            { "fa", "faris\u00ee" },
            { "ff", "fulah\u00ee" },
            { "fi", "f\u00een\u00ee" },
            { "fj", "f\u00eej\u00ee" },
            { "fo", "fer\u00ee" },
            { "fr", "frens\u00ee" },
            { "fy", "fr\u00ees\u00ee" },
            { "ga", "\u00eer\u00ee" },
            { "gd", "gael\u00eeka skot\u00ee" },
            { "gl", "gal\u00ees\u00ee" },
            { "gn", "guwaran\u00ee" },
            { "gu", "gujarat\u00ee" },
            { "gv", "manks\u00ee" },
            { "ha", "hawsay\u00ee" },
            { "he", "\u00eebran\u00ee" },
            { "hi", "hind\u00ee" },
            { "hr", "xirwat\u00ee" },
            { "ht", "ha\u00eet\u00ee" },
            { "hu", "mecar\u00ee" },
            { "hy", metaValue_hy },
            { "hz", "hereroy\u00ee" },
            { "ia", "interlingua" },
            { "id", "indonez\u00ee" },
            { "ig", "\u00eegboy\u00ee" },
            { "io", "\u00eedoy\u00ee" },
            { "is", "\u00eezlend\u00ee" },
            { "it", "\u00eetal\u00ee" },
            { "iu", "\u00eenu\u00eet\u00ee" },
            { "ja", "japon\u00ee" },
            { "jv", "javay\u00ee" },
            { "ka", metaValue_ka },
            { "kk", "qazax\u00ee" },
            { "kl", "kalal\u00ees\u00fbt\u00ee" },
            { "km", metaValue_km },
            { "kn", "kannaday\u00ee" },
            { "ko", "korey\u00ee" },
            { "ks", "ke\u015fm\u00eer\u00ee" },
            { "ku", "kurd\u00ee" },
            { "kv", "kom\u00ee" },
            { "kw", "korn\u00ee" },
            { "ky", "kirgiz\u00ee" },
            { "lb", "luksemb\u00fbrg\u00ee" },
            { "lg", "luganday\u00ee" },
            { "li", "l\u00eemb\u00fbrg\u00ee" },
            { "ln", "lingalay\u00ee" },
            { "lo", "laws\u00ee" },
            { "lt", "l\u00eetwan\u00ee" },
            { "lv", "latviyay\u00ee" },
            { "mg", "malagas\u00ee" },
            { "mh", "mar\u015fal\u00ee" },
            { "mi", "maor\u00ee" },
            { "mk", "makedon\u00ee" },
            { "ml", "malayalam\u00ee" },
            { "mn", metaValue_mn },
            { "mr", "marat\u00ee" },
            { "ms", "malez\u00ee" },
            { "mt", "maltay\u00ee" },
            { "my", "burmay\u00ee" },
            { "na", "nawr\u00fby\u00ee" },
            { "nb", "norwec\u00ee (bokm\u00e5l)" },
            { "ne", "nepal\u00ee" },
            { "nl", "holend\u00ee" },
            { "nn", "norwec\u00ee (nynorsk)" },
            { "nv", "navajoy\u00ee" },
            { "oc", "oks\u00eetan\u00ee" },
            { "om", "oromoy\u00ee" },
            { "or", "oriyay\u00ee" },
            { "os", "oset\u00ee" },
            { "pa", "puncab\u00ee" },
            { "pl", "polon\u00ee" },
            { "ps", "pe\u015ft\u00fby\u00ee" },
            { "pt", "portugal\u00ee" },
            { "qu", "ke\u00e7way\u00ee" },
            { "rm", "romanc\u00ee" },
            { "ro", "roman\u00ee" },
            { "ru", "rus\u00ee" },
            { "rw", "k\u00eenyariwanday\u00ee" },
            { "sa", "sanskr\u00eet\u00ee" },
            { "sc", "sard\u00een\u00ee" },
            { "sd", "sindh\u00ee" },
            { "se", "samiya bakur" },
            { "si", "k\u00eengal\u00ee" },
            { "sk", "slovak\u00ee" },
            { "sl", "sloven\u00ee" },
            { "sm", "samoay\u00ee" },
            { "sn", "\u015fonay\u00ee" },
            { "so", "somal\u00ee" },
            { "sq", "elban\u00ee" },
            { "sr", "sirb\u00ee" },
            { "ss", "swaz\u00ee" },
            { "st", "sotoyiya ba\u015f\u00fbr" },
            { "su", "sundan\u00ee" },
            { "sv", "sw\u00ead\u00ee" },
            { "sw", "swah\u00eel\u00ee" },
            { "ta", "tam\u00eel\u00ee" },
            { "te", "tel\u00fbg\u00fby\u00ee" },
            { "tg", "tacik\u00ee" },
            { "th", "tay\u00ee" },
            { "ti", "tigr\u00een\u00ee" },
            { "tk", "tirkmen\u00ee" },
            { "tn", "tswanay\u00ee" },
            { "to", "tong\u00ee" },
            { "tr", "tirk\u00ee" },
            { "ts", "tsongay\u00ee" },
            { "tt", "teter\u00ee" },
            { "ty", "tah\u00eet\u00ee" },
            { "ug", "oygur\u00ee" },
            { "uk", "ukrayn\u00ee" },
            { "ur", "urd\u00fby\u00ee" },
            { "uz", "ozbek\u00ee" },
            { "vi", "viyetnam\u00ee" },
            { "vo", "volap\u00fbk\u00ee" },
            { "wa", "walon\u00ee" },
            { "wo", "wolof\u00ee" },
            { "xh", "xosay\u00ee" },
            { "yi", "yid\u00ee\u015f\u00ee" },
            { "yo", "yorubay\u00ee" },
            { "zu", "zuluy\u00ee" },
            { "ace", "a\u00e7eh\u00ee" },
            { "ady", "ad\u00eegey\u00ee" },
            { "ain", "aynuy\u00ee" },
            { "ale", "al\u00eaw\u00eet\u00ee" },
            { "ast", "ast\u00fbr\u00ee" },
            { "ban", "bal\u00een\u00ee" },
            { "bem", "bembay\u00ee" },
            { "bho", "bojp\u00fbr\u00ee" },
            { "bla", "blakfot\u00ee" },
            { "bug", "bug\u00ee" },
            { "ceb", "sebwanoy\u00ee" },
            { "chk", "\u00e7\u00fbk\u00ee" },
            { "chm", "mar\u00ee" },
            { "chr", "\u00e7erok\u00ee" },
            { "chy", "\u00e7eyen\u00ee" },
            { "ckb", "soran\u00ee" },
            { "dsb", "sorbiya j\u00ear\u00een" },
            { "dua", "diwalay\u00ee" },
            { "fil", "f\u00eel\u00eep\u00eenoy\u00ee" },
            { "fur", "friyol\u00ee" },
            { "gil", "k\u00eer\u00eebat\u00ee" },
            { "gor", "gorontaloy\u00ee" },
            { "gsw", "elman\u00ee\u015f\u00ee" },
            { "haw", "haway\u00ee" },
            { "hil", "h\u00eel\u00eegaynon\u00ee" },
            { "hsb", "sorbiya jor\u00een" },
            { "ilo", "\u00eelokanoy\u00ee" },
            { "inh", "\u00eeng\u00fb\u015f\u00ee" },
            { "jbo", "lojban\u00ee" },
            { "kab", "kab\u00eel\u00ee" },
            { "kea", "kapverd\u00ee" },
            { "kok", "konkan\u00ee" },
            { "ksh", "r\u00eepwar\u00ee" },
            { "lad", "lad\u00eenoy\u00ee" },
            { "lez", "lezg\u00een\u00ee" },
            { "lkt", "lakotay\u00ee" },
            { "lrc", "luriya bakur" },
            { "mad", "maduray\u00ee" },
            { "mas", "masay\u00ee" },
            { "mdf", "mok\u015fay\u00ee" },
            { "mic", "m\u00eekmak\u00ee" },
            { "min", "m\u00eenangkabaw\u00ee" },
            { "moh", "mohawk\u00ee" },
            { "myv", "erzay\u00ee" },
            { "mzn", "mazenderan\u00ee" },
            { "nap", "napol\u00eetan\u00ee" },
            { "niu", "n\u00eew\u00ee" },
            { "nso", "sotoyiya bakur" },
            { "pam", "kapampangan\u00ee" },
            { "pap", "papyamentoy\u00ee" },
            { "pau", "palaw\u00ee" },
            { "prg", "pr\u00fbsyay\u00ee" },
            { "rap", "rapanuy\u00ee" },
            { "rar", "rarotong\u00ee" },
            { "rup", "aroman\u00ee" },
            { "scn", "sic\u00eel\u00ee" },
            { "sco", "skot\u00ee" },
            { "smn", "samiya \u00eenar\u00ee" },
            { "srn", "siranan\u00ee" },
            { "swb", "komor\u00ee" },
            { "syr", "siryan\u00ee" },
            { "tet", "tet\u00fbm\u00ee" },
            { "tlh", "kl\u00eengon\u00ee" },
            { "tpi", "tokpisin\u00ee" },
            { "trv", "tarokoy\u00ee" },
            { "tum", "tumbukay\u00ee" },
            { "tvl", "tuval\u00fby\u00ee" },
            { "tzm", "temaz\u00eext\u00ee" },
            { "udm", "udmurt\u00ee" },
            { "war", "waray\u00ee" },
            { "yue", "kanton\u00ee" },
            { "zza", "zazak\u00ee" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Cyrl", "kir\u00eel\u00ee" },
            { "Deva", "devanagar\u00ee" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Khmr", metaValue_km },
            { "Latn", "lat\u00een\u00ee" },
            { "Mong", metaValue_mn },
            { "Tibt", metaValue_bo },
            { "Zsym", "sembol" },
            { "Zxxx", "ne niv\u00eesand\u00ee" },
            { "Zyyy", "hevpar" },
            { "Zzzz", "niv\u00eesa nenas" },
            { "nl_BE", "flam\u00ee" },
            { "ar_001", "erebiya standard" },
            { "key.ca", "salname" },
            { "key.cu", "diw\u00eez" },
            { "type.ca.roc", "salnameya Komara \u00c7\u00een\u00ea" },
            { "type.nu.roman", "hejmar\u00ean rom\u00ee" },
            { "type.ca.hebrew", "salnameya \u00eebran\u00ee" },
            { "type.ca.chinese", "salnameya \u00e7\u00een\u00ee" },
            { "type.ca.islamic", "salnameya ko\u00e7\u00ee" },
            { "type.ca.iso8601", "salnameya ISO-8601" },
            { "type.ca.persian", "salnameya \u00eeran\u00ee" },
            { "type.ca.japanese", "salnameya japon\u00ee" },
            { "type.ca.gregorian", "salnameya gregor\u00ee" },
        };
        return data;
    }
}
