/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;

public class SuppressWarningsProposalCore
extends ASTRewriteCorrectionProposalCore {
    private final String fWarningToken;
    private final ASTNode fNode;
    private final ChildListPropertyDescriptor fProperty;

    public SuppressWarningsProposalCore(String warningToken, String label, ICompilationUnit cu, ASTNode node, ChildListPropertyDescriptor property, int relevance) {
        super(label, cu, (ASTRewrite)null, relevance);
        this.fWarningToken = warningToken;
        this.fNode = node;
        this.fProperty = property;
        this.setCommandId("org.eclipse.jdt.ui.correction.addSuppressWarnings");
    }

    public String getWarningToken() {
        return this.fWarningToken;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        NormalAnnotation annotation;
        Expression value;
        AST ast = this.fNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        StringLiteral newStringLiteral = ast.newStringLiteral();
        newStringLiteral.setLiteralValue(this.fWarningToken);
        Annotation existing = SuppressWarningsProposalCore.findExistingAnnotation(ASTNodes.getChildListProperty(this.fNode, this.fProperty));
        if (existing == null) {
            ListRewrite listRewrite = rewrite.getListRewrite(this.fNode, this.fProperty);
            SingleMemberAnnotation newAnnot = ast.newSingleMemberAnnotation();
            String importString = this.createImportRewrite((CompilationUnit)this.fNode.getRoot()).addImport("java.lang.SuppressWarnings");
            newAnnot.setTypeName(ast.newName(importString));
            newAnnot.setValue((Expression)newStringLiteral);
            listRewrite.insertFirst((ASTNode)newAnnot, null);
        } else if (existing instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation annotation2 = (SingleMemberAnnotation)existing;
            Expression value2 = annotation2.getValue();
            if (!SuppressWarningsProposalCore.addSuppressArgument(rewrite, value2, newStringLiteral)) {
                rewrite.set((ASTNode)existing, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, (Object)newStringLiteral, null);
            }
        } else if (existing instanceof NormalAnnotation && !SuppressWarningsProposalCore.addSuppressArgument(rewrite, value = SuppressWarningsProposalCore.findValue((annotation = (NormalAnnotation)existing).values()), newStringLiteral)) {
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)annotation, NormalAnnotation.VALUES_PROPERTY);
            MemberValuePair pair = ast.newMemberValuePair();
            pair.setName(ast.newSimpleName("value"));
            pair.setValue((Expression)newStringLiteral);
            listRewrite.insertFirst((ASTNode)pair, null);
        }
        return rewrite;
    }

    private static boolean addSuppressArgument(ASTRewrite rewrite, Expression value, StringLiteral newStringLiteral) {
        if (value instanceof ArrayInitializer) {
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)value, ArrayInitializer.EXPRESSIONS_PROPERTY);
            listRewrite.insertLast((ASTNode)newStringLiteral, null);
        } else if (value instanceof StringLiteral) {
            ArrayInitializer newArr = rewrite.getAST().newArrayInitializer();
            newArr.expressions().add(rewrite.createMoveTarget((ASTNode)value));
            newArr.expressions().add(newStringLiteral);
            rewrite.replace((ASTNode)value, (ASTNode)newArr, null);
        } else {
            return false;
        }
        return true;
    }

    private static Expression findValue(List<MemberValuePair> keyValues) {
        for (MemberValuePair curr : keyValues) {
            if (!"value".equals(curr.getName().getIdentifier())) continue;
            return curr.getValue();
        }
        return null;
    }

    private static Annotation findExistingAnnotation(List<? extends ASTNode> modifiers) {
        for (ASTNode aSTNode : modifiers) {
            String fullyQualifiedName;
            Annotation annotation;
            ITypeBinding typeBinding;
            if (!(aSTNode instanceof NormalAnnotation) && !(aSTNode instanceof SingleMemberAnnotation) || !((typeBinding = (annotation = (Annotation)aSTNode).resolveTypeBinding()) != null ? "java.lang.SuppressWarnings".equals(typeBinding.getQualifiedName()) : "SuppressWarnings".equals(fullyQualifiedName = annotation.getTypeName().getFullyQualifiedName()) || "java.lang.SuppressWarnings".equals(fullyQualifiedName))) continue;
            return annotation;
        }
        return null;
    }
}

