/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.BranchStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.StatementWithFinallyBlock;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideStatementWithFinallyBlockFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class YieldStatement
extends BranchStatement {
    public Expression expression;
    public SwitchExpression switchExpression;
    public boolean isImplicit;

    public YieldStatement(Expression expression, boolean isImplicit, int sourceStart, int sourceEnd) {
        super(null, sourceStart, sourceEnd);
        this.expression = expression;
        this.isImplicit = isImplicit;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowContext targetContext = flowContext.getTargetContextForYield(this.isImplicit);
        flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
        this.expression.checkNPEbyUnboxing(currentScope, flowContext, flowInfo);
        targetContext.recordAbruptExit();
        targetContext.expireNullCheckedFieldInfo();
        this.initStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        this.targetLabel = targetContext.breakLabel();
        FlowContext traversedContext = flowContext;
        int finallys = 0;
        this.statementsWithFinallyBlock = new StatementWithFinallyBlock[5];
        do {
            StatementWithFinallyBlock stmt;
            if ((stmt = traversedContext.statementWithFinallyBlock()) != null) {
                if (finallys == this.statementsWithFinallyBlock.length) {
                    this.statementsWithFinallyBlock = new StatementWithFinallyBlock[finallys * 2];
                    System.arraycopy(this.statementsWithFinallyBlock, 0, this.statementsWithFinallyBlock, 0, finallys);
                }
                this.statementsWithFinallyBlock[finallys++] = stmt;
                if (stmt.isFinallyBlockEscaping()) {
                    this.bits |= 0x20000000;
                    break;
                }
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            traversedContext.recordBreakTo(targetContext);
            if (traversedContext instanceof InsideStatementWithFinallyBlockFlowContext) {
                if (!(traversedContext.associatedNode instanceof TryStatement)) continue;
                TryStatement ts = (TryStatement)traversedContext.associatedNode;
                flowInfo.addInitializationsFrom(ts.finallyBlockInits);
                continue;
            }
            if (traversedContext != targetContext) continue;
            targetContext.recordBreakFrom(flowInfo);
            break;
        } while ((traversedContext = traversedContext.getLocalParent()) != null);
        if (finallys != this.statementsWithFinallyBlock.length) {
            this.statementsWithFinallyBlock = new StatementWithFinallyBlock[finallys];
            System.arraycopy(this.statementsWithFinallyBlock, 0, this.statementsWithFinallyBlock, 0, finallys);
        }
        return FlowInfo.DEAD_END;
    }

    private void adjustOperandStackTopIfNeeded(CodeStream codeStream) {
        if (this.expression.resolvedType == TypeBinding.NULL && !this.switchExpression.resolvedType.isBaseType()) {
            codeStream.operandStack.pop(TypeBinding.NULL);
            codeStream.operandStack.push(this.switchExpression.resolvedType);
        }
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.switchExpression != null) {
            this.switchExpression.refillOperandStackIfNeeded(codeStream, this);
        }
        int pc = codeStream.position;
        boolean expressionGenerationDeferred = true;
        if (this.expression.hasSideEffects() || this.statementsWithFinallyBlock.length == 0) {
            expressionGenerationDeferred = false;
            boolean valueRequired = this.switchExpression != null && (this.bits & 0x20000000) == 0;
            this.expression.generateCode(currentScope, codeStream, valueRequired);
            if (valueRequired) {
                this.adjustOperandStackTopIfNeeded(codeStream);
            }
        } else {
            codeStream.nop();
        }
        int i = 0;
        int max = this.statementsWithFinallyBlock.length;
        while (i < max) {
            StatementWithFinallyBlock stmt = this.statementsWithFinallyBlock[i];
            boolean didEscape = stmt.generateFinallyBlock(currentScope, codeStream, this.initStateIndex);
            if (didEscape) {
                codeStream.recordPositionsFrom(pc, this.sourceStart);
                StatementWithFinallyBlock.reenterAllExceptionHandlers(this.statementsWithFinallyBlock, i, codeStream);
                if (this.initStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.initStateIndex);
                    codeStream.addDefinitelyAssignedVariables(currentScope, this.initStateIndex);
                }
                return;
            }
            ++i;
        }
        if (expressionGenerationDeferred) {
            this.expression.generateCode(currentScope, codeStream, this.switchExpression != null);
            this.adjustOperandStackTopIfNeeded(codeStream);
        }
        codeStream.goto_(this.targetLabel);
        if (this.initStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.initStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.initStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
        StatementWithFinallyBlock.reenterAllExceptionHandlers(this.statementsWithFinallyBlock, -1, codeStream);
    }

    @Override
    public void resolve(BlockScope scope) {
        if (this.switchExpression == null) {
            this.switchExpression = this.enclosingSwitchExpression(scope);
            if (this.switchExpression != null && this.switchExpression.isPolyExpression()) {
                this.expression.setExpressionContext(this.switchExpression.expressionContext);
                this.expression.setExpectedType(this.switchExpression.expectedType);
            }
        }
        this.expression.resolveType(scope);
        if (this.switchExpression != null) {
            this.switchExpression.results.add(this.expression);
        }
        if (this.isImplicit) {
            if (this.switchExpression == null && !this.expression.statementExpression()) {
                scope.problemReporter().invalidExpressionAsStatement(this.expression);
            }
        } else if (this.switchExpression == null) {
            scope.problemReporter().yieldOutsideSwitchExpression(this);
        }
    }

    @Override
    public StringBuilder printStatement(int tab, StringBuilder output) {
        if (this.isImplicit) {
            this.expression.print(tab, output);
        } else {
            YieldStatement.printIndent(tab, output).append("yield ");
            this.expression.printExpression(tab, output);
        }
        return output.append(';');
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockscope) {
        if (visitor.visit(this, blockscope)) {
            this.expression.traverse(visitor, blockscope);
        }
        visitor.endVisit(this, blockscope);
    }

    @Override
    public boolean doesNotCompleteNormally() {
        return true;
    }
}

