/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.RGBByteDataset;
import org.eclipse.january.dataset.RGBDataset;
import org.junit.Assert;
import org.junit.Test;

public class DatasetFactoryTest {
    @Test
    public void testZeros() {
        DoubleDataset exp = new DoubleDataset();
        DoubleDataset act = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new int[0]);
        act = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new int[]{3});
        act = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[]{3});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new int[]{0, 0});
        act = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[]{0, 0});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new int[]{3, 4, 5});
        act = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[]{3, 4, 5});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testZerosElemental() {
        DoubleDataset exp = new DoubleDataset();
        DoubleDataset act = (DoubleDataset)DatasetFactory.zeros((int)1, DoubleDataset.class, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new int[0]);
        act = (DoubleDataset)DatasetFactory.zeros((int)1, DoubleDataset.class, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new int[]{3});
        act = (DoubleDataset)DatasetFactory.zeros((int)1, DoubleDataset.class, (int[])new int[]{3});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new int[]{3, 4, 5});
        act = (DoubleDataset)DatasetFactory.zeros((int)1, DoubleDataset.class, (int[])new int[]{3, 4, 5});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testZerosCompound() {
        CompoundDoubleDataset exp = new CompoundDoubleDataset();
        CompoundDoubleDataset act = (CompoundDoubleDataset)DatasetFactory.zeros((int)0, CompoundDoubleDataset.class, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(1);
        act = (CompoundDoubleDataset)DatasetFactory.compoundZeros((int)1, CompoundDoubleDataset.class, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(2);
        act = (CompoundDoubleDataset)DatasetFactory.zeros((int)2, CompoundDoubleDataset.class, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(1, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.compoundZeros((int)1, CompoundDoubleDataset.class, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(2, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.zeros((int)2, CompoundDoubleDataset.class, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(1, new int[]{3});
        act = (CompoundDoubleDataset)DatasetFactory.compoundZeros((int)1, CompoundDoubleDataset.class, (int[])new int[]{3});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(2, new int[]{3});
        act = (CompoundDoubleDataset)DatasetFactory.zeros((int)2, CompoundDoubleDataset.class, (int[])new int[]{3});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(1, new int[]{3, 4, 5});
        act = (CompoundDoubleDataset)DatasetFactory.compoundZeros((int)1, CompoundDoubleDataset.class, (int[])new int[]{3, 4, 5});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(2, new int[]{3, 4, 5});
        act = (CompoundDoubleDataset)DatasetFactory.zeros((int)2, CompoundDoubleDataset.class, (int[])new int[]{3, 4, 5});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testCreator() {
        DoubleDataset exp = new DoubleDataset();
        DoubleDataset act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, null, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[0], null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, null, (int[])new int[]{0});
        TestUtils.assertDatasetEquals((Dataset)exp.reshape(new int[]{0}), (Dataset)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[0], (int[])new int[]{0});
        TestUtils.assertDatasetEquals((Dataset)exp.reshape(new int[]{0}), (Dataset)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[0], (int[])new int[]{0, 0, 0});
        TestUtils.assertDatasetEquals((Dataset)exp.reshape(new int[]{0, 0, 0}), (Dataset)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[0], (int[])new int[]{0, 1, 0});
        TestUtils.assertDatasetEquals((Dataset)exp.reshape(new int[]{0, 1, 0}), (Dataset)act);
        exp = new DoubleDataset(new double[]{3.0}, new int[0]);
        exp.setShape(new int[0]);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)3);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new double[]{3.0, 4.0, 5.0}, new int[0]);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, new int[]{2, 3});
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[][]{{3.0, 4.0, 5.0}, {6.0, 7.0, 8.0}});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testCreatorInteger() {
        IntegerDataset exp = new IntegerDataset();
        IntegerDataset act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, null, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[0], null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new IntegerDataset(new int[]{3}, null);
        exp.setShape(new int[0]);
        act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)3);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new IntegerDataset(new int[]{3, 4, 5}, null);
        act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{3, 4, 5}, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new IntegerDataset(new int[]{3, 4, 5, 6, 7, 8}, new int[]{2, 3});
        act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{3, 4, 5, 6, 7, 8}, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[][]{{3, 4, 5}, {6, 7, 8}});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testCreatorElemental() {
        DoubleDataset exp = new DoubleDataset();
        DoubleDataset act = (DoubleDataset)DatasetFactory.createFromObject((int)1, DoubleDataset.class, null, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new double[]{3.0}, new int[0]);
        exp.setShape(new int[0]);
        act = (DoubleDataset)DatasetFactory.createFromObject((int)1, DoubleDataset.class, (Object)3, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new double[]{3.0, 4.0, 5.0}, new int[0]);
        act = (DoubleDataset)DatasetFactory.createFromObject((int)1, DoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0}, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new DoubleDataset(new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, new int[]{2, 3});
        act = (DoubleDataset)DatasetFactory.createFromObject((int)1, DoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, (int[])new int[]{2, 3});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testCreatorCompound() {
        CompoundDoubleDataset exp = new CompoundDoubleDataset();
        CompoundDoubleDataset act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)0, CompoundDoubleDataset.class, null, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(1);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)1, CompoundDoubleDataset.class, null, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(2);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, null, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(1, new double[]{3.0}, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)1, CompoundDoubleDataset.class, (Object)3.0, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(2, new double[]{3.0, 4.0}, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{3.0, 4.0}, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(1, new double[]{3.0, 4.0, 5.0, 6.0}, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)1, CompoundDoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0}, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(2, new double[]{3.0, 4.0, 5.0, 6.0}, new int[0]);
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0}, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(1, new double[]{3.0, 5.0, 7.0}, new int[]{3, 1});
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)1, CompoundDoubleDataset.class, (Object)new double[]{3.0, 5.0, 7.0}, (int[])new int[]{3, 1});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new CompoundDoubleDataset(2, new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, new int[]{3, 1});
        act = (CompoundDoubleDataset)DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, (int[])new int[]{3, 1});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (CompoundDoubleDataset)DatasetFactory.createCompoundDataset(CompoundDoubleDataset.class, (Object[])new Object[]{new double[]{3.0, 5.0, 7.0}, new double[]{4.0, 6.0, 8.0}});
        act.setShape(new int[]{3, 1});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testCreatorComplex() {
        ComplexDoubleDataset exp = new ComplexDoubleDataset(new double[]{3.0, 5.0, 7.0}, new double[]{4.0, 6.0, 8.0}, new int[]{3, 1});
        ComplexDoubleDataset act = (ComplexDoubleDataset)DatasetFactory.createComplexDataset(ComplexDoubleDataset.class, (Object)new double[]{3.0, 5.0, 7.0}, (Object)new double[]{4.0, 6.0, 8.0});
        act.setShape(new int[]{3, 1});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (ComplexDoubleDataset)DatasetFactory.createFromObject(ComplexDoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0}, (int[])new int[]{3, 1});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (ComplexDoubleDataset)DatasetFactory.createFromObject(ComplexDoubleDataset.class, (Object)new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0});
        act.setShape(new int[]{3, 1});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testRGBDatasetCreator() {
        RGBByteDataset exp = new RGBByteDataset();
        RGBByteDataset act = (RGBByteDataset)DatasetFactory.createFromObject((int)0, RGBByteDataset.class, null, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new RGBByteDataset(new byte[]{3, 4, 5}, new int[0]);
        act = (RGBByteDataset)DatasetFactory.createFromObject((int)2, RGBByteDataset.class, (Object)new byte[]{3, 4, 5}, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new RGBByteDataset(new byte[]{3, 4, 5, 6, 7, 8}, new int[0]);
        act = (RGBByteDataset)DatasetFactory.createFromObject((int)2, RGBByteDataset.class, (Object)new byte[]{3, 4, 5, 6, 7, 8}, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        byte[] byArray = new byte[9];
        byArray[0] = 3;
        byArray[1] = 4;
        byArray[2] = 5;
        byArray[3] = 6;
        byArray[4] = 7;
        byArray[5] = 8;
        byArray[6] = 9;
        byArray[8] = 1;
        exp = new RGBByteDataset(byArray, new int[]{3, 1});
        byte[] byArray2 = new byte[9];
        byArray2[0] = 3;
        byArray2[1] = 4;
        byArray2[2] = 5;
        byArray2[3] = 6;
        byArray2[4] = 7;
        byArray2[5] = 8;
        byArray2[6] = 9;
        byArray2[8] = 1;
        act = (RGBByteDataset)DatasetFactory.createFromObject((int)2, RGBByteDataset.class, (Object)byArray2, (int[])new int[]{3, 1});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new RGBByteDataset(new byte[]{3, 4, 5, 6, 7, 8}, new int[0]);
        act = (RGBByteDataset)DatasetFactory.createFromObject(RGBByteDataset.class, (Object)new byte[]{3, 4, 5, 6, 7, 8});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testRGBCreator() {
        RGBDataset exp = new RGBDataset();
        RGBDataset act = (RGBDataset)DatasetFactory.createFromObject((int)0, RGBDataset.class, null, null);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new RGBDataset(new short[]{3, 4, 5}, new int[0]);
        act = (RGBDataset)DatasetFactory.createFromObject((int)2, RGBDataset.class, (Object)new short[]{3, 4, 5}, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new RGBDataset(new short[]{3, 4, 5, 6, 7, 8}, new int[0]);
        act = (RGBDataset)DatasetFactory.createFromObject((int)2, RGBDataset.class, (Object)new short[]{3, 4, 5, 6, 7, 8}, (int[])new int[0]);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        short[] sArray = new short[9];
        sArray[0] = 3;
        sArray[1] = 4;
        sArray[2] = 5;
        sArray[3] = 6;
        sArray[4] = 7;
        sArray[5] = 8;
        sArray[6] = 9;
        sArray[8] = 1;
        exp = new RGBDataset(sArray, new int[]{3, 1});
        short[] sArray2 = new short[9];
        sArray2[0] = 3;
        sArray2[1] = 4;
        sArray2[2] = 5;
        sArray2[3] = 6;
        sArray2[4] = 7;
        sArray2[5] = 8;
        sArray2[6] = 9;
        sArray2[8] = 1;
        act = (RGBDataset)DatasetFactory.createFromObject((int)2, RGBDataset.class, (Object)sArray2, (int[])new int[]{3, 1});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        exp = new RGBDataset(new short[]{3, 4, 5, 6, 7, 8}, new int[0]);
        act = (RGBDataset)DatasetFactory.createFromObject(RGBDataset.class, (Object)new short[]{3, 4, 5, 6, 7, 8});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testCreatorDataset() {
        Dataset a = DatasetFactory.createRange((double)10.0).reshape(new int[]{5, 2});
        Dataset act = DatasetFactory.createFromObject((Object)new IDataset[]{a, a, a});
        Assert.assertEquals((long)3L, (long)act.getRank());
        Assert.assertArrayEquals((int[])new int[]{3, 5, 2}, (int[])act.getShapeRef());
        Dataset b = a.reshape(new int[]{1, 5, 2});
        Dataset exp = DatasetUtils.concatenate((IDataset[])new IDataset[]{b, b, b}, (int)0);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        list.add(a);
        list.add(a);
        list.add(a);
        act = DatasetFactory.createFromObject(list);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = DatasetFactory.createFromList(list);
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testLinearSpace() {
        DoubleDataset act = (DoubleDataset)DatasetFactory.createLinearSpace(DoubleDataset.class, (double)2.0, (double)12.4, (int)4);
        Dataset exp = DatasetFactory.createFromObject((Object)new double[]{2.0, 5.466666666666667, 8.933333333333334, 12.4});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
        act = (DoubleDataset)DatasetFactory.createLinearSpace(DoubleDataset.class, (double)12.4, (double)2.0, (int)4);
        exp = DatasetFactory.createFromObject((Object)new double[]{12.4, 8.933333333333334, 5.466666666666667, 2.0});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act);
    }

    @Test
    public void testLogSpace() {
        DoubleDataset act = (DoubleDataset)DatasetFactory.createLogSpace(DoubleDataset.class, (double)2.0, (double)3.6, (int)4, (double)3.5);
        Dataset exp = DatasetFactory.createFromObject((Object)new double[]{12.25, 23.89492724, 46.60959572, 90.91697129});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act, (double)1.0E-9, (double)1.0E-9);
        act = (DoubleDataset)DatasetFactory.createLogSpace(DoubleDataset.class, (double)3.6, (double)2.0, (int)4, (double)3.5);
        exp = DatasetFactory.createFromObject((Object)new double[]{90.91697129, 46.60959572, 23.89492724, 12.25});
        TestUtils.assertDatasetEquals((Dataset)exp, (Dataset)act, (double)1.0E-9, (double)1.0E-9);
    }
}

