/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.january.DatasetException;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.RunningAverage;
import org.eclipse.january.dataset.ShapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazyMaths {
    protected static final Logger logger = LoggerFactory.getLogger(LazyMaths.class);

    public static Dataset sum(ILazyDataset data, int axis) throws DatasetException {
        if (data instanceof Dataset) {
            return ((Dataset)data).sum(axis, new boolean[0]);
        }
        int[][] sliceInfo = new int[3][];
        int[] shape = data.getShape();
        Dataset result = LazyMaths.prepareDataset(axis, shape, sliceInfo);
        int[] start = sliceInfo[0];
        int[] stop = sliceInfo[1];
        int[] step = sliceInfo[2];
        int length = shape[axis];
        int i = 0;
        while (i < length) {
            start[axis] = i;
            stop[axis] = i + 1;
            result.iadd(data.getSlice(start, stop, step));
            ++i;
        }
        result.setShape(ShapeUtils.squeezeShape(shape, axis));
        return result;
    }

    public static Dataset sum(ILazyDataset data, int ... ignoreAxes) throws DatasetException {
        return LazyMaths.sum(data, true, ignoreAxes);
    }

    public static Dataset sum(ILazyDataset data, boolean ignore, int ... axes) throws DatasetException {
        Arrays.sort(axes);
        ILazyDataset rv = data;
        if (ignore) {
            ArrayList<Integer> goodAxes = new ArrayList<Integer>();
            int i = 0;
            while (i < data.getRank()) {
                boolean found = false;
                int j = 0;
                while (j < axes.length) {
                    if (i == axes[j]) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    goodAxes.add(i);
                }
                ++i;
            }
            i = 0;
            while (i < goodAxes.size()) {
                rv = LazyMaths.sum(rv, (Integer)goodAxes.get(i) - i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < axes.length) {
                rv = LazyMaths.sum(rv, axes[i] - i);
                ++i;
            }
        }
        return DatasetUtils.sliceAndConvertLazyDataset(rv);
    }

    public static Dataset product(ILazyDataset data, int axis) throws DatasetException {
        int[][] sliceInfo = new int[3][];
        int[] shape = data.getShape();
        Dataset result = LazyMaths.prepareDataset(axis, shape, sliceInfo);
        result.fill(1);
        int[] start = sliceInfo[0];
        int[] stop = sliceInfo[1];
        int[] step = sliceInfo[2];
        int length = shape[axis];
        int i = 0;
        while (i < length) {
            start[axis] = i;
            stop[axis] = i + 1;
            result.imultiply(data.getSlice(start, stop, step));
            ++i;
        }
        result.setShape(ShapeUtils.squeezeShape(shape, axis));
        return result;
    }

    public static Dataset mean(int start, int stop, ILazyDataset data, int ... ignoreAxes) throws DatasetException {
        int[] shape = data.getShape();
        PositionIterator iter = new PositionIterator(shape, ignoreAxes);
        int[] pos = iter.getPos();
        boolean[] omit = iter.getOmit();
        int rank = shape.length;
        int[] st = new int[rank];
        Arrays.fill(st, 1);
        int[] end = new int[rank];
        RunningAverage av = null;
        int c = 0;
        while (iter.hasNext() && c < stop) {
            if (c++ < start) continue;
            int i = 0;
            while (i < rank) {
                end[i] = omit[i] ? shape[i] : pos[i] + 1;
                ++i;
            }
            IDataset ds = data.getSlice(pos, end, st);
            if (av == null) {
                av = new RunningAverage(ds);
                continue;
            }
            av.update(ds);
        }
        return av != null ? av.getCurrentAverage().squeeze() : null;
    }

    public static Dataset mean(ILazyDataset data, int ... ignoreAxes) throws DatasetException {
        return LazyMaths.mean(0, 0x7FFFFFFE, data, ignoreAxes);
    }

    private static Dataset prepareDataset(int axis, int[] shape, int[][] sliceInfo) {
        int rank = shape.length;
        if (axis < 0) {
            axis += rank;
        }
        if (axis < 0 || axis >= rank) {
            logger.error("Axis argument is outside allowed range");
            throw new IllegalArgumentException("Axis argument is outside allowed range");
        }
        sliceInfo[0] = new int[rank];
        sliceInfo[1] = (int[])shape.clone();
        sliceInfo[2] = new int[rank];
        Arrays.fill(sliceInfo[2], 1);
        int[] nshape = (int[])shape.clone();
        nshape[axis] = 1;
        return DatasetFactory.zeros(nshape, 6);
    }
}

