/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.PositionIterator;
import org.junit.Assert;
import org.junit.Test;

public class PositionIteratorTest {
    @Test
    public void testIterations() {
        int size = 1024;
        int type = 6;
        this.testIterationND(size, type);
        type = 8;
        this.testIterationND(size, type);
    }

    @Test
    public void testOffsetIteration() {
        int size = 0x900000;
        int type = 6;
        Dataset ta = DatasetFactory.createRange((double)0.0, (double)size, (double)1.0, (int)type).reshape(new int[]{3, 3, 1024, 1024});
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 1;
        int[] start = nArray;
        int[] stop = new int[]{3, 3, 1024, 1024};
        int[] step = new int[]{1, 1, 1, 1};
        int[] axes = new int[]{2, 3};
        this.testDatasetAxes(ta, axes, start, stop, step);
    }

    private void testIterationND(int size, int type) {
        TestUtils.verbosePrintf((String)"Size: %d\n", (Object[])new Object[]{size});
        Dataset ta = DatasetFactory.createRange((double)0.0, (double)size, (double)1.0, (int)type);
        this.testDataset(ta);
        ta = DatasetFactory.createRange((double)0.0, (double)size, (double)1.0, (int)type).reshape(new int[]{16, size / 16});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        this.testDataset(ta);
        this.testDatasetAxes(ta, new int[1]);
        this.testDatasetAxes(ta, new int[]{1});
        ta = DatasetFactory.createRange((double)0.0, (double)size, (double)1.0, (int)type).reshape(new int[]{size / 32, 32});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        this.testDataset(ta);
        this.testDatasetAxes(ta, new int[1]);
        this.testDatasetAxes(ta, new int[]{1});
        ta = DatasetFactory.createRange((double)0.0, (double)size, (double)1.0, (int)type).reshape(new int[]{16, 8, size / 128});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        this.testDataset(ta);
        this.testDatasetAxes(ta, new int[1]);
        this.testDatasetAxes(ta, new int[]{2});
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.testDatasetAxes(ta, nArray);
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        this.testDatasetAxes(ta, nArray2);
        ta = DatasetFactory.createRange((double)0.0, (double)size, (double)1.0, (int)type).reshape(new int[]{size / 128, 16, 8});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        this.testDataset(ta);
        this.testDatasetAxes(ta, new int[1]);
        this.testDatasetAxes(ta, new int[]{2});
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        this.testDatasetAxes(ta, nArray3);
        int[] nArray4 = new int[2];
        nArray4[1] = 2;
        this.testDatasetAxes(ta, nArray4);
    }

    private void testDataset(Dataset ta) {
        PositionIterator iter = ta.getPositionIterator(new int[0]);
        int[] pos = iter.getPos();
        Assert.assertArrayEquals((int[])ta.getShapeRef(), (int[])iter.getShape());
        int i = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((double)i, (double)ta.getDouble(pos), (double)(1.0E-5 * (double)i));
            ++i;
        }
    }

    private void testDatasetAxes(Dataset ta, int[] axes) {
        int[] shape = ta.getShapeRef();
        int rank = shape.length;
        int[] step = new int[rank];
        Arrays.fill(step, 1);
        int[] start = new int[rank];
        int[] stop = (int[])shape.clone();
        this.testDatasetAxes(ta, axes, start, stop, step);
    }

    private void testDatasetAxes(Dataset ta, int[] axes, int[] start, int[] stop, int[] step) {
        int[] shape = ta.getShapeRef();
        PositionIterator iter = new PositionIterator(shape, start, stop, step, axes);
        int[] pos = iter.getPos();
        int endrank = shape.length - 1;
        int[] tpos = (int[])start.clone();
        int i = 0;
        while (i < axes.length) {
            step[axes[i]] = 0;
            ++i;
        }
        i = 0;
        while (i <= endrank) {
            int s = iter.getShape()[i];
            if (step[i] > 0) {
                Assert.assertEquals((long)s, (long)((stop[i] - start[i] - 1) / step[i] + 1));
            } else if (step[i] < 0) {
                Assert.assertEquals((long)s, (long)((stop[i] - start[i] + 1) / step[i] + 1));
            } else {
                Assert.assertEquals((long)s, (long)1L);
            }
            ++i;
        }
        block2: while (iter.hasNext()) {
            int j = 0;
            while (j <= endrank) {
                Assert.assertEquals((String)("  Axes: " + Arrays.toString(axes) + "; shape: " + Arrays.toString(shape) + "; dim " + j), (double)tpos[j], (double)pos[j], (double)(1.0E-5 * (double)tpos[j]));
                ++j;
            }
            j = endrank;
            while (j >= 0) {
                if (step[j] > 0) {
                    int n = j;
                    tpos[n] = tpos[n] + step[j];
                    if (tpos[j] < stop[j]) continue block2;
                    tpos[j] = start[j];
                }
                --j;
            }
        }
    }
}

