/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DateDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.StringDataset;
import org.eclipse.january.dataset.StringDatasetBase;

public class DateDatasetImpl
extends StringDataset
implements DateDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final SimpleDateFormat ISO8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    static DateDatasetImpl createFromObject(Object obj) {
        DateDatasetImpl result = new DateDatasetImpl();
        result.shape = ShapeUtils.getShapeFromObject(obj);
        result.size = ShapeUtils.calcSize(result.shape);
        result.data = DateDatasetImpl.createArray(result.size);
        result.odata = result.data;
        int[] pos = new int[result.shape.length];
        result.fillData(obj, 0, pos);
        return result;
    }

    DateDatasetImpl() {
    }

    DateDatasetImpl(int ... shape) {
        super(shape);
    }

    DateDatasetImpl(Date[] data, int ... shape) {
        super(DateDatasetImpl.datesToStrings(data), shape);
    }

    private static String[] datesToStrings(Date[] dates) {
        String[] dateStrings = new String[dates.length];
        int i = 0;
        while (i < dates.length) {
            dateStrings[i] = DateDatasetImpl.dateToString(dates[i]);
            ++i;
        }
        return dateStrings;
    }

    private static String dateToString(Date date) {
        if (date != null) {
            return ISO8601_DATE_FORMAT.format(date);
        }
        return null;
    }

    private static String objectToDateString(Object obj) {
        if (obj instanceof Date) {
            return DateDatasetImpl.dateToString((Date)obj);
        }
        if (obj instanceof Dataset) {
            Dataset dataset = (Dataset)obj;
            if (dataset.getSize() != 1) {
                logger.error("Given dataset must only have one item");
                throw new IllegalArgumentException("Given dataset must have only one item");
            }
            return DateDatasetImpl.objectToDateString(dataset.getObjectAbs(0));
        }
        if (obj instanceof IDataset) {
            IDataset dataset = (IDataset)obj;
            if (dataset.getSize() != 1) {
                logger.error("Given dataset must only have one item");
                throw new IllegalArgumentException("Given dataset must have only one item");
            }
            return DateDatasetImpl.objectToDateString(dataset.getObject(new int[dataset.getRank()]));
        }
        logger.error("Argument is of unsupported class");
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    private static Date stringToDate(String dateAsString) {
        if (dateAsString != null) {
            try {
                return ISO8601_DATE_FORMAT.parse(dateAsString);
            }
            catch (ParseException parseException) {
                logger.error("Could not parse datetime: " + dateAsString);
            }
        }
        return null;
    }

    @Override
    public Date getDate() {
        String dateAsString = super.getString();
        return DateDatasetImpl.stringToDate(dateAsString);
    }

    @Override
    public Date getDate(int i) {
        String dateAsString = super.getString(i);
        return DateDatasetImpl.stringToDate(dateAsString);
    }

    @Override
    public Date getDate(int i, int j) {
        String dateAsString = super.getString(i, j);
        return DateDatasetImpl.stringToDate(dateAsString);
    }

    @Override
    public Date getDate(int ... pos) {
        String dateAsString = super.getString(pos);
        return DateDatasetImpl.stringToDate(dateAsString);
    }

    @Override
    public Date getDateAbs(int index) {
        String dateAsString = super.getStringAbs(index);
        if (dateAsString != null) {
            return DateDatasetImpl.stringToDate(dateAsString);
        }
        return null;
    }

    @Override
    public void setItemDirect(int dindex, int sindex, Object src) {
        if (src instanceof String[]) {
            super.setItemDirect(dindex, sindex, src);
        } else if (src instanceof Date[]) {
            String[] datesAsStrings = DateDatasetImpl.datesToStrings((Date[])src);
            this.data[dindex] = datesAsStrings[sindex];
        } else {
            logger.error("Argument is of unsupported class");
            throw new IllegalArgumentException("Argument is of unsupported class");
        }
    }

    public void setAbs(int index, Date date) {
        this.data[index] = DateDatasetImpl.dateToString(date);
        this.setDirty();
    }

    public void setItem(Date value) {
        this.setAbs(this.getFirst1DIndex(), value);
    }

    public void setItem(Date value, int i) {
        this.setAbs(this.get1DIndex(i), value);
    }

    public void setItem(Date value, int i, int j) {
        this.setAbs(this.get1DIndex(i, j), value);
    }

    public void setItem(Date value, int ... pos) {
        this.setAbs(this.get1DIndex(pos), value);
    }

    @Override
    public void set(Object obj) {
        this.setItem(DateDatasetImpl.objectToDateString(obj));
    }

    @Override
    public void set(Object obj, int i) {
        this.setItem(DateDatasetImpl.objectToDateString(obj), i);
    }

    @Override
    public void set(Object obj, int i, int j) {
        this.setItem(DateDatasetImpl.objectToDateString(obj), i, j);
    }

    @Override
    public void set(Object obj, int ... pos) {
        if (pos == null || pos.length == 0 && this.shape.length > 0) {
            pos = new int[this.shape.length];
        }
        this.setItem(DateDatasetImpl.objectToDateString(obj), pos);
    }

    @Override
    public StringDatasetBase sort(Integer axis) {
        throw new UnsupportedOperationException("Cannot sort dataset");
    }

    static /* bridge */ /* synthetic */ StringDataset createFromObject(Object object) {
        return DateDatasetImpl.createFromObject(object);
    }
}

