/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.SliceIterator;
import org.eclipse.january.dataset.SliceND;

public class StrideIterator
extends SliceIterator {
    private int[] stride;
    private int[] delta;
    private int nstart;
    private int element;

    public StrideIterator(int[] shape) {
        this(shape, null, 0);
    }

    public StrideIterator(int isize, int[] shape) {
        this(isize, shape, null, 0);
    }

    public StrideIterator(int[] shape, int[] strides) {
        this(shape, strides, 0);
    }

    public StrideIterator(int[] shape, int[] strides, int offset) {
        this(1, shape, strides, offset);
    }

    public StrideIterator(int isize, int[] shape, int[] strides, int offset) {
        this(isize, shape, strides, offset, 0);
    }

    public StrideIterator(int isize, int[] shape, int[] strides, int offset, int element) {
        this.init(isize, shape, strides, offset, element);
        this.reset();
    }

    public StrideIterator(int isize, int[] shape, int[] start, int[] stop, int[] step) {
        this(isize, shape, null, 0, start, stop, step);
    }

    public StrideIterator(int isize, int[] shape, int[] oStrides, int oOffset, int[] start, int[] stop, int[] step) {
        this(isize, shape, oStrides, oOffset, new SliceND(shape, start, stop, step));
    }

    public StrideIterator(int isize, int[] shape, int[] oStrides, int oOffset, SliceND slice) {
        int rank = shape.length;
        int[] strides = new int[rank];
        int[] offset = new int[1];
        int[] newShape = AbstractDataset.createStrides(slice, isize, shape, oStrides, oOffset, strides, offset);
        this.init(isize, newShape, strides, offset[0], 0);
        this.reset();
    }

    private void init(int isize, int[] shape, int[] strides, int offset, int element) {
        this.isize = isize;
        this.istep = isize;
        this.shape = shape;
        int rank = shape.length;
        this.endrank = rank - 1;
        this.pos = new int[rank];
        this.delta = new int[rank];
        this.element = element;
        if (strides != null) {
            this.stride = strides;
            int j = this.endrank;
            while (j >= 0) {
                this.delta[j] = this.stride[j] * shape[j];
                --j;
            }
        } else {
            this.stride = new int[rank];
            int s = isize;
            int j = this.endrank;
            while (j >= 0) {
                this.stride[j] = s;
                this.delta[j] = s *= shape[j];
                --j;
            }
            this.imax = s;
        }
        this.nstart = offset;
    }

    @Override
    void calcGap() {
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean hasNext() {
        j = this.endrank;
        if (j >= 0) ** GOTO lbl13
        this.index += this.istep;
        return this.index < this.istep;
lbl-1000:
        // 1 sources

        {
            this.index += this.stride[j];
            p = this.pos[j] + 1;
            if (p < this.shape[j]) {
                this.pos[j] = p;
                break;
            }
            this.pos[j] = 0;
            this.index -= this.delta[j];
            --j;
lbl13:
            // 2 sources

            ** while (j >= 0)
        }
lbl14:
        // 2 sources

        return j >= 0;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    @Override
    public void reset() {
        Arrays.fill(this.pos, 0);
        if (this.endrank >= 0) {
            this.pos[this.endrank] = -1;
            this.index = this.nstart - this.stride[this.endrank];
        } else {
            this.index = -this.istep;
        }
        this.index += this.element;
    }
}

