/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.List;
import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.Dataset;

public class BroadcastPairIterator
extends BroadcastIterator {
    private int[] aShape;
    private int[] bShape;
    private int[] aStride;
    private int[] bStride;
    private int[] oStride;
    private final int endrank;
    private final int[] aDelta;
    private final int[] bDelta;
    private final int[] oDelta;
    private final int aStep;
    private final int bStep;
    private final int oStep;
    private int aMax;
    private int bMax;
    private int aStart;
    private int bStart;
    private int oStart;

    public BroadcastPairIterator(Dataset a, Dataset b, Dataset o, boolean createIfNull) {
        super(a, b, o);
        List<int[]> fullShapes = BroadcastUtils.broadcastShapes(a.getShapeRef(), b.getShapeRef(), o == null ? null : o.getShapeRef());
        this.maxShape = fullShapes.remove(0);
        this.oStride = null;
        if (o != null && !Arrays.equals(this.maxShape, o.getShapeRef())) {
            throw new IllegalArgumentException("Output does not match broadcasted shape");
        }
        this.aShape = fullShapes.remove(0);
        this.bShape = fullShapes.remove(0);
        int rank = this.maxShape.length;
        this.endrank = rank - 1;
        this.aDataset = a.reshape(this.aShape);
        this.bDataset = b.reshape(this.bShape);
        this.aStride = BroadcastUtils.createBroadcastStrides(this.aDataset, this.maxShape);
        this.bStride = BroadcastUtils.createBroadcastStrides(this.bDataset, this.maxShape);
        if (this.outputA) {
            this.oStride = this.aStride;
            this.oDelta = null;
            this.oStep = 0;
        } else if (this.outputB) {
            this.oStride = this.bStride;
            this.oDelta = null;
            this.oStep = 0;
        } else if (o != null) {
            this.oStride = BroadcastUtils.createBroadcastStrides(o, this.maxShape);
            this.oDelta = new int[rank];
            this.oStep = o.getElementsPerItem();
        } else if (createIfNull) {
            this.oDataset = BroadcastUtils.createDataset(a, b, this.maxShape);
            this.oStride = BroadcastUtils.createBroadcastStrides(this.oDataset, this.maxShape);
            this.oDelta = new int[rank];
            this.oStep = this.oDataset.getElementsPerItem();
        } else {
            this.oDelta = null;
            this.oStep = 0;
        }
        this.pos = new int[rank];
        this.aDelta = new int[rank];
        this.aStep = this.aDataset.getElementsPerItem();
        this.bDelta = new int[rank];
        this.bStep = this.bDataset.getElementsPerItem();
        int j = this.endrank;
        while (j >= 0) {
            this.aDelta[j] = this.aStride[j] * this.aShape[j];
            this.bDelta[j] = this.bStride[j] * this.bShape[j];
            if (this.oDelta != null) {
                this.oDelta[j] = this.oStride[j] * this.maxShape[j];
            }
            --j;
        }
        if (this.endrank < 0) {
            this.aMax = this.aStep;
            this.bMax = this.bStep;
        } else {
            this.aMax = Integer.MIN_VALUE;
            this.bMax = Integer.MIN_VALUE;
            j = this.endrank;
            while (j >= 0) {
                if (this.aDelta[j] > this.aMax) {
                    this.aMax = this.aDelta[j];
                }
                if (this.bDelta[j] > this.bMax) {
                    this.bMax = this.bDelta[j];
                }
                --j;
            }
        }
        this.aStart = this.aDataset.getOffset();
        this.aMax += this.aStart;
        this.bStart = this.bDataset.getOffset();
        this.bMax += this.bStart;
        this.oStart = this.oDelta == null ? 0 : this.oDataset.getOffset();
        this.reset();
    }

    @Override
    public boolean hasNext() {
        int j = this.endrank;
        int oldA = this.aIndex;
        int oldB = this.bIndex;
        while (j >= 0) {
            int n = j;
            this.pos[n] = this.pos[n] + 1;
            this.aIndex += this.aStride[j];
            this.bIndex += this.bStride[j];
            if (this.oDelta != null) {
                this.oIndex += this.oStride[j];
            }
            if (this.pos[j] < this.maxShape[j]) break;
            this.pos[j] = 0;
            this.aIndex -= this.aDelta[j];
            this.bIndex -= this.bDelta[j];
            if (this.oDelta != null) {
                this.oIndex -= this.oDelta[j];
            }
            --j;
        }
        if (j == -1) {
            if (this.endrank >= 0) {
                this.aIndex = this.aMax;
                this.bIndex = this.bMax;
                return false;
            }
            this.aIndex += this.aStep;
            this.bIndex += this.bStep;
            if (this.oDelta != null) {
                this.oIndex += this.oStep;
            }
        }
        if (this.outputA) {
            this.oIndex = this.aIndex;
        } else if (this.outputB) {
            this.oIndex = this.bIndex;
        }
        if (this.aIndex == this.aMax || this.bIndex == this.bMax) {
            return false;
        }
        if (this.read) {
            if (oldA != this.aIndex) {
                if (this.asDouble) {
                    this.aDouble = this.aDataset.getElementDoubleAbs(this.aIndex);
                } else {
                    this.aLong = this.aDataset.getElementLongAbs(this.aIndex);
                }
            }
            if (oldB != this.bIndex) {
                if (this.asDouble) {
                    this.bDouble = this.bDataset.getElementDoubleAbs(this.bIndex);
                } else {
                    this.bLong = this.bDataset.getElementLongAbs(this.bIndex);
                }
            }
        }
        return true;
    }

    public int[] getFirstShape() {
        return this.aShape;
    }

    public int[] getSecondShape() {
        return this.bShape;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i <= this.endrank) {
            this.pos[i] = 0;
            ++i;
        }
        if (this.endrank >= 0) {
            this.pos[this.endrank] = -1;
            this.aIndex = this.aStart - this.aStride[this.endrank];
            this.bIndex = this.bStart - this.bStride[this.endrank];
            this.oIndex = this.oStart - (this.oStride == null ? 0 : this.oStride[this.endrank]);
        } else {
            this.aIndex = this.aStart - this.aStep;
            this.bIndex = this.bStart - this.bStep;
            this.oIndex = this.oStart - this.oStep;
        }
        if (this.aIndex == 0 || this.bIndex == 0) {
            if (this.read) {
                this.storeCurrentValues();
            }
            if (this.aMax == this.aIndex) {
                ++this.aMax;
            }
            if (this.bMax == this.bIndex) {
                ++this.bMax;
            }
        }
    }
}

