/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.DatasetException;
import org.eclipse.january.IMonitor;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.ContiguousIterator;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.SingleItemIterator;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.dataset.StrideIterator;
import org.eclipse.january.metadata.StatisticsMetadata;
import org.eclipse.january.metadata.internal.StatisticsMetadataImpl;

public abstract class AbstractCompoundDataset
extends AbstractDataset
implements CompoundDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    protected int isize;

    @Override
    public int getElementsPerItem() {
        return this.isize;
    }

    @Override
    protected int get1DIndex(int i) {
        int n = super.get1DIndex(i);
        return this.stride == null ? this.isize * n : n;
    }

    @Override
    protected int get1DIndex(int i, int j) {
        int n = super.get1DIndex(i, j);
        return this.stride == null ? this.isize * n : n;
    }

    @Override
    protected int get1DIndexFromShape(int[] n) {
        return this.isize * super.get1DIndexFromShape(n);
    }

    @Override
    public Dataset getUniqueItems() {
        throw new UnsupportedOperationException("Cannot sort compound datasets");
    }

    @Override
    public IndexIterator getIterator(boolean withPosition) {
        if (this.stride != null) {
            return this.base.getSize() == 1 ? (withPosition ? new PositionIterator(this.offset, this.shape) : new SingleItemIterator(this.offset, this.size)) : new StrideIterator(this.isize, this.shape, this.stride, this.offset);
        }
        return withPosition ? this.getSliceIterator(null, null, null) : new ContiguousIterator(this.size, this.isize);
    }

    public IndexIterator getIterator(int element) {
        if (element < 0) {
            element += this.isize;
        }
        if (element < 0 || element > this.isize) {
            logger.error("Invalid choice of element: {}/{}", (Object)element, (Object)this.isize);
            throw new IllegalArgumentException("Invalid choice of element: " + element + "/" + this.isize);
        }
        IndexIterator it = this.stride != null ? (this.base.getSize() == 1 ? new SingleItemIterator(this.offset + element, this.size) : new StrideIterator(this.isize, this.shape, this.stride, this.offset, element)) : new ContiguousIterator(this.size, this.isize, element);
        return it;
    }

    @Override
    public IndexIterator getSliceIterator(SliceND slice) {
        if (this.stride != null) {
            return new StrideIterator(this.isize, this.shape, this.stride, this.offset, slice);
        }
        return new SliceIterator(this.shape, this.size, this.isize, slice);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CompoundDataset other = (CompoundDataset)obj;
        return this.isize == other.getElementsPerItem();
    }

    @Override
    public int hashCode() {
        return this.getCompoundStats().getHash(this.shape);
    }

    @Override
    public CompoundDataset cast(boolean repeat, int dtype, int isize) {
        return (CompoundDataset)super.cast(repeat, dtype, isize);
    }

    @Override
    public CompoundDataset cast(int dtype) {
        return (CompoundDataset)super.cast(dtype);
    }

    @Override
    public abstract AbstractCompoundDataset clone();

    @Override
    public CompoundDataset flatten() {
        return (CompoundDataset)super.flatten();
    }

    @Override
    public CompoundDataset getBy1DIndex(IntegerDataset index) {
        return (CompoundDataset)super.getBy1DIndex(index);
    }

    @Override
    public CompoundDataset getByBoolean(Dataset selection) {
        return (CompoundDataset)super.getByBoolean(selection);
    }

    @Override
    public CompoundDataset getByIndexes(Object ... indexes) {
        return (CompoundDataset)super.getByIndexes(indexes);
    }

    @Override
    public CompoundDataset getSlice(IMonitor mon, int[] start, int[] stop, int[] step) {
        return (CompoundDataset)super.getSlice(mon, start, stop, step);
    }

    @Override
    public CompoundDataset getSlice(IMonitor mon, Slice ... slice) {
        return (CompoundDataset)super.getSlice(mon, slice);
    }

    @Override
    public CompoundDataset getSlice(IMonitor mon, SliceND slice) {
        return (CompoundDataset)super.getSlice(mon, slice);
    }

    @Override
    public CompoundDataset getSlice(int[] start, int[] stop, int[] step) {
        return (CompoundDataset)super.getSlice(start, stop, step);
    }

    @Override
    public CompoundDataset getSlice(Slice ... slice) {
        return (CompoundDataset)super.getSlice(slice);
    }

    @Override
    public CompoundDataset getSlice(SliceND slice) {
        return (CompoundDataset)super.getSlice(slice);
    }

    @Override
    public abstract AbstractCompoundDataset getSlice(SliceIterator var1);

    @Override
    public CompoundDataset getSliceView(int[] start, int[] stop, int[] step) {
        return (CompoundDataset)super.getSliceView(start, stop, step);
    }

    @Override
    public CompoundDataset getSliceView(Slice ... slice) {
        return (CompoundDataset)super.getSliceView(slice);
    }

    @Override
    public CompoundDataset getSliceView(SliceND slice) {
        return (CompoundDataset)super.getSliceView(slice);
    }

    @Override
    public CompoundDataset getTransposedView(int ... axes) {
        return (CompoundDataset)super.getTransposedView(axes);
    }

    @Override
    public abstract AbstractCompoundDataset getView(boolean var1);

    @Override
    public CompoundDataset getBroadcastView(int ... broadcastShape) {
        return (CompoundDataset)super.getBroadcastView(broadcastShape);
    }

    @Override
    public CompoundDataset ifloorDivide(Object o) {
        return (CompoundDataset)super.ifloorDivide(o);
    }

    @Override
    public CompoundDataset reshape(int ... shape) {
        return (CompoundDataset)super.reshape(shape);
    }

    @Override
    public CompoundDataset setSlice(Object obj, int[] start, int[] stop, int[] step) {
        return (CompoundDataset)super.setSlice(obj, start, stop, step);
    }

    @Override
    public CompoundDataset setSlice(Object object, Slice ... slice) {
        return (CompoundDataset)super.setSlice(object, slice);
    }

    @Override
    public CompoundDataset sort(Integer axis) {
        throw new UnsupportedOperationException("Cannot sort dataset");
    }

    @Override
    public CompoundDataset squeezeEnds() {
        return (CompoundDataset)super.squeezeEnds();
    }

    @Override
    public CompoundDataset squeeze() {
        return (CompoundDataset)super.squeeze();
    }

    @Override
    public CompoundDataset squeeze(boolean onlyFromEnd) {
        return (CompoundDataset)super.squeeze(onlyFromEnd);
    }

    @Override
    public CompoundDataset swapAxes(int axis1, int axis2) {
        return (CompoundDataset)super.swapAxes(axis1, axis2);
    }

    @Override
    public synchronized CompoundDataset synchronizedCopy() {
        return this.clone();
    }

    @Override
    public CompoundDataset transpose(int ... axes) {
        return (CompoundDataset)super.transpose(axes);
    }

    protected abstract double getFirstValue();

    protected abstract double getFirstValue(int var1);

    protected abstract double getFirstValue(int var1, int var2);

    protected abstract double getFirstValue(int ... var1);

    @Override
    public boolean getBoolean() {
        return this.getFirstValue() != 0.0;
    }

    @Override
    public boolean getBoolean(int i) {
        return this.getFirstValue(i) != 0.0;
    }

    @Override
    public boolean getBoolean(int i, int j) {
        return this.getFirstValue(i, j) != 0.0;
    }

    @Override
    public boolean getBoolean(int ... pos) {
        return this.getFirstValue(pos) != 0.0;
    }

    @Override
    public byte getByte() {
        return (byte)this.getFirstValue();
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.getFirstValue(i);
    }

    @Override
    public byte getByte(int i, int j) {
        return (byte)this.getFirstValue(i, j);
    }

    @Override
    public byte getByte(int ... pos) {
        return (byte)this.getFirstValue(pos);
    }

    @Override
    public short getShort() {
        return (short)this.getFirstValue();
    }

    @Override
    public short getShort(int i) {
        return (short)this.getFirstValue(i);
    }

    @Override
    public short getShort(int i, int j) {
        return (short)this.getFirstValue(i, j);
    }

    @Override
    public short getShort(int ... pos) {
        return (short)this.getFirstValue(pos);
    }

    @Override
    public int getInt() {
        return (int)this.getFirstValue();
    }

    @Override
    public int getInt(int i) {
        return (int)this.getFirstValue(i);
    }

    @Override
    public int getInt(int i, int j) {
        return (int)this.getFirstValue(i, j);
    }

    @Override
    public int getInt(int ... pos) {
        return (int)this.getFirstValue(pos);
    }

    @Override
    public long getLong() {
        return (long)this.getFirstValue();
    }

    @Override
    public long getLong(int i) {
        return (long)this.getFirstValue(i);
    }

    @Override
    public long getLong(int i, int j) {
        return (long)this.getFirstValue(i, j);
    }

    @Override
    public long getLong(int ... pos) {
        return (long)this.getFirstValue(pos);
    }

    @Override
    public float getFloat() {
        return (float)this.getFirstValue();
    }

    @Override
    public float getFloat(int i) {
        return (float)this.getFirstValue(i);
    }

    @Override
    public float getFloat(int i, int j) {
        return (float)this.getFirstValue(i, j);
    }

    @Override
    public float getFloat(int ... pos) {
        return (float)this.getFirstValue(pos);
    }

    @Override
    public double getDouble() {
        return this.getFirstValue();
    }

    @Override
    public double getDouble(int i) {
        return this.getFirstValue(i);
    }

    @Override
    public double getDouble(int i, int j) {
        return this.getFirstValue(i, j);
    }

    @Override
    public double getDouble(int ... pos) {
        return this.getFirstValue(pos);
    }

    @Override
    public void getDoubleArray(double[] darray) {
        this.getDoubleArrayAbs(this.getFirst1DIndex(), darray);
    }

    @Override
    public void getDoubleArray(double[] darray, int i) {
        this.getDoubleArrayAbs(this.get1DIndex(i), darray);
    }

    @Override
    public void getDoubleArray(double[] darray, int i, int j) {
        this.getDoubleArrayAbs(this.get1DIndex(i, j), darray);
    }

    @Override
    public void getDoubleArray(double[] darray, int ... pos) {
        this.getDoubleArrayAbs(this.get1DIndex(pos), darray);
    }

    protected StatisticsMetadata<double[]> getCompoundStats() {
        StatisticsMetadataImpl<double[]> md = (StatisticsMetadataImpl<double[]>)this.getFirstMetadata(StatisticsMetadata.class);
        if (md == null || md.isDirty()) {
            md = new StatisticsMetadataImpl<double[]>();
            md.initialize(this);
            this.setMetadata(md);
        }
        return md;
    }

    @Override
    public IntegerDataset argMax(int axis, boolean ... ignoreInvalids) {
        logger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public IntegerDataset argMin(int axis, boolean ... ignoreInvalids) {
        logger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public Number max(boolean ... ignoreInvalids) {
        logger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public CompoundDataset max(int axis, boolean ... ignoreInvalids) {
        logger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public Number min(boolean ... ignoreInvalids) {
        logger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public CompoundDataset min(int axis, boolean ... ignoreInvalids) {
        logger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public int[] maxPos(boolean ... ignoreNaNs) {
        logger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public int[] minPos(boolean ... ignoreNaNs) {
        logger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public CompoundDataset peakToPeak(int axis, boolean ... ignoreInvalids) {
        logger.error("Cannot compare compound numbers");
        throw new UnsupportedOperationException("Cannot compare compound numbers");
    }

    @Override
    public double[] maxItem() {
        return this.getCompoundStats().getMaximum(new boolean[0]);
    }

    @Override
    public double[] minItem() {
        return this.getCompoundStats().getMinimum(new boolean[0]);
    }

    @Override
    public Object mean(boolean ... ignoreInvalids) {
        return this.getCompoundStats().getMean(new boolean[0]);
    }

    @Override
    public CompoundDataset mean(int axis, boolean ... ignoreInvalids) {
        return (CompoundDataset)super.mean(axis, ignoreInvalids);
    }

    @Override
    public CompoundDataset product(int axis, boolean ... ignoreInvalids) {
        return (CompoundDataset)super.product(axis, ignoreInvalids);
    }

    @Override
    public CompoundDataset rootMeanSquare(int axis, boolean ... ignoreInvalids) {
        return (CompoundDataset)super.rootMeanSquare(axis, ignoreInvalids);
    }

    @Override
    public CompoundDataset stdDeviation(int axis) {
        return (CompoundDataset)super.stdDeviation(axis, false, new boolean[0]);
    }

    @Override
    public CompoundDataset stdDeviation(int axis, boolean isWholePopulation, boolean ... ignoreInvalids) {
        return (CompoundDataset)super.stdDeviation(axis, isWholePopulation, ignoreInvalids);
    }

    @Override
    public Object sum(boolean ... ignoreInvalids) {
        return this.getCompoundStats().getSum(new boolean[0]);
    }

    @Override
    public CompoundDataset sum(int axis, boolean ... ignoreInvalids) {
        return (CompoundDataset)super.sum(axis, ignoreInvalids);
    }

    @Override
    public double variance(boolean isWholePopulation, boolean ... ignoreInvalids) {
        return this.getCompoundStats().getVariance(isWholePopulation, ignoreInvalids);
    }

    @Override
    public CompoundDataset variance(int axis) {
        return (CompoundDataset)super.variance(axis, false, new boolean[0]);
    }

    @Override
    public CompoundDataset variance(int axis, boolean isWholePopulation, boolean ... ignoreInvalids) {
        return (CompoundDataset)super.variance(axis, isWholePopulation, ignoreInvalids);
    }

    @Override
    public double rootMeanSquare(boolean ... ignoreInvalids) {
        StatisticsMetadata<double[]> stats = this.getCompoundStats();
        double[] mean = stats.getMean(ignoreInvalids);
        double result = 0.0;
        int i = 0;
        while (i < this.isize) {
            double m = mean[i];
            result += m * m;
            ++i;
        }
        return Math.sqrt(result + stats.getVariance(true, new boolean[0]));
    }

    private CompoundDataset getInternalError() {
        Dataset led = super.getErrors();
        if (led == null) {
            return null;
        }
        Dataset ed = null;
        try {
            ed = DatasetUtils.sliceAndConvertLazyDataset(led);
        }
        catch (DatasetException e) {
            logger.error("Could not get data from lazy dataset", (Throwable)e);
        }
        CompoundDataset ced = !(ed instanceof CompoundDataset) || ed.getElementsPerItem() != this.isize ? new CompoundDoubleDataset(this.isize, true, ed) : (CompoundDataset)ed;
        if (led != ced) {
            this.setErrors(ced);
        }
        return ced;
    }

    @Override
    public CompoundDataset getErrors() {
        CompoundDataset ed = this.getInternalError();
        if (ed == null) {
            return null;
        }
        return ed.getBroadcastView(this.shape);
    }

    @Override
    public double getError(int i) {
        return this.calcError(this.getInternalErrorArray(true, i));
    }

    @Override
    public double getError(int i, int j) {
        return this.calcError(this.getInternalErrorArray(true, i, j));
    }

    @Override
    public double getError(int ... pos) {
        return this.calcError(this.getInternalErrorArray(true, pos));
    }

    private double calcError(double[] es) {
        if (es == null) {
            return 0.0;
        }
        double e = 0.0;
        int k = 0;
        while (k < this.isize) {
            e += es[k];
            ++k;
        }
        return Math.sqrt(e);
    }

    @Override
    public double[] getErrorArray(int i) {
        return this.getInternalErrorArray(false, i);
    }

    @Override
    public double[] getErrorArray(int i, int j) {
        return this.getInternalErrorArray(false, i, j);
    }

    @Override
    public double[] getErrorArray(int ... pos) {
        return this.getInternalErrorArray(false, pos);
    }

    private Dataset getInternalError(boolean squared) {
        Dataset sed;
        Dataset dataset = sed = squared ? this.getInternalSquaredError() : this.getInternalError();
        if (sed == null) {
            return null;
        }
        return sed.getBroadcastView(this.shape);
    }

    private double[] getInternalErrorArray(boolean squared, int i) {
        double[] es;
        Dataset sed = this.getInternalError(squared);
        if (sed == null) {
            return null;
        }
        if (sed instanceof CompoundDoubleDataset) {
            es = ((CompoundDoubleDataset)sed).getDoubleArray(i);
            if (sed.getElementsPerItem() != this.isize) {
                Arrays.fill(es, es[0]);
            }
        } else {
            es = new double[this.isize];
            Arrays.fill(es, ((DoubleDataset)sed).getDouble(i));
        }
        return es;
    }

    private double[] getInternalErrorArray(boolean squared, int i, int j) {
        double[] es;
        Dataset sed = this.getInternalError(squared);
        if (sed == null) {
            return null;
        }
        if (sed instanceof CompoundDoubleDataset) {
            es = ((CompoundDoubleDataset)sed).getDoubleArray(i, j);
            if (sed.getElementsPerItem() != this.isize) {
                Arrays.fill(es, es[0]);
            }
        } else {
            es = new double[this.isize];
            Arrays.fill(es, ((DoubleDataset)sed).getDouble(i, j));
        }
        return es;
    }

    private double[] getInternalErrorArray(boolean squared, int ... pos) {
        Dataset sed = this.getInternalError(squared);
        if (sed == null) {
            return null;
        }
        double[] es = new double[this.isize];
        if (sed instanceof CompoundDoubleDataset) {
            es = ((CompoundDoubleDataset)sed).getDoubleArray(pos);
            if (sed.getElementsPerItem() != this.isize) {
                Arrays.fill(es, es[0]);
            }
        } else {
            es = new double[this.isize];
            Arrays.fill(es, ((DoubleDataset)sed).getDouble(pos));
        }
        return es;
    }
}

