/*******************************************************************************
 * Copyright (c) 2016 UT-Battelle, LLC. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     UT-Battelle, LLC. - initial API and implementation
 *******************************************************************************/
package org.eclipse.january.geometry.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.january.geometry.VertexSource;


/**
 * A sample validator interface for {@link org.eclipse.january.geometry.Geometry}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface GeometryValidator {
	boolean validate();

	boolean validateVertexSources(EList<VertexSource> value);

	boolean validateVertexSource(VertexSource value);

}
