/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.impl.client.container;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.api.GroupDef;
import org.jboss.arquillian.config.descriptor.impl.ContainerDefImpl;
import org.jboss.arquillian.container.impl.LocalContainerRegistry;
import org.jboss.arquillian.container.impl.client.container.SecurityActions;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class ContainerRegistryCreator {
    static final String ARQUILLIAN_LAUNCH_PROPERTY = "arquillian.launch";
    static final String ARQUILLIAN_LAUNCH_DEFAULT = "arquillian.launch_file";
    @Deprecated
    static final String ARQUILLIAN_LAUNCH_DEFAULT_DEPRECATED = "arquillian.launch";
    private Logger log = Logger.getLogger(ContainerRegistryCreator.class.getName());
    @Inject
    @ApplicationScoped
    private InstanceProducer<ContainerRegistry> registry;
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Instance<ServiceLoader> loader;

    public void createRegistry(@Observes ArquillianDescriptor event) {
        LocalContainerRegistry reg = new LocalContainerRegistry((Injector)this.injector.get());
        ServiceLoader serviceLoader = (ServiceLoader)this.loader.get();
        this.validateConfiguration(event);
        String activeConfiguration = this.getActivatedConfiguration();
        for (ContainerDef container : event.getContainers()) {
            if ((activeConfiguration == null || !activeConfiguration.equals(container.getContainerName())) && (activeConfiguration != null || !container.isDefault())) continue;
            reg.create(container, serviceLoader);
        }
        for (GroupDef group : event.getGroups()) {
            if ((activeConfiguration == null || !activeConfiguration.equals(group.getGroupName())) && (activeConfiguration != null || !group.isGroupDefault())) continue;
            for (ContainerDef container : group.getGroupContainers()) {
                reg.create(container, serviceLoader);
            }
        }
        if (activeConfiguration == null && reg.getContainers().size() == 0) {
            DeployableContainer deployableContainer = null;
            try {
                deployableContainer = (DeployableContainer)serviceLoader.onlyOne(DeployableContainer.class);
            }
            catch (IllegalStateException e) {
                StringBuilder stringBuilder = new StringBuilder().append("Could not add a default container to registry because multiple instances of ").append(DeployableContainer.class.getName()).append(" found on classpath (candidates are: ");
                String separator = "";
                for (DeployableContainer s : serviceLoader.all(DeployableContainer.class)) {
                    stringBuilder.append(separator).append(s.getConfigurationClass().getName());
                    separator = ", ";
                }
                stringBuilder.append(")");
                throw new IllegalStateException(stringBuilder.toString());
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create the default container instance", e);
            }
            if (deployableContainer != null) {
                reg.create(new ContainerDefImpl("arquillian.xml").setContainerName("default"), serviceLoader);
            }
        } else if (activeConfiguration != null && reg.getContainers().size() == 0) {
            throw new IllegalArgumentException("No container or group found that match given qualifier: " + activeConfiguration);
        }
        this.registry.set((Object)reg);
    }

    private void validateConfiguration(ArquillianDescriptor desc) {
        ContainerDef defaultConfig = null;
        for (ContainerDef container : desc.getContainers()) {
            if (!container.isDefault()) continue;
            if (defaultConfig != null) {
                throw new IllegalStateException("Multiple Containers defined as default, only one is allowed:\n" + defaultConfig + ":" + container);
            }
            defaultConfig = container;
        }
        boolean containerMarkedAsDefault = defaultConfig != null;
        for (GroupDef group : desc.getGroups()) {
            if (group.isGroupDefault()) {
                if (defaultConfig != null) {
                    if (containerMarkedAsDefault) {
                        throw new IllegalStateException("Multiple Containers/Groups defined as default, only one is allowed:\n" + defaultConfig + ":" + group);
                    }
                    throw new IllegalStateException("Multiple Groups defined as default, only one is allowed:\n" + defaultConfig + ":" + group);
                }
                defaultConfig = group;
            }
            ContainerDef defaultInGroup = null;
            for (ContainerDef container : group.getGroupContainers()) {
                if (!container.isDefault()) continue;
                if (defaultInGroup != null) {
                    throw new IllegalStateException("Multiple Containers within Group defined as default, only one is allowed:\n" + group);
                }
                defaultInGroup = container;
            }
        }
    }

    private String getActivatedConfiguration() {
        if (this.exists(SecurityActions.getProperty("arquillian.launch"))) {
            return SecurityActions.getProperty("arquillian.launch");
        }
        String qualifier = this.readLaunchFile(ARQUILLIAN_LAUNCH_DEFAULT);
        if (qualifier == null && (qualifier = this.readLaunchFile("arquillian.launch")) != null) {
            this.log.log(Level.WARNING, "The use of arquillian.launch has been deprecated and replaced with arquillian.launch_file. The .launch file extension caused warnings when found in Eclipse due to conflicts with the Eclipse Launch Profile files. See https://issues.jboss.org/browse/ARQ-1607 for more information.");
        }
        return qualifier;
    }

    private String readLaunchFile(String resourceName) {
        InputStream arquillianLaunchStream = SecurityActions.getThreadContextClassLoader().getResourceAsStream(resourceName);
        if (arquillianLaunchStream != null) {
            try {
                return this.readActivatedValue(new BufferedReader(new InputStreamReader(arquillianLaunchStream)));
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Could not read resource " + resourceName, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readActivatedValue(BufferedReader reader) throws Exception {
        try {
            String value;
            while ((value = reader.readLine()) != null) {
                if (value.startsWith("#")) continue;
                String string = value;
                return string;
            }
        }
        finally {
            reader.close();
        }
        return null;
    }

    private boolean exists(String value) {
        return value != null && value.trim().length() != 0;
    }
}

