/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emf.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hawk.core.IModelResourceFactory;
import org.eclipse.hawk.core.model.IHawkModelResource;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.emf.EMFWrapperFactory;

public class EMFModelResource
implements IHawkModelResource {
    protected EMFWrapperFactory wf;
    protected Resource res;
    protected Set<IHawkObject> allContents = null;

    public void unload() {
        this.res.unload();
        if (this.res.getResourceSet() != null) {
            this.res.getResourceSet().getResources().remove((Object)this.res);
        }
        this.res = null;
        this.allContents = null;
    }

    public EMFModelResource(Resource r, EMFWrapperFactory wf, IModelResourceFactory p) {
        this.res = r;
        this.wf = wf;
    }

    public Iterable<IHawkObject> getAllContents() {
        return new EMFObjectIterable();
    }

    public Set<IHawkObject> getAllContentsSet() {
        if (this.allContents == null) {
            this.allContents = new HashSet<IHawkObject>();
            for (IHawkObject eob : this.getAllContents()) {
                this.allContents.add(eob);
            }
        }
        return this.allContents;
    }

    public Resource getResource() {
        return this.res;
    }

    public boolean providesSingletonElements() {
        return false;
    }

    protected class EMFObjectIterable
    implements Iterable<IHawkObject> {
        protected EMFObjectIterable() {
        }

        @Override
        public Iterator<IHawkObject> iterator() {
            final TreeIterator it = EcoreUtil.getAllContents((Resource)EMFModelResource.this.res, (boolean)false);
            return new Iterator<IHawkObject>(){
                EObject next = null;

                @Override
                public boolean hasNext() {
                    while (this.next == null && it.hasNext()) {
                        EObject rawNext = (EObject)it.next();
                        if (rawNext.eIsProxy()) continue;
                        if (rawNext.eResource() == ((EMFObjectIterable)EMFObjectIterable.this).EMFModelResource.this.res) {
                            this.next = rawNext;
                            continue;
                        }
                        it.prune();
                    }
                    return this.next != null;
                }

                @Override
                public IHawkObject next() {
                    if (this.hasNext()) {
                        EObject ret = this.next;
                        this.next = null;
                        return ((EMFObjectIterable)EMFObjectIterable.this).EMFModelResource.this.wf.createObject(ret);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

