/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.schema;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.hawk.sqlite.schema.ISchema;

public class TimeAwareSchema
implements ISchema {
    private Connection connection;

    public TimeAwareSchema(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void createSchema() throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute("CREATE TABLE IF NOT EXISTS nodes (label VARCHAR NOT NULL, validFrom INTEGER NOT NULL, validTo INTEGER);");
            stmt.execute("CREATE INDEX IF NOT EXISTS nodes_by_label ON nodes (label, validFrom);");
            stmt.execute("CREATE TABLE IF NOT EXISTS nodeprops (nodeid INTEGER NOT NULL, key VARCHAR NOT NULL, type VARCHAR NOT NULL, value, validAt INTEGER NOT NULL);");
            stmt.execute("CREATE UNIQUE INDEX IF NOT EXISTS nodeprops_by_id_key ON nodeprops (nodeid, key, validAt);");
            stmt.execute("CREATE TABLE IF NOT EXISTS edges (label VARCHAR NOT NULL, startId INTEGER NOT NULL, endId INTEGER NOT NULL, validFrom INTEGER NOT NULL, validTo INTEGER);");
            stmt.execute("CREATE UNIQUE INDEX IF NOT EXISTS edges_unique ON edges (label, startId, endId, validFrom);");
            stmt.execute("CREATE INDEX IF NOT EXISTS edges_label_end ON edges (label, endId, validFrom);");
            stmt.execute("CREATE INDEX IF NOT EXISTS edges_start ON edges (startId, validFrom);");
            stmt.execute("CREATE INDEX IF NOT EXISTS edges_end ON edges (endId, validFrom);");
            stmt.execute("CREATE TABLE IF NOT EXISTS edgeprops (edgeid INTEGER NOT NULL, key VARCHAR NOT NULL, type VARCHAR NOT NULL, value VARCHAR, validAt INTEGER NOT NULL);");
            stmt.execute("CREATE UNIQUE INDEX IF NOT EXISTS edgeprops_by_id_key ON edgeprops (edgeid, key, validAt);");
            stmt.execute("CREATE TABLE IF NOT EXISTS nodeindices (name VARCHAR UNIQUE NOT NULL);");
            this.connection.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void createNodeIndex(String name) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(String.format("CREATE TABLE IF NOT EXISTS `idx_%s` (key VARCHAR NOT NULL, nodeid INTEGER NOT NULL, value, validFrom INTEGER NOT NULL, validTo INTEGER);", name));
            stmt.execute(String.format("CREATE INDEX IF NOT EXISTS `idx_%s_key` ON `idx_%s` (key, validFrom);", name, name));
            stmt.execute(String.format("CREATE INDEX IF NOT EXISTS `idx_%s_node` ON `idx_%s` (nodeid, validFrom);", name, name));
            stmt.execute(String.format("CREATE INDEX IF NOT EXISTS `idx_%s_val` ON `idx_%s` (value, validFrom);", name, name));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void clearNodeIndexTable(String name) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(String.format("DELETE FROM `idx_%s`;", name));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void dropNodeIndexTable(String name) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(String.format("DROP TABLE `idx_%s`;", name));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

