/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.contextful;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.graph.FileNode;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.ModelElementNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubtreeFileSupplier
implements Supplier<Set<IGraphNode>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubtreeFileSupplier.class);
    private final String subtreeRootPath;
    private final List<String> rplist;
    private final IGraphDatabase graph;

    public SubtreeFileSupplier(IGraphDatabase graph, String subtreeRootPath, List<String> rplist) {
        this.subtreeRootPath = subtreeRootPath;
        this.rplist = rplist;
        this.graph = graph;
    }

    @Override
    public Set<IGraphNode> get() {
        GraphWrapper gw = new GraphWrapper(this.graph);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (IGraphTransaction tx = this.graph.beginTransaction();){
                HashSet<IGraphNode> fileNodes = new HashSet<IGraphNode>();
                Set allFileNodes = gw.getFileNodes(this.rplist, null);
                block7: for (FileNode fn : allFileNodes) {
                    Iterator itElems = fn.getModelElements().iterator();
                    if (!itElems.hasNext()) continue;
                    ModelElementNode first = (ModelElementNode)itElems.next();
                    if (this.rplist == null) {
                        if (!first.isContainedWithin(null, this.subtreeRootPath)) continue;
                        fileNodes.add(fn.getNode());
                        continue;
                    }
                    for (String repo : this.rplist) {
                        if (!first.isContainedWithin(repo, this.subtreeRootPath)) continue;
                        fileNodes.add(fn.getNode());
                        continue block7;
                    }
                }
                tx.success();
                return fileNodes;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }
}

