/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations;

import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.declarative.FirstOrderOperation;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.wrappers.TypeNodeWrapper;
import org.eclipse.hawk.graph.TypeNode;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeAwareNodeFirstOrderOperation
extends FirstOrderOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeAwareNodeFirstOrderOperation.class);
    protected final Supplier<TimeAwareEOLQueryEngine> containerModelSupplier;

    public TimeAwareNodeFirstOrderOperation(Supplier<TimeAwareEOLQueryEngine> containerModelSupplier) {
        this.containerModelSupplier = containerModelSupplier;
    }

    protected abstract Object execute(Variable var1, Expression var2, IEolContext var3, Function<ITimeAwareGraphNode, Object> var4, ITimeAwareGraphNode var5) throws EolInternalException;

    /*
     * Enabled aggressive block sorting
     */
    public Object execute(Object target, Variable iterator, Expression expression, IEolContext context) throws EolRuntimeException {
        Function<ITimeAwareGraphNode, Object> varWrapper;
        ITimeAwareGraphNode taNode;
        if (target == null) {
            LOGGER.warn("called on null value, returning false");
            return false;
        }
        if (target instanceof EOLQueryEngine.GraphNodeWrapper) {
            EOLQueryEngine.GraphNodeWrapper gnw = (EOLQueryEngine.GraphNodeWrapper)target;
            if (gnw.getNode() instanceof ITimeAwareGraphNode) {
                taNode = (ITimeAwareGraphNode)gnw.getNode();
                varWrapper = n -> this.containerModelSupplier.get().wrap((IGraphNode)n);
                return this.execute(iterator, expression, context, varWrapper, taNode);
            }
            LOGGER.warn("called on non-timeaware node {}, returning false", (Object)target.getClass().getName());
            return false;
        }
        if (!(target instanceof TypeNodeWrapper)) {
            LOGGER.warn("called on non-node {}, returning false", (Object)target.getClass().getName());
            return false;
        }
        TypeNodeWrapper tnw = (TypeNodeWrapper)target;
        if (tnw.getNode() instanceof ITimeAwareGraphNode) {
            taNode = (ITimeAwareGraphNode)tnw.getNode();
            varWrapper = n -> new TypeNodeWrapper(new TypeNode((IGraphNode)n), (EOLQueryEngine)this.containerModelSupplier.get());
            return this.execute(iterator, expression, context, varWrapper, taNode);
        }
        LOGGER.warn("called on non-timeaware node {}, returning false", (Object)target.getClass().getName());
        return false;
    }
}

