/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphUtil.class);
    private static HashSet<String> unknownTypes = new HashSet();

    private GraphUtil() {
    }

    public static boolean isPrimitiveOrWrapperType(Class<?> valueClass) {
        String type;
        boolean ret;
        boolean bl = ret = String.class.isAssignableFrom(valueClass) || Boolean.class.isAssignableFrom(valueClass) || Character.class.isAssignableFrom(valueClass) || Byte.class.isAssignableFrom(valueClass) || Short.class.isAssignableFrom(valueClass) || Integer.class.isAssignableFrom(valueClass) || Long.class.isAssignableFrom(valueClass) || Float.class.isAssignableFrom(valueClass) || Double.class.isAssignableFrom(valueClass) || Boolean.TYPE.isAssignableFrom(valueClass) || Character.TYPE.isAssignableFrom(valueClass) || Byte.TYPE.isAssignableFrom(valueClass) || Short.TYPE.isAssignableFrom(valueClass) || Integer.TYPE.isAssignableFrom(valueClass) || Long.TYPE.isAssignableFrom(valueClass) || Float.TYPE.isAssignableFrom(valueClass) || Double.TYPE.isAssignableFrom(valueClass);
        if (!ret && unknownTypes.add(type = valueClass.getName())) {
            LOGGER.warn("Unknown type found, converting to String: {}", (Object)type);
        }
        return ret;
    }

    public static Object formatDate(Date value) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return sdf.format(value);
    }
}

