/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.emf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import org.eclipse.hawk.service.api.EffectiveMetamodelRuleset;
import org.eclipse.hawk.service.api.SubscriptionDurability;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.emf.EffectiveMetamodelRulesetSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawkModelDescriptor {
    public static final String DEFAULT_FILES = "*";
    public static final String DEFAULT_REPOSITORY = "*";
    public static final String DEFAULT_URL = "http://127.0.0.1:8080/thrift/hawk/tuple";
    public static final String DEFAULT_USERNAME = "";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_INSTANCE = "myhawk";
    public static final LoadingMode DEFAULT_LOADING_MODE = LoadingMode.GREEDY;
    public static final boolean DEFAULT_IS_SUBSCRIBED = false;
    public static final boolean DEFAULT_IS_SPLIT = true;
    public static final int DEFAULT_PAGE_SIZE = 0;
    public static final APIUtils.ThriftProtocol DEFAULT_TPROTOCOL = APIUtils.ThriftProtocol.TUPLE;
    public static final String DEFAULT_CLIENTID = System.getProperty("user.name");
    public static final SubscriptionDurability DEFAULT_DURABILITY = SubscriptionDurability.DEFAULT;
    public static final String DEFAULT_DEFAULT_NAMESPACES = "";
    public static final String DEFAULT_QUERY_LANGUAGE = "";
    public static final String DEFAULT_QUERY = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(HawkModelDescriptor.class);
    private static final String FILE_PATTERN_SEP = ",";
    public static final String PROPERTY_HAWK_FILES = "hawk.files";
    public static final String PROPERTY_HAWK_REPOSITORY = "hawk.repository";
    public static final String PROPERTY_HAWK_INSTANCE = "hawk.instance";
    public static final String PROPERTY_HAWK_URL = "hawk.url";
    public static final String PROPERTY_HAWK_TPROTOCOL = "hawk.thriftProtocol";
    public static final String PROPERTY_HAWK_LOADING_MODE = "hawk.loadingMode";
    public static final String PROPERTY_HAWK_QUERY_LANGUAGE = "hawk.queryLanguage";
    public static final String PROPERTY_HAWK_DEFAULT_NAMESPACES = "hawk.defaultNamespaces";
    public static final String PROPERTY_HAWK_QUERY = "hawk.query";
    public static final String PROPERTY_HAWK_SUBSCRIBE = "hawk.subscribe";
    public static final String PROPERTY_HAWK_CLIENTID = "hawk.clientID";
    public static final String PROPERTY_HAWK_DURABILITY = "hawk.subscriptionDurability";
    public static final String PROPERTY_HAWK_SPLIT = "hawk.split";
    public static final String PROPERTY_HAWK_PAGE_SIZE = "hawk.pageSize";
    public static final String PROPERTY_HAWK_USERNAME = "hawk.username";
    public static final String PROPERTY_HAWK_PASSWORD = "hawk.password";
    public static final String PROPERTY_HAWK_EMM_PREFIX = "hawk.effectiveMetamodel";
    private String hawkURL = "http://127.0.0.1:8080/thrift/hawk/tuple";
    private String hawkInstance = "myhawk";
    private APIUtils.ThriftProtocol thriftProtocol = DEFAULT_TPROTOCOL;
    private String hawkUsername = "";
    private String hawkPassword = "";
    private String hawkRepository = "*";
    private String[] hawkFilePatterns = new String[]{"*"};
    private LoadingMode loadingMode = DEFAULT_LOADING_MODE;
    private String hawkQueryLanguage = "";
    private String hawkQuery = "";
    private String defaultNamespaces = "";
    private boolean isSplit = true;
    private int pageSize = 0;
    private EffectiveMetamodelRuleset emm = new EffectiveMetamodelRuleset();
    private boolean isSubscribed = false;
    private String subscriptionClientID = DEFAULT_CLIENTID;
    private SubscriptionDurability subscriptionDurability = DEFAULT_DURABILITY;

    public void load(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        is.close();
        this.loadFromProperties(props);
    }

    public void load(Reader r) throws IOException {
        Properties props = new Properties();
        props.load(r);
        r.close();
        this.loadFromProperties(props);
    }

    public String getHawkURL() {
        return this.hawkURL;
    }

    public void setHawkURL(String hawkURL) {
        this.hawkURL = hawkURL;
    }

    public String getHawkInstance() {
        return this.hawkInstance;
    }

    public void setHawkInstance(String hawkInstance) {
        this.hawkInstance = hawkInstance;
    }

    public String getHawkRepository() {
        return this.hawkRepository;
    }

    public void setHawkRepository(String hawkRepository) {
        this.hawkRepository = hawkRepository;
    }

    public String[] getHawkFilePatterns() {
        return this.hawkFilePatterns;
    }

    public void setHawkFilePatterns(String[] hawkFilePatterns) {
        this.hawkFilePatterns = hawkFilePatterns;
    }

    public LoadingMode getLoadingMode() {
        return this.loadingMode;
    }

    public void setLoadingMode(LoadingMode mode) {
        this.loadingMode = mode;
    }

    public String getHawkQueryLanguage() {
        return this.hawkQueryLanguage;
    }

    public void setHawkQueryLanguage(String hawkQueryLanguage) {
        this.hawkQueryLanguage = hawkQueryLanguage;
    }

    public String getHawkQuery() {
        return this.hawkQuery;
    }

    public void setHawkQuery(String hawkQuery) {
        this.hawkQuery = hawkQuery;
    }

    public boolean isSubscribed() {
        return this.isSubscribed;
    }

    public void setSubscribed(boolean isSubscribed) {
        this.isSubscribed = isSubscribed;
    }

    public APIUtils.ThriftProtocol getThriftProtocol() {
        return this.thriftProtocol;
    }

    public void setThriftProtocol(APIUtils.ThriftProtocol thriftProtocol) {
        this.thriftProtocol = thriftProtocol;
    }

    public String getSubscriptionClientID() {
        return this.subscriptionClientID;
    }

    public void setSubscriptionClientID(String clientID) {
        this.subscriptionClientID = clientID;
    }

    public SubscriptionDurability getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public void setSubscriptionDurability(SubscriptionDurability subscriptionDurability) {
        this.subscriptionDurability = subscriptionDurability;
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean newValue) {
        this.isSplit = newValue;
    }

    public boolean isPaged() {
        return this.pageSize > 0;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getDefaultNamespaces() {
        return this.defaultNamespaces;
    }

    public void setDefaultNamespaces(String defaultNamespaces) {
        this.defaultNamespaces = defaultNamespaces;
    }

    public String getUsername() {
        return this.hawkUsername;
    }

    public void setUsername(String hawkUsername) {
        this.hawkUsername = hawkUsername;
    }

    public String getPassword() {
        return this.hawkPassword;
    }

    public void setPassword(String hawkPassword) {
        this.hawkPassword = hawkPassword;
    }

    public EffectiveMetamodelRuleset getEffectiveMetamodel() {
        return this.emm;
    }

    public void setEffectiveMetamodel(EffectiveMetamodelRuleset emm) {
        this.emm = emm;
    }

    public void save(OutputStream os) throws IOException {
        this.createProperties().store(os, "");
    }

    public void save(Writer w) throws IOException {
        this.createProperties().store(w, "");
    }

    private Properties createProperties() {
        Properties props = new Properties();
        props.setProperty(PROPERTY_HAWK_URL, this.hawkURL);
        props.setProperty(PROPERTY_HAWK_INSTANCE, this.hawkInstance);
        props.setProperty(PROPERTY_HAWK_TPROTOCOL, this.thriftProtocol.toString());
        props.setProperty(PROPERTY_HAWK_USERNAME, this.hawkUsername);
        props.setProperty(PROPERTY_HAWK_PASSWORD, this.hawkPassword);
        props.setProperty(PROPERTY_HAWK_REPOSITORY, this.hawkRepository);
        props.setProperty(PROPERTY_HAWK_FILES, HawkModelDescriptor.concat(this.hawkFilePatterns, FILE_PATTERN_SEP));
        props.setProperty(PROPERTY_HAWK_LOADING_MODE, this.loadingMode.toString());
        props.setProperty(PROPERTY_HAWK_QUERY_LANGUAGE, this.hawkQueryLanguage);
        props.setProperty(PROPERTY_HAWK_QUERY, this.hawkQuery);
        props.setProperty(PROPERTY_HAWK_DEFAULT_NAMESPACES, this.defaultNamespaces);
        props.setProperty(PROPERTY_HAWK_SPLIT, Boolean.toString(this.isSplit));
        props.setProperty(PROPERTY_HAWK_PAGE_SIZE, Integer.toString(this.pageSize));
        props.setProperty(PROPERTY_HAWK_SUBSCRIBE, Boolean.toString(this.isSubscribed));
        props.setProperty(PROPERTY_HAWK_CLIENTID, this.subscriptionClientID);
        props.setProperty(PROPERTY_HAWK_DURABILITY, this.subscriptionDurability.toString());
        new EffectiveMetamodelRulesetSerializer(PROPERTY_HAWK_EMM_PREFIX).save(this.emm, props);
        return props;
    }

    private void loadFromProperties(Properties props) throws IOException {
        this.hawkURL = HawkModelDescriptor.requiredProperty(props, PROPERTY_HAWK_URL);
        this.hawkInstance = HawkModelDescriptor.requiredProperty(props, PROPERTY_HAWK_INSTANCE);
        this.thriftProtocol = APIUtils.ThriftProtocol.valueOf((String)HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_TPROTOCOL, "" + DEFAULT_TPROTOCOL));
        this.hawkUsername = HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_USERNAME, "");
        this.hawkPassword = HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_PASSWORD, "");
        this.hawkRepository = HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_REPOSITORY, "*");
        this.hawkFilePatterns = HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_FILES, "*").split(FILE_PATTERN_SEP);
        this.loadingMode = LoadingMode.valueOf(HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_LOADING_MODE, "" + (Object)((Object)DEFAULT_LOADING_MODE)));
        this.hawkQueryLanguage = HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_QUERY_LANGUAGE, "");
        this.hawkQuery = HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_QUERY, "");
        this.defaultNamespaces = HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_DEFAULT_NAMESPACES, "");
        this.isSplit = Boolean.valueOf(HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_SPLIT, "true"));
        this.pageSize = Integer.valueOf(HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_PAGE_SIZE, "0"));
        this.emm = new EffectiveMetamodelRulesetSerializer(PROPERTY_HAWK_EMM_PREFIX).load(props);
        this.isSubscribed = Boolean.valueOf(HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_SUBSCRIBE, Boolean.toString(false)));
        this.subscriptionClientID = HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_CLIENTID, DEFAULT_CLIENTID);
        this.subscriptionDurability = SubscriptionDurability.valueOf((String)HawkModelDescriptor.optionalProperty(props, PROPERTY_HAWK_DURABILITY, "" + DEFAULT_DURABILITY));
    }

    private static String requiredProperty(Properties props, String name) throws IOException {
        String value = (String)props.get(name);
        if (value == null) {
            throw new IOException(String.valueOf(name) + " has not been set");
        }
        return value;
    }

    private static String optionalProperty(Properties props, String name, String defaultValue) throws IOException {
        String value = (String)props.get(name);
        if (value == null) {
            LOGGER.info("{} has not been set, using {} as default", (Object)name, (Object)defaultValue);
            return defaultValue;
        }
        return value;
    }

    private static String concat(String[] elems, String separator) {
        StringBuffer sbuf = new StringBuffer();
        boolean bFirst = true;
        String[] stringArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            String filePattern = stringArray[n2];
            if (bFirst) {
                bFirst = false;
            } else {
                sbuf.append(separator);
            }
            sbuf.append(filePattern);
            ++n2;
        }
        return sbuf.toString();
    }

    private static <T> String[] toStringArray(Object[] c) {
        String[] strings = new String[c.length];
        int i = 0;
        Object[] objectArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            strings[i++] = "" + o;
            ++n2;
        }
        return strings;
    }

    public static enum LoadingMode {
        GREEDY(true, true, true),
        LAZY_ATTRIBUTES(true, false, true),
        LAZY_CHILDREN(false, true, true),
        LAZY_REFERENCES(false, true, false),
        LAZY_ATTRIBUTES_CHILDREN(false, false, true),
        LAZY_ATTRIBUTES_REFERENCES(false, false, false);

        private final boolean greedyElements;
        private final boolean greedyAttributes;
        private final boolean greedyReferences;

        public static String[] strings() {
            return HawkModelDescriptor.toStringArray((Object[])LoadingMode.values());
        }

        private LoadingMode(boolean greedyElements, boolean greedyAttributes, boolean greedyChildren) {
            this.greedyElements = greedyElements;
            this.greedyAttributes = greedyAttributes;
            this.greedyReferences = greedyElements || greedyChildren;
        }

        public boolean isGreedyElements() {
            return this.greedyElements;
        }

        public boolean isGreedyAttributes() {
            return this.greedyAttributes;
        }

        public boolean isGreedyReferences() {
            return this.greedyReferences;
        }
    }
}

