/*******************************************************************************
 * Copyright (c) 2015-2016 The University of York.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 3.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-3.0
 *
 * Contributors:
 *     Antonio Garcia-Dominguez - initial API and implementation
 ******************************************************************************/
package org.eclipse.hawk.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;

public class MetamodelNode {

	private IGraphNode node;

	public MetamodelNode(IGraphNode n) {
		this.node = n;
	}

	public Iterable<TypeNode> getTypes() {
		final Iterable<IGraphEdge> iterableEdges = node.getIncomingWithType("epackage");
		return new Iterable<TypeNode>() {
			@Override
			public Iterator<TypeNode> iterator() {
				final Iterator<IGraphEdge> itEdges = iterableEdges.iterator();
				return new Iterator<TypeNode>() {

					@Override
					public boolean hasNext() {
						return itEdges.hasNext();
					}

					@Override
					public TypeNode next() {
						return new TypeNode(itEdges.next().getStartNode());
					}

					@Override
					public void remove() {
						itEdges.remove();
					}};
			}
		};
	}

	public IGraphNode getNode() {
		return node;
	}

	public String getUri() {
		return (String)node.getProperty(IModelIndexer.IDENTIFIER_PROPERTY);
	}

	public String getType() {
		return (String)node.getProperty(IModelIndexer.METAMODEL_TYPE_PROPERTY);
	}

	public String getResource() {
		return (String)node.getProperty(IModelIndexer.METAMODEL_RESOURCE_PROPERTY);
	}

	public List<MetamodelNode> getDependencies() {
		final List<MetamodelNode> nodes = new ArrayList<>();
		for (IGraphEdge e : node.getOutgoingWithType(IModelIndexer.METAMODEL_DEPENDENCY_EDGE)) {
			final IGraphNode depNode = e.getEndNode();
			nodes.add(new MetamodelNode(depNode));
		}
		return nodes;
	}
}
