/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.session;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import java.util.Map;
import java.util.Optional;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.di.ClientSessionModule;
import org.eclipse.glsp.server.di.scope.DiagramGlobalScope;
import org.eclipse.glsp.server.di.scope.DiagramGlobalScopeModule;
import org.eclipse.glsp.server.internal.session.DefaultClientSession;
import org.eclipse.glsp.server.protocol.InitializeClientSessionParameters;
import org.eclipse.glsp.server.session.ClientSession;
import org.eclipse.glsp.server.session.ClientSessionFactory;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.ModuleUtil;

public class DefaultClientSessionFactory
implements ClientSessionFactory {
    @Inject
    protected Injector serverInjector;
    @Inject
    protected DiagramGlobalScope diagramGlobalScope;
    @Inject
    @Named(value="Diagram_Modules")
    protected Map<String, Module> diagramModules;

    @Override
    public ClientSession create(InitializeClientSessionParameters params) {
        String diagramType = params.getDiagramType();
        String clientSessionId = params.getClientSessionId();
        Module diagramModule = GLSPServerException.getOrThrow(Optional.of(this.diagramModules.get(diagramType)), "Could not retrieve module configuration for diagram type: " + diagramType);
        ClientSessionModule clientIdModule = new ClientSessionModule(clientSessionId, params.getClientActionKinds());
        DiagramGlobalScopeModule diagramScopeModule = new DiagramGlobalScopeModule(this.diagramGlobalScope);
        Module clientSessionModule = ModuleUtil.mixin(diagramModule, new Module[]{clientIdModule, diagramScopeModule});
        Injector sessionInjector = this.serverInjector.createChildInjector(new Module[]{clientSessionModule});
        return new DefaultClientSession(clientSessionId, diagramType, (ActionDispatcher)sessionInjector.getInstance(ActionDispatcher.class), sessionInjector);
    }
}

