/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.common.java.Assert;

public class CifControllerPropertiesAnnotationUtils {
    private CifControllerPropertiesAnnotationUtils() {
    }

    public static Boolean hasBoundedResponse(Specification spec) {
        Annotation anno = CifAnnotationUtils.tryGetSingleAnnotation((AnnotatedObject)spec, "controller:properties");
        AnnotationArgument arg = anno == null ? null : CifAnnotationUtils.tryGetArgument(anno, "boundedResponse");
        return arg == null ? null : Boolean.valueOf(((BoolExpression)arg.getValue()).isValue());
    }

    public static Boolean hasConfluence(Specification spec) {
        Annotation anno = CifAnnotationUtils.tryGetSingleAnnotation((AnnotatedObject)spec, "controller:properties");
        AnnotationArgument arg = anno == null ? null : CifAnnotationUtils.tryGetArgument(anno, "confluence");
        return arg == null ? null : Boolean.valueOf(((BoolExpression)arg.getValue()).isValue());
    }

    public static Boolean hasFiniteResponse(Specification spec) {
        Annotation anno = CifAnnotationUtils.tryGetSingleAnnotation((AnnotatedObject)spec, "controller:properties");
        AnnotationArgument arg = anno == null ? null : CifAnnotationUtils.tryGetArgument(anno, "finiteResponse");
        return arg == null ? null : Boolean.valueOf(((BoolExpression)arg.getValue()).isValue());
    }

    public static Boolean isNonBlockingUnderControl(Specification spec) {
        Annotation anno = CifAnnotationUtils.tryGetSingleAnnotation((AnnotatedObject)spec, "controller:properties");
        AnnotationArgument arg = anno == null ? null : CifAnnotationUtils.tryGetArgument(anno, "nonBlockingUnderControl");
        return arg == null ? null : Boolean.valueOf(((BoolExpression)arg.getValue()).isValue());
    }

    public static Integer getUncontrollablesBound(Specification spec) {
        Annotation anno = CifAnnotationUtils.tryGetSingleAnnotation((AnnotatedObject)spec, "controller:properties");
        AnnotationArgument arg = anno == null ? null : CifAnnotationUtils.tryGetArgument(anno, "uncontrollablesBound");
        return arg == null ? null : Integer.valueOf(((IntExpression)arg.getValue()).getValue());
    }

    public static Integer getControllablesBound(Specification spec) {
        Annotation anno = CifAnnotationUtils.tryGetSingleAnnotation((AnnotatedObject)spec, "controller:properties");
        AnnotationArgument arg = anno == null ? null : CifAnnotationUtils.tryGetArgument(anno, "controllablesBound");
        return arg == null ? null : Integer.valueOf(((IntExpression)arg.getValue()).getValue());
    }

    public static void setBoundedResponse(Specification spec, Integer uncontrollablesBound, Integer controllablesBound) {
        Assert.areEqual((Object)(controllablesBound == null ? 1 : 0), (Object)(uncontrollablesBound == null ? 1 : 0));
        boolean boundedResponse = controllablesBound != null;
        Annotation anno = CifAnnotationUtils.getOrCreateSingleAnnotation((AnnotatedObject)spec, "controller:properties");
        CifAnnotationUtils.setArgument(anno, "boundedResponse", (Expression)CifValueUtils.makeBool(boundedResponse));
        if (boundedResponse) {
            CifAnnotationUtils.setArgument(anno, "uncontrollablesBound", CifValueUtils.makeInt(uncontrollablesBound));
            CifAnnotationUtils.setArgument(anno, "controllablesBound", CifValueUtils.makeInt(controllablesBound));
        } else {
            CifAnnotationUtils.tryRemoveArgument(anno, "uncontrollablesBound");
            CifAnnotationUtils.tryRemoveArgument(anno, "controllablesBound");
        }
    }

    public static void setConfluence(Specification spec, boolean confluence) {
        Annotation anno = CifAnnotationUtils.getOrCreateSingleAnnotation((AnnotatedObject)spec, "controller:properties");
        CifAnnotationUtils.setArgument(anno, "confluence", (Expression)CifValueUtils.makeBool(confluence));
    }

    public static void setFiniteResponse(Specification spec, boolean finiteResponse) {
        Annotation anno = CifAnnotationUtils.getOrCreateSingleAnnotation((AnnotatedObject)spec, "controller:properties");
        CifAnnotationUtils.setArgument(anno, "finiteResponse", (Expression)CifValueUtils.makeBool(finiteResponse));
    }

    public static void setNonBlockingUnderControl(Specification spec, boolean nonBlockingUnderControl) {
        Annotation anno = CifAnnotationUtils.getOrCreateSingleAnnotation((AnnotatedObject)spec, "controller:properties");
        CifAnnotationUtils.setArgument(anno, "nonBlockingUnderControl", (Expression)CifValueUtils.makeBool(nonBlockingUnderControl));
    }

    public static void remove(Specification spec) {
        CifAnnotationUtils.removeAnnotations((AnnotatedObject)spec, "controller:properties");
    }
}

