/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.eventbased.analysis.SynthesisDumpInterface;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.eventbased.automata.AutomatonKind;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.builders.AutomatonBuilder;
import org.eclipse.escet.cif.eventbased.builders.State;
import org.eclipse.escet.cif.eventbased.builders.StateEdges;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidModelException;

public class SupervisorSynthesis {
    private SupervisorSynthesis() {
    }

    public static void synthesisPreCheck(List<Automaton> automs, boolean warnDisjunct, boolean warnEmpty, boolean warnDeadlock, boolean warnSingleUse) {
        List<List<Automaton>> groups;
        List reqs = Lists.list();
        int warnCount = 0;
        for (Automaton aut : automs) {
            Iterator<Location> msg;
            switch (aut.kind) {
                case REQUIREMENT: {
                    reqs.add(aut);
                    break;
                }
            }
            boolean bl = aut.hasMarkedLoc();
            if (!bl) {
                msg = "Automaton \"" + aut.name + "\" has no marked location, supervisor will be empty.";
                OutputProvider.warn((String)((Object)msg));
                ++warnCount;
            }
            if (!bl || AutomatonHelper.trimCheck(aut)) continue;
            msg = "Automaton \"" + aut.name + "\" is not trim.";
            OutputProvider.warn(msg);
            ++warnCount;
        }
        if (reqs.isEmpty()) {
            String msg = "The specification has no requirement automata.";
            OutputProvider.warn((String)msg);
            ++warnCount;
        }
        if (warnEmpty || warnDeadlock) {
            for (Automaton aut : automs) {
                if (aut.alphabet.isEmpty() && warnEmpty) {
                    String string = Strings.fmt((String)"The alphabet of automaton \"%s\" is empty.", (Object[])new Object[]{aut.name});
                    OutputProvider.warn((String)string);
                    ++warnCount;
                }
                if (!warnDeadlock) continue;
                for (Location location : aut) {
                    if (!location.marked || location.outgoingEdges != null) continue;
                    String string2 = location.toString() + " is a marked deadlock location.";
                    string2 = StringUtils.capitalize((String)string2);
                    OutputProvider.warn((String)string2);
                    ++warnCount;
                }
            }
        }
        if (warnSingleUse) {
            Map usesEvent = Maps.map();
            Set sharedEvents = Sets.set();
            for (Automaton automaton : automs) {
                for (Event event : automaton.alphabet) {
                    if (!event.isControllable()) continue;
                    Automaton unique = (Automaton)usesEvent.get(event);
                    if (unique == null) {
                        usesEvent.put(event, automaton);
                        continue;
                    }
                    sharedEvents.add(event);
                }
            }
            for (Map.Entry entry : usesEvent.entrySet()) {
                Event event = (Event)entry.getKey();
                if (sharedEvents.contains(event)) continue;
                String msg = Strings.fmt((String)"Controllable event \"%s\" is only used by automaton \"%s\".", (Object[])new Object[]{event.name, ((Automaton)entry.getValue()).name});
                OutputProvider.warn((String)msg);
                ++warnCount;
            }
        }
        if (warnDisjunct && (groups = AutomatonHelper.findDisjunctGroups(automs)).size() > 1) {
            List mesg = Lists.listc((int)(groups.size() + 1));
            String string = Strings.fmt((String)"Found %d disjunct groups of automata that do not share events between the groups:", (Object[])new Object[]{groups.size()});
            mesg.add(string);
            int number = 1;
            for (List list : groups) {
                mesg.add(SupervisorSynthesis.constructGroupLine(number, list));
                ++number;
            }
            OutputProvider.warn((String)String.join((CharSequence)"\n", mesg));
            ++warnCount;
        }
        if (warnCount == 1) {
            OutputProvider.out((String)"Reported 1 synthesis warning.");
        } else if (warnCount > 0) {
            OutputProvider.out((String)Strings.fmt((String)"Reported %d synthesis warnings.", (Object[])new Object[]{warnCount}));
        }
    }

    private static String constructGroupLine(int number, List<Automaton> group) {
        List names = Lists.listc((int)group.size());
        for (Automaton aut : group) {
            names.add(Strings.fmt((String)"\"%s\"", (Object[])new Object[]{aut.name}));
        }
        Collections.sort(names, Strings.SORTER);
        String line = names.size() == 1 ? "automaton" : "automata";
        line = Strings.fmt((String)" - Group %d consists of %s %s.", (Object[])new Object[]{number, line, String.join((CharSequence)", ", names)});
        return line;
    }

    public static Automaton synthesis(List<Automaton> automs, SynthesisDumpInterface synDump) {
        for (Automaton aut : automs) {
            if (aut.hasMarkedLoc()) continue;
            throw new InvalidModelException("Supervisor is empty (no marker states).");
        }
        List plants = Lists.list();
        List requirements = Lists.list();
        for (Automaton aut : automs) {
            switch (aut.kind) {
                case PLANT: {
                    plants.add(aut);
                    break;
                }
                case REQUIREMENT: {
                    requirements.add(aut);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected automaton kind.");
                }
            }
        }
        ArrayDeque<Location> badStates = new ArrayDeque<Location>(1000);
        OutputProvider.dbg((String)"Starting synthesis...");
        Automaton aut = SupervisorSynthesis.makeProductWithBadStates(plants, requirements, badStates, synDump);
        if (OutputProvider.dodbg()) {
            OutputProvider.dbg((String)"Pruning non-coreachables (%s)...", (Object[])new Object[]{AutomatonHelper.getAutStatistics(aut)});
        }
        SupervisorSynthesis.pruneNonCoreachables(aut, badStates, synDump);
        if (OutputProvider.dodbg()) {
            OutputProvider.dbg((String)"Pruning non-reachables (%s)...", (Object[])new Object[]{AutomatonHelper.getAutStatistics(aut)});
        }
        AutomatonHelper.removeNonReachables(aut, synDump);
        if (OutputProvider.dodbg()) {
            OutputProvider.dbg((String)"Synthesis finished (%s).", (Object[])new Object[]{AutomatonHelper.getAutStatistics(aut)});
        }
        aut.kind = AutomatonKind.SUPERVISOR;
        return aut;
    }

    private static Automaton makeProductWithBadStates(List<Automaton> plants, List<Automaton> reqs, ArrayDeque<Location> badStates, SynthesisDumpInterface synDump) {
        int numPlants = plants.size();
        plants.addAll(reqs);
        synDump.storeAutomata(plants, numPlants);
        badStates.clear();
        AutomatonBuilder builder = new AutomatonBuilder(plants);
        block0: for (State srcState : builder) {
            Location srcLoc = builder.getLocation(srcState);
            synDump.newLocation(srcState, srcLoc);
            builder.edgeBuilder.setupStateEdges(srcState);
            for (StateEdges resEdges : builder.edgeBuilder.getStateEdges()) {
                int disabledIndex = resEdges.disabledIndex();
                if (disabledIndex >= 0) {
                    synDump.disabledEvent(srcLoc, resEdges.event, disabledIndex);
                }
                if (disabledIndex < numPlants || resEdges.event.isControllable()) continue;
                badStates.add(srcLoc);
                continue block0;
            }
            for (StateEdges resEdges : builder.edgeBuilder.getStateEdges()) {
                for (State destState : resEdges) {
                    Location destLoc = builder.getLocation(destState);
                    Edge.addEdge(resEdges.event, srcLoc, destLoc);
                }
            }
        }
        if (!synDump.isFake()) {
            for (Location loc : builder.destAut) {
                for (Edge edge : loc.getOutgoing()) {
                    synDump.newEdge(edge.event, edge.srcLoc, edge.dstLoc);
                }
            }
        }
        return builder.destAut;
    }

    private static void pruneNonCoreachables(Automaton aut, Queue<Location> toDelete, SynthesisDumpInterface synDump) {
        if (aut.isEmpty()) {
            return;
        }
        LinkedHashSet<Location> badStates = new LinkedHashSet<Location>(toDelete);
        Set marked = Sets.set();
        Set preds = Sets.set();
        block0: while (true) {
            if (!toDelete.isEmpty()) {
                Location loc = toDelete.remove();
                preds.clear();
                for (Edge e : loc.getIncoming()) {
                    if (e.srcLoc == loc) continue;
                    synDump.removedDestination(e.srcLoc, e.event, loc);
                    if (e.event.isControllable()) {
                        if (e.srcLoc.marked) continue;
                        preds.add(e.srcLoc);
                        continue;
                    }
                    if (!badStates.add(e.srcLoc)) continue;
                    toDelete.add(e.srcLoc);
                }
                if (aut.initial == loc) {
                    aut.clear();
                    return;
                }
                aut.removeLocation(loc);
                Iterator<Edge> iterator = preds.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    Location loc2 = (Location)((Object)iterator.next());
                    if (loc2.outgoingEdges != null || !badStates.add(loc2)) continue;
                    synDump.blockingLocation(loc2);
                    toDelete.add(loc2);
                }
            }
            badStates.clear();
            int badLocCount = AutomatonHelper.getNonCoreachableCount(aut, marked);
            if (badLocCount == 0) {
                return;
            }
            Location loc = aut.locations;
            while (badLocCount > 0) {
                if (!marked.contains(loc)) {
                    toDelete.add(loc);
                    synDump.nonCoreachableLocation(loc);
                    badStates.add(loc);
                    --badLocCount;
                }
                loc = loc.nextLoc;
            }
            marked.clear();
        }
    }
}

