/******************************************************************************
 * Copyright (c) 2024, 2025 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the terms
 * of the MIT License which is available at https://opensource.org/licenses/MIT
 *
 *  SPDX-License-Identifier: MIT
 *****************************************************************************/

/* CIF language for highlight.js 11.9.0. */
(() => {
    var e = (() => {
        "use strict";
        return e => {
            return {
                name: "CIF",
                keywords: {
                    keyword: [
                        // Keywords.
                        "alg", "alphabet", "any", "attr", "automaton",
                        "bool", "break",
                        "case", "const", "cont", "continue", "controllable",
                        "def", "der", "dict", "disables", "disc", "dist", "do",
                        "edge", "elif", "else", "end", "enum", "equation", "event",
                        "false", "file", "final", "for", "func",
                        "goto", "group",
                        "id", "if", "import", "initial", "input", "int", "invariant",
                        "list", "location",
                        "marked", "monitor",
                        "namespace", "needs", "now",
                        "post", "pre", "print", "printfile",
                        "real", "return",
                        "self", "set", "string", "svgcopy", "svgfile", "svgin", "svgmove", "svgout", "switch",
                        "tau", "text", "time", "to", "true", "tuple", "type",
                        "uncontrollable", "urgent",
                        "value", "void",
                        "when", "while",

                        // Supervisory kinds.
                        "plant", "requirement", "supervisor",
                    ],
                    built_in: [
                        // Trigonometric functions.
                        "acosh", "acos", "asinh", "asin", "atanh", "atan",
                        "cosh", "cos",
                        "sinh", "sin",
                        "tanh", "tan",

                        // General functions.
                        "abs",
                        "cbrt", "ceil",
                        "del",
                        "empty", "exp",
                        "floor", "fmt",
                        "ln", "log",
                        "max", "min",
                        "pop", "pow",
                        "round",
                        "scale", "sign", "size", "sqrt",

                        // Distribution functions.
                        "bernoulli", "beta", "binomial",
                        "constant",
                        "erlang", "exponential",
                        "gamma", "geometric",
                        "lognormal",
                        "normal",
                        "poisson",
                        "random",
                        "triangle",
                        "uniform",
                        "weibull",
                    ],
                    operator: [
                        "and",
                        "div",
                        "in", // Keyword/operator conflict.
                        "mod",
                        "not",
                        "or",
                        "sample", "sub",
                    ]
                },
                contains: [
                    // Numbers.
                    {
                        scope: "number",
                        match: /\b(0|[1-9][0-9]*)(([.][0-9]+)?[eE][-+]?[0-9]+)\b/,
                    },
                    {
                        scope: "number",
                        match: /\b(0|[1-9][0-9]*)([.][0-9]+)\b/,
                    },
                    {
                        scope: "number",
                        match: /\b(0|[1-9][0-9]*)\b/,
                    },

                    // Comments.
                    {
                        scope: "comment",
                        begin: '//',
                        end: '$',
                    },
                    {
                        scope: "comment",
                        begin: '/\\*',
                        end: '\\*/',
                    },

                    // Strings, with escapes and format patterns.
                    {
                        scope: "string",
                        begin: '"',
                        end: '"',
                        contains: [
                            {
                                scope: "char.escape",
                                match: /\\[nt\\"]/,
                            },
                            {
                                scope: "regex",
                                match: /%([0-9]+[$])?[-+ 0,]*[0-9]*([.][0-9]+)?[bBdxXeEfgGsS]/,
                            },
                            {
                                scope: "char.escape",
                                match: '%%',
                            }
                        ]
                    },

                    // Annotations.
                    {
                        scope: "meta",
                        match: /@@?[a-zA-Z_][a-zA-Z0-9_]*(:[a-zA-Z_][a-zA-Z0-9_]*)*/,
                    },

                    // Special event names.
                    {
                        scope: "cevent",
                        match: /[.^]?([$]?\b[A-Za-z_][A-Za-z0-9_]*\b[.])*[$]?\bc_[A-Za-z0-9_]+\b/,
                    },
                    {
                        scope: "uevent",
                        match: /[.^]?([$]?\b[A-Za-z_][A-Za-z0-9_]*\b[.])*[$]?\bu_[A-Za-z0-9_]+\b/,
                    },
                    {
                        scope: "eevent",
                        match: /[.^]?([$]?\b[A-Za-z_][A-Za-z0-9_]*\b[.])*[$]?\be_[A-Za-z0-9_]+\b/,
                    },

                    // Escaped keywords should be identifiers.
                    {
                        scope: "escaped-keyword",
                        match: /[$]\b[A-Za-z_][A-Za-z0-9_]*\b/,
                    }
                ]
            }
        }
    })();
    hljs.registerLanguage("cif", e)
})();
