/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.print;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.escet.cif.simulator.CifSimulatorContext;
import org.eclipse.escet.cif.simulator.output.NormalOutputType;
import org.eclipse.escet.cif.simulator.output.print.PrintTransitionKind;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public abstract class RuntimePrintDecls {
    private boolean enabled;
    protected AppStream stream;
    private boolean shouldClose;

    public abstract String getRelPath();

    public abstract String getAbsPath();

    public abstract void print(RuntimeState var1, RuntimeState var2, PrintTransitionKind var3, int var4);

    public void init(CifSimulatorContext ctxt) {
        this.enabled = ctxt.normal.contains((Object)NormalOutputType.PRINT);
        if (this.enabled) {
            this.setStream(ctxt);
        }
    }

    private void setStream(CifSimulatorContext ctxt) {
        String absFilePath = this.getAbsPath();
        if (absFilePath.equals(":stdout")) {
            this.stream = ctxt.appEnvData.getStreams().out;
            this.shouldClose = false;
        } else if (absFilePath.equals(":stderr")) {
            this.stream = ctxt.appEnvData.getStreams().err;
            this.shouldClose = false;
        } else {
            String absDirPath = org.eclipse.escet.common.app.framework.Paths.getAbsFilePathDir((String)absFilePath);
            try {
                Files.createDirectories(Paths.get(absDirPath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException ex) {
                String msg = Strings.fmt((String)"Failed to create directory to contain file \"%s\" for writing using print declarations.", (Object[])new Object[]{this.getRelPath()});
                throw new InputOutputException(msg, (Throwable)ex);
            }
            try {
                this.stream = new FileAppStream(this.getRelPath(), absFilePath);
            }
            catch (InputOutputException ex) {
                String msg = Strings.fmt((String)"Failed to open file \"%s\" for writing using print declarations.", (Object[])new Object[]{this.getRelPath()});
                throw new InputOutputException(msg, (Throwable)ex);
            }
            this.shouldClose = true;
        }
    }

    public void close() {
        if (this.enabled && this.shouldClose && this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }
}

